/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>
#include "browserextension.h"

namespace Aurora {
namespace WebView {

/**
 * @class MediaPlaybackStatus
 * @brief extension that provides media playback status
 */

class IMediaPlaybackExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IMediaPlaybackExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {};
    ~IMediaPlaybackExtension() = default;

    /// returns true if audio is currently playing
    virtual bool audioIsPlaying() const = 0;

    /// returns true if video is currently playing
    virtual bool videoIsPlaying() const = 0;

signals:
    /**
     * @brief emitted when audio playback status is changed
     */
    void audioStatusChanged();
    /**
     * @brief emitted when video playback status is changed
    */
    void videoStatusChanged();
};

} // namespace WebView
} // namespace Aurora
