/****************************************************************************************
**
** SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

#ifndef TABLETTOTOUCHEVENTFILTER_H
#define TABLETTOTOUCHEVENTFILTER_H

#include <QObject>
#include <QScopedPointer>
#include <silicaglobal.h>

class TabletToTouchEventFilterPrivate;
class SAILFISH_SILICA_EXPORT TabletToTouchEventFilter : public QObject
{
    Q_OBJECT
public:
    explicit TabletToTouchEventFilter(QObject *parent = nullptr);
    ~TabletToTouchEventFilter() override;

protected:
    bool eventFilter(QObject *obj, QEvent *event) override;

private:
    QScopedPointer<TabletToTouchEventFilterPrivate> d_ptr;
};

#endif // TABLETTOTOUCHEVENTFILTER_H
