/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QJsonObject>

namespace Aurora {
namespace WebView {

class ILoadRequestWebViewExtension
{
public:
    virtual ~ILoadRequestWebViewExtension() = default;

    virtual bool beforeUrlLoad(const QJsonObject &url, bool userGesture, bool isRedirect) = 0;
    virtual bool handleUrlSchemeNatively(const QString url) = 0;
};

} // namespace WebView
} // namespace Aurora
