/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <cstdint>

namespace Aurora {
namespace WebView {

enum class TouchEventType { Press, Move, Release, Canceled };

struct TouchEvent
{
    TouchEventType type = TouchEventType::Press;
    int id = 0;
    double x = 0.;
    double y = 0;
};

enum class KeyEventType { Press, Release, Char };

struct KeyEvent
{
    KeyEventType type = KeyEventType::Press;
    std::uint32_t modifiers = 0;
    int domCode = 0;
    std::uint32_t nativeCode = 0;
    char16_t character = 0;
};

class IInputExtension
{
public:
    virtual ~IInputExtension() = default;

    virtual void sendTouchEvent(const TouchEvent &event) = 0;
    virtual void sendKeyEvent(const KeyEvent &event) = 0;
};

} // namespace WebView
} // namespace Aurora
