/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

namespace Aurora {
namespace WebView {

enum class TextInputMode { Text, Tel, Url, Email, Numeric, Decimal, Search };

class IBrowserObserver
{
public:
    virtual ~IBrowserObserver() = default;

    virtual void onViewTextureReady() = 0;

    virtual void onShowKeyboard(TextInputMode mode) = 0;
    virtual void onHideKeyboard() = 0;
};

} // namespace WebView
} // namespace Aurora
