/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <cstdint>
#include <memory>
#include <optional>
#include <string>

#include "ibrowserobserver.h"
#include "iloadrequestwebviewextension.h"

namespace Aurora {
namespace WebView {

class IInputExtension;

struct TextureDescription
{
    std::int64_t textureId = 0;
    std::size_t width = 0;
    std::size_t height = 0;
    bool hasAlpha = false;
};

class IBrowser
{
public:
    virtual ~IBrowser() = default;

    static std::unique_ptr<IBrowser> Create(IBrowserObserver *observer);

    virtual void setFrameRate(int frameRate) = 0;
    virtual void setDeviceScaleFactor(float deviceScaleFactor) = 0;

    virtual std::string url() const = 0;
    virtual void setUrl(const std::string &url) = 0;

    virtual std::optional<TextureDescription> getTextureDescription() const = 0;

    virtual void resize(int width, int height) = 0;

    virtual IInputExtension *getInputExtension() const = 0;

    virtual void setLoadRequestExtension(ILoadRequestWebViewExtension *extension) = 0;
};

} // namespace WebView
} // namespace Aurora
