/* This file is part of the Aurora OS SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Qt QmlLive"));
    component.setValue("Description", qsTranslate("installscript", "Qt QmlLive is a live reloader environment for rapid UI development."));

    installer.valueChanged.connect(this, Component.prototype.reactOnTargetDirChange);
    Component.prototype.reactOnTargetDirChange("TargetDir", installer.value("TargetDir"));

}

Component.prototype.beginInstallation = function()
{
    var os = installer.value("os");

    if (os === "win") {
        component.setStopProcessForUpdateRequest("qmllivebench.exe", true);
        component.setStopProcessForUpdateRequest("qmlliveruntime.exe", true);
    } else {
        component.setStopProcessForUpdateRequest("qmllivebench", true);
        component.setStopProcessForUpdateRequest("qmlliveruntime", true);
    }
}

Component.prototype.reactOnTargetDirChange = function(key, value)
{
    if (key === "TargetDir") {
        var os = installer.value("os");
        if (os === "win") {
            installer.setValue("QmlLiveBenchBinary", value + "/bin/qmllivebench.exe");
        } else {
            installer.setValue("QmlLiveBenchBinary", value + "/bin/qmllivebench");
        }
    }
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();
}
