/* This file is part of the Aurora SDK
*/

function abortInstaller()
{
    installer.setDefaultPageVisible(QInstaller.Introduction, false);
    installer.setDefaultPageVisible(QInstaller.TargetDirectory, false);
    installer.setDefaultPageVisible(QInstaller.ComponentSelection, false);
    installer.setDefaultPageVisible(QInstaller.ReadyForInstallation, false); 
    installer.setDefaultPageVisible(QInstaller.StartMenuSelection, false);
    installer.setDefaultPageVisible(QInstaller.PerformInstallation, false); 
    installer.setDefaultPageVisible(QInstaller.LicenseCheck, false);
    installer.setDefaultPageVisible(QInstaller.ComponentSelection - 1, false);

    var abortText;

    if(installer.value("existingInstallationWarning")) {
        abortText = "<font color='red'>" + 
        qsTranslate("installscript", "If you have an existing Aurora SDK or Aurora OS SDK it must first be removed. Please run the 'SDKMaintenanceTool' found in the installation directory (usually AuroraOS in your home/user directory) and remove all components") + "</font>";
    } else {
        abortText = "<font color='red'>" + 
        qsTranslate("installscript", "Installation Aborted!") + 
        "</font>";
    }
    print(installer.value("installer_errors"));
    var error_list = installer.value("installer_errors").split(";;;");
    abortText += "<ul>";
    // ignore the first empty one
    for (var i = 0; i < error_list.length; ++i) {
        if (error_list[i] !== "") {
            print(error_list[i]);
            abortText += "<li>" + error_list[i] + "</li>";
        }
     }
     abortText += "</ul>";
     installer.setValue("FinishedText", abortText);
}

function Component()
{
    component.setValue("DisplayName", qsTranslate("installscript", "Aurora SDK"));
    component.setValue("Description", component.value("DisplayName"));

    console.log("Component constructor: " + component.name);
    installer.setValue("FinishedText","");
    if (installer.isInstaller()) {
        installer.setDefaultPageVisible(QInstaller.ComponentSelection, true);
        installer.currentPageChanged.connect(this, Component.prototype.handlePageChanged);
    }

    installer.finishAllComponentsReset.connect(Component.prototype.handleComponentsReset);
    installer.finishUpdaterComponentsReset.connect(Component.prototype.handleComponentsReset);

    if (installer.value("os") !== "win") {
        // Don't allow running as root
        var id = installer.execute("which", ["id"])[0];
        id = id.replace(/\n/gi, "");
        var uid = installer.execute(id, ["-u"])[0];
        uid = uid.replace(/\n/gi, "");
        if (uid === "0"  && !installer.value("abortInstaller") && !component.fromOnlineRepository) {
            installer.setValue("installer_errors", installer.value("installer_errors") + ";;;" +
                qsTranslate("installscript", "Running as root not supported: ") +
                qsTranslate("installscript", "You need to run this installer as a normal user, system wide installation not supported."));
            installer.setValue("abortInstaller", true);
        }
        installer.setValue("uid", uid);
    } else {
        installer.setValue("uid", "1000");
    }

    var vboxDownloadLink = qsTranslate("installscript", "<a href=\"http://www.virtualbox.org/\">www.virtualbox.org</a>");
    var dockerDownloadLink = qsTranslate("installscript", "<a href=\"https://docs.docker.com/desktop/\">https://docs.docker.com/desktop/</a>");
    var minVboxVersion = 4.0;

    var vboxManage = installer.value("vboxManagePath");
    var dockerPath = installer.value("dockerPath");
    if (!vboxManage && !dockerPath
            && !installer.value("abortInstaller") && !component.fromOnlineRepository) {
            installer.setValue("installer_errors", installer.value("installer_errors") + ";;;" +
                qsTranslate("installscript", "Virtualization technology not installed: ") +
                               qsTranslate("installscript", "You need a working VirtualBox or Docker installation. Please download one from %1 or %2, install it and then rerun this installer.").arg(vboxDownloadLink).arg(dockerDownloadLink));
            installer.setValue("abortInstaller", true);
	return;
    }

    var homeDir = installer.value("homeDir");
    if (homeDir.includes(' ') && !installer.value("allowHomeDirWithSpaces")
            && !installer.value("abortInstaller")) {
        installer.setValue("installer_errors", installer.value("installer_errors") + ";;;" +
                qsTranslate("installscript", "User's home directory path contains spaces. Installation is not possible."));
        installer.setValue("abortInstaller", true);
        return;
    }

    installer.setValue("sharedMerHomeDir", homeDir);

    if (installer.value("workspaceDir") === "")
        installer.setValue("workspaceDir", homeDir);
    var workspaceDir = installer.value("workspaceDir");
    var workspaceMountPoint = alignedMountPointFor(workspaceDir);
    console.log("Workspace: '" + workspaceDir + "', mount point: '" + workspaceMountPoint + "'");
    installer.setValue("workspaceMountPoint", workspaceMountPoint);

    installer.addWizardPage(component, "WorkspaceWidget", QInstaller.ComponentSelection);

    var workspaceWidget = component.userInterface("WorkspaceWidget");
    if (workspaceWidget) {
        workspaceWidget.workspaceLineEdit.text = workspaceDir;
        workspaceWidget.workspaceErrorLabel.text = "";
        installer.setValidatorForCustomPage(component, "WorkspaceWidget", "validateWorkspaceDir");
        workspaceWidget.workspaceBrowseButton.clicked.connect(function() {
            var dir = QFileDialog.getExistingDirectory(qsTranslate("installscript", "Select Workspace Folder"),
                    workspaceWidget.workspaceLineEdit.text);
            if (dir !== "")
                workspaceWidget.workspaceLineEdit.text = dir;
        });
        workspaceWidget.workspaceLineEdit.textChanged.connect(Component.prototype.validateWorkspaceDir);
    }

    installer.setValue("rootLoaded", true);
}

function toNativePath(path)
{
    if (installer.value("os") === "win")
        return path.replace(/\//g, "\\");
    else
        return path;
}

function mkdirWithoutUndo(path)
{
    path = toNativePath(path);

    mkdirError = qsTranslate("installscript", "Failed to create workspace directory \"%1\"").arg(path);
    if (installer.value("os") === "win") {
        component.addOperation("Execute", "cmd", "/c", "mkdir " + path,
                "errormessage=" + mkdirError);
    } else {
        component.addOperation("Execute", "mkdir", "-p", path,
                "errormessage=" + mkdirError);
    }
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    var workspaceDir = installer.value("workspaceDir");
    if (!installer.fileExists(workspaceDir))
        mkdirWithoutUndo(workspaceDir);
}

Component.prototype.handleComponentsReset = function()
{
    if (installer.components().length === 1) {
        installer.setValue("installer_errors", installer.value("installer_errors") + ";;;" +
                qsTranslate("installscript", "No repository could be reached. Please check your network connection and try again."));
        installer.setValue("abortInstaller", true);
    }
    if (installer.value("abortInstaller") === "true")
        abortInstaller();
}

Component.prototype.handlePageChanged = function(page)
{
    if (page == QInstaller.ComponentSelection) {
        var workspaceWidget = component.userInterface("WorkspaceWidget");
        var workspaceDir = workspaceWidget.workspaceLineEdit.text;
        var workspaceMountPoint = alignedMountPointFor(workspaceDir);
        console.log("Workspace: '" + workspaceDir + "', mount point: '" + workspaceMountPoint + "'");
        installer.setValue("workspaceDir", workspaceDir);
        installer.setValue("workspaceMountPoint", workspaceMountPoint);
    }
}

Component.prototype.validateWorkspaceDir = function()
{
    var errorTemplate = '<html><head/><body><p><span style="color:#ef2929;">%1</span></p></body></html>';
    var workspaceWidget = component.userInterface("WorkspaceWidget");
    var workspaceDir = workspaceWidget.workspaceLineEdit.text;

    if(QFileInfo.isSymLink(workspaceDir)) {
        workspaceWidget.workspaceErrorLabel.text = errorTemplate.arg(qsTranslate("installscript", "The installation path must not be a symbolic link, "
            + "please specify a valid directory."));
        return false;
    }

    for (var i = 0; i < workspaceDir.length; ++i) {
        if (workspaceDir.charCodeAt(i) > 127) {
            workspaceWidget.workspaceErrorLabel.text = errorTemplate.arg(qsTranslate("installscript", "The directory path contains invalid characters. "
                + "Please use Latin letters, numbers and underscores."));
            return false;
        }
    }

    if (workspaceDir === '') {
        workspaceWidget.workspaceErrorLabel.text = errorTemplate.arg(qsTranslate("installscript", "Path may not be empty"));
        return false;
    }

    if (workspaceDir.includes(' ') && !installer.value("allowWorkspaceDirWithSpaces")) {
        workspaceWidget.workspaceErrorLabel.text = errorTemplate.arg(qsTranslate("installscript", "Path may not contain spaces"));
        return false;
    }

    if (installer.fileExists(workspaceDir) && !installer.fileExists(workspaceDir + "/.")) {
        workspaceWidget.workspaceErrorLabel.text = errorTemplate.arg(qsTranslate("installscript", "Not a folder"));
        return false;
    }

    var workspaceMountPoint = alignedMountPointFor(workspaceDir);

    if (workspaceMountPoint === '') {
        workspaceWidget.workspaceErrorLabel.text = errorTemplate.arg(qsTranslate("installscript", "Cannot be used as a workspace folder"));
        return false;
    }

    workspaceWidget.workspaceErrorLabel.text = "";
    return true;
}

// Keep in sync with Sfdk
function alignedMountPointFor(hostPath)
{
    var path = hostPath.replace(/\\/g, '/');

    path = path.replace(/\/+$/, '');
    path = path.replace(/\/+/g, '/');

    if (path.length < 3) {
        console.log("Cannot align too short path '" + hostPath + "'");
        return '';
    }

    if (installer.value("os") === "win") {
        // C:/Users/user -> /c/Users/user
        path = "/" + path[0].toLowerCase() + path.substring(2);
    }

    if (path.startsWith("/home/mersdk") || path.startsWith("/home/deploy")) {
        path = "/home/" + path[6].toUpperCase() + path.substring(7);
    } else if (path == "/home") {
        path = "/Home";
    } else if (path.startsWith("/home")) {
        ; // no clash
    } else if (path.toLowerCase().startsWith("/users")) {
        ; // no clash
    } else if (path[2] == '/') {
        ; // path starting with drive letter - no clash
    } else {
        path = "/" + path[1].toUpperCase() + path.substring(2);
    }

    return path;
}
