/* This file is part of the Aurora OS SDK
*/

// Keep these in sync with org.merproject.emulator4qtcreator [[Begin
var emulatorVmName = "latest" === "ea"
    ? "AuroraOS-5.1.6.110-BTEA"
    : "AuroraOS-5.1.6.110-BT";
var emulatorVmSnapshotName = "5.1.6.110-BT";
var emulatorMemoryMB = "4096";
var emulatorCpuCount = "1";
// End]]

var emulatorTargetDir = "@TargetDir@/emulator/" + emulatorVmName;

function Component()
{
    console.log("Component constructor: " + component.name);
    if ("latest" === "5.1.6.110-BT") {
        component.setValue("DisplayName", "AuroraOS-latest");
        component.setValue("Description",
                qsTranslate("installscript", "Emulates devices running %1 release %2")
                    .arg("Aurora OS")
                    .arg("5.1.6.110-BT"));
    } else if ("latest" === "ea") {
        component.setValue("Description",
                qsTranslate("installscript", "Emulates devices running the latest %1 release " +
                        "published to Early Access users (%2)")
                    .arg("Aurora OS")
                    .arg("5.1.6.110-BT"));
    } else if ("latest" === "latest") {
        component.setValue("Description",
                qsTranslate("installscript", "Emulates devices running the latest %1 release (%2)")
                    .arg("Aurora OS")
                    .arg("5.1.6.110-BT"));
    } else {
        component.setValue("Description", "*** TRANSLATION MISSING !! ***");
    }

    // Installing emulator without VirtualBox is not possible
    if (!installer.value("vboxManagePath"))
        component.enabled = false;

    if(installer.value("vboxManagePath")) {
        var registeredVMs = installer.execute(installer.value("vboxManagePath"), ["list", "vms"])[0];
        if (registeredVMs.indexOf("\"" + emulatorVmName + "\"") !== -1
            && !component.fromOnlineRepository) {
            installer.setValue("installer_errors", installer.value("installer_errors") + ";;;" +
                qsTranslate("installscript", "%1: There is already a <em>%2</em> VirtualBox machine. " +
                     "Please remove it before restarting this installation.")
                               .arg(component.value("DisplayName"))
                               .arg(emulatorVmName));
            installer.setValue("abortInstaller", true);
            installer.setValue("existingInstallationWarning", true);
        }
    }
}

// this is only called for the latest emulator
Component.prototype.isDefault = function()
{
    return installer.value("vboxManagePath");
}

Component.prototype.createOperationsForArchive = function(archive)
{
    component.addOperation("Extract", archive, emulatorTargetDir);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    var vboxManagePath = installer.value("vboxManagePath");
    var vdiFileName = emulatorTargetDir + "/auroraos.vdi";

    var initialDeviceModel = installer.componentByName("org.merproject.emulators").initialDeviceModel;

    var portcountparam = "";
    var version = installer.execute(vboxManagePath, ["--version"])[0];
    version = version.substring(0,3); // 4.0, 4.1, 4.2, 4.3 etc.
    var floatver = parseFloat(version);

    if (floatver < 4.3) {
	portcountparam = "--sataportcount";
    }
    else {
	portcountparam = "--portcount";
    }

    var cpuCount = installer.value("cpuCount") > 1 ? 2 : 1;

    var errorMessage = "errormessage=" +  qsTranslate("installscript", "Please shutdown the \"%1\" VM").arg(emulatorVmName);

    var audioDrivers = {
        x11: "pulse",
        win: "dsound",
        mac: "coreaudio"
    };

    var parameterLists = [
        [
            vboxManagePath, "createvm",
                            "--name", emulatorVmName,
                            "--register",
                            "--basefolder", emulatorTargetDir,
            "UNDOEXECUTE",
            vboxManagePath, "unregistervm",
                            "--delete", emulatorVmName, errorMessage
        ], [
            vboxManagePath, "modifyvm", emulatorVmName,
                            "--description", qsTranslate("installscript", "ATTENTION: This virtual machine is managed by the Aurora SDK."
                                + " Do not try to alter it!")
        ], [
            vboxManagePath, "modifyvm", emulatorVmName,
                            "--ostype", "Linux26_64",
                            "--rtcuseutc", "on",
                            "--cpus", emulatorCpuCount,
                            "--memory", emulatorMemoryMB,
                            "--vram", "128",
                            "--ioapic", "on",
                            "--pae", "on",
                            "--audio", audioDrivers[installer.value('os')],
                            "--audiocontroller", "ac97",
                            "--nic1", "nat",
                            "--cableconnected1", "on",
                            "--nictype1", "virtio",
                            "--nic2", "intnet",
                            "--cableconnected2", "on",
                            "--intnet2", "@ConfigVariant@",
                            "--nictype2", "virtio",
                            "--bioslogodisplaytime", "1"
        ], [
            vboxManagePath, "storagectl", emulatorVmName,
                            "--name", "SATA",
                            "--add", "sata",
                            "--controller", "IntelAhci",
                            portcountparam, "1",
                            "--bootable", "on"
        ], [
            vboxManagePath, "internalcommands", "sethduuid",
                            vdiFileName
        ],[
            vboxManagePath, "storageattach", emulatorVmName,
                            "--storagectl", "SATA",
                            "--port", "0",
                            "--medium", vdiFileName,
                            "--type", "hdd",
                            "--mtype", "normal",
            "UNDOEXECUTE",
            "{0,1}", vboxManagePath, "closemedium",
                            "disk", vdiFileName, errorMessage
        ], [
            vboxManagePath, "setextradata", emulatorVmName,
                            "CustomVideoMode1", initialDeviceModel.videoMode()
         ], [
            vboxManagePath, "setextradata", emulatorVmName,
                            "GUI/LastGuestSizeHint", initialDeviceModel.guestSizeHint()
         ], [
            vboxManagePath, "setextradata", emulatorVmName,
                            "GUI/AutoresizeGuest", "false"
         ], [
            vboxManagePath, "setextradata", emulatorVmName,
                            "GUI/RestrictedCloseActions", "SaveState,Shutdown"
         ], [
            vboxManagePath, "modifyvm", emulatorVmName,
                        "--natdnshostresolver1", "on"
         ], [
            vboxManagePath, "modifyvm", emulatorVmName,
                            "--cpus", cpuCount
         ]
    ];

    parameterLists.forEach(function(parameterList) {
        component.addOperation("Execute", parameterList);
    });

    component.addOperation("VmShutdown",
                           emulatorVmName,
                           "when=undo");
}
