/**
 * SPDX-FileCopyrightText: Copyright 2022-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_ACCESSSWITCHPLUGIN_H
#define AURORA_ACCESSSWITCHPLUGIN_H

#include <QObject>

namespace Sailfish {

class Q_DECL_EXPORT AccessSwitchPlugin : public QObject
{
    Q_OBJECT
public:
    virtual QVariant keyValue(const QString &key) = 0;
    virtual int setKeyValue(const QString &key, const QVariant &value) = 0;
    virtual QHash<QString,QList<int>> switches() = 0;
signals:
    void keyValueChanged(const QString &key, const QVariant &value);
};

}

Q_DECLARE_INTERFACE(Sailfish::AccessSwitchPlugin, "ru.omp.auroraos.AccessSwitchPlugin/1.0")

#endif // AURORA_ACCESSSWITCHPLUGIN_H
