/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"
#include "favicon.h"

#include <QList>
#include <QObject>
#include <QSize>

namespace Aurora {
namespace WebView {

class IFaviconExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IFaviconExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    virtual ~IFaviconExtension() = default;

    virtual QList<QSize> availableSizes() const = 0;
    virtual QList<Favicon> favicons(const QSize size) const = 0;

signals:
    /**
     * @brief emitted when download of website favicons starts
     * 
     * The signal is emitted when a new site is loaded and precedes favicons 
     * downloading. All previously downloaded favicons are deleted.
     */
    void downloadStarted();
    /**
     * @brief emitted when favicon is downloaded
     * 
     * @param size size of downloaded favicon
     * @param downloadedCount downloaded count of current website favicons
     * @param totalCount total count of current website favicons
     */
    void downloaded(QSize size, int downloadedCount, int totalCount);
    /**
     * @brief emitted when all favicons of current website are downloaded
     * 
     * @param count count of downloaded favicons
     */
    void downloadFinished(int count);
};

} // namespace WebView
} // namespace Aurora
