/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

namespace Aurora {
namespace WebView {

/**
 * @class CertificateInfo
 * @brief stores certificate fields like CN, country, etc.
 * 
 * See Aurora::WebView::Certificates::CertificateInfoTypeKnown
 */
class CertificateInfo
{
    Q_GADGET

    Q_PROPERTY(QStringList commonName READ commonName CONSTANT)
    Q_PROPERTY(QStringList email READ email CONSTANT)
    Q_PROPERTY(QStringList emailLegacy READ emailLegacy CONSTANT)
    Q_PROPERTY(QStringList organization READ organization CONSTANT)
    Q_PROPERTY(QStringList organizationalUnit READ organizationalUnit CONSTANT)
    Q_PROPERTY(QStringList locality READ locality CONSTANT)
    Q_PROPERTY(QStringList incorporationLocality READ incorporationLocality CONSTANT)
    Q_PROPERTY(QStringList state READ state CONSTANT)
    Q_PROPERTY(QStringList incorporationState READ incorporationState CONSTANT)
    Q_PROPERTY(QStringList country READ country CONSTANT)
    Q_PROPERTY(QStringList incorporationCountry READ incorporationCountry CONSTANT)
    Q_PROPERTY(QStringList uri READ uri CONSTANT)
    Q_PROPERTY(QStringList dns READ dns CONSTANT)
    Q_PROPERTY(QStringList ipAddress READ ipAddress CONSTANT)
    Q_PROPERTY(QStringList xmpp READ xmpp CONSTANT)
    Q_PROPERTY(QStringList inn READ inn CONSTANT)
    Q_PROPERTY(QStringList ogrn READ ogrn CONSTANT)
    Q_PROPERTY(QStringList snils READ snils CONSTANT)
    Q_PROPERTY(QStringList innle READ innle CONSTANT)
    Q_PROPERTY(QStringList ogrnip READ ogrnip CONSTANT)
    Q_PROPERTY(QStringList identificationKind READ identificationKind CONSTANT)
public:
    CertificateInfo();
    CertificateInfo(
        QStringList commonName,
        QStringList email,
        QStringList emailLegacy,
        QStringList organization,
        QStringList organizationalUnit,
        QStringList locality,
        QStringList incorporationLocality,
        QStringList state,
        QStringList incorporationState,
        QStringList country,
        QStringList incorporationCountry,
        QStringList uri,
        QStringList dns,
        QStringList ipAddress,
        QStringList xmpp,
        QStringList inn,
        QStringList ogrn,
        QStringList snils,
        QStringList innle,
        QStringList ogrnip,
        QStringList identificationKind);
    virtual ~CertificateInfo() = default;

    QStringList commonName() const;
    QStringList email() const;
    QStringList emailLegacy() const;
    QStringList organization() const;
    QStringList organizationalUnit() const;
    QStringList locality() const;
    QStringList incorporationLocality() const;
    QStringList state() const;
    QStringList incorporationState() const;
    QStringList country() const;
    QStringList incorporationCountry() const;
    QStringList uri() const;
    QStringList dns() const;
    QStringList ipAddress() const;
    QStringList xmpp() const;
    QStringList inn() const;
    QStringList ogrn() const;
    QStringList snils() const;
    QStringList innle() const;
    QStringList ogrnip() const;
    QStringList identificationKind() const;

private:
    QStringList m_commonName;
    QStringList m_email;
    QStringList m_emailLegacy;
    QStringList m_organization;
    QStringList m_organizationalUnit;
    QStringList m_locality;
    QStringList m_incorporationLocality;
    QStringList m_state;
    QStringList m_incorporationState;
    QStringList m_country;
    QStringList m_incorporationCountry;
    QStringList m_uri;
    QStringList m_dns;
    QStringList m_ipAddress;
    QStringList m_xmpp;
    QStringList m_inn;
    QStringList m_ogrn;
    QStringList m_snils;
    QStringList m_innle;
    QStringList m_ogrnip;
    QStringList m_identificationKind;
};

} // namespace WebView
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::WebView::CertificateInfo)
