/*******************************************************************************
 *
 * SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 *
 ******************************************************************************/

#ifndef RM_COMMON_TYPES_H
#define RM_COMMON_TYPES_H

/* Note: this file is a symbolic link to the public types.h header installed by
 * the client library. */
#include "public_types.h"

#include <QVariant>
#include <QVariantMap>

class QJsonObject;

namespace Core {
namespace Types {

/* QJsonObject already has a toVariantMap() method, but it always converts
 * arrays into QVariantLists; in many places we assume arrays to be
 * homogeneous, therefore we want a conversion that checks if the array
 * elements are of the same type, and returns a typed QList instead. */
QVariantMap jsonObjectToMap(const QJsonObject &object);
QVariant jsonArrayToVariant(const QJsonArray &array);

} // namespace Types
} // namespace Core

#endif // RM_COMMON_TYPES_H
