/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import ru.auroraos.WebView.Private 1.0 as WebView
import ru.auroraos.WebView.Global 1.0
import Sailfish.Silica 1.0
import Sailfish.Share 1.0
import Aurora.Controls 1.0

WebView.ContextMenu {
    id: contextMenuComponent

    property alias popup: contextMenu
    default property alias children: contextMenu.items
    property bool showUrlHeader: false
    property string url

    onShowMenuRequested: {
        if (menu)
            menu.show(contextMenuComponent.x, contextMenuComponent.y, params.availableActions)
    }

    anchors.fill: parent

    Item {
        id: topAnchor
    }

    Item {
        id: menu

        function show(newX, newY, availableActions) {
            contextMenuComponent.url = params.unfilteredLinkUrl ?
                        params.unfilteredLinkUrl :
                        params.sourceUrl ? params.sourceUrl : ""
            contextMenu.headerText = showUrlHeader ? contextMenuComponent.url : ""
            topAnchor.x = newX
            topAnchor.y = newY

            copyLinkAddressButton.enabled = (availableActions.indexOf(MenuId.MENU_ID_USER_COPY_LINK) != -1)
            shareLinkButton.enabled = (availableActions.indexOf(MenuId.MENU_ID_USER_SHARE_LINK) != -1)
            downloadImageButton.enabled = (availableActions.indexOf(MenuId.MENU_ID_USER_DOWNLOAD_IMAGE) != -1)

            contextMenu.open()
        }

        anchors {
            top: topAnchor.top
            left: topAnchor.left
            topMargin: -Theme.paddingSmall
        }

        PopupMenu {
            id: contextMenu

            onClosed: {
                contextMenuComponent.cancel()
            }

            PopupMenuItem {
                id: copyLinkAddressButton

                onClicked: {
                    console.log("copy link address")
                    contextMenuComponent.execute(MenuId.MENU_ID_USER_COPY_LINK)
                }

                //% "Copy link"
                text: qsTrId("webview-pi-copy_link")
                visible: enabled
            }

            PopupMenuItem {
                id: shareLinkButton

                onClicked: {
                    console.log("share link")
                    shareDialog.resources = [{
                                                 "type": "text/x-url",
                                                 "status": params.linkUrl
                                             }]
                    shareDialog.trigger()
                }

                //% "Share link"
                text: qsTrId("webview-pi-share_link")
                visible: enabled
            }

            PopupMenuItem {
                id: downloadImageButton

                onClicked: {
                    console.log("download image")
                    contextMenuComponent.execute(MenuId.MENU_ID_USER_DOWNLOAD_IMAGE)
                }

                //% "Save image"
                text: qsTrId("webview-pi-save_image")
                visible: enabled
            }
        }
    }

    ShareAction {
        id: shareDialog

        title: qsTrId("webview-pi-share_link")
    }
}
