/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_REPORTGENERATOR_P_H
#define AURORA_MDM_REPORTGENERATOR_P_H

#include "base-mdm-proxy-interface_p.h"

#include <QObject>
#include <QDBusInterface>
#include <QDBusUnixFileDescriptor>
namespace Aurora {
namespace Mdm {

class ReportGenerator;
class ReportGeneratorPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT
    Q_DISABLE_COPY(ReportGeneratorPrivate)
    Q_DECLARE_PUBLIC(ReportGenerator)

public:
    explicit ReportGeneratorPrivate(ReportGenerator *q);
    ~ReportGeneratorPrivate();

    void removeData();

    QDBusUnixFileDescriptor fd;
    ReportGenerator *q_ptr;
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_REPORTGENERATOR_P_H
