/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 - 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

Dialog {
    property alias deletionHeader: deletionHeaderLabel.text
    property alias deletionText: deletionTextLabel.text

    DialogHeader {
        id: dialogHeader

        //% "Delete"
        acceptText: qsTrId("components_gallery-me-delete")
    }

    SilicaFlickable {
        anchors {
            top: dialogHeader.bottom
            left: parent.left
            right: parent.right
            bottom: parent.bottom
            leftMargin: Theme.paddingLarge
            rightMargin: Theme.paddingLarge
        }

        contentHeight: content.height

        Column {
            id: content

            width: parent.width
            spacing: Theme.paddingLarge

            InfoLabel {
                id: deletionHeaderLabel

                x: 0
                horizontalAlignment: Text.AlignLeft
                color: Theme.primaryColor
                //% "Are you sure you want to delete this item from device?"
                text: qsTrId("components_gallery-me-delete_item")
            }

            Label {
                id: deletionTextLabel

                width: parent.width
                color: Theme.rgba(Theme.primaryColor, Theme.opacityOverlay)
                wrapMode: Text.Wrap
                //% "This item will be permanently deleted."
                text: qsTrId("components_gallery-me-delete_item_without_recovery")
            }
        }
    }
}
