/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

pragma Singleton
import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    readonly property real gradWidth: Theme.dp(500)
    readonly property real progressStart: -gradWidth
    property real pageWidth
    property real progressEnd
    property real progress: progressStart
    property real progress2: progressStart
    property int users

    function resetAnimation(anim) {
        if (anim.running) {
            anim.stop()
            anim.running = Qt.binding(function(){ return root.users })
        }
    }

    visible: false

    onPageWidthChanged: {
        anim.stop()
        progress = anim.from
        grad2Anim.stop()
        progress2 = anim2.from

        progressEndDdosProtection.start()
    }

    NumberAnimation {
        id: anim

        target: root
        property: "progress"
        from: root.progressStart
        to: root.progressEnd
        duration: 3000
        loops: Animation.Infinite
        easing.type: Easing.InOutQuad
        running: root.users

        onToChanged: resetAnimation(this)
    }

    SequentialAnimation {
        id: grad2Anim

        running: root.users

        PauseAnimation {
            duration: 1250
        }

        NumberAnimation {
            id: anim2

            target: root
            property: "progress2"
            from: root.progressStart
            to: root.progressEnd
            duration: 3000
            loops: Animation.Infinite
            easing.type: Easing.InOutQuad

            onToChanged: resetAnimation(grad2Anim)
        }
    }

    Timer {
        id: progressEndDdosProtection

        interval: 1
        onTriggered: root.progressEnd = root.pageWidth + root.gradWidth
    }
}
