/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_REPORTGENERATOR_H
#define AURORA_MDM_REPORTGENERATOR_H

#include <QObject>

namespace Aurora {
namespace Mdm {

class ReportGeneratorPrivate;
class Q_DECL_EXPORT ReportGenerator : public QObject
{
    Q_OBJECT

public:
    explicit ReportGenerator(QObject *parent = nullptr);
    ~ReportGenerator();

    void generate();
    void removeData();
    bool encryptionEnabled();
    bool setEncryptionKeyFile(const QString &path);

signals:
    void generateFinished(int fd);

private:
    ReportGeneratorPrivate *d_ptr;
    Q_DISABLE_COPY(ReportGenerator)
    Q_DECLARE_PRIVATE(ReportGenerator)
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_REPORTGENERATOR_H
