/*
 * Copyright (c) 2020 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_DBUSJOURNAL_P_H
#define SAILFISH_MDM_DBUSJOURNAL_P_H

#include <QDataStream>
#include <QDBusMessage>
#include <QFile>
#include <QList>
#include <QMetaType>
#include <QPair>
#include <QString>
#include <QUuid>

namespace Sailfish {
namespace Mdm {

class DBusJournalPrivate {
public:
    DBusJournalPrivate(quint32 user);

    quint32 uid;
    QFile file;
    QDataStream stream;
    int transactionsHandled;
    int transactionsFailed;
};

struct JournaledItem {
    QUuid id;
    QDBusMessage message;
    quint32 timeout;
    QDBusMessage callback;
    QStringList argumentNames;
};

}; // Mdm
}; // Sailfish

#endif // SAILFISH_MDM_DBUSJOURNAL_P_H
