/**
 * SPDX-FileCopyrightText: 2017-2020 Jolla Ltd.
 * SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_ACCOUNTS_P_H
#define SAILFISH_MDM_ACCOUNTS_P_H

#include "mdm-accounts.h"
#include "mdm-dbusjournal.h"
#include "base-mdm-proxy-interface_p.h"

#include <QDBusInterface>
#include <QDBusArgument>
#include <QDBusMetaType>
#include <QDBusPendingReply>

#include <QVariantMap>
#include <QString>

namespace Sailfish {
namespace Mdm {
namespace Accounts {

class ProvisionerPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT

public:
    ProvisionerPrivate(Provisioner *parent);

    virtual void customInitProxyPrep();

    virtual bool canCreateAccount() const;

    bool queuedTransaction(const QString &method, const QVariantList &args, const QStringList &names);
    bool notQueuedTransaction();
    bool call(const QString &method, const QVariantList &args);


    QString m_providerName;
    QString m_accountDisplayName;
    QVariantMap m_accountConfig;
    bool m_accountReadOnly;
    bool m_accountLimited;

    QString m_errorMessage;
    int m_error;
    quint64 m_accountId;

    QVariantMap m_fetchedProperties;

    quint32 m_user;
    QString m_lastTransactionUuid;
    bool m_queuedTransactionUsed;
    QString m_callbackService;
    QString m_callbackPath;
    QString m_callbackInterface;
    QString m_callbackMethod;

Q_SIGNALS:
    void lastTransactionUuidChanged();
    void queuedTransactionUsedChanged();
};

class GenericAccountProvisionerPrivate : public ProvisionerPrivate
{
    Q_OBJECT

public:
    GenericAccountProvisionerPrivate(GenericAccountProvisioner *parent);
    ~GenericAccountProvisionerPrivate() override;

    bool canCreateAccount() const Q_DECL_OVERRIDE;

    QString m_defaultServiceName;
    QString m_username;
    QString m_password;
};

class EmailAccountProvisionerPrivate : public ProvisionerPrivate
{
    Q_OBJECT

public:
    EmailAccountProvisionerPrivate(EmailAccountProvisioner *parent);
    ~EmailAccountProvisionerPrivate() override;

    bool canCreateAccount() const Q_DECL_OVERRIDE;

    QString m_defaultServiceName;
    QString m_emailAddress;
    Sailfish::Mdm::Accounts::EmailAccountProvisioner::IncomingProtocol m_incomingProtocol;
    QString m_incomingUsername;
    QString m_incomingPassword;
    QString m_incomingServer;
    int m_incomingPort;
    Sailfish::Mdm::Accounts::EmailAccountProvisioner::ConnectionEncryption m_incomingConnectionEncryption;
    bool m_incomingAcceptUntrustedCertificates;
    Sailfish::Mdm::Accounts::EmailAccountProvisioner::OutgoingProtocol m_outgoingProtocol;
    QString m_outgoingUsername;
    QString m_outgoingPassword;
    QString m_outgoingServer;
    int m_outgoingPort;
    Sailfish::Mdm::Accounts::EmailAccountProvisioner::ConnectionEncryption m_outgoingConnectionEncryption;
    bool m_outgoingAcceptUntrustedCertificates;
    Sailfish::Mdm::Accounts::EmailAccountProvisioner::Authentication m_outgoingAuthentication;
};

class ActiveSyncAccountProvisionerPrivate : public ProvisionerPrivate
{
    Q_OBJECT

public:
    ActiveSyncAccountProvisionerPrivate(ActiveSyncAccountProvisioner *parent);
    ~ActiveSyncAccountProvisionerPrivate() override;

    bool canCreateAccount() const Q_DECL_OVERRIDE;

    QString m_defaultServiceName;
    QString m_username;
    QString m_password;
    QString m_emailAddress;
    QString m_description;
    QString m_signature;
    QString m_domain;
    QString m_serverAddress;
    int m_port;
    bool m_secureConnection;
    bool m_acceptUntrustedCertificates;
    QString m_certificate;
    QString m_certPassphrase;
};

} // Accounts
} // Mdm
} // Sailfish

#endif // SAILFISH_MDM_ACCOUNTS_P_H
