/****************************************************************************************
**
** SPDX-FileCopyrightText: 2015-2021 Jolla Ltd.
** SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.2
import QtQuick.Window 2.3

Item {
    id: virtualKeyboardObserver

    property bool isOnPortraitScreen: virtualKeyboardObserver.Screen.primaryOrientation === Qt.PortraitOrientation
    property bool transpose: Screen.angleBetween(orientation, Screen.primaryOrientation) % 180
    property bool active

    property int orientation: Qt.PrimaryOrientation
    readonly property bool verticalOrientation: orientation === Qt.PortraitOrientation ||
                                                orientation === Qt.InvertedPortraitOrientation ||
                                                orientation === Qt.PrimaryOrientation && isOnPortraitScreen
    readonly property bool horizontalOrientation: orientation === Qt.LandscapeOrientation ||
                                                  orientation === Qt.InvertedLandscapeOrientation ||
                                                  orientation === Qt.PrimaryOrientation && !isOnPortraitScreen

    property bool testMode

    // panelSize is the sometimes animated imSize
    property real panelSize: 0
    property real previousImSize: 0
    property real imSize: {
        if (!active || Screen.name !== Qt.application.screens[0].name) {
            return 0
        }

        return transpose ? Qt.inputMethod.keyboardRectangle.width
                         : Qt.inputMethod.keyboardRectangle.height
    }

    // When closing im panel imSize changes to zero immediately.
    readonly property bool opened: imSize > 0 && panelSize == imSize
    readonly property bool closed: imSize == 0 && panelSize == imSize
    readonly property bool animating: imHideAnimation.running || imShowAnimation.running

    onImSizeChanged: {
        if (imSize <= 0 && previousImSize > 0) {
            imShowAnimation.stop()
            imHideAnimation.start()
        } else if (imSize > 0 && previousImSize <= 0) {
            imHideAnimation.stop()
            imShowAnimation.to = imSize
            imShowAnimation.start()
        } else {
            panelSize = imSize
        }

        previousImSize = imSize
    }

    SequentialAnimation {
        id: imHideAnimation
        PauseAnimation {
            duration: testMode ? 5 : 200
        }
        NumberAnimation {
            target: virtualKeyboardObserver
            property: 'panelSize'
            to: 0
            duration: testMode ? 5 : 200
            easing.type: Easing.InOutQuad
        }
    }

    NumberAnimation {
        id: imShowAnimation
        target: virtualKeyboardObserver
        property: 'panelSize'
        duration: testMode ? 5 : 200
        easing.type: Easing.InOutQuad
    }
}
