/****************************************************************************************
**
** SPDX-FileCopyrightText: 2019 Jolla Ltd.
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private

Private.SilicaRectangle {
    id: cursor

    property bool toggled
    readonly property alias active: timer.running
    property Item editor: parent
    property QtObject preedit

    property bool _blinkEnabled: true

    onActiveChanged: if (active) toggled = true

    function reset() {
        if (active) {
            timer.restart()
            toggled = true
        }
    }

    visible: active && (toggled || !_blinkEnabled) && editor.selectedText === ""
    color: palette.primaryColor
    width: Math.floor(Theme.dp(2))

    Timer {
        id: timer
        repeat: true
        interval: 800 // TODO: use Qt.styleHints.cursorFlashTime ?
        running: editor.activeFocus && editor.selectionStart === editor.selectionEnd
                 && Qt.application.active
        onTriggered: toggled = !toggled
    }
    Connections {
        target: active ? editor : null
        onTextChanged: reset()
        onCursorPositionChanged: reset()
    }
    Connections {
        target: active ? preedit : null
        onTextChanged: reset()
    }
}
