/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd.
** SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0
import "private"

SilicaMouseArea {
    id: switchItem

    property bool checked
    property alias iconSource: image.source //XXX Deprecated
    property alias icon: image
    property bool down: pressed && containsMouse && !DragFilter.canceled
    property bool busy
    property bool automaticCheck: true

    onPressed: switchItem.DragFilter.begin(mouse.x, mouse.y)
    onCanceled: switchItem.DragFilter.end()
    onPreventStealingChanged: if (preventStealing) switchItem.DragFilter.end()

    onClicked: {
        if (automaticCheck && !busy) {
            checked = !checked
        }
    }

    width: icon.status === Image.Null ? Theme.itemSizeExtraSmall : Theme.itemSizeMedium
    height: column.height

    highlighted: down
    cursorShape: enabled ? Qt.PointingHandCursor : Qt.ArrowCursor

    Column {
        id: column

        anchors.centerIn: parent

        CheckBox {
            id: indicator

            anchors.horizontalCenter: parent.horizontalCenter
            checked: switchItem.checked
            enabled: switchItem.enabled
            busy: switchItem.busy
            highlighted: switchItem.highlighted
        }

        Icon {
            id: image

            visible: status === Image.Ready
            sourceSize: Qt.size(Theme.iconSizeMedium, Theme.iconSizeMedium)
            opacity: switchItem.enabled ? 1.0 : Theme.opacityHigh
            highlighted: false
        }
    }

    // for testing
    function _indicator() {
        return indicator
    }
}
