/****************************************************************************************
**
** SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

Item {
    id: root

    property string text
    property var _parentPopup
    property alias icon: iconImage

    property Palette palette: _parentPopup.palette

    signal clicked()

    // Maximum width of component
    implicitWidth: imageItem.width + 2 * Theme.paddingSmall + Theme.horizontalPageMargin + label.contentWidth
    implicitHeight: row.height
    opacity: enabled ? 1 : Theme.opacityLow

    Rectangle {
        anchors.fill: mouseArea

        color: mouseArea.containsPress ? Theme.rgba(palette.highlightColor, 0.2)
                                       : Theme.rgba(palette.primaryColor, 0.1)
        visible: mouseArea.containsPress
        radius: Theme.paddingSmall
    }

    Row {
        id: row

        leftPadding: Theme.paddingSmall
        rightPadding: Theme.horizontalPageMargin
        spacing: Theme.paddingSmall

        Item {
            id: imageItem

            anchors.verticalCenter: parent.verticalCenter
            width: iconImage.source != "" ? height : Theme.horizontalPageMargin - 2 * Theme.paddingSmall
            height: Theme.dp(72)

            Icon {
                id: iconImage

                anchors.centerIn: parent

                width: Theme.iconSizeSmallPlus
                height: Theme.iconSizeSmallPlus

                asynchronous: true
                highlighted: mouseArea.containsPress
                visible: iconImage.source != ""
            }
        }

        Label {
            id: label

            anchors.verticalCenter: parent.verticalCenter
            // Calculate available width for text
            width: _parentPopup.width - Theme.paddingSmall - imageItem.width - Theme.horizontalPageMargin
            text: root.text
            truncationMode: TruncationMode.Fade
            highlighted: mouseArea.containsPress
            font.pixelSize: Theme.fontSizeMedium
            palette.highlightColor: root.palette.primaryHighlightColor
            palette.primaryColor: root.palette.primaryColor
        }
    }

    MouseArea {
        id: mouseArea

        // Use only visible part of component for interacting
        x: Theme.paddingSmall
        width: _parentPopup.width - 2 * Theme.paddingSmall
        height: parent.height
        cursorShape: enabled ? Qt.PointingHandCursor : Qt.ArrowCursor

        onClicked: {
            root.clicked()
            _parentPopup.close()
        }
    }
}
