#pragma once


#include <qtwaylandclient-config.h>


#include <QtCore/qmath.h>
#include <QtCore/qstring.h>
using QStringView=QString;
using QByteArrayView=QByteArray;
#define sliced(A, B) mid(A, B)
#define QT_IGNORE_DEPRECATIONS(statement) statement
#define Q_UNREACHABLE_RETURN(retval) Q_UNREACHABLE(); return retval;
QT_BEGIN_NAMESPACE
inline QString qEnvironmentVariable(const char *varName, const QString &defaultValue = QString())
{
    const QByteArray value = qgetenv(varName);
    return !value.isNull() ? QString::fromLocal8Bit(value) : defaultValue;
}
namespace Qt {
inline namespace Literals {
inline namespace StringLiterals {
constexpr inline QLatin1Char operator""_L1(char ch) noexcept
{ return QLatin1Char(ch); }
inline QString operator""_L1(const char *str, std::size_t size) noexcept
{ return QString::fromLatin1(str, int(size)); }
inline QString operator""_s(const char16_t *str, std::size_t size) noexcept
{ return QString(reinterpret_cast<const QChar *>(str), int(size)); }
inline QByteArray operator""_ba(const char *str, std::size_t size) noexcept
{ return QByteArray(str, int(size)); }
} // StringLiterals
} // Literals
} // Qt
QT_END_NAMESPACE
