/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

QT_BEGIN_NAMESPACE

/* This part of the file isn't generated, but written by hand since
 * Unicode CLDR doesn't contain measurement system information.
 */
struct CountryLanguage
{
    quint16 languageId;
    quint16 countryId;
    QLocale::MeasurementSystem system;
};
static const CountryLanguage ImperialMeasurementSystems[] = {
    { QLocale::English, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedStatesMinorOutlyingIslands, QLocale::ImperialUSSystem },
    { QLocale::Spanish, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::Hawaiian, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedKingdom, QLocale::ImperialUKSystem }
};
static const int ImperialMeasurementSystemsCount =
    sizeof(ImperialMeasurementSystems)/sizeof(ImperialMeasurementSystems[0]);

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2016-11-28 from the
    Common Locale Data Repository v27

    http://www.unicode.org/cldr/

    Do not change it, instead edit CLDR data and regenerate this file using
    cldr2qlocalexml.py and qlocalexml2cpp.py.
*/


static const QLocaleId likely_subtags[] = {
    {   4,  0,   0 }, {   4,  7,  69 }, // aa -> aa_Latn_ET
    {   2,  0,   0 }, {   2,  2,  81 }, // ab -> ab_Cyrl_GE
    { 255,  0,   0 }, { 255, 36, 102 }, // ae -> ae_Avst_IR
    {   5,  0,   0 }, {   5,  7, 195 }, // af -> af_Latn_ZA
    { 237,  0,   0 }, { 237,  7,  37 }, // agq -> agq_Latn_CM
    { 146,  0,   0 }, { 146,  7,  83 }, // ak -> ak_Latn_GH
    { 262,  0,   0 }, { 262, 94, 103 }, // akk -> akk_Xsux_IQ
    {   7,  0,   0 }, {   7, 14,  69 }, // am -> am_Ethi_ET
    {   8,  0,   0 }, {   8,  1,  64 }, // ar -> ar_Arab_EG
    { 265,  0,   0 }, { 265, 57, 102 }, // arc -> arc_Armi_IR
    { 265, 119,   0 }, { 265, 119, 109 }, // arc_Nbat -> arc_Nbat_JO
    { 265, 120,   0 }, { 265, 120, 207 }, // arc_Palm -> arc_Palm_SY
    { 315,  0,   0 }, { 315,  7,  43 }, // arn -> arn_Latn_CL
    {  10,  0,   0 }, {  10, 11, 100 }, // as -> as_Beng_IN
    { 205,  0,   0 }, { 205,  7, 210 }, // asa -> asa_Latn_TZ
    { 256,  0,   0 }, { 256,  7, 197 }, // ast -> ast_Latn_ES
    { 216,  0,   0 }, { 216,  2, 178 }, // av -> av_Cyrl_RU
    {  11,  0,   0 }, {  11,  7,  26 }, // ay -> ay_Latn_BO
    {  12,  0,   0 }, {  12,  7,  15 }, // az -> az_Latn_AZ
    {  12,  0, 102 }, {  12,  1, 102 }, // az_IR -> az_Arab_IR
    {  12,  0, 178 }, {  12,  2, 178 }, // az_RU -> az_Cyrl_RU
    {  12,  1,   0 }, {  12,  1, 102 }, // az_Arab -> az_Arab_IR
    {  13,  0,   0 }, {  13,  2, 178 }, // ba -> ba_Cyrl_RU
    { 266,  0,   0 }, { 266,  7, 101 }, // ban -> ban_Latn_ID
    { 238,  0,   0 }, { 238,  7,  37 }, // bas -> bas_Latn_CM
    { 267,  0,   0 }, { 267, 38,  37 }, // bax -> bax_Bamu_CM
    { 268,  0,   0 }, { 268,  7, 101 }, // bbc -> bbc_Latn_ID
    {  22,  0,   0 }, {  22,  2,  20 }, // be -> be_Cyrl_BY
    { 195,  0,   0 }, { 195,  7, 239 }, // bem -> bem_Latn_ZM
    { 186,  0,   0 }, { 186,  7, 210 }, // bez -> bez_Latn_TZ
    {  20,  0,   0 }, {  20,  2,  33 }, // bg -> bg_Cyrl_BG
    {  17,  0,   0 }, {  17, 61, 100 }, // bh -> bh_Kthi_IN
    {  18,  0,   0 }, {  18,  7, 229 }, // bi -> bi_Latn_VU
    { 270,  0,   0 }, { 270,  7, 170 }, // bku -> bku_Latn_PH
    { 309,  0,   0 }, { 309, 100, 232 }, // blt -> blt_Tavt_VN
    { 188,  0,   0 }, { 188,  7, 132 }, // bm -> bm_Latn_ML
    {  15,  0,   0 }, {  15, 11,  18 }, // bn -> bn_Beng_BD
    { 121,  0,   0 }, { 121, 31,  44 }, // bo -> bo_Tibt_CN
    {  19,  0,   0 }, {  19,  7,  74 }, // br -> br_Latn_FR
    { 215,  0,   0 }, { 215, 13, 100 }, // brx -> brx_Deva_IN
    { 142,  0,   0 }, { 142,  7,  27 }, // bs -> bs_Latn_BA
    { 336,  0,   0 }, { 336, 106, 121 }, // bsq -> bsq_Bass_LR
    { 312,  0,   0 }, { 312,  7,  37 }, // bss -> bss_Latn_CM
    { 269,  0,   0 }, { 269,  7, 101 }, // bug -> bug_Latn_ID
    { 152,  0,   0 }, { 152, 14,  67 }, // byn -> byn_Ethi_ER
    {  24,  0,   0 }, {  24,  7, 197 }, // ca -> ca_Latn_ES
    { 156,  0,   0 }, { 156,  7, 157 }, // cch -> cch_Latn_NG
    { 272,  0,   0 }, { 272, 11, 100 }, // ccp -> ccp_Beng_IN
    { 272, 46,   0 }, { 272, 46,  18 }, // ccp_Cakm -> ccp_Cakm_BD
    { 218,  0,   0 }, { 218,  2, 178 }, // ce -> ce_Cyrl_RU
    { 211,  0,   0 }, { 211,  7, 221 }, // cgg -> cgg_Latn_UG
    { 217,  0,   0 }, { 217,  7,  89 }, // ch -> ch_Latn_GU
    { 190,  0,   0 }, { 190, 12, 225 }, // chr -> chr_Cher_US
    { 276,  0,   0 }, { 276, 47, 232 }, // cjm -> cjm_Cham_VN
    { 316,  0,   0 }, { 316,  1, 103 }, // ckb -> ckb_Arab_IQ
    {  26,  0,   0 }, {  26,  7,  74 }, // co -> co_Latn_FR
    { 274,  0,   0 }, { 274, 48,  64 }, // cop -> cop_Copt_EG
    { 221,  0,   0 }, { 221, 44,  38 }, // cr -> cr_Cans_CA
    {  28,  0,   0 }, {  28,  7,  57 }, // cs -> cs_Latn_CZ
    { 338,  0,   0 }, { 338, 121, 147 }, // ctd -> ctd_Pauc_MM
    { 219,  0,   0 }, { 219,  2, 178 }, // cu -> cu_Cyrl_RU
    { 219, 52,   0 }, { 219, 52,  33 }, // cu_Glag -> cu_Glag_BG
    { 220,  0,   0 }, { 220,  2, 178 }, // cv -> cv_Cyrl_RU
    { 134,  0,   0 }, { 134,  7, 224 }, // cy -> cy_Latn_GB
    {  29,  0,   0 }, {  29,  7,  58 }, // da -> da_Latn_DK
    { 176,  0,   0 }, { 176,  7, 111 }, // dav -> dav_Latn_KE
    {  42,  0,   0 }, {  42,  7,  82 }, // de -> de_Latn_DE
    { 239,  0,   0 }, { 239,  7, 156 }, // dje -> dje_Latn_NE
    { 275,  0,   0 }, { 275,  1, 100 }, // doi -> doi_Arab_IN
    { 317,  0,   0 }, { 317,  7,  82 }, // dsb -> dsb_Latn_DE
    { 240,  0,   0 }, { 240,  7,  37 }, // dua -> dua_Latn_CM
    { 143,  0,   0 }, { 143, 29, 131 }, // dv -> dv_Thaa_MV
    { 241,  0,   0 }, { 241,  7, 187 }, // dyo -> dyo_Latn_SN
    {  16,  0,   0 }, {  16, 31,  25 }, // dz -> dz_Tibt_BT
    { 189,  0,   0 }, { 189,  7, 111 }, // ebu -> ebu_Latn_KE
    { 161,  0,   0 }, { 161,  7,  83 }, // ee -> ee_Latn_GH
    { 263,  0,   0 }, { 263, 50,  64 }, // egy -> egy_Egyp_EG
    { 277,  0,   0 }, { 277, 63, 147 }, // eky -> eky_Kali_MM
    {  43,  0,   0 }, {  43, 16,  85 }, // el -> el_Grek_GR
    {  31,  0,   0 }, {  31,  7, 225 }, // en -> en_Latn_US
    {  31, 92,   0 }, {  31, 92, 224 }, // en_Shaw -> en_Shaw_GB
    { 111,  0,   0 }, { 111,  7, 197 }, // es -> es_Latn_ES
    {  33,  0,   0 }, {  33,  7,  68 }, // et -> et_Latn_EE
    { 278,  0,   0 }, { 278, 79, 106 }, // ett -> ett_Ital_IT
    {  14,  0,   0 }, {  14,  7, 197 }, // eu -> eu_Latn_ES
    { 242,  0,   0 }, { 242,  7,  37 }, // ewo -> ewo_Latn_CM
    {  89,  0,   0 }, {  89,  1, 102 }, // fa -> fa_Arab_IR
    { 177,  0,   0 }, { 177,  7, 187 }, // ff -> ff_Latn_SN
    {  36,  0,   0 }, {  36,  7,  73 }, // fi -> fi_Latn_FI
    { 166,  0,   0 }, { 166,  7, 170 }, // fil -> fil_Latn_PH
    {  35,  0,   0 }, {  35,  7,  72 }, // fj -> fj_Latn_FJ
    {  34,  0,   0 }, {  34,  7,  71 }, // fo -> fo_Latn_FO
    {  37,  0,   0 }, {  37,  7,  74 }, // fr -> fr_Latn_FR
    { 159,  0,   0 }, { 159,  7, 106 }, // fur -> fur_Latn_IT
    {  38,  0,   0 }, {  38,  7, 151 }, // fy -> fy_Latn_NL
    {  57,  0,   0 }, {  57,  7, 104 }, // ga -> ga_Latn_IE
    { 148,  0,   0 }, { 148,  7,  83 }, // gaa -> gaa_Latn_GH
    {  39,  0,   0 }, {  39,  7, 224 }, // gd -> gd_Latn_GB
    { 153,  0,   0 }, { 153, 14,  69 }, // gez -> gez_Ethi_ET
    {  40,  0,   0 }, {  40,  7, 197 }, // gl -> gl_Latn_ES
    {  45,  0,   0 }, {  45,  7, 168 }, // gn -> gn_Latn_PY
    { 279,  0,   0 }, { 279, 53, 222 }, // got -> got_Goth_UA
    { 264,  0,   0 }, { 264, 49,  56 }, // grc -> grc_Cprt_CY
    { 264, 68,   0 }, { 264, 68,  85 }, // grc_Linb -> grc_Linb_GR
    { 167,  0,   0 }, { 167,  7, 206 }, // gsw -> gsw_Latn_CH
    {  46,  0,   0 }, {  46, 17, 100 }, // gu -> gu_Gujr_IN
    { 175,  0,   0 }, { 175,  7, 111 }, // guz -> guz_Latn_KE
    { 144,  0,   0 }, { 144,  7, 251 }, // gv -> gv_Latn_IM
    {  47,  0,   0 }, {  47,  7, 157 }, // ha -> ha_Latn_NG
    {  47,  0,  37 }, {  47,  1,  37 }, // ha_CM -> ha_Arab_CM
    {  47,  0, 201 }, {  47,  1, 201 }, // ha_SD -> ha_Arab_SD
    { 163,  0,   0 }, { 163,  7, 225 }, // haw -> haw_Latn_US
    {  48,  0,   0 }, {  48, 18, 105 }, // he -> he_Hebr_IL
    {  49,  0,   0 }, {  49, 13, 100 }, // hi -> hi_Deva_IN
    { 282,  0,   0 }, { 282, 86,  44 }, // hmd -> hmd_Plrd_CN
    { 333,  0,   0 }, { 333, 110, 117 }, // hnj -> hnj_Hmng_LA
    { 280,  0,   0 }, { 280,  7, 170 }, // hnn -> hnn_Latn_PH
    { 224,  0,   0 }, { 224,  7, 167 }, // ho -> ho_Latn_PG
    { 334,  0,   0 }, { 334, 13, 100 }, // hoc -> hoc_Deva_IN
    {  27,  0,   0 }, {  27,  7,  54 }, // hr -> hr_Latn_HR
    { 318,  0,   0 }, { 318,  7,  82 }, // hsb -> hsb_Latn_DE
    { 222,  0,   0 }, { 222,  7,  94 }, // ht -> ht_Latn_HT
    {  50,  0,   0 }, {  50,  7,  98 }, // hu -> hu_Latn_HU
    {   9,  0,   0 }, {   9, 10,  11 }, // hy -> hy_Armn_AM
    { 223,  0,   0 }, { 223,  7, 148 }, // hz -> hz_Latn_NA
    {  53,  0,   0 }, {  53,  7,  74 }, // ia -> ia_Latn_FR
    {  52,  0,   0 }, {  52,  7, 101 }, // id -> id_Latn_ID
    { 149,  0,   0 }, { 149,  7, 157 }, // ig -> ig_Latn_NG
    { 168,  0,   0 }, { 168, 34,  44 }, // ii -> ii_Yiii_CN
    {  56,  0,   0 }, {  56,  7, 225 }, // ik -> ik_Latn_US
    { 281,  0,   0 }, { 281,  2, 178 }, // inh -> inh_Cyrl_RU
    {  51,  0,   0 }, {  51,  7,  99 }, // is -> is_Latn_IS
    {  58,  0,   0 }, {  58,  7, 106 }, // it -> it_Latn_IT
    {  55,  0,   0 }, {  55, 44,  38 }, // iu -> iu_Cans_CA
    {  59,  0,   0 }, {  59, 19, 108 }, // ja -> ja_Jpan_JP
    { 257,  0,   0 }, { 257,  7,  37 }, // jgo -> jgo_Latn_CM
    { 200,  0,   0 }, { 200,  7, 210 }, // jmc -> jmc_Latn_TZ
    {  60,  0,   0 }, {  60,  7, 101 }, // jv -> jv_Latn_ID
    {  41,  0,   0 }, {  41, 15,  81 }, // ka -> ka_Geor_GE
    { 184,  0,   0 }, { 184,  7,   3 }, // kab -> kab_Latn_DZ
    { 158,  0,   0 }, { 158,  7, 157 }, // kaj -> kaj_Latn_NG
    { 150,  0,   0 }, { 150,  7, 111 }, // kam -> kam_Latn_KE
    { 164,  0,   0 }, { 164,  7, 157 }, // kcg -> kcg_Latn_NG
    { 192,  0,   0 }, { 192,  7, 210 }, // kde -> kde_Latn_TZ
    { 196,  0,   0 }, { 196,  7,  39 }, // kea -> kea_Latn_CV
    { 319,  0,   0 }, { 319,  7,  37 }, // ken -> ken_Latn_CM
    { 154,  0,   0 }, { 154,  7,  53 }, // kfo -> kfo_Latn_CI
    { 227,  0,   0 }, { 227,  7,  49 }, // kg -> kg_Latn_CD
    { 286,  0,   0 }, { 286, 76,  44 }, // khb -> khb_Talu_CN
    { 208,  0,   0 }, { 208,  7, 132 }, // khq -> khq_Latn_ML
    { 178,  0,   0 }, { 178,  7, 111 }, // ki -> ki_Latn_KE
    { 228,  0,   0 }, { 228,  7, 148 }, // kj -> kj_Latn_NA
    {  63,  0,   0 }, {  63,  2, 110 }, // kk -> kk_Cyrl_KZ
    {  63,  0,   1 }, {  63,  1,   1 }, // kk_AF -> kk_Arab_AF
    {  63,  0,  44 }, {  63,  1,  44 }, // kk_CN -> kk_Arab_CN
    {  63,  0, 102 }, {  63,  1, 102 }, // kk_IR -> kk_Arab_IR
    {  63,  0, 143 }, {  63,  1, 143 }, // kk_MN -> kk_Arab_MN
    {  63,  1,   0 }, {  63,  1,  44 }, // kk_Arab -> kk_Arab_CN
    { 258,  0,   0 }, { 258,  7,  37 }, // kkj -> kkj_Latn_CM
    {  44,  0,   0 }, {  44,  7,  86 }, // kl -> kl_Latn_GL
    { 198,  0,   0 }, { 198,  7, 111 }, // kln -> kln_Latn_KE
    {  23,  0,   0 }, {  23, 20,  36 }, // km -> km_Khmr_KH
    {  61,  0,   0 }, {  61, 21, 100 }, // kn -> kn_Knda_IN
    {  66,  0,   0 }, {  66, 22, 114 }, // ko -> ko_Kore_KR
    { 147,  0,   0 }, { 147, 13, 100 }, // kok -> kok_Deva_IN
    { 169,  0,   0 }, { 169,  7, 121 }, // kpe -> kpe_Latn_LR
    {  62,  0,   0 }, {  62,  1, 100 }, // ks -> ks_Arab_IN
    { 214,  0,   0 }, { 214,  7, 210 }, // ksb -> ksb_Latn_TZ
    { 243,  0,   0 }, { 243,  7,  37 }, // ksf -> ksf_Latn_CM
    { 201,  0,   0 }, { 201,  7,  82 }, // ksh -> ksh_Latn_DE
    {  67,  0,   0 }, {  67,  7, 217 }, // ku -> ku_Latn_TR
    {  67,  0, 119 }, {  67,  1, 119 }, // ku_LB -> ku_Arab_LB
    {  67,  1,   0 }, {  67,  1, 103 }, // ku_Arab -> ku_Arab_IQ
    { 226,  0,   0 }, { 226,  2, 178 }, // kv -> kv_Cyrl_RU
    { 145,  0,   0 }, { 145,  7, 224 }, // kw -> kw_Latn_GB
    {  65,  0,   0 }, {  65,  2, 116 }, // ky -> ky_Cyrl_KG
    {  65,  0,  44 }, {  65,  1,  44 }, // ky_CN -> ky_Arab_CN
    {  65,  0, 217 }, {  65,  7, 217 }, // ky_TR -> ky_Latn_TR
    {  65,  1,   0 }, {  65,  1,  44 }, // ky_Arab -> ky_Arab_CN
    {  65,  7,   0 }, {  65,  7, 217 }, // ky_Latn -> ky_Latn_TR
    {  70,  0,   0 }, {  70,  7, 230 }, // la -> la_Latn_VA
    { 332,  0,   0 }, { 332, 112,  85 }, // lab -> lab_Lina_GR
    { 193,  0,   0 }, { 193,  7, 210 }, // lag -> lag_Latn_TZ
    { 231,  0,   0 }, { 231,  7, 125 }, // lb -> lb_Latn_LU
    { 283,  0,   0 }, { 283, 66, 100 }, // lep -> lep_Lepc_IN
    { 335,  0,   0 }, { 335,  2, 178 }, // lez -> lez_Cyrl_RU
    { 194,  0,   0 }, { 194,  7, 221 }, // lg -> lg_Latn_UG
    { 229,  0,   0 }, { 229,  7, 151 }, // li -> li_Latn_NL
    { 284,  0,   0 }, { 284, 13, 150 }, // lif -> lif_Deva_NP
    { 284, 67,   0 }, { 284, 67, 100 }, // lif_Limb -> lif_Limb_IN
    { 285,  0,   0 }, { 285, 51,  44 }, // lis -> lis_Lisu_CN
    { 313,  0,   0 }, { 313,  7, 225 }, // lkt -> lkt_Latn_US
    {  72,  0,   0 }, {  72,  7,  49 }, // ln -> ln_Latn_CD
    {  69,  0,   0 }, {  69, 23, 117 }, // lo -> lo_Laoo_LA
    {  73,  0,   0 }, {  73,  7, 124 }, // lt -> lt_Latn_LT
    { 230,  0,   0 }, { 230,  7,  49 }, // lu -> lu_Latn_CD
    { 210,  0,   0 }, { 210,  7, 111 }, // luo -> luo_Latn_KE
    { 204,  0,   0 }, { 204,  7, 111 }, // luy -> luy_Latn_KE
    {  71,  0,   0 }, {  71,  7, 118 }, // lv -> lv_Latn_LV
    { 339,  0,   0 }, { 339, 13, 100 }, // mai -> mai_Deva_IN
    { 289,  0,   0 }, { 289,  7,  80 }, // man -> man_Latn_GM
    { 289,  0,  91 }, { 289, 75,  91 }, // man_GN -> man_Nkoo_GN
    { 289, 75,   0 }, { 289, 75,  91 }, // man_Nkoo -> man_Nkoo_GN
    { 202,  0,   0 }, { 202,  7, 111 }, // mas -> mas_Latn_KE
    { 330,  0,   0 }, { 330,  7, 189 }, // men -> men_Latn_SL
    { 197,  0,   0 }, { 197,  7, 111 }, // mer -> mer_Latn_KE
    { 191,  0,   0 }, { 191,  7, 137 }, // mfe -> mfe_Latn_MU
    {  75,  0,   0 }, {  75,  7, 128 }, // mg -> mg_Latn_MG
    { 244,  0,   0 }, { 244,  7, 146 }, // mgh -> mgh_Latn_MZ
    { 259,  0,   0 }, { 259,  7,  37 }, // mgo -> mgo_Latn_CM
    {  81,  0,   0 }, {  81,  7, 134 }, // mh -> mh_Latn_MH
    {  79,  0,   0 }, {  79,  7, 154 }, // mi -> mi_Latn_NZ
    {  74,  0,   0 }, {  74,  2, 127 }, // mk -> mk_Cyrl_MK
    {  77,  0,   0 }, {  77, 24, 100 }, // ml -> ml_Mlym_IN
    {  82,  0,   0 }, {  82,  2, 143 }, // mn -> mn_Cyrl_MN
    {  82,  0,  44 }, {  82,  8,  44 }, // mn_CN -> mn_Mong_CN
    {  82,  8,   0 }, {  82,  8,  44 }, // mn_Mong -> mn_Mong_CN
    { 290,  0,   0 }, { 290, 11, 100 }, // mni -> mni_Beng_IN
    { 320,  0,   0 }, { 320,  7,  38 }, // moh -> moh_Latn_CA
    {  80,  0,   0 }, {  80, 13, 100 }, // mr -> mr_Deva_IN
    { 337,  0,   0 }, { 337, 117,  18 }, // mru -> mru_Mroo_BD
    {  76,  0,   0 }, {  76,  7, 130 }, // ms -> ms_Latn_MY
    {  76,  0,  46 }, {  76,  1,  46 }, // ms_CC -> ms_Arab_CC
    {  76,  0, 101 }, {  76,  1, 101 }, // ms_ID -> ms_Arab_ID
    {  78,  0,   0 }, {  78,  7, 133 }, // mt -> mt_Latn_MT
    { 245,  0,   0 }, { 245,  7,  37 }, // mua -> mua_Latn_CM
    {  21,  0,   0 }, {  21, 25, 147 }, // my -> my_Mymr_MM
    { 273,  0,   0 }, { 273, 71, 102 }, // myz -> myz_Mand_IR
    {  83,  0,   0 }, {  83,  7, 149 }, // na -> na_Latn_NR
    { 199,  0,   0 }, { 199,  7, 148 }, // naq -> naq_Latn_NA
    {  85,  0,   0 }, {  85,  7, 161 }, // nb -> nb_Latn_NO
    { 181,  0,   0 }, { 181,  7, 240 }, // nd -> nd_Latn_ZW
    { 170,  0,   0 }, { 170,  7,  82 }, // nds -> nds_Latn_DE
    {  84,  0,   0 }, {  84, 13, 150 }, // ne -> ne_Deva_NP
    { 233,  0,   0 }, { 233,  7, 148 }, // ng -> ng_Latn_NA
    {  30,  0,   0 }, {  30,  7, 151 }, // nl -> nl_Latn_NL
    { 246,  0,   0 }, { 246,  7,  37 }, // nmg -> nmg_Latn_CM
    { 141,  0,   0 }, { 141,  7, 161 }, // nn -> nn_Latn_NO
    { 260,  0,   0 }, { 260,  7,  37 }, // nnh -> nnh_Latn_CM
    { 292,  0,   0 }, { 292, 65, 211 }, // nod -> nod_Lana_TH
    { 294,  0,   0 }, { 294, 88, 205 }, // non -> non_Runr_SE
    { 321,  0,   0 }, { 321, 75,  91 }, // nqo -> nqo_Nkoo_GN
    { 171,  0,   0 }, { 171,  7, 195 }, // nr -> nr_Latn_ZA
    { 172,  0,   0 }, { 172,  7, 195 }, // nso -> nso_Latn_ZA
    { 247,  0,   0 }, { 247,  7, 201 }, // nus -> nus_Latn_SD
    { 232,  0,   0 }, { 232,  7, 225 }, // nv -> nv_Latn_US
    { 165,  0,   0 }, { 165,  7, 129 }, // ny -> ny_Latn_MW
    { 185,  0,   0 }, { 185,  7, 221 }, // nyn -> nyn_Latn_UG
    {  86,  0,   0 }, {  86,  7,  74 }, // oc -> oc_Latn_FR
    {   3,  0,   0 }, {   3,  7,  69 }, // om -> om_Latn_ET
    {  87,  0,   0 }, {  87, 26, 100 }, // or -> or_Orya_IN
    { 101,  0,   0 }, { 101,  2,  81 }, // os -> os_Cyrl_GE
    { 296,  0,   0 }, { 296, 82, 143 }, // otk -> otk_Orkh_MN
    {  92,  0,   0 }, {  92,  4, 100 }, // pa -> pa_Guru_IN
    {  92,  0, 163 }, {  92,  1, 163 }, // pa_PK -> pa_Arab_PK
    {  92,  1,   0 }, {  92,  1, 163 }, // pa_Arab -> pa_Arab_PK
    { 297,  0,   0 }, { 297, 58, 102 }, // pal -> pal_Phli_IR
    { 297, 123,   0 }, { 297, 123,  44 }, // pal_Phlp -> pal_Phlp_CN
    { 295,  0,   0 }, { 295, 80, 102 }, // peo -> peo_Xpeo_IR
    { 299,  0,   0 }, { 299, 85, 119 }, // phn -> phn_Phnx_LB
    {  90,  0,   0 }, {  90,  7, 172 }, // pl -> pl_Latn_PL
    { 300,  0,   0 }, { 300, 64, 163 }, // pra -> pra_Khar_PK
    {  88,  0,   0 }, {  88,  1,   1 }, // ps -> ps_Arab_AF
    {  91,  0,   0 }, {  91,  7,  30 }, // pt -> pt_Latn_BR
    {  93,  0,   0 }, {  93,  7, 169 }, // qu -> qu_Latn_PE
    { 323,  0,   0 }, { 323,  7,  90 }, // quc -> quc_Latn_GT
    { 301,  0,   0 }, { 301,  7, 101 }, // rej -> rej_Latn_ID
    {  94,  0,   0 }, {  94,  7, 206 }, // rm -> rm_Latn_CH
    {  68,  0,   0 }, {  68,  7,  35 }, // rn -> rn_Latn_BI
    {  95,  0,   0 }, {  95,  7, 177 }, // ro -> ro_Latn_RO
    { 182,  0,   0 }, { 182,  7, 210 }, // rof -> rof_Latn_TZ
    {  96,  0,   0 }, {  96,  2, 178 }, // ru -> ru_Cyrl_RU
    {  64,  0,   0 }, {  64,  7, 179 }, // rw -> rw_Latn_RW
    { 209,  0,   0 }, { 209,  7, 210 }, // rwk -> rwk_Latn_TZ
    {  99,  0,   0 }, {  99, 13, 100 }, // sa -> sa_Deva_IN
    { 248,  0,   0 }, { 248,  2, 178 }, // sah -> sah_Cyrl_RU
    { 179,  0,   0 }, { 179,  7, 111 }, // saq -> saq_Latn_KE
    { 304,  0,   0 }, { 304,  7, 100 }, // sat -> sat_Latn_IN
    { 305,  0,   0 }, { 305, 90, 100 }, // saz -> saz_Saur_IN
    { 249,  0,   0 }, { 249,  7, 210 }, // sbp -> sbp_Latn_TZ
    { 115,  0,   0 }, { 115,  7, 106 }, // sc -> sc_Latn_IT
    { 105,  0,   0 }, { 105,  1, 163 }, // sd -> sd_Arab_PK
    { 105, 13,   0 }, { 105, 13, 100 }, // sd_Deva -> sd_Deva_IN
    { 105, 111,   0 }, { 105, 111, 100 }, // sd_Khoj -> sd_Khoj_IN
    { 105, 125,   0 }, { 105, 125, 100 }, // sd_Sind -> sd_Sind_IN
    { 173,  0,   0 }, { 173,  7, 161 }, // se -> se_Latn_NO
    { 180,  0,   0 }, { 180,  7, 146 }, // seh -> seh_Latn_MZ
    { 213,  0,   0 }, { 213,  7, 132 }, // ses -> ses_Latn_ML
    {  98,  0,   0 }, {  98,  7,  41 }, // sg -> sg_Latn_CF
    { 293,  0,   0 }, { 293, 77, 104 }, // sga -> sga_Ogam_IE
    { 183,  0,   0 }, { 183,  9, 145 }, // shi -> shi_Tfng_MA
    { 106,  0,   0 }, { 106, 32, 198 }, // si -> si_Sinh_LK
    { 155,  0,   0 }, { 155,  7,  69 }, // sid -> sid_Latn_ET
    { 108,  0,   0 }, { 108,  7, 191 }, // sk -> sk_Latn_SK
    { 109,  0,   0 }, { 109,  7, 192 }, // sl -> sl_Latn_SI
    {  97,  0,   0 }, {  97,  7, 183 }, // sm -> sm_Latn_WS
    { 324,  0,   0 }, { 324,  7, 205 }, // sma -> sma_Latn_SE
    { 325,  0,   0 }, { 325,  7, 205 }, // smj -> smj_Latn_SE
    { 326,  0,   0 }, { 326,  7,  73 }, // smn -> smn_Latn_FI
    { 303,  0,   0 }, { 303, 89, 105 }, // smp -> smp_Samr_IL
    { 327,  0,   0 }, { 327,  7,  73 }, // sms -> sms_Latn_FI
    { 104,  0,   0 }, { 104,  7, 240 }, // sn -> sn_Latn_ZW
    { 110,  0,   0 }, { 110,  7, 194 }, // so -> so_Latn_SO
    {   6,  0,   0 }, {   6,  7,   2 }, // sq -> sq_Latn_AL
    { 100,  0,   0 }, { 100,  2, 243 }, // sr -> sr_Cyrl_RS
    { 100,  0, 242 }, { 100,  7, 242 }, // sr_ME -> sr_Latn_ME
    { 100,  0, 177 }, { 100,  7, 177 }, // sr_RO -> sr_Latn_RO
    { 100,  0, 178 }, { 100,  7, 178 }, // sr_RU -> sr_Latn_RU
    { 100,  0, 217 }, { 100,  7, 217 }, // sr_TR -> sr_Latn_TR
    { 306,  0,   0 }, { 306, 93, 100 }, // srb -> srb_Sora_IN
    { 107,  0,   0 }, { 107,  7, 195 }, // ss -> ss_Latn_ZA
    { 207,  0,   0 }, { 207,  7,  67 }, // ssy -> ssy_Latn_ER
    { 102,  0,   0 }, { 102,  7, 195 }, // st -> st_Latn_ZA
    { 112,  0,   0 }, { 112,  7, 101 }, // su -> su_Latn_ID
    { 114,  0,   0 }, { 114,  7, 205 }, // sv -> sv_Latn_SE
    { 113,  0,   0 }, { 113,  7, 210 }, // sw -> sw_Latn_TZ
    { 250,  0,   0 }, { 250,  7,  49 }, // swc -> swc_Latn_CD
    { 307,  0,   0 }, { 307, 11,  18 }, // syl -> syl_Beng_BD
    { 151,  0,   0 }, { 151, 33, 103 }, // syr -> syr_Syrc_IQ
    { 117,  0,   0 }, { 117, 27, 100 }, // ta -> ta_Taml_IN
    { 308,  0,   0 }, { 308,  7, 170 }, // tbw -> tbw_Latn_PH
    { 310,  0,   0 }, { 310, 99,  44 }, // tdd -> tdd_Tale_CN
    { 119,  0,   0 }, { 119, 28, 100 }, // te -> te_Telu_IN
    { 206,  0,   0 }, { 206,  7, 221 }, // teo -> teo_Latn_UG
    { 116,  0,   0 }, { 116,  2, 209 }, // tg -> tg_Cyrl_TJ
    { 116,  0, 163 }, { 116,  1, 163 }, // tg_PK -> tg_Arab_PK
    { 116,  1,   0 }, { 116,  1, 163 }, // tg_Arab -> tg_Arab_PK
    { 120,  0,   0 }, { 120, 30, 211 }, // th -> th_Thai_TH
    { 122,  0,   0 }, { 122, 14,  69 }, // ti -> ti_Ethi_ET
    { 157,  0,   0 }, { 157, 14,  67 }, // tig -> tig_Ethi_ER
    { 126,  0,   0 }, { 126,  7, 218 }, // tk -> tk_Latn_TM
    { 103,  0,   0 }, { 103,  7, 195 }, // tn -> tn_Latn_ZA
    { 123,  0,   0 }, { 123,  7, 214 }, // to -> to_Latn_TO
    { 125,  0,   0 }, { 125,  7, 217 }, // tr -> tr_Latn_TR
    { 174,  0,   0 }, { 174,  7, 208 }, // trv -> trv_Latn_TW
    { 124,  0,   0 }, { 124,  7, 195 }, // ts -> ts_Latn_ZA
    { 118,  0,   0 }, { 118,  2, 178 }, // tt -> tt_Cyrl_RU
    { 251,  0,   0 }, { 251,  7, 156 }, // twq -> twq_Latn_NE
    { 127,  0,   0 }, { 127,  7,  77 }, // ty -> ty_Latn_PF
    { 212,  0,   0 }, { 212,  7, 145 }, // tzm -> tzm_Latn_MA
    { 128,  0,   0 }, { 128,  1,  44 }, // ug -> ug_Arab_CN
    { 128,  0, 110 }, { 128,  2, 110 }, // ug_KZ -> ug_Cyrl_KZ
    { 128,  0, 143 }, { 128,  2, 143 }, // ug_MN -> ug_Cyrl_MN
    { 128,  2,   0 }, { 128,  2, 110 }, // ug_Cyrl -> ug_Cyrl_KZ
    { 311,  0,   0 }, { 311, 102, 207 }, // uga -> uga_Ugar_SY
    { 129,  0,   0 }, { 129,  2, 222 }, // uk -> uk_Cyrl_UA
    { 130,  0,   0 }, { 130,  1, 163 }, // ur -> ur_Arab_PK
    { 131,  0,   0 }, { 131,  7, 228 }, // uz -> uz_Latn_UZ
    { 131,  0,   1 }, { 131,  1,   1 }, // uz_AF -> uz_Arab_AF
    { 131,  0,  44 }, { 131,  2,  44 }, // uz_CN -> uz_Cyrl_CN
    { 131,  1,   0 }, { 131,  1,   1 }, // uz_Arab -> uz_Arab_AF
    { 252,  0,   0 }, { 252, 35, 121 }, // vai -> vai_Vaii_LR
    { 160,  0,   0 }, { 160,  7, 195 }, // ve -> ve_Latn_ZA
    { 132,  0,   0 }, { 132,  7, 232 }, // vi -> vi_Latn_VN
    { 187,  0,   0 }, { 187,  7, 210 }, // vun -> vun_Latn_TZ
    { 236,  0,   0 }, { 236,  7,  21 }, // wa -> wa_Latn_BE
    { 253,  0,   0 }, { 253,  7, 206 }, // wae -> wae_Latn_CH
    { 162,  0,   0 }, { 162, 14,  69 }, // wal -> wal_Ethi_ET
    { 328,  0,   0 }, { 328,  7,  13 }, // wbp -> wbp_Latn_AU
    { 135,  0,   0 }, { 135,  7, 187 }, // wo -> wo_Latn_SN
    { 271,  0,   0 }, { 271, 45, 217 }, // xcr -> xcr_Cari_TR
    { 136,  0,   0 }, { 136,  7, 195 }, // xh -> xh_Latn_ZA
    { 287,  0,   0 }, { 287, 69, 217 }, // xlc -> xlc_Lyci_TR
    { 288,  0,   0 }, { 288, 70, 217 }, // xld -> xld_Lydi_TR
    { 329,  0,   0 }, { 329, 114,  44 }, // xmn -> xmn_Mani_CN
    { 291,  0,   0 }, { 291, 74, 201 }, // xmr -> xmr_Merc_SD
    { 331,  0,   0 }, { 331, 118, 186 }, // xna -> xna_Narb_SA
    { 203,  0,   0 }, { 203,  7, 221 }, // xog -> xog_Latn_UG
    { 298,  0,   0 }, { 298, 59, 102 }, // xpr -> xpr_Prti_IR
    { 302,  0,   0 }, { 302, 81, 237 }, // xsa -> xsa_Sarb_YE
    { 254,  0,   0 }, { 254,  7,  37 }, // yav -> yav_Latn_CM
    { 138,  0,   0 }, { 138,  7, 157 }, // yo -> yo_Latn_NG
    { 139,  0,   0 }, { 139,  7,  44 }, // za -> za_Latn_CN
    { 314,  0,   0 }, { 314,  9, 145 }, // zgh -> zgh_Tfng_MA
    {  25,  0,   0 }, {  25,  5,  44 }, // zh -> zh_Hans_CN
    {  25,  0,  13 }, {  25,  6,  13 }, // zh_AU -> zh_Hant_AU
    {  25,  0,  32 }, {  25,  6,  32 }, // zh_BN -> zh_Hant_BN
    {  25,  0, 224 }, {  25,  6, 224 }, // zh_GB -> zh_Hant_GB
    {  25,  0,  76 }, {  25,  6,  76 }, // zh_GF -> zh_Hant_GF
    {  25,  0,  97 }, {  25,  6,  97 }, // zh_HK -> zh_Hant_HK
    {  25,  0, 101 }, {  25,  6, 101 }, // zh_ID -> zh_Hant_ID
    {  25,  0, 126 }, {  25,  6, 126 }, // zh_MO -> zh_Hant_MO
    {  25,  0, 130 }, {  25,  6, 130 }, // zh_MY -> zh_Hant_MY
    {  25,  0, 166 }, {  25,  6, 166 }, // zh_PA -> zh_Hant_PA
    {  25,  0,  77 }, {  25,  6,  77 }, // zh_PF -> zh_Hant_PF
    {  25,  0, 170 }, {  25,  6, 170 }, // zh_PH -> zh_Hant_PH
    {  25,  0, 202 }, {  25,  6, 202 }, // zh_SR -> zh_Hant_SR
    {  25,  0, 211 }, {  25,  6, 211 }, // zh_TH -> zh_Hant_TH
    {  25,  0, 208 }, {  25,  6, 208 }, // zh_TW -> zh_Hant_TW
    {  25,  0, 225 }, {  25,  6, 225 }, // zh_US -> zh_Hant_US
    {  25,  0, 232 }, {  25,  6, 232 }, // zh_VN -> zh_Hant_VN
    {  25, 40,   0 }, {  25, 40, 208 }, // zh_Bopo -> zh_Bopo_TW
    {  25,  6,   0 }, {  25,  6, 208 }, // zh_Hant -> zh_Hant_TW
    { 140,  0,   0 }, { 140,  7, 195 }, // zu -> zu_Latn_ZA
    {   0,  0, 246 }, { 111,  7, 246 }, // und_419 -> es_Latn_419
    {   0,  0,   5 }, {  24,  7,   5 }, // und_AD -> ca_Latn_AD
    {   0,  0, 223 }, {   8,  1, 223 }, // und_AE -> ar_Arab_AE
    {   0,  0,   1 }, {  89,  1,   1 }, // und_AF -> fa_Arab_AF
    {   0,  0,   2 }, {   6,  7,   2 }, // und_AL -> sq_Latn_AL
    {   0,  0,  11 }, {   9, 10,  11 }, // und_AM -> hy_Armn_AM
    {   0,  0,   6 }, {  91,  7,   6 }, // und_AO -> pt_Latn_AO
    {   0,  0,   8 }, {   0,  7,   8 }, // und_AQ -> und_Latn_AQ
    {   0,  0,  10 }, { 111,  7,  10 }, // und_AR -> es_Latn_AR
    {   0,  0,   4 }, {  97,  7,   4 }, // und_AS -> sm_Latn_AS
    {   0,  0,  14 }, {  42,  7,  14 }, // und_AT -> de_Latn_AT
    {   0,  0,  12 }, {  30,  7,  12 }, // und_AW -> nl_Latn_AW
    {   0,  0, 248 }, { 114,  7, 248 }, // und_AX -> sv_Latn_AX
    {   0,  0,  15 }, {  12,  7,  15 }, // und_AZ -> az_Latn_AZ
    {   0,  0,  27 }, { 142,  7,  27 }, // und_BA -> bs_Latn_BA
    {   0,  0,  18 }, {  15, 11,  18 }, // und_BD -> bn_Beng_BD
    {   0,  0,  21 }, {  30,  7,  21 }, // und_BE -> nl_Latn_BE
    {   0,  0,  34 }, {  37,  7,  34 }, // und_BF -> fr_Latn_BF
    {   0,  0,  33 }, {  20,  2,  33 }, // und_BG -> bg_Cyrl_BG
    {   0,  0,  17 }, {   8,  1,  17 }, // und_BH -> ar_Arab_BH
    {   0,  0,  35 }, {  68,  7,  35 }, // und_BI -> rn_Latn_BI
    {   0,  0,  23 }, {  37,  7,  23 }, // und_BJ -> fr_Latn_BJ
    {   0,  0, 244 }, {  37,  7, 244 }, // und_BL -> fr_Latn_BL
    {   0,  0,  32 }, {  76,  7,  32 }, // und_BN -> ms_Latn_BN
    {   0,  0,  26 }, { 111,  7,  26 }, // und_BO -> es_Latn_BO
    {   0,  0,  30 }, {  91,  7,  30 }, // und_BR -> pt_Latn_BR
    {   0,  0,  25 }, {  16, 31,  25 }, // und_BT -> dz_Tibt_BT
    {   0,  0,  29 }, {   0,  7,  29 }, // und_BV -> und_Latn_BV
    {   0,  0,  20 }, {  22,  2,  20 }, // und_BY -> be_Cyrl_BY
    {   0,  0,  49 }, { 113,  7,  49 }, // und_CD -> sw_Latn_CD
    {   0,  0,  41 }, {  37,  7,  41 }, // und_CF -> fr_Latn_CF
    {   0,  0,  50 }, {  37,  7,  50 }, // und_CG -> fr_Latn_CG
    {   0,  0, 206 }, {  42,  7, 206 }, // und_CH -> de_Latn_CH
    {   0,  0,  53 }, {  37,  7,  53 }, // und_CI -> fr_Latn_CI
    {   0,  0,  43 }, { 111,  7,  43 }, // und_CL -> es_Latn_CL
    {   0,  0,  37 }, {  37,  7,  37 }, // und_CM -> fr_Latn_CM
    {   0,  0,  44 }, {  25,  5,  44 }, // und_CN -> zh_Hans_CN
    {   0,  0,  47 }, { 111,  7,  47 }, // und_CO -> es_Latn_CO
    {   0,  0, 241 }, {   0,  7, 241 }, // und_CP -> und_Latn_CP
    {   0,  0,  52 }, { 111,  7,  52 }, // und_CR -> es_Latn_CR
    {   0,  0,  55 }, { 111,  7,  55 }, // und_CU -> es_Latn_CU
    {   0,  0,  39 }, {  91,  7,  39 }, // und_CV -> pt_Latn_CV
    {   0,  0,  56 }, {  43, 16,  56 }, // und_CY -> el_Grek_CY
    {   0,  0,  57 }, {  28,  7,  57 }, // und_CZ -> cs_Latn_CZ
    {   0,  0,  82 }, {  42,  7,  82 }, // und_DE -> de_Latn_DE
    {   0,  0,  59 }, {   4,  7,  59 }, // und_DJ -> aa_Latn_DJ
    {   0,  0,  58 }, {  29,  7,  58 }, // und_DK -> da_Latn_DK
    {   0,  0,  61 }, { 111,  7,  61 }, // und_DO -> es_Latn_DO
    {   0,  0,   3 }, {   8,  1,   3 }, // und_DZ -> ar_Arab_DZ
    {   0,  0, 250 }, { 111,  7, 250 }, // und_EA -> es_Latn_EA
    {   0,  0,  63 }, { 111,  7,  63 }, // und_EC -> es_Latn_EC
    {   0,  0,  68 }, {  33,  7,  68 }, // und_EE -> et_Latn_EE
    {   0,  0,  64 }, {   8,  1,  64 }, // und_EG -> ar_Arab_EG
    {   0,  0, 236 }, {   8,  1, 236 }, // und_EH -> ar_Arab_EH
    {   0,  0,  67 }, { 122, 14,  67 }, // und_ER -> ti_Ethi_ER
    {   0,  0, 197 }, { 111,  7, 197 }, // und_ES -> es_Latn_ES
    {   0,  0,  69 }, {   7, 14,  69 }, // und_ET -> am_Ethi_ET
    {   0,  0,  73 }, {  36,  7,  73 }, // und_FI -> fi_Latn_FI
    {   0,  0,  71 }, {  34,  7,  71 }, // und_FO -> fo_Latn_FO
    {   0,  0,  74 }, {  37,  7,  74 }, // und_FR -> fr_Latn_FR
    {   0,  0,  79 }, {  37,  7,  79 }, // und_GA -> fr_Latn_GA
    {   0,  0,  81 }, {  41, 15,  81 }, // und_GE -> ka_Geor_GE
    {   0,  0,  76 }, {  37,  7,  76 }, // und_GF -> fr_Latn_GF
    {   0,  0,  83 }, { 146,  7,  83 }, // und_GH -> ak_Latn_GH
    {   0,  0,  86 }, {  44,  7,  86 }, // und_GL -> kl_Latn_GL
    {   0,  0,  91 }, {  37,  7,  91 }, // und_GN -> fr_Latn_GN
    {   0,  0,  88 }, {  37,  7,  88 }, // und_GP -> fr_Latn_GP
    {   0,  0,  66 }, { 111,  7,  66 }, // und_GQ -> es_Latn_GQ
    {   0,  0,  85 }, {  43, 16,  85 }, // und_GR -> el_Grek_GR
    {   0,  0, 196 }, {   0,  7, 196 }, // und_GS -> und_Latn_GS
    {   0,  0,  90 }, { 111,  7,  90 }, // und_GT -> es_Latn_GT
    {   0,  0,  92 }, {  91,  7,  92 }, // und_GW -> pt_Latn_GW
    {   0,  0,  97 }, {  25,  6,  97 }, // und_HK -> zh_Hant_HK
    {   0,  0,  95 }, {   0,  7,  95 }, // und_HM -> und_Latn_HM
    {   0,  0,  96 }, { 111,  7,  96 }, // und_HN -> es_Latn_HN
    {   0,  0,  54 }, {  27,  7,  54 }, // und_HR -> hr_Latn_HR
    {   0,  0,  94 }, { 222,  7,  94 }, // und_HT -> ht_Latn_HT
    {   0,  0,  98 }, {  50,  7,  98 }, // und_HU -> hu_Latn_HU
    {   0,  0, 238 }, { 111,  7, 238 }, // und_IC -> es_Latn_IC
    {   0,  0, 101 }, {  52,  7, 101 }, // und_ID -> id_Latn_ID
    {   0,  0, 105 }, {  48, 18, 105 }, // und_IL -> he_Hebr_IL
    {   0,  0, 100 }, {  49, 13, 100 }, // und_IN -> hi_Deva_IN
    {   0,  0, 103 }, {   8,  1, 103 }, // und_IQ -> ar_Arab_IQ
    {   0,  0, 102 }, {  89,  1, 102 }, // und_IR -> fa_Arab_IR
    {   0,  0,  99 }, {  51,  7,  99 }, // und_IS -> is_Latn_IS
    {   0,  0, 106 }, {  58,  7, 106 }, // und_IT -> it_Latn_IT
    {   0,  0, 109 }, {   8,  1, 109 }, // und_JO -> ar_Arab_JO
    {   0,  0, 108 }, {  59, 19, 108 }, // und_JP -> ja_Jpan_JP
    {   0,  0, 111 }, { 113,  7, 111 }, // und_KE -> sw_Latn_KE
    {   0,  0, 116 }, {  65,  2, 116 }, // und_KG -> ky_Cyrl_KG
    {   0,  0,  36 }, {  23, 20,  36 }, // und_KH -> km_Khmr_KH
    {   0,  0,  48 }, {   8,  1,  48 }, // und_KM -> ar_Arab_KM
    {   0,  0, 113 }, {  66, 22, 113 }, // und_KP -> ko_Kore_KP
    {   0,  0, 114 }, {  66, 22, 114 }, // und_KR -> ko_Kore_KR
    {   0,  0, 115 }, {   8,  1, 115 }, // und_KW -> ar_Arab_KW
    {   0,  0, 110 }, {  96,  2, 110 }, // und_KZ -> ru_Cyrl_KZ
    {   0,  0, 117 }, {  69, 23, 117 }, // und_LA -> lo_Laoo_LA
    {   0,  0, 119 }, {   8,  1, 119 }, // und_LB -> ar_Arab_LB
    {   0,  0, 123 }, {  42,  7, 123 }, // und_LI -> de_Latn_LI
    {   0,  0, 198 }, { 106, 32, 198 }, // und_LK -> si_Sinh_LK
    {   0,  0, 120 }, { 102,  7, 120 }, // und_LS -> st_Latn_LS
    {   0,  0, 124 }, {  73,  7, 124 }, // und_LT -> lt_Latn_LT
    {   0,  0, 125 }, {  37,  7, 125 }, // und_LU -> fr_Latn_LU
    {   0,  0, 118 }, {  71,  7, 118 }, // und_LV -> lv_Latn_LV
    {   0,  0, 122 }, {   8,  1, 122 }, // und_LY -> ar_Arab_LY
    {   0,  0, 145 }, {   8,  1, 145 }, // und_MA -> ar_Arab_MA
    {   0,  0, 142 }, {  37,  7, 142 }, // und_MC -> fr_Latn_MC
    {   0,  0, 141 }, {  95,  7, 141 }, // und_MD -> ro_Latn_MD
    {   0,  0, 242 }, { 100,  7, 242 }, // und_ME -> sr_Latn_ME
    {   0,  0, 245 }, {  37,  7, 245 }, // und_MF -> fr_Latn_MF
    {   0,  0, 128 }, {  75,  7, 128 }, // und_MG -> mg_Latn_MG
    {   0,  0, 127 }, {  74,  2, 127 }, // und_MK -> mk_Cyrl_MK
    {   0,  0, 132 }, { 188,  7, 132 }, // und_ML -> bm_Latn_ML
    {   0,  0, 147 }, {  21, 25, 147 }, // und_MM -> my_Mymr_MM
    {   0,  0, 143 }, {  82,  2, 143 }, // und_MN -> mn_Cyrl_MN
    {   0,  0, 126 }, {  25,  6, 126 }, // und_MO -> zh_Hant_MO
    {   0,  0, 135 }, {  37,  7, 135 }, // und_MQ -> fr_Latn_MQ
    {   0,  0, 136 }, {   8,  1, 136 }, // und_MR -> ar_Arab_MR
    {   0,  0, 133 }, {  78,  7, 133 }, // und_MT -> mt_Latn_MT
    {   0,  0, 137 }, { 191,  7, 137 }, // und_MU -> mfe_Latn_MU
    {   0,  0, 131 }, { 143, 29, 131 }, // und_MV -> dv_Thaa_MV
    {   0,  0, 139 }, { 111,  7, 139 }, // und_MX -> es_Latn_MX
    {   0,  0, 130 }, {  76,  7, 130 }, // und_MY -> ms_Latn_MY
    {   0,  0, 146 }, {  91,  7, 146 }, // und_MZ -> pt_Latn_MZ
    {   0,  0, 148 }, {   5,  7, 148 }, // und_NA -> af_Latn_NA
    {   0,  0, 153 }, {  37,  7, 153 }, // und_NC -> fr_Latn_NC
    {   0,  0, 156 }, {  47,  7, 156 }, // und_NE -> ha_Latn_NE
    {   0,  0, 155 }, { 111,  7, 155 }, // und_NI -> es_Latn_NI
    {   0,  0, 151 }, {  30,  7, 151 }, // und_NL -> nl_Latn_NL
    {   0,  0, 161 }, {  85,  7, 161 }, // und_NO -> nb_Latn_NO
    {   0,  0, 150 }, {  84, 13, 150 }, // und_NP -> ne_Deva_NP
    {   0,  0, 162 }, {   8,  1, 162 }, // und_OM -> ar_Arab_OM
    {   0,  0, 166 }, { 111,  7, 166 }, // und_PA -> es_Latn_PA
    {   0,  0, 169 }, { 111,  7, 169 }, // und_PE -> es_Latn_PE
    {   0,  0,  77 }, {  37,  7,  77 }, // und_PF -> fr_Latn_PF
    {   0,  0, 170 }, { 166,  7, 170 }, // und_PH -> fil_Latn_PH
    {   0,  0, 163 }, { 130,  1, 163 }, // und_PK -> ur_Arab_PK
    {   0,  0, 172 }, {  90,  7, 172 }, // und_PL -> pl_Latn_PL
    {   0,  0, 200 }, {  37,  7, 200 }, // und_PM -> fr_Latn_PM
    {   0,  0, 174 }, { 111,  7, 174 }, // und_PR -> es_Latn_PR
    {   0,  0, 165 }, {   8,  1, 165 }, // und_PS -> ar_Arab_PS
    {   0,  0, 173 }, {  91,  7, 173 }, // und_PT -> pt_Latn_PT
    {   0,  0, 168 }, {  45,  7, 168 }, // und_PY -> gn_Latn_PY
    {   0,  0, 175 }, {   8,  1, 175 }, // und_QA -> ar_Arab_QA
    {   0,  0, 176 }, {  37,  7, 176 }, // und_RE -> fr_Latn_RE
    {   0,  0, 177 }, {  95,  7, 177 }, // und_RO -> ro_Latn_RO
    {   0,  0, 243 }, { 100,  2, 243 }, // und_RS -> sr_Cyrl_RS
    {   0,  0, 178 }, {  96,  2, 178 }, // und_RU -> ru_Cyrl_RU
    {   0,  0, 179 }, {  64,  7, 179 }, // und_RW -> rw_Latn_RW
    {   0,  0, 186 }, {   8,  1, 186 }, // und_SA -> ar_Arab_SA
    {   0,  0, 188 }, {  37,  7, 188 }, // und_SC -> fr_Latn_SC
    {   0,  0, 201 }, {   8,  1, 201 }, // und_SD -> ar_Arab_SD
    {   0,  0, 205 }, { 114,  7, 205 }, // und_SE -> sv_Latn_SE
    {   0,  0, 192 }, { 109,  7, 192 }, // und_SI -> sl_Latn_SI
    {   0,  0, 203 }, {  85,  7, 203 }, // und_SJ -> nb_Latn_SJ
    {   0,  0, 191 }, { 108,  7, 191 }, // und_SK -> sk_Latn_SK
    {   0,  0, 184 }, {  58,  7, 184 }, // und_SM -> it_Latn_SM
    {   0,  0, 187 }, {  37,  7, 187 }, // und_SN -> fr_Latn_SN
    {   0,  0, 194 }, { 110,  7, 194 }, // und_SO -> so_Latn_SO
    {   0,  0, 202 }, {  30,  7, 202 }, // und_SR -> nl_Latn_SR
    {   0,  0, 185 }, {  91,  7, 185 }, // und_ST -> pt_Latn_ST
    {   0,  0,  65 }, { 111,  7,  65 }, // und_SV -> es_Latn_SV
    {   0,  0, 207 }, {   8,  1, 207 }, // und_SY -> ar_Arab_SY
    {   0,  0,  42 }, {  37,  7,  42 }, // und_TD -> fr_Latn_TD
    {   0,  0,  78 }, {  37,  7,  78 }, // und_TF -> fr_Latn_TF
    {   0,  0, 212 }, {  37,  7, 212 }, // und_TG -> fr_Latn_TG
    {   0,  0, 211 }, { 120, 30, 211 }, // und_TH -> th_Thai_TH
    {   0,  0, 209 }, { 116,  2, 209 }, // und_TJ -> tg_Cyrl_TJ
    {   0,  0,  62 }, {  91,  7,  62 }, // und_TL -> pt_Latn_TL
    {   0,  0, 218 }, { 126,  7, 218 }, // und_TM -> tk_Latn_TM
    {   0,  0, 216 }, {   8,  1, 216 }, // und_TN -> ar_Arab_TN
    {   0,  0, 214 }, { 123,  7, 214 }, // und_TO -> to_Latn_TO
    {   0,  0, 217 }, { 125,  7, 217 }, // und_TR -> tr_Latn_TR
    {   0,  0, 208 }, {  25,  6, 208 }, // und_TW -> zh_Hant_TW
    {   0,  0, 210 }, { 113,  7, 210 }, // und_TZ -> sw_Latn_TZ
    {   0,  0, 222 }, { 129,  2, 222 }, // und_UA -> uk_Cyrl_UA
    {   0,  0, 221 }, { 113,  7, 221 }, // und_UG -> sw_Latn_UG
    {   0,  0, 227 }, { 111,  7, 227 }, // und_UY -> es_Latn_UY
    {   0,  0, 228 }, { 131,  7, 228 }, // und_UZ -> uz_Latn_UZ
    {   0,  0, 230 }, {  58,  7, 230 }, // und_VA -> it_Latn_VA
    {   0,  0, 231 }, { 111,  7, 231 }, // und_VE -> es_Latn_VE
    {   0,  0, 232 }, { 132,  7, 232 }, // und_VN -> vi_Latn_VN
    {   0,  0, 229 }, {  18,  7, 229 }, // und_VU -> bi_Latn_VU
    {   0,  0, 235 }, {  37,  7, 235 }, // und_WF -> fr_Latn_WF
    {   0,  0, 183 }, {  97,  7, 183 }, // und_WS -> sm_Latn_WS
    {   0,  0, 257 }, {   6,  7, 257 }, // und_XK -> sq_Latn_XK
    {   0,  0, 237 }, {   8,  1, 237 }, // und_YE -> ar_Arab_YE
    {   0,  0, 138 }, {  37,  7, 138 }, // und_YT -> fr_Latn_YT
    {   0,  0, 240 }, { 104,  7, 240 }, // und_ZW -> sn_Latn_ZW
    {   0, 105,   0 }, { 335, 105, 178 }, // und_Aghb -> lez_Aghb_RU
    {   0,  1,   0 }, {   8,  1,  64 }, // und_Arab -> ar_Arab_EG
    {   0,  1,  46 }, {  76,  1,  46 }, // und_Arab_CC -> ms_Arab_CC
    {   0,  1,  44 }, { 128,  1,  44 }, // und_Arab_CN -> ug_Arab_CN
    {   0,  1, 224 }, {  62,  1, 224 }, // und_Arab_GB -> ks_Arab_GB
    {   0,  1, 101 }, {  76,  1, 101 }, // und_Arab_ID -> ms_Arab_ID
    {   0,  1, 100 }, { 130,  1, 100 }, // und_Arab_IN -> ur_Arab_IN
    {   0,  1, 143 }, {  63,  1, 143 }, // und_Arab_MN -> kk_Arab_MN
    {   0,  1, 137 }, { 130,  1, 137 }, // und_Arab_MU -> ur_Arab_MU
    {   0,  1, 157 }, {  47,  1, 157 }, // und_Arab_NG -> ha_Arab_NG
    {   0,  1, 163 }, { 130,  1, 163 }, // und_Arab_PK -> ur_Arab_PK
    {   0,  1, 209 }, {  89,  1, 209 }, // und_Arab_TJ -> fa_Arab_TJ
    {   0, 57,   0 }, { 265, 57, 102 }, // und_Armi -> arc_Armi_IR
    {   0, 10,   0 }, {   9, 10,  11 }, // und_Armn -> hy_Armn_AM
    {   0, 36,   0 }, { 255, 36, 102 }, // und_Avst -> ae_Avst_IR
    {   0, 37,   0 }, { 266, 37, 101 }, // und_Bali -> ban_Bali_ID
    {   0, 38,   0 }, { 267, 38,  37 }, // und_Bamu -> bax_Bamu_CM
    {   0, 106,   0 }, { 336, 106, 121 }, // und_Bass -> bsq_Bass_LR
    {   0, 39,   0 }, { 268, 39, 101 }, // und_Batk -> bbc_Batk_ID
    {   0, 11,   0 }, {  15, 11,  18 }, // und_Beng -> bn_Beng_BD
    {   0, 40,   0 }, {  25, 40, 208 }, // und_Bopo -> zh_Bopo_TW
    {   0, 103,   0 }, {  37, 103,  74 }, // und_Brai -> fr_Brai_FR
    {   0, 42,   0 }, { 269, 42, 101 }, // und_Bugi -> bug_Bugi_ID
    {   0, 43,   0 }, { 270, 43, 170 }, // und_Buhd -> bku_Buhd_PH
    {   0, 46,   0 }, { 272, 46,  18 }, // und_Cakm -> ccp_Cakm_BD
    {   0, 44,   0 }, { 221, 44,  38 }, // und_Cans -> cr_Cans_CA
    {   0, 45,   0 }, { 271, 45, 217 }, // und_Cari -> xcr_Cari_TR
    {   0, 47,   0 }, { 276, 47, 232 }, // und_Cham -> cjm_Cham_VN
    {   0, 12,   0 }, { 190, 12, 225 }, // und_Cher -> chr_Cher_US
    {   0, 48,   0 }, { 274, 48,  64 }, // und_Copt -> cop_Copt_EG
    {   0, 49,   0 }, { 264, 49,  56 }, // und_Cprt -> grc_Cprt_CY
    {   0,  2,   0 }, {  96,  2, 178 }, // und_Cyrl -> ru_Cyrl_RU
    {   0,  2,   2 }, {  74,  2,   2 }, // und_Cyrl_AL -> mk_Cyrl_AL
    {   0,  2,  27 }, { 100,  2,  27 }, // und_Cyrl_BA -> sr_Cyrl_BA
    {   0,  2,  81 }, {   2,  2,  81 }, // und_Cyrl_GE -> ab_Cyrl_GE
    {   0,  2,  85 }, {  74,  2,  85 }, // und_Cyrl_GR -> mk_Cyrl_GR
    {   0,  2, 141 }, { 129,  2, 141 }, // und_Cyrl_MD -> uk_Cyrl_MD
    {   0,  2, 172 }, {  22,  2, 172 }, // und_Cyrl_PL -> be_Cyrl_PL
    {   0,  2, 177 }, {  20,  2, 177 }, // und_Cyrl_RO -> bg_Cyrl_RO
    {   0,  2, 191 }, { 129,  2, 191 }, // und_Cyrl_SK -> uk_Cyrl_SK
    {   0,  2, 257 }, { 100,  2, 257 }, // und_Cyrl_XK -> sr_Cyrl_XK
    {   0, 13,   0 }, {  49, 13, 100 }, // und_Deva -> hi_Deva_IN
    {   0, 13,  25 }, {  84, 13,  25 }, // und_Deva_BT -> ne_Deva_BT
    {   0, 107,   0 }, {  37, 107,  74 }, // und_Dupl -> fr_Dupl_FR
    {   0, 50,   0 }, { 263, 50,  64 }, // und_Egyp -> egy_Egyp_EG
    {   0, 108,   0 }, {   6, 108,   2 }, // und_Elba -> sq_Elba_AL
    {   0, 14,   0 }, {   7, 14,  69 }, // und_Ethi -> am_Ethi_ET
    {   0, 15,   0 }, {  41, 15,  81 }, // und_Geor -> ka_Geor_GE
    {   0, 52,   0 }, { 219, 52,  33 }, // und_Glag -> cu_Glag_BG
    {   0, 53,   0 }, { 279, 53, 222 }, // und_Goth -> got_Goth_UA
    {   0, 109,   0 }, {  99, 109, 100 }, // und_Gran -> sa_Gran_IN
    {   0, 16,   0 }, {  43, 16,  85 }, // und_Grek -> el_Grek_GR
    {   0, 17,   0 }, {  46, 17, 100 }, // und_Gujr -> gu_Gujr_IN
    {   0,  4,   0 }, {  92,  4, 100 }, // und_Guru -> pa_Guru_IN
    {   0, 55,   0 }, {  66, 55, 114 }, // und_Hang -> ko_Hang_KR
    {   0, 54,   0 }, {  25, 54,  44 }, // und_Hani -> zh_Hani_CN
    {   0, 56,   0 }, { 280, 56, 170 }, // und_Hano -> hnn_Hano_PH
    {   0,  5,   0 }, {  25,  5,  44 }, // und_Hans -> zh_Hans_CN
    {   0,  6,   0 }, {  25,  6, 208 }, // und_Hant -> zh_Hant_TW
    {   0, 18,   0 }, {  48, 18, 105 }, // und_Hebr -> he_Hebr_IL
    {   0, 18,  38 }, { 137, 18,  38 }, // und_Hebr_CA -> yi_Hebr_CA
    {   0, 18, 224 }, { 137, 18, 224 }, // und_Hebr_GB -> yi_Hebr_GB
    {   0, 18, 205 }, { 137, 18, 205 }, // und_Hebr_SE -> yi_Hebr_SE
    {   0, 18, 222 }, { 137, 18, 222 }, // und_Hebr_UA -> yi_Hebr_UA
    {   0, 18, 225 }, { 137, 18, 225 }, // und_Hebr_US -> yi_Hebr_US
    {   0, 104,   0 }, {  59, 104, 108 }, // und_Hira -> ja_Hira_JP
    {   0, 110,   0 }, { 333, 110, 117 }, // und_Hmng -> hnj_Hmng_LA
    {   0, 79,   0 }, { 278, 79, 106 }, // und_Ital -> ett_Ital_IT
    {   0, 60,   0 }, {  60, 60, 101 }, // und_Java -> jv_Java_ID
    {   0, 19,   0 }, {  59, 19, 108 }, // und_Jpan -> ja_Jpan_JP
    {   0, 63,   0 }, { 277, 63, 147 }, // und_Kali -> eky_Kali_MM
    {   0, 62,   0 }, {  59, 62, 108 }, // und_Kana -> ja_Kana_JP
    {   0, 64,   0 }, { 300, 64, 163 }, // und_Khar -> pra_Khar_PK
    {   0, 20,   0 }, {  23, 20,  36 }, // und_Khmr -> km_Khmr_KH
    {   0, 111,   0 }, { 105, 111, 100 }, // und_Khoj -> sd_Khoj_IN
    {   0, 21,   0 }, {  61, 21, 100 }, // und_Knda -> kn_Knda_IN
    {   0, 22,   0 }, {  66, 22, 114 }, // und_Kore -> ko_Kore_KR
    {   0, 61,   0 }, {  17, 61, 100 }, // und_Kthi -> bh_Kthi_IN
    {   0, 65,   0 }, { 292, 65, 211 }, // und_Lana -> nod_Lana_TH
    {   0, 23,   0 }, {  69, 23, 117 }, // und_Laoo -> lo_Laoo_LA
    {   0,  7,   1 }, { 126,  7,   1 }, // und_Latn_AF -> tk_Latn_AF
    {   0,  7,  11 }, {  67,  7,  11 }, // und_Latn_AM -> ku_Latn_AM
    {   0,  7,  44 }, { 139,  7,  44 }, // und_Latn_CN -> za_Latn_CN
    {   0,  7,  56 }, { 125,  7,  56 }, // und_Latn_CY -> tr_Latn_CY
    {   0,  7,   3 }, {  37,  7,   3 }, // und_Latn_DZ -> fr_Latn_DZ
    {   0,  7,  69 }, {  31,  7,  69 }, // und_Latn_ET -> en_Latn_ET
    {   0,  7,  81 }, {  67,  7,  81 }, // und_Latn_GE -> ku_Latn_GE
    {   0,  7, 102 }, { 126,  7, 102 }, // und_Latn_IR -> tk_Latn_IR
    {   0,  7,  48 }, {  37,  7,  48 }, // und_Latn_KM -> fr_Latn_KM
    {   0,  7, 145 }, {  37,  7, 145 }, // und_Latn_MA -> fr_Latn_MA
    {   0,  7, 127 }, {   6,  7, 127 }, // und_Latn_MK -> sq_Latn_MK
    {   0,  7, 126 }, {  91,  7, 126 }, // und_Latn_MO -> pt_Latn_MO
    {   0,  7, 136 }, {  37,  7, 136 }, // und_Latn_MR -> fr_Latn_MR
    {   0,  7, 207 }, {  37,  7, 207 }, // und_Latn_SY -> fr_Latn_SY
    {   0,  7, 216 }, {  37,  7, 216 }, // und_Latn_TN -> fr_Latn_TN
    {   0,  7, 208 }, { 174,  7, 208 }, // und_Latn_TW -> trv_Latn_TW
    {   0,  7, 222 }, {  90,  7, 222 }, // und_Latn_UA -> pl_Latn_UA
    {   0, 66,   0 }, { 283, 66, 100 }, // und_Lepc -> lep_Lepc_IN
    {   0, 67,   0 }, { 284, 67, 100 }, // und_Limb -> lif_Limb_IN
    {   0, 112,   0 }, { 332, 112,  85 }, // und_Lina -> lab_Lina_GR
    {   0, 68,   0 }, { 264, 68,  85 }, // und_Linb -> grc_Linb_GR
    {   0, 51,   0 }, { 285, 51,  44 }, // und_Lisu -> lis_Lisu_CN
    {   0, 69,   0 }, { 287, 69, 217 }, // und_Lyci -> xlc_Lyci_TR
    {   0, 70,   0 }, { 288, 70, 217 }, // und_Lydi -> xld_Lydi_TR
    {   0, 113,   0 }, {  49, 113, 100 }, // und_Mahj -> hi_Mahj_IN
    {   0, 71,   0 }, { 273, 71, 102 }, // und_Mand -> myz_Mand_IR
    {   0, 114,   0 }, { 329, 114,  44 }, // und_Mani -> xmn_Mani_CN
    {   0, 115,   0 }, { 330, 115, 189 }, // und_Mend -> men_Mend_SL
    {   0, 74,   0 }, { 291, 74, 201 }, // und_Merc -> xmr_Merc_SD
    {   0, 73,   0 }, { 291, 73, 201 }, // und_Mero -> xmr_Mero_SD
    {   0, 24,   0 }, {  77, 24, 100 }, // und_Mlym -> ml_Mlym_IN
    {   0, 116,   0 }, {  80, 116, 100 }, // und_Modi -> mr_Modi_IN
    {   0,  8,   0 }, {  82,  8,  44 }, // und_Mong -> mn_Mong_CN
    {   0, 117,   0 }, { 337, 117,  18 }, // und_Mroo -> mru_Mroo_BD
    {   0, 72,   0 }, { 290, 72, 100 }, // und_Mtei -> mni_Mtei_IN
    {   0, 25,   0 }, {  21, 25, 147 }, // und_Mymr -> my_Mymr_MM
    {   0, 118,   0 }, { 331, 118, 186 }, // und_Narb -> xna_Narb_SA
    {   0, 119,   0 }, { 265, 119, 109 }, // und_Nbat -> arc_Nbat_JO
    {   0, 75,   0 }, { 289, 75,  91 }, // und_Nkoo -> man_Nkoo_GN
    {   0, 77,   0 }, { 293, 77, 104 }, // und_Ogam -> sga_Ogam_IE
    {   0, 78,   0 }, { 304, 78, 100 }, // und_Olck -> sat_Olck_IN
    {   0, 82,   0 }, { 296, 82, 143 }, // und_Orkh -> otk_Orkh_MN
    {   0, 26,   0 }, {  87, 26, 100 }, // und_Orya -> or_Orya_IN
    {   0, 83,   0 }, { 110, 83, 194 }, // und_Osma -> so_Osma_SO
    {   0, 120,   0 }, { 265, 120, 207 }, // und_Palm -> arc_Palm_SY
    {   0, 121,   0 }, { 338, 121, 147 }, // und_Pauc -> ctd_Pauc_MM
    {   0, 122,   0 }, { 226, 122, 178 }, // und_Perm -> kv_Perm_RU
    {   0, 58,   0 }, { 297, 58, 102 }, // und_Phli -> pal_Phli_IR
    {   0, 123,   0 }, { 297, 123,  44 }, // und_Phlp -> pal_Phlp_CN
    {   0, 85,   0 }, { 299, 85, 119 }, // und_Phnx -> phn_Phnx_LB
    {   0, 86,   0 }, { 282, 86,  44 }, // und_Plrd -> hmd_Plrd_CN
    {   0, 59,   0 }, { 298, 59, 102 }, // und_Prti -> xpr_Prti_IR
    {   0, 87,   0 }, { 301, 87, 101 }, // und_Rjng -> rej_Rjng_ID
    {   0, 88,   0 }, { 294, 88, 205 }, // und_Runr -> non_Runr_SE
    {   0, 89,   0 }, { 303, 89, 105 }, // und_Samr -> smp_Samr_IL
    {   0, 81,   0 }, { 302, 81, 237 }, // und_Sarb -> xsa_Sarb_YE
    {   0, 90,   0 }, { 305, 90, 100 }, // und_Saur -> saz_Saur_IN
    {   0, 92,   0 }, {  31, 92, 224 }, // und_Shaw -> en_Shaw_GB
    {   0, 91,   0 }, {  99, 91, 100 }, // und_Shrd -> sa_Shrd_IN
    {   0, 124,   0 }, {  99, 124, 100 }, // und_Sidd -> sa_Sidd_IN
    {   0, 125,   0 }, { 105, 125, 100 }, // und_Sind -> sd_Sind_IN
    {   0, 32,   0 }, { 106, 32, 198 }, // und_Sinh -> si_Sinh_LK
    {   0, 93,   0 }, { 306, 93, 100 }, // und_Sora -> srb_Sora_IN
    {   0, 95,   0 }, { 112, 95, 101 }, // und_Sund -> su_Sund_ID
    {   0, 96,   0 }, { 307, 96,  18 }, // und_Sylo -> syl_Sylo_BD
    {   0, 33,   0 }, { 151, 33, 103 }, // und_Syrc -> syr_Syrc_IQ
    {   0, 98,   0 }, { 308, 98, 170 }, // und_Tagb -> tbw_Tagb_PH
    {   0, 101,   0 }, { 275, 101, 100 }, // und_Takr -> doi_Takr_IN
    {   0, 99,   0 }, { 310, 99,  44 }, // und_Tale -> tdd_Tale_CN
    {   0, 76,   0 }, { 286, 76,  44 }, // und_Talu -> khb_Talu_CN
    {   0, 27,   0 }, { 117, 27, 100 }, // und_Taml -> ta_Taml_IN
    {   0, 100,   0 }, { 309, 100, 232 }, // und_Tavt -> blt_Tavt_VN
    {   0, 28,   0 }, { 119, 28, 100 }, // und_Telu -> te_Telu_IN
    {   0,  9,   0 }, { 314,  9, 145 }, // und_Tfng -> zgh_Tfng_MA
    {   0, 97,   0 }, { 166, 97, 170 }, // und_Tglg -> fil_Tglg_PH
    {   0, 29,   0 }, { 143, 29, 131 }, // und_Thaa -> dv_Thaa_MV
    {   0, 30,   0 }, { 120, 30, 211 }, // und_Thai -> th_Thai_TH
    {   0, 31,   0 }, { 121, 31,  44 }, // und_Tibt -> bo_Tibt_CN
    {   0, 126,   0 }, { 339, 126, 100 }, // und_Tirh -> mai_Tirh_IN
    {   0, 102,   0 }, { 311, 102, 207 }, // und_Ugar -> uga_Ugar_SY
    {   0, 35,   0 }, { 252, 35, 121 }, // und_Vaii -> vai_Vaii_LR
    {   0, 127,   0 }, { 334, 127, 100 }, // und_Wara -> hoc_Wara_IN
    {   0, 80,   0 }, { 295, 80, 102 }, // und_Xpeo -> peo_Xpeo_IR
    {   0, 94,   0 }, { 262, 94, 103 }, // und_Xsux -> akk_Xsux_IQ
    {   0, 34,   0 }, { 168, 34,  44 }  // und_Yiii -> ii_Yiii_CN
};

static const quint16 locale_index[] = {
     0, // AnyLanguage
     0, // C
     0, // Abkhazian
     1, // Oromo
     3, // Afar
     4, // Afrikaans
     6, // Albanian
     9, // Amharic
    10, // Arabic
    37, // Armenian
    38, // Assamese
     0, // Aymara
    39, // Azerbaijani
    41, // Bashkir
    42, // Basque
    43, // Bengali
    45, // Dzongkha
     0, // Bihari
     0, // Bislama
    46, // Breton
    47, // Bulgarian
    48, // Burmese
    49, // Belarusian
    50, // Khmer
    51, // Catalan
    55, // Chinese
    62, // Corsican
    63, // Croatian
    65, // Czech
    66, // Danish
    68, // Dutch
    75, // English
     0, // Esperanto
   167, // Estonian
   168, // Faroese
     0, // Fijian
   169, // Finnish
   170, // French
   216, // Western Frisian
   217, // Gaelic
   218, // Galician
   219, // Georgian
   220, // German
   226, // Greek
   228, // Greenlandic
   229, // Guarani
   230, // Gujarati
   231, // Hausa
   235, // Hebrew
   236, // Hindi
   237, // Hungarian
   238, // Icelandic
   239, // Indonesian
   240, // Interlingua
     0, // Interlingue
   241, // Inuktitut
     0, // Inupiak
   243, // Irish
   244, // Italian
   247, // Japanese
   248, // Javanese
   249, // Kannada
   250, // Kashmiri
   251, // Kazakh
   252, // Kinyarwanda
   253, // Kirghiz
   254, // Korean
   256, // Kurdish
   257, // Rundi
   258, // Lao
     0, // Latin
   259, // Latvian
   260, // Lingala
   264, // Lithuanian
   265, // Macedonian
   266, // Malagasy
   267, // Malay
   271, // Malayalam
   272, // Maltese
   273, // Maori
   274, // Marathi
     0, // Marshallese
   275, // Mongolian
     0, // Nauru
   277, // Nepali
   279, // NorwegianBokmal
   281, // Occitan
   282, // Oriya
   283, // Pashto
   284, // Persian
   286, // Polish
   287, // Portuguese
   296, // Punjabi
   298, // Quechua
   301, // Romansh
   302, // Romanian
   304, // Russian
     0, // Samoan
   310, // Sango
   311, // Sanskrit
   312, // Serbian
   320, // Ossetic
   322, // Southern Sotho
   323, // Tswana
   324, // Shona
   325, // Sindhi
   326, // Sinhala
   327, // Swati
   328, // Slovak
   329, // Slovenian
   330, // Somali
   334, // Spanish
     0, // Sundanese
   360, // Swahili
   364, // Swedish
     0, // Sardinian
   367, // Tajik
   368, // Tamil
   372, // Tatar
   373, // Telugu
   374, // Thai
   375, // Tibetan
   377, // Tigrinya
   379, // Tongan
   380, // Tsonga
   381, // Turkish
   383, // Turkmen
     0, // Tahitian
   384, // Uighur
   385, // Ukrainian
   386, // Urdu
   388, // Uzbek
   391, // Vietnamese
     0, // Volapuk
   392, // Welsh
   393, // Wolof
   394, // Xhosa
     0, // Yiddish
   395, // Yoruba
     0, // Zhuang
   397, // Zulu
   398, // NorwegianNynorsk
   399, // Bosnian
   401, // Divehi
   402, // Manx
   403, // Cornish
   404, // Akan
   405, // Konkani
   406, // Ga
   407, // Igbo
   408, // Kamba
   409, // Syriac
   410, // Blin
   411, // Geez
     0, // Koro
   412, // Sidamo
   413, // Atsam
   414, // Tigre
   415, // Jju
   416, // Friulian
   417, // Venda
   418, // Ewe
   420, // Walamo
   421, // Hawaiian
   422, // Tyap
   423, // Nyanja
   424, // Filipino
   425, // Swiss German
   428, // Sichuan Yi
   429, // Kpelle
   430, // Low German
   431, // South Ndebele
   432, // Northern Sotho
   433, // Northern Sami
   436, // Taroko
   437, // Gusii
   438, // Taita
   439, // Fulah
   443, // Kikuyu
   444, // Samburu
   445, // Sena
   446, // North Ndebele
   447, // Rombo
   448, // Tachelhit
   450, // Kabyle
   451, // Nyankole
   452, // Bena
   453, // Vunjo
   454, // Bambara
   456, // Embu
   457, // Cherokee
   458, // Morisyen
   459, // Makonde
   460, // Langi
   461, // Ganda
   462, // Bemba
   463, // Kabuverdianu
   464, // Meru
   465, // Kalenjin
   466, // Nama
   467, // Machame
   468, // Colognian
   469, // Masai
   471, // Soga
   472, // Luyia
   473, // Asu
   474, // Teso
   476, // Saho
   477, // Koyra Chiini
   478, // Rwa
   479, // Luo
   480, // Chiga
   481, // Central Morocco Tamazight
   482, // Koyraboro Senni
   483, // Shambala
   484, // Bodo
     0, // Avaric
     0, // Chamorro
   485, // Chechen
   486, // Church
     0, // Chuvash
     0, // Cree
     0, // Haitian
     0, // Herero
     0, // Hiri Motu
     0, // Kanuri
     0, // Komi
     0, // Kongo
     0, // Kwanyama
     0, // Limburgish
   487, // LubaKatanga
   488, // Luxembourgish
     0, // Navaho
     0, // Ndonga
     0, // Ojibwa
     0, // Pali
   489, // Walloon
   490, // Aghem
   491, // Basaa
   492, // Zarma
   493, // Duala
   494, // JolaFonyi
   495, // Ewondo
   496, // Bafia
   497, // MakhuwaMeetto
   498, // Mundang
   499, // Kwasio
   500, // Nuer
   501, // Sakha
   502, // Sangu
     0, // Congo Swahili
   503, // Tasawaq
   504, // Vai
   506, // Walser
   507, // Yangben
     0, // Avestan
   508, // Asturian
   509, // Ngomba
   510, // Kako
   511, // Meta
   512, // Ngiemboon
     0, // Aragonese
     0, // Akkadian
     0, // AncientEgyptian
     0, // AncientGreek
     0, // Aramaic
     0, // Balinese
     0, // Bamun
     0, // BatakToba
     0, // Buginese
     0, // Buhid
     0, // Carian
     0, // Chakma
     0, // ClassicalMandaic
     0, // Coptic
     0, // Dogri
     0, // EasternCham
     0, // EasternKayah
     0, // Etruscan
     0, // Gothic
     0, // Hanunoo
     0, // Ingush
     0, // LargeFloweryMiao
     0, // Lepcha
     0, // Limbu
     0, // Lisu
     0, // Lu
     0, // Lycian
     0, // Lydian
     0, // Mandingo
     0, // Manipuri
     0, // Meroitic
     0, // NorthernThai
     0, // OldIrish
     0, // OldNorse
     0, // OldPersian
     0, // OldTurkish
     0, // Pahlavi
     0, // Parthian
     0, // Phoenician
     0, // PrakritLanguage
     0, // Rejang
     0, // Sabaean
     0, // Samaritan
     0, // Santali
     0, // Saurashtra
     0, // Sora
     0, // Sylheti
     0, // Tagbanwa
     0, // TaiDam
     0, // TaiNua
     0, // Ugaritic
   513, // Akoose
   514, // Lakota
   515, // Standard Moroccan Tamazight
   516, // Mapuche
   517, // Central Kurdish
   518, // LowerSorbian
   519, // UpperSorbian
   520, // Kenyang
   521, // Mohawk
   522, // Nko
     0, // Prussian
   523, // Kiche
   524, // Southern Sami
   525, // Lule Sami
   526, // Inari Sami
   527, // Skolt Sami
   528, // Warlpiri
     0, // Manichaean Middle Persian
     0, // Mende
     0, // Ancient North Arabian
     0, // Linear A
     0, // Hmong Njua
     0, // Ho
     0, // Lezghian
     0, // Bassa
     0, // Mono
     0, // Tedim Chin
     0, // Maithili
     0 // trailing 0
};

static const QLocaleData locale_data[] = {
//      lang   script terr    dec  group   list  prcnt   zero  minus  plus    exp quotStart quotEnd altQuotStart altQuotEnd lpStart lpMid lpEnd lpTwo sDtFmt lDtFmt sTmFmt lTmFmt ssMonth slMonth  sMonth lMonth  sDays  lDays  am,len      pm,len
    {      1,     0,     0,    46,    44,    59,    37,    48,    45,    43,   101,    34,    34,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 0,10 , 10,17 , 0,8 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 158,27 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 99,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 0,7 , 0,4 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // C/AnyScript/AnyCountry
    {      3,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 35,18 , 18,7 , 25,12 , 185,48 , 233,111 , 134,24 , 185,48 , 233,111 , 134,24 , 113,28 , 141,55 , 85,14 , 113,28 , 141,55 , 85,14 , 2,2 , 2,2 , {69,84,66},  0,2 , 7,24 , 4,4 , 4,0 , 0,6 , 6,10 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Ethiopia
    {      3,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 35,18 , 18,7 , 25,12 , 185,48 , 233,111 , 134,24 , 185,48 , 233,111 , 134,24 , 113,28 , 141,55 , 85,14 , 113,28 , 141,55 , 85,14 , 2,2 , 2,2 , {75,69,83},  2,3 , 0,7 , 4,4 , 4,0 , 0,6 , 16,8 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Kenya
    {      4,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,84,66},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Afar/Latin/Ethiopia
    {      5,     7,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 6,8 , 6,8 , 53,10 , 80,18 , 18,7 , 25,12 , 392,51 , 443,92 , 134,24 , 392,51 , 443,92 , 134,24 , 196,21 , 217,58 , 275,14 , 196,21 , 217,58 , 275,14 , 4,3 , 4,3 , {90,65,82},  5,1 , 31,67 , 4,4 , 4,0 , 24,9 , 33,11 ,     2,     1,     7,     6,     7 }, // Afrikaans/Latin/SouthAfrica
    {      5,     7,   148,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 6,8 , 6,8 , 53,10 , 98,16 , 37,5 , 8,10 , 392,51 , 443,92 , 134,24 , 392,51 , 443,92 , 134,24 , 196,21 , 217,58 , 275,14 , 196,21 , 217,58 , 275,14 , 4,3 , 4,3 , {78,65,68},  6,1 , 98,55 , 4,4 , 4,0 , 24,9 , 44,7 ,     2,     1,     1,     6,     7 }, // Afrikaans/Latin/Namibia
    {      6,     7,     2,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 14,9 , 14,9 , 114,6 , 10,17 , 37,5 , 8,10 , 535,48 , 583,78 , 661,24 , 535,48 , 685,78 , 661,24 , 289,28 , 317,58 , 375,14 , 289,28 , 389,58 , 375,14 , 7,8 , 7,7 , {65,76,76},  7,4 , 153,45 , 13,5 , 4,0 , 51,5 , 56,8 ,     0,     0,     1,     6,     7 }, // Albanian/Latin/Albania
    {      6,     7,   127,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 14,9 , 14,9 , 114,6 , 10,17 , 37,5 , 8,10 , 535,48 , 583,78 , 661,24 , 535,48 , 685,78 , 661,24 , 289,28 , 317,58 , 375,14 , 289,28 , 389,58 , 375,14 , 7,8 , 7,7 , {77,75,68},  11,3 , 198,54 , 13,5 , 4,0 , 51,5 , 64,8 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Macedonia
    {      6,     7,   257,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 14,9 , 14,9 , 114,6 , 10,17 , 37,5 , 8,10 , 535,48 , 583,78 , 661,24 , 535,48 , 685,78 , 661,24 , 289,28 , 317,58 , 375,14 , 289,28 , 389,58 , 375,14 , 7,8 , 7,7 , {69,85,82},  14,1 , 252,21 , 13,5 , 4,0 , 51,5 , 72,6 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Kosovo
    {      7,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 23,6 , 23,6 , 29,9 , 38,8 , 120,10 , 10,17 , 18,7 , 25,12 , 763,46 , 809,61 , 870,24 , 763,46 , 809,61 , 870,24 , 447,27 , 474,28 , 502,14 , 447,27 , 474,28 , 502,14 , 15,3 , 14,4 , {69,84,66},  15,2 , 273,34 , 4,4 , 4,0 , 78,4 , 82,5 ,     2,     1,     7,     6,     7 }, // Amharic/Ethiopic/Ethiopia
    {      8,     1,    64,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 60,6 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {69,71,80},  17,5 , 307,70 , 8,5 , 4,0 , 87,7 , 94,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Egypt
    {      8,     1,     3,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 993,71 , 993,71 , 1064,24 , 993,71 , 993,71 , 1064,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {68,90,68},  22,5 , 377,91 , 8,5 , 4,0 , 87,7 , 97,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Algeria
    {      8,     1,    17,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {66,72,68},  27,5 , 468,91 , 8,5 , 4,0 , 87,7 , 104,7 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Bahrain
    {      8,     1,    42,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {88,65,70},  32,4 , 559,84 , 8,5 , 4,0 , 87,7 , 111,4 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Chad
    {      8,     1,    48,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {75,77,70},  36,7 , 643,105 , 8,5 , 4,0 , 87,7 , 115,9 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Comoros
    {      8,     1,    59,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {68,74,70},  43,3 , 748,84 , 8,5 , 4,0 , 87,7 , 124,6 ,     0,     0,     6,     6,     7 }, // Arabic/Arabic/Djibouti
    {      8,     1,    67,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {69,82,78},  46,3 , 832,91 , 8,5 , 4,0 , 87,7 , 130,7 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Eritrea
    {      8,     1,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1088,92 , 1088,92 , 1180,24 , 1204,92 , 1088,92 , 1180,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {73,81,68},  49,5 , 923,84 , 8,5 , 4,0 , 87,7 , 137,6 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Iraq
    {      8,     1,   105,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {73,76,83},  54,1 , 1007,133 , 8,5 , 4,0 , 87,7 , 143,7 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/Israel
    {      8,     1,   109,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1088,92 , 1088,92 , 1180,24 , 1088,92 , 1088,92 , 1180,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {74,79,68},  55,5 , 1140,84 , 8,5 , 4,0 , 87,7 , 150,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Jordan
    {      8,     1,   115,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {75,87,68},  60,5 , 1224,84 , 8,5 , 4,0 , 87,7 , 156,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Kuwait
    {      8,     1,   119,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1088,92 , 1088,92 , 1180,24 , 1088,92 , 1088,92 , 1180,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {76,66,80},  65,5 , 1308,84 , 8,5 , 4,0 , 87,7 , 162,5 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Lebanon
    {      8,     1,   122,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {76,89,68},  70,5 , 1392,77 , 8,5 , 4,0 , 87,7 , 167,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Libya
    {      8,     1,   136,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1296,72 , 1296,72 , 1368,24 , 1296,72 , 1296,72 , 1368,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {77,82,79},  75,5 , 1469,112 , 8,5 , 4,0 , 87,7 , 172,9 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Mauritania
    {      8,     1,   145,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1392,70 , 1392,70 , 1462,24 , 1392,70 , 1392,70 , 1462,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {77,65,68},  80,5 , 1581,77 , 8,5 , 4,0 , 87,7 , 181,6 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Morocco
    {      8,     1,   162,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {79,77,82},  85,5 , 1658,77 , 8,5 , 4,0 , 87,7 , 187,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Oman
    {      8,     1,   165,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1088,92 , 1088,92 , 1180,24 , 1088,92 , 1088,92 , 1180,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {73,76,83},  54,1 , 1007,133 , 8,5 , 4,0 , 87,7 , 192,18 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/PalestinianTerritories
    {      8,     1,   175,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {81,65,82},  90,5 , 1735,70 , 8,5 , 4,0 , 87,7 , 210,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Qatar
    {      8,     1,   186,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {83,65,82},  95,5 , 1805,77 , 8,5 , 4,0 , 87,7 , 213,24 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/SaudiArabia
    {      8,     1,   194,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {83,79,83},  100,1 , 1882,77 , 8,5 , 4,0 , 87,7 , 237,7 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Somalia
    {      8,     1,   201,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {83,68,71},  101,4 , 1959,84 , 8,5 , 4,0 , 87,7 , 244,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Sudan
    {      8,     1,   207,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 1088,92 , 1088,92 , 1180,24 , 1088,92 , 1088,92 , 1180,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {83,89,80},  105,5 , 2043,77 , 8,5 , 4,0 , 87,7 , 251,5 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Syria
    {      8,     1,   216,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 993,71 , 993,71 , 1064,24 , 993,71 , 993,71 , 1064,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {84,78,68},  110,5 , 2120,77 , 8,5 , 4,0 , 87,7 , 256,4 ,     3,     0,     7,     5,     6 }, // Arabic/Arabic/Tunisia
    {      8,     1,   223,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {65,69,68},  115,5 , 2197,91 , 8,5 , 4,0 , 87,7 , 260,24 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/UnitedArabEmirates
    {      8,     1,   236,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {77,65,68},  80,5 , 1581,77 , 8,5 , 4,0 , 87,7 , 284,15 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/WesternSahara
    {      8,     1,   237,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {89,69,82},  120,5 , 2288,70 , 8,5 , 4,0 , 87,7 , 299,5 ,     0,     0,     7,     5,     6 }, // Arabic/Arabic/Yemen
    {      8,     1,   254,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 52,8 , 66,7 , 130,10 , 140,18 , 18,7 , 25,12 , 894,75 , 894,75 , 969,24 , 894,75 , 894,75 , 969,24 , 516,52 , 516,52 , 568,14 , 516,52 , 516,52 , 568,14 , 18,1 , 18,1 , {83,83,80},  125,1 , 2358,126 , 8,5 , 4,0 , 87,7 , 304,12 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/SouthSudan
    {      9,    10,    11,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 73,7 , 73,7 , 158,8 , 166,19 , 42,4 , 46,10 , 1486,48 , 1534,94 , 1628,24 , 1486,48 , 1652,106 , 1628,24 , 582,28 , 610,62 , 672,15 , 582,28 , 610,62 , 672,15 , 19,12 , 19,12 , {65,77,68},  126,1 , 2484,46 , 13,5 , 4,0 , 316,7 , 323,8 ,     0,     0,     1,     6,     7 }, // Armenian/Armenian/Armenia
    {     10,    11,   100,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 185,8 , 193,18 , 56,8 , 64,12 , 1758,62 , 1820,88 , 158,27 , 1758,62 , 1820,88 , 158,27 , 687,37 , 724,58 , 85,14 , 687,37 , 724,58 , 85,14 , 31,9 , 31,7 , {73,78,82},  127,1 , 0,7 , 8,5 , 4,0 , 331,7 , 338,4 ,     2,     1,     7,     7,     7 }, // Assamese/Bengali/India
    {     12,     7,    15,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,8 , 80,8 , 158,8 , 211,17 , 37,5 , 8,10 , 1908,48 , 1956,77 , 158,27 , 1908,48 , 2033,77 , 158,27 , 782,27 , 809,67 , 99,14 , 782,27 , 809,67 , 99,14 , 0,2 , 0,2 , {65,90,78},  128,3 , 2530,58 , 8,5 , 4,0 , 342,10 , 352,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Latin/Azerbaijan
    {     12,     2,    15,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 158,8 , 228,19 , 37,5 , 8,10 , 2110,77 , 2110,77 , 158,27 , 2110,77 , 2110,77 , 158,27 , 876,67 , 876,67 , 99,14 , 876,67 , 876,67 , 99,14 , 0,2 , 0,2 , {65,90,78},  131,4 , 2588,12 , 8,5 , 4,0 , 362,10 , 362,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Cyrillic/Azerbaijan
    {     13,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {82,85,66},  135,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Bashkir/Cyrillic/Russia
    {     14,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,    34,    34,    34,    34, 0,6 , 0,6 , 88,9 , 88,9 , 247,10 , 257,26 , 37,5 , 76,12 , 2187,60 , 2247,93 , 2340,24 , 2364,60 , 2424,105 , 2340,24 , 943,28 , 971,68 , 1039,14 , 1053,28 , 1081,68 , 1039,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2600,20 , 13,5 , 4,0 , 372,7 , 379,8 ,     2,     1,     1,     6,     7 }, // Basque/Latin/Spain
    {     15,    11,    18,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 97,10 , 107,9 , 283,6 , 193,18 , 18,7 , 25,12 , 2529,90 , 2529,90 , 2619,33 , 2529,90 , 2529,90 , 2619,33 , 1149,37 , 1186,58 , 1244,18 , 1149,37 , 1262,58 , 1244,18 , 40,9 , 38,7 , {66,68,84},  136,1 , 2620,49 , 0,4 , 4,0 , 387,5 , 392,8 ,     2,     1,     5,     6,     7 }, // Bengali/Bengali/Bangladesh
    {     15,    11,   100,    46,    44,    59,    37,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 97,10 , 107,9 , 283,6 , 193,18 , 18,7 , 25,12 , 2529,90 , 2529,90 , 2619,33 , 2529,90 , 2529,90 , 2619,33 , 1149,37 , 1186,58 , 1244,18 , 1149,37 , 1262,58 , 1244,18 , 40,9 , 38,7 , {73,78,82},  127,1 , 2669,43 , 0,4 , 4,0 , 387,5 , 400,4 ,     2,     1,     7,     7,     7 }, // Bengali/Bengali/India
    {     16,    31,    25,    46,    44,    59,    37,  3872,    45,    43,   101,  8220,  8221,  8216,  8217, 116,9 , 116,9 , 116,9 , 116,9 , 53,10 , 289,30 , 88,22 , 110,27 , 2652,63 , 2715,191 , 2906,27 , 2933,27 , 2960,132 , 3092,27 , 1320,34 , 1354,79 , 1433,27 , 1320,34 , 1354,79 , 1433,27 , 49,5 , 45,6 , {66,84,78},  137,3 , 2712,15 , 4,4 , 4,0 , 404,6 , 410,5 ,     2,     1,     7,     6,     7 }, // Dzongkha/Tibetan/Bhutan
    {     19,     7,    74,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 3119,55 , 3174,78 , 3252,36 , 3119,55 , 3174,78 , 3252,36 , 1460,33 , 1493,43 , 1536,18 , 1460,33 , 1493,43 , 1536,18 , 54,4 , 51,4 , {69,85,82},  14,1 , 2727,36 , 13,5 , 4,0 , 415,9 , 424,5 ,     2,     1,     1,     6,     7 }, // Breton/Latin/France
    {     20,     2,    33,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 319,12 , 331,22 , 42,4 , 137,9 , 3288,59 , 3347,82 , 3429,24 , 3288,59 , 3347,82 , 3429,24 , 1554,21 , 1575,55 , 1630,14 , 1554,21 , 1575,55 , 1630,14 , 58,6 , 55,6 , {66,71,78},  140,3 , 2763,47 , 13,5 , 4,0 , 429,9 , 438,8 ,     2,     1,     1,     6,     7 }, // Bulgarian/Cyrillic/Bulgaria
    {     21,    25,   147,    46,    44,  4170,    37,  4160,    45,    43,   101,  8220,  8221,  8216,  8217, 132,6 , 132,6 , 138,11 , 149,9 , 353,8 , 361,18 , 37,5 , 8,10 , 3453,46 , 3499,88 , 3587,24 , 3453,46 , 3499,88 , 3587,24 , 1644,54 , 1644,54 , 1698,14 , 1644,54 , 1644,54 , 1698,14 , 64,5 , 61,3 , {77,77,75},  143,1 , 2810,27 , 8,5 , 4,0 , 446,3 , 449,6 ,     0,     0,     7,     6,     7 }, // Burmese/Myanmar/Myanmar
    {     22,     2,    20,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 114,6 , 10,17 , 146,5 , 151,10 , 3611,48 , 3659,95 , 3754,24 , 3778,48 , 3826,98 , 3754,24 , 1712,21 , 1733,56 , 1789,14 , 1712,21 , 1733,56 , 1789,14 , 69,10 , 64,13 , {66,89,82},  144,2 , 2837,23 , 4,4 , 4,0 , 455,10 , 465,8 ,     0,     0,     1,     6,     7 }, // Belarusian/Cyrillic/Belarus
    {     23,    20,    36,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 158,5 , 163,9 , 283,6 , 98,16 , 18,7 , 25,12 , 3924,71 , 3924,71 , 158,27 , 3924,71 , 3924,71 , 158,27 , 1803,46 , 1803,46 , 1849,14 , 1803,46 , 1803,46 , 1849,14 , 79,5 , 77,5 , {75,72,82},  146,1 , 2860,29 , 4,4 , 4,0 , 473,5 , 478,7 ,     2,     1,     7,     6,     7 }, // Khmer/Khmer/Cambodia
    {     24,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 172,7 , 172,7 , 283,6 , 379,22 , 42,4 , 137,9 , 3995,60 , 4055,82 , 4137,36 , 3995,60 , 4173,115 , 4137,36 , 1863,28 , 1891,60 , 1951,21 , 1863,28 , 1891,60 , 1951,21 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 485,6 , 491,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Spain
    {     24,     7,     5,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 172,7 , 172,7 , 283,6 , 379,22 , 42,4 , 137,9 , 3995,60 , 4055,82 , 4137,36 , 3995,60 , 4173,115 , 4137,36 , 1863,28 , 1891,60 , 1951,21 , 1863,28 , 1891,60 , 1951,21 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 485,6 , 498,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Andorra
    {     24,     7,    74,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 172,7 , 172,7 , 283,6 , 379,22 , 42,4 , 137,9 , 3995,60 , 4055,82 , 4137,36 , 3995,60 , 4173,115 , 4137,36 , 1863,28 , 1891,60 , 1951,21 , 1863,28 , 1891,60 , 1951,21 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 485,6 , 505,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/France
    {     24,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 172,7 , 172,7 , 283,6 , 379,22 , 42,4 , 137,9 , 3995,60 , 4055,82 , 4137,36 , 3995,60 , 4173,115 , 4137,36 , 1863,28 , 1891,60 , 1951,21 , 1863,28 , 1891,60 , 1951,21 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 485,6 , 511,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Italy
    {     25,     5,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 179,5 , 179,5 , 184,5 , 184,5 , 401,6 , 407,13 , 161,6 , 167,11 , 4288,39 , 4327,38 , 158,27 , 4288,39 , 4327,38 , 158,27 , 1972,21 , 1993,28 , 2021,14 , 1972,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {67,78,89},  147,1 , 2909,13 , 8,5 , 4,0 , 517,4 , 521,2 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/China
    {     25,     5,    97,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 179,5 , 179,5 , 184,5 , 184,5 , 283,6 , 407,13 , 161,6 , 167,11 , 4288,39 , 4327,38 , 158,27 , 4288,39 , 4327,38 , 158,27 , 1972,21 , 1993,28 , 2021,14 , 1972,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {72,75,68},  148,3 , 2922,11 , 4,4 , 4,0 , 517,4 , 523,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/HongKong
    {     25,     5,   126,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 179,5 , 179,5 , 184,5 , 184,5 , 283,6 , 407,13 , 161,6 , 167,11 , 4288,39 , 4327,38 , 158,27 , 4288,39 , 4327,38 , 158,27 , 1972,21 , 1993,28 , 2021,14 , 1972,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {77,79,80},  151,4 , 2933,13 , 4,4 , 4,0 , 517,4 , 532,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Macau
    {     25,     5,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 179,5 , 179,5 , 184,5 , 184,5 , 27,8 , 407,13 , 161,6 , 167,11 , 4288,39 , 4327,38 , 158,27 , 4288,39 , 4327,38 , 158,27 , 1972,21 , 1993,28 , 2021,14 , 1972,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {83,71,68},  6,1 , 2946,15 , 4,4 , 4,0 , 517,4 , 541,3 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Singapore
    {     25,     6,    97,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 179,5 , 179,5 , 184,5 , 184,5 , 283,6 , 407,13 , 161,6 , 178,13 , 4288,39 , 4288,39 , 158,27 , 4288,39 , 4288,39 , 158,27 , 2035,21 , 1993,28 , 2021,14 , 2035,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {72,75,68},  148,3 , 2922,11 , 4,4 , 4,0 , 544,4 , 548,14 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/HongKong
    {     25,     6,   126,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 179,5 , 179,5 , 184,5 , 184,5 , 283,6 , 407,13 , 161,6 , 178,13 , 4288,39 , 4288,39 , 158,27 , 4288,39 , 4288,39 , 158,27 , 2035,21 , 1993,28 , 2021,14 , 2035,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {77,79,80},  151,4 , 2961,13 , 4,4 , 4,0 , 544,4 , 562,14 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Macau
    {     25,     6,   208,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 179,5 , 179,5 , 184,5 , 184,5 , 420,8 , 428,14 , 161,6 , 178,13 , 4288,39 , 4288,39 , 158,27 , 4288,39 , 4288,39 , 158,27 , 2035,21 , 1993,28 , 2021,14 , 2035,21 , 1993,28 , 2021,14 , 89,2 , 87,2 , {84,87,68},  155,3 , 2974,13 , 4,4 , 4,0 , 544,4 , 576,2 ,     2,     0,     7,     6,     7 }, // Chinese/Traditional Han/Taiwan
    {     26,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Corsican/Latin/France
    {     27,     7,    54,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 172,7 , 172,7 , 442,11 , 453,19 , 37,5 , 8,10 , 4365,49 , 4414,94 , 4508,39 , 4365,49 , 4547,98 , 4508,39 , 2056,28 , 2084,58 , 2142,14 , 2056,28 , 2084,58 , 2156,14 , 0,2 , 0,2 , {72,82,75},  158,3 , 2987,60 , 13,5 , 4,0 , 578,8 , 586,8 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/Croatia
    {     27,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 172,7 , 172,7 , 442,11 , 453,19 , 37,5 , 8,10 , 4365,49 , 4414,94 , 4508,39 , 4365,49 , 4547,98 , 4508,39 , 2056,28 , 2084,58 , 2142,14 , 2056,28 , 2084,58 , 2156,14 , 0,2 , 0,2 , {66,65,77},  161,2 , 3047,85 , 13,5 , 4,0 , 578,8 , 594,19 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/BosniaAndHerzegowina
    {     28,     7,    57,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 189,7 , 189,7 , 158,8 , 472,17 , 42,4 , 137,9 , 4645,48 , 4693,82 , 158,27 , 4645,48 , 4775,84 , 158,27 , 2170,21 , 2191,49 , 2240,14 , 2170,21 , 2191,49 , 2240,14 , 91,9 , 89,9 , {67,90,75},  163,2 , 3132,68 , 13,5 , 4,0 , 613,7 , 620,15 ,     2,     0,     1,     6,     7 }, // Czech/Latin/CzechRepublic
    {     29,     7,    58,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 196,8 , 196,8 , 120,10 , 489,23 , 146,5 , 151,10 , 4859,48 , 4907,84 , 134,24 , 4991,59 , 4907,84 , 134,24 , 2254,28 , 2282,51 , 2333,14 , 2347,35 , 2282,51 , 2333,14 , 0,2 , 0,2 , {68,75,75},  165,3 , 3200,42 , 13,5 , 4,0 , 635,5 , 640,7 ,     2,     1,     1,     6,     7 }, // Danish/Latin/Denmark
    {     29,     7,    86,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 196,8 , 196,8 , 120,10 , 489,23 , 146,5 , 151,10 , 4859,48 , 4907,84 , 134,24 , 4991,59 , 4907,84 , 134,24 , 2254,28 , 2282,51 , 2333,14 , 2347,35 , 2282,51 , 2333,14 , 0,2 , 0,2 , {68,75,75},  165,3 , 3200,42 , 13,5 , 4,0 , 635,5 , 647,8 ,     2,     1,     1,     6,     7 }, // Danish/Latin/Greenland
    {     30,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {69,85,82},  14,1 , 3242,19 , 8,5 , 18,6 , 655,10 , 665,9 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Netherlands
    {     30,     7,    12,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {65,87,71},  168,4 , 3261,55 , 8,5 , 18,6 , 655,10 , 674,5 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Aruba
    {     30,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 512,7 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {69,85,82},  14,1 , 3242,19 , 13,5 , 4,0 , 679,6 , 685,6 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Belgium
    {     30,     7,   152,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {65,78,71},  172,4 , 3316,97 , 8,5 , 18,6 , 655,10 , 691,7 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/CuraSao
    {     30,     7,   202,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {83,82,68},  6,1 , 3413,58 , 8,5 , 18,6 , 655,10 , 698,8 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Suriname
    {     30,     7,   255,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {85,83,68},  6,1 , 3471,61 , 8,5 , 18,6 , 655,10 , 706,19 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Bonaire
    {     30,     7,   256,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 5050,59 , 5109,88 , 134,24 , 5197,59 , 5256,88 , 134,24 , 2382,21 , 2403,59 , 2462,14 , 2476,21 , 2497,59 , 2462,14 , 100,4 , 98,4 , {65,78,71},  172,4 , 3316,97 , 8,5 , 18,6 , 655,10 , 725,12 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/SintMaarten
    {     31,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 737,16 , 753,13 ,     2,     1,     7,     6,     7 }, // English/Latin/UnitedStates
    {     31,     3,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // English/Deseret/UnitedStates
    {     31,     7,     4,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 773,14 ,     2,     1,     7,     6,     7 }, // English/Latin/AmericanSamoa
    {     31,     7,     7,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 787,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Anguilla
    {     31,     7,     9,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 795,17 ,     2,     1,     7,     6,     7 }, // English/Latin/AntiguaAndBarbuda
    {     31,     7,    13,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 525,9 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 812,18 , 830,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Australia
    {     31,     7,    16,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,83,68},  6,1 , 3697,53 , 4,4 , 4,0 , 766,7 , 839,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Bahamas
    {     31,     7,    19,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,66,68},  6,1 , 3750,56 , 4,4 , 4,0 , 766,7 , 846,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Barbados
    {     31,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 27,8 , 10,17 , 18,7 , 191,24 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 3806,20 , 13,5 , 4,0 , 766,7 , 854,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Belgium
    {     31,     7,    22,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 27,8 , 80,18 , 37,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,90,68},  6,1 , 3826,47 , 4,4 , 4,0 , 766,7 , 861,6 ,     2,     1,     7,     6,     7 }, // English/Latin/Belize
    {     31,     7,    24,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,77,68},  6,1 , 3873,53 , 4,4 , 4,0 , 766,7 , 867,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Bermuda
    {     31,     7,    28,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 27,8 , 80,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,87,80},  179,1 , 3926,50 , 4,4 , 4,0 , 766,7 , 874,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Botswana
    {     31,     7,    31,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 882,30 ,     2,     1,     1,     6,     7 }, // English/Latin/BritishIndianOceanTerritory
    {     31,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 3976,83 , 4,4 , 4,0 , 766,7 , 912,8 ,     0,     0,     1,     6,     7 }, // English/Latin/Cameroon
    {     31,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 53,10 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {67,65,68},  6,1 , 4059,53 , 4,4 , 4,0 , 920,16 , 936,6 ,     2,     0,     7,     6,     7 }, // English/Latin/Canada
    {     31,     7,    40,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {75,89,68},  6,1 , 4112,71 , 4,4 , 4,0 , 766,7 , 942,14 ,     2,     1,     1,     6,     7 }, // English/Latin/CaymanIslands
    {     31,     7,    45,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 766,7 , 956,16 ,     2,     1,     1,     6,     7 }, // English/Latin/ChristmasIsland
    {     31,     7,    46,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 766,7 , 972,23 ,     2,     1,     1,     6,     7 }, // English/Latin/CocosIslands
    {     31,     7,    51,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,90,68},  6,1 , 4183,62 , 4,4 , 4,0 , 766,7 , 995,12 ,     2,     1,     1,     6,     7 }, // English/Latin/CookIslands
    {     31,     7,    60,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 1007,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Dominica
    {     31,     7,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {69,82,78},  46,3 , 4245,50 , 4,4 , 4,0 , 766,7 , 1015,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Eritrea
    {     31,     7,    70,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {70,75,80},  125,1 , 4295,74 , 4,4 , 4,0 , 766,7 , 1022,16 ,     2,     1,     1,     6,     7 }, // English/Latin/FalklandIslands
    {     31,     7,    72,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {70,74,68},  6,1 , 4369,47 , 4,4 , 4,0 , 766,7 , 1038,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Fiji
    {     31,     7,    75,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,66,80},  125,1 , 4416,47 , 4,4 , 4,0 , 766,7 , 1042,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Guernsey
    {     31,     7,    80,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,77,68},  180,1 , 4463,50 , 4,4 , 4,0 , 766,7 , 1050,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Gambia
    {     31,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,72,83},  181,3 , 4513,47 , 4,4 , 4,0 , 766,7 , 1056,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Ghana
    {     31,     7,    84,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,73,80},  125,1 , 4560,53 , 4,4 , 4,0 , 766,7 , 1061,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Gibraltar
    {     31,     7,    87,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 1070,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Grenada
    {     31,     7,    89,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 1077,4 ,     2,     1,     7,     6,     7 }, // English/Latin/Guam
    {     31,     7,    93,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,89,68},  6,1 , 4613,56 , 4,4 , 4,0 , 766,7 , 1081,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Guyana
    {     31,     7,    97,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 534,8 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {72,75,68},  148,3 , 4669,56 , 4,4 , 4,0 , 766,7 , 1087,19 ,     2,     1,     7,     6,     7 }, // English/Latin/HongKong
    {     31,     7,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 27,8 , 98,16 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {73,78,82},  127,1 , 4725,44 , 8,5 , 4,0 , 766,7 , 1106,5 ,     2,     1,     7,     7,     7 }, // English/Latin/India
    {     31,     7,   104,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 98,16 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 100,4 , 98,4 , {69,85,82},  14,1 , 3806,20 , 4,4 , 4,0 , 766,7 , 1111,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Ireland
    {     31,     7,   107,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 283,6 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {74,77,68},  6,1 , 4769,53 , 4,4 , 4,0 , 766,7 , 1118,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Jamaica
    {     31,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {75,69,83},  2,3 , 4822,53 , 4,4 , 4,0 , 766,7 , 1125,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Kenya
    {     31,     7,   112,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 766,7 , 1130,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Kiribati
    {     31,     7,   120,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 4875,61 , 4,4 , 4,0 , 766,7 , 1138,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Lesotho
    {     31,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {76,82,68},  6,1 , 4936,53 , 4,4 , 4,0 , 766,7 , 1145,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Liberia
    {     31,     7,   126,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {77,79,80},  151,4 , 4989,53 , 4,4 , 4,0 , 766,7 , 1152,15 ,     2,     1,     7,     6,     7 }, // English/Latin/Macau
    {     31,     7,   128,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {77,71,65},  184,2 , 5042,54 , 4,4 , 4,0 , 766,7 , 1167,10 ,     0,     0,     1,     6,     7 }, // English/Latin/Madagascar
    {     31,     7,   129,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {77,87,75},  186,2 , 5096,53 , 4,4 , 4,0 , 766,7 , 1177,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Malawi
    {     31,     7,   130,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {77,89,82},  188,2 , 5149,59 , 4,4 , 4,0 , 766,7 , 1183,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Malaysia
    {     31,     7,   133,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 3806,20 , 4,4 , 4,0 , 766,7 , 1191,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Malta
    {     31,     7,   134,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 1196,16 ,     2,     1,     7,     6,     7 }, // English/Latin/MarshallIslands
    {     31,     7,   137,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {77,85,82},  190,2 , 5208,53 , 4,4 , 4,0 , 766,7 , 1212,9 ,     0,     0,     1,     6,     7 }, // English/Latin/Mauritius
    {     31,     7,   140,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 1221,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Micronesia
    {     31,     7,   144,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 1231,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Montserrat
    {     31,     7,   148,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,65,68},  6,1 , 5261,53 , 4,4 , 4,0 , 766,7 , 1241,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Namibia
    {     31,     7,   149,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 766,7 , 1248,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Nauru
    {     31,     7,   154,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 512,7 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,90,68},  6,1 , 4183,62 , 4,4 , 4,0 , 766,7 , 1253,11 ,     2,     1,     7,     6,     7 }, // English/Latin/NewZealand
    {     31,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,71,78},  192,1 , 5314,50 , 4,4 , 4,0 , 766,7 , 1264,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Nigeria
    {     31,     7,   158,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,90,68},  6,1 , 4183,62 , 4,4 , 4,0 , 766,7 , 1271,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Niue
    {     31,     7,   159,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 766,7 , 1275,14 ,     2,     1,     1,     6,     7 }, // English/Latin/NorfolkIsland
    {     31,     7,   160,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 1289,24 ,     2,     1,     1,     6,     7 }, // English/Latin/NorthernMarianaIslands
    {     31,     7,   163,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {80,75,82},  190,2 , 5364,53 , 4,4 , 4,0 , 766,7 , 1313,8 ,     0,     0,     7,     6,     7 }, // English/Latin/Pakistan
    {     31,     7,   164,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 1321,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Palau
    {     31,     7,   167,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {80,71,75},  143,1 , 5417,73 , 4,4 , 4,0 , 766,7 , 1326,16 ,     2,     1,     1,     6,     7 }, // English/Latin/PapuaNewGuinea
    {     31,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {80,72,80},  193,1 , 5490,53 , 4,4 , 4,0 , 766,7 , 1342,11 ,     2,     1,     7,     6,     7 }, // English/Latin/Philippines
    {     31,     7,   171,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,90,68},  6,1 , 4183,62 , 4,4 , 4,0 , 766,7 , 1353,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Pitcairn
    {     31,     7,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 1369,11 ,     2,     1,     7,     6,     7 }, // English/Latin/PuertoRico
    {     31,     7,   179,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {82,87,70},  194,2 , 5543,47 , 4,4 , 4,0 , 766,7 , 1380,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Rwanda
    {     31,     7,   180,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 1386,17 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintKittsAndNevis
    {     31,     7,   181,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 1403,9 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintLucia
    {     31,     7,   182,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {88,67,68},  6,1 , 3567,71 , 4,4 , 4,0 , 766,7 , 1412,24 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintVincentAndTheGrenadines
    {     31,     7,   183,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {87,83,84},  196,3 , 5590,40 , 4,4 , 4,0 , 766,7 , 1436,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Samoa
    {     31,     7,   188,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,67,82},  199,2 , 5630,59 , 4,4 , 4,0 , 766,7 , 1441,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Seychelles
    {     31,     7,   189,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,76,76},  201,2 , 5689,68 , 4,4 , 4,0 , 766,7 , 1451,12 ,     0,     0,     1,     6,     7 }, // English/Latin/SierraLeone
    {     31,     7,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 283,6 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,71,68},  6,1 , 5757,56 , 4,4 , 4,0 , 766,7 , 1463,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Singapore
    {     31,     7,   193,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,66,68},  6,1 , 5813,74 , 4,4 , 4,0 , 766,7 , 1472,15 ,     2,     1,     1,     6,     7 }, // English/Latin/SolomonIslands
    {     31,     7,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 247,10 , 80,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 4875,61 , 4,4 , 4,0 , 766,7 , 1487,12 ,     2,     1,     7,     6,     7 }, // English/Latin/SouthAfrica
    {     31,     7,   199,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,72,80},  125,1 , 5887,56 , 4,4 , 4,0 , 766,7 , 1499,10 ,     2,     1,     1,     6,     7 }, // English/Latin/SaintHelena
    {     31,     7,   201,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,68,71},  0,0 , 5943,50 , 4,4 , 4,0 , 766,7 , 1509,5 ,     2,     1,     6,     5,     6 }, // English/Latin/Sudan
    {     31,     7,   204,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,90,76},  203,1 , 5993,53 , 4,4 , 4,0 , 766,7 , 1514,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Swaziland
    {     31,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {84,90,83},  204,3 , 6046,62 , 4,4 , 4,0 , 766,7 , 1523,8 ,     0,     0,     1,     6,     7 }, // English/Latin/Tanzania
    {     31,     7,   213,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,90,68},  6,1 , 4183,62 , 4,4 , 4,0 , 766,7 , 1531,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Tokelau
    {     31,     7,   214,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {84,79,80},  207,2 , 6108,49 , 4,4 , 4,0 , 766,7 , 1538,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Tonga
    {     31,     7,   215,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {84,84,68},  6,1 , 6157,80 , 4,4 , 4,0 , 766,7 , 1543,17 ,     2,     1,     7,     6,     7 }, // English/Latin/TrinidadAndTobago
    {     31,     7,   219,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 1560,22 ,     2,     1,     1,     6,     7 }, // English/Latin/TurksAndCaicosIslands
    {     31,     7,   220,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  6,1 , 3638,59 , 4,4 , 4,0 , 766,7 , 1582,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Tuvalu
    {     31,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,71,88},  209,3 , 6237,56 , 4,4 , 4,0 , 766,7 , 1588,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Uganda
    {     31,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 37,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 100,4 , 98,4 , {71,66,80},  125,1 , 4416,47 , 4,4 , 4,0 , 1594,15 , 1609,14 ,     2,     1,     1,     6,     7 }, // English/Latin/UnitedKingdom
    {     31,     7,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 1623,21 ,     2,     1,     7,     6,     7 }, // English/Latin/UnitedStatesMinorOutlyingIslands
    {     31,     7,   229,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {86,85,86},  212,2 , 6293,44 , 4,4 , 4,0 , 766,7 , 1644,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Vanuatu
    {     31,     7,   233,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 1651,22 ,     2,     1,     1,     6,     7 }, // English/Latin/BritishVirginIslands
    {     31,     7,   234,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 3532,35 , 4,4 , 4,0 , 766,7 , 1673,19 ,     2,     1,     7,     6,     7 }, // English/Latin/UnitedStatesVirginIslands
    {     31,     7,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {90,77,87},  143,1 , 6337,50 , 4,4 , 4,0 , 766,7 , 1692,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Zambia
    {     31,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 534,8 , 80,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 1698,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Zimbabwe
    {     31,     7,   249,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 3532,35 , 4,4 , 4,0 , 766,7 , 1706,12 ,     2,     1,     1,     6,     7 }, // English/Latin/DiegoGarcia
    {     31,     7,   251,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,66,80},  125,1 , 4416,47 , 4,4 , 4,0 , 766,7 , 1718,11 ,     2,     1,     1,     6,     7 }, // English/Latin/IsleOfMan
    {     31,     7,   252,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,66,80},  125,1 , 4416,47 , 4,4 , 4,0 , 766,7 , 1729,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Jersey
    {     31,     7,   254,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,83,80},  125,1 , 6387,68 , 4,4 , 4,0 , 766,7 , 1735,11 ,     2,     1,     1,     6,     7 }, // English/Latin/SouthSudan
    {     31,     7,   256,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 204,10 , 214,9 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,78,71},  172,4 , 6455,95 , 4,4 , 4,0 , 766,7 , 1746,12 ,     2,     1,     1,     6,     7 }, // English/Latin/SintMaarten
    {     33,     7,    68,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 223,8 , 223,8 , 158,8 , 542,18 , 42,4 , 215,9 , 5344,59 , 5403,91 , 5494,24 , 5344,59 , 5403,91 , 5494,24 , 2556,14 , 2570,63 , 2556,14 , 2556,14 , 2570,63 , 2556,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 6550,20 , 13,5 , 4,0 , 1758,5 , 1763,5 ,     2,     1,     1,     6,     7 }, // Estonian/Latin/Estonia
    {     34,     7,    71,    44,    46,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 196,8 , 196,8 , 353,8 , 560,17 , 37,5 , 8,10 , 5518,48 , 5566,83 , 134,24 , 5518,48 , 5566,83 , 134,24 , 2633,28 , 2661,74 , 2735,14 , 2633,28 , 2661,74 , 2735,14 , 104,14 , 102,15 , {68,75,75},  214,2 , 6570,42 , 4,4 , 24,5 , 1768,8 , 1776,7 ,     2,     1,     1,     6,     7 }, // Faroese/Latin/FaroeIslands
    {     36,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 223,8 , 223,8 , 577,8 , 472,17 , 224,4 , 228,9 , 5649,69 , 5718,105 , 5823,24 , 5847,129 , 5847,129 , 5823,24 , 2749,21 , 2770,67 , 2837,14 , 2749,21 , 2851,81 , 2837,14 , 118,3 , 117,3 , {69,85,82},  14,1 , 6612,20 , 13,5 , 4,0 , 1783,5 , 1788,5 ,     2,     1,     1,     6,     7 }, // Finnish/Latin/Finland
    {     37,     7,    74,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 1801,6 ,     2,     1,     1,     6,     7 }, // French/Latin/France
    {     37,     7,     3,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {68,90,68},  216,2 , 6632,51 , 13,5 , 4,0 , 1793,8 , 1807,7 ,     2,     1,     6,     5,     6 }, // French/Latin/Algeria
    {     37,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 512,7 , 98,16 , 37,5 , 237,23 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 1814,8 ,     2,     1,     1,     6,     7 }, // French/Latin/Belgium
    {     37,     7,    23,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 1822,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Benin
    {     37,     7,    34,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 1827,12 ,     0,     0,     1,     6,     7 }, // French/Latin/BurkinaFaso
    {     37,     7,    35,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {66,73,70},  221,3 , 6742,53 , 13,5 , 4,0 , 1793,8 , 1839,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Burundi
    {     37,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 6795,56 , 13,5 , 4,0 , 1793,8 , 1846,8 ,     0,     0,     1,     6,     7 }, // French/Latin/Cameroon
    {     37,     7,    38,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 585,8 , 98,16 , 37,5 , 8,10 , 6124,63 , 6187,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 3033,35 , 3068,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {67,65,68},  6,1 , 6851,54 , 13,5 , 4,0 , 1854,17 , 936,6 ,     2,     0,     7,     6,     7 }, // French/Latin/Canada
    {     37,     7,    41,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 6795,56 , 13,5 , 4,0 , 1793,8 , 1871,25 ,     0,     0,     1,     6,     7 }, // French/Latin/CentralAfricanRepublic
    {     37,     7,    42,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 6795,56 , 13,5 , 4,0 , 1793,8 , 1896,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Chad
    {     37,     7,    48,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {75,77,70},  224,2 , 6905,51 , 13,5 , 4,0 , 1793,8 , 1901,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Comoros
    {     37,     7,    49,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {67,68,70},  226,2 , 6956,53 , 13,5 , 4,0 , 1793,8 , 1908,14 ,     2,     1,     1,     6,     7 }, // French/Latin/CongoKinshasa
    {     37,     7,    50,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 6795,56 , 13,5 , 4,0 , 1793,8 , 1922,17 ,     0,     0,     1,     6,     7 }, // French/Latin/CongoBrazzaville
    {     37,     7,    53,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 1939,13 ,     0,     0,     1,     6,     7 }, // French/Latin/IvoryCoast
    {     37,     7,    59,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {68,74,70},  43,3 , 7009,57 , 13,5 , 4,0 , 1793,8 , 1952,8 ,     0,     0,     6,     6,     7 }, // French/Latin/Djibouti
    {     37,     7,    66,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 6795,56 , 13,5 , 4,0 , 1793,8 , 1960,18 ,     0,     0,     1,     6,     7 }, // French/Latin/EquatorialGuinea
    {     37,     7,    76,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 1978,16 ,     2,     1,     1,     6,     7 }, // French/Latin/FrenchGuiana
    {     37,     7,    77,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,80,70},  228,4 , 7066,35 , 13,5 , 4,0 , 1793,8 , 1994,19 ,     0,     0,     1,     6,     7 }, // French/Latin/FrenchPolynesia
    {     37,     7,    79,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 6795,56 , 13,5 , 4,0 , 1793,8 , 2013,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Gabon
    {     37,     7,    88,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2018,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Guadeloupe
    {     37,     7,    91,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {71,78,70},  232,2 , 7101,48 , 13,5 , 4,0 , 1793,8 , 2028,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Guinea
    {     37,     7,    94,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {72,84,71},  234,1 , 7149,57 , 13,5 , 4,0 , 1793,8 , 2034,5 ,     2,     1,     1,     6,     7 }, // French/Latin/Haiti
    {     37,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2039,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Luxembourg
    {     37,     7,   128,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {77,71,65},  184,2 , 7206,54 , 13,5 , 4,0 , 1793,8 , 1167,10 ,     0,     0,     1,     6,     7 }, // French/Latin/Madagascar
    {     37,     7,   132,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 2049,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Mali
    {     37,     7,   135,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2053,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Martinique
    {     37,     7,   136,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {77,82,79},  235,2 , 7260,66 , 13,5 , 4,0 , 1793,8 , 2063,10 ,     0,     0,     1,     6,     7 }, // French/Latin/Mauritania
    {     37,     7,   137,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {77,85,82},  190,2 , 7326,63 , 13,5 , 4,0 , 1793,8 , 2073,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Mauritius
    {     37,     7,   138,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2080,7 ,     2,     1,     1,     6,     7 }, // French/Latin/Mayotte
    {     37,     7,   142,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2087,6 ,     2,     1,     1,     6,     7 }, // French/Latin/Monaco
    {     37,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {77,65,68},  237,3 , 7389,54 , 13,5 , 4,0 , 1793,8 , 2093,5 ,     2,     1,     6,     5,     6 }, // French/Latin/Morocco
    {     37,     7,   153,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,80,70},  228,4 , 7066,35 , 13,5 , 4,0 , 1793,8 , 2098,18 ,     0,     0,     1,     6,     7 }, // French/Latin/NewCaledonia
    {     37,     7,   156,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 2116,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Niger
    {     37,     7,   176,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2121,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Reunion
    {     37,     7,   179,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {82,87,70},  194,2 , 7443,50 , 13,5 , 4,0 , 1793,8 , 1380,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Rwanda
    {     37,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 2131,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Senegal
    {     37,     7,   188,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {83,67,82},  199,2 , 7493,71 , 13,5 , 4,0 , 1793,8 , 1441,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Seychelles
    {     37,     7,   200,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2138,24 ,     2,     1,     1,     6,     7 }, // French/Latin/SaintPierreAndMiquelon
    {     37,     7,   206,    46,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 231,8 , 231,8 , 158,8 , 10,17 , 37,5 , 260,14 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {67,72,70},  240,3 , 7564,45 , 8,5 , 29,5 , 2162,15 , 2177,6 ,     2,     0,     1,     6,     7 }, // French/Latin/Switzerland
    {     37,     7,   207,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {83,89,80},  243,2 , 7609,51 , 13,5 , 4,0 , 1793,8 , 2183,5 ,     0,     0,     6,     5,     6 }, // French/Latin/Syria
    {     37,     7,   212,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 6683,59 , 13,5 , 4,0 , 1793,8 , 2188,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Togo
    {     37,     7,   216,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {84,78,68},  245,2 , 7660,51 , 13,5 , 4,0 , 1793,8 , 2192,7 ,     3,     0,     7,     5,     6 }, // French/Latin/Tunisia
    {     37,     7,   229,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {86,85,86},  212,2 , 7711,51 , 13,5 , 4,0 , 1793,8 , 1644,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Vanuatu
    {     37,     7,   235,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {88,80,70},  228,4 , 7066,35 , 13,5 , 4,0 , 1793,8 , 2199,16 ,     0,     0,     1,     6,     7 }, // French/Latin/WallisAndFutunaIslands
    {     37,     7,   244,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2215,16 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Barthelemy
    {     37,     7,   245,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 231,8 , 231,8 , 120,10 , 98,16 , 37,5 , 8,10 , 5976,63 , 6039,85 , 134,24 , 6124,63 , 6187,85 , 134,24 , 2932,35 , 2967,52 , 3019,14 , 3033,35 , 3068,52 , 3019,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 1793,8 , 2231,12 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Martin
    {     38,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 6,8 , 6,8 , 353,8 , 98,16 , 37,5 , 8,10 , 6272,48 , 6320,95 , 134,24 , 6415,59 , 6320,95 , 134,24 , 3120,21 , 3141,54 , 2462,14 , 3120,21 , 3141,54 , 2462,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 3242,19 , 8,5 , 34,6 , 2243,10 , 2253,8 ,     2,     1,     1,     6,     7 }, // Western Frisian/Latin/Netherlands
    {     39,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 239,10 , 239,10 , 120,10 , 593,21 , 37,5 , 8,10 , 6474,61 , 6535,142 , 6677,24 , 6474,61 , 6701,167 , 6677,24 , 3195,28 , 3223,69 , 3292,14 , 3195,28 , 3223,69 , 3292,14 , 121,1 , 120,1 , {71,66,80},  125,1 , 7762,86 , 4,4 , 4,0 , 2261,8 , 2269,22 ,     2,     1,     1,     6,     7 }, // Gaelic/Latin/UnitedKingdom
    {     40,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 560,17 , 37,5 , 8,10 , 6868,48 , 6916,87 , 7003,24 , 7027,48 , 7075,87 , 7003,24 , 3306,28 , 3334,49 , 3383,14 , 3397,28 , 3425,49 , 3383,14 , 100,4 , 98,4 , {69,85,82},  14,1 , 3806,20 , 4,4 , 4,0 , 2291,6 , 2297,6 ,     2,     1,     1,     6,     7 }, // Galician/Latin/Spain
    {     41,    15,    81,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,   171,   187, 0,6 , 0,6 , 256,8 , 256,8 , 158,8 , 614,19 , 37,5 , 8,10 , 7162,48 , 7210,99 , 7309,24 , 7162,48 , 7210,99 , 7309,24 , 3474,28 , 3502,62 , 3564,14 , 3474,28 , 3502,62 , 3564,14 , 0,2 , 0,2 , {71,69,76},  247,3 , 7848,43 , 13,5 , 4,0 , 2303,7 , 2310,10 ,     2,     1,     1,     6,     7 }, // Georgian/Georgian/Georgia
    {     42,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 7381,83 , 134,24 , 7464,59 , 7381,83 , 134,24 , 3578,21 , 3599,60 , 3659,14 , 3673,28 , 3599,60 , 3659,14 , 122,5 , 121,6 , {69,85,82},  14,1 , 7891,19 , 13,5 , 4,0 , 2320,7 , 2327,11 ,     2,     1,     1,     6,     7 }, // German/Latin/Germany
    {     42,     7,    14,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7523,48 , 7571,83 , 134,24 , 7654,59 , 7571,83 , 134,24 , 3578,21 , 3599,60 , 3659,14 , 3673,28 , 3599,60 , 3659,14 , 122,5 , 121,6 , {69,85,82},  14,1 , 7891,19 , 8,5 , 4,0 , 2338,24 , 2362,10 ,     2,     1,     1,     6,     7 }, // German/Latin/Austria
    {     42,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 7381,83 , 134,24 , 7464,59 , 7381,83 , 134,24 , 3578,21 , 3599,60 , 3659,14 , 3673,28 , 3599,60 , 3659,14 , 122,5 , 121,6 , {69,85,82},  14,1 , 7891,19 , 13,5 , 4,0 , 2320,7 , 2372,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Belgium
    {     42,     7,   123,    46,    39,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 7381,83 , 134,24 , 7464,59 , 7381,83 , 134,24 , 3578,21 , 3599,60 , 3659,14 , 3673,28 , 3599,60 , 3659,14 , 122,5 , 121,6 , {67,72,70},  240,3 , 7910,58 , 8,5 , 4,0 , 2320,7 , 2379,13 ,     2,     0,     1,     6,     7 }, // German/Latin/Liechtenstein
    {     42,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 7381,83 , 134,24 , 7464,59 , 7381,83 , 134,24 , 3578,21 , 3599,60 , 3659,14 , 3673,28 , 3599,60 , 3659,14 , 122,5 , 121,6 , {69,85,82},  14,1 , 7891,19 , 13,5 , 4,0 , 2320,7 , 2392,9 ,     2,     1,     1,     6,     7 }, // German/Latin/Luxembourg
    {     42,     7,   206,    46,    39,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 7381,83 , 134,24 , 7464,59 , 7381,83 , 134,24 , 3578,21 , 3599,60 , 3659,14 , 3673,28 , 3599,60 , 3659,14 , 122,5 , 121,6 , {67,72,70},  240,3 , 7910,58 , 8,5 , 29,5 , 2401,21 , 2422,7 ,     2,     0,     1,     6,     7 }, // German/Latin/Switzerland
    {     43,    16,    85,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,    34,    34, 0,6 , 0,6 , 273,9 , 273,9 , 283,6 , 10,17 , 18,7 , 25,12 , 7713,50 , 7763,115 , 7878,24 , 7902,50 , 7952,115 , 7878,24 , 3701,28 , 3729,55 , 3784,14 , 3701,28 , 3729,55 , 3784,14 , 127,4 , 127,4 , {69,85,82},  14,1 , 7968,19 , 13,5 , 4,0 , 2429,8 , 2437,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Greece
    {     43,    16,    56,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,    34,    34, 0,6 , 0,6 , 273,9 , 273,9 , 283,6 , 10,17 , 18,7 , 25,12 , 7713,50 , 7763,115 , 7878,24 , 7902,50 , 7952,115 , 7878,24 , 3701,28 , 3729,55 , 3784,14 , 3701,28 , 3729,55 , 3784,14 , 127,4 , 127,4 , {69,85,82},  14,1 , 7968,19 , 13,5 , 4,0 , 2429,8 , 2443,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Cyprus
    {     44,     7,    86,    44,    46,    59,    37,    48,  8722,    43,   101,   187,   171,  8250,  8249, 0,6 , 0,6 , 282,11 , 282,11 , 53,10 , 560,17 , 18,7 , 25,12 , 4859,48 , 8067,96 , 134,24 , 4859,48 , 8067,96 , 134,24 , 3798,28 , 3826,98 , 3924,14 , 3798,28 , 3826,98 , 3924,14 , 0,2 , 0,2 , {68,75,75},  165,3 , 7987,62 , 4,4 , 24,5 , 2449,11 , 2460,16 ,     2,     1,     1,     6,     7 }, // Greenlandic/Latin/Greenland
    {     45,     7,   168,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {80,89,71},  250,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     7,     6,     7 }, // Guarani/Latin/Paraguay
    {     46,    17,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 293,9 , 293,9 , 283,6 , 193,18 , 274,8 , 282,13 , 8163,67 , 8230,87 , 8317,31 , 8348,64 , 8230,87 , 8317,31 , 3938,32 , 3970,53 , 4023,19 , 3938,32 , 3970,53 , 4023,19 , 0,2 , 0,2 , {73,78,82},  127,1 , 8049,46 , 4,4 , 4,0 , 2476,7 , 2483,4 ,     2,     1,     7,     7,     7 }, // Gujarati/Gujarati/India
    {     47,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 283,6 , 193,18 , 37,5 , 8,10 , 8412,48 , 8460,85 , 8545,24 , 8412,48 , 8460,85 , 8545,24 , 4042,21 , 4063,52 , 4115,14 , 4042,21 , 4063,52 , 4115,14 , 0,2 , 0,2 , {78,71,78},  192,1 , 8095,12 , 8,5 , 4,0 , 2487,5 , 2492,8 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Nigeria
    {     47,     1,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,71,78},  192,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Hausa/Arabic/Nigeria
    {     47,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 283,6 , 193,18 , 37,5 , 8,10 , 8412,48 , 8460,85 , 8545,24 , 8412,48 , 8460,85 , 8545,24 , 4042,21 , 4063,52 , 4115,14 , 4042,21 , 4063,52 , 4115,14 , 0,2 , 0,2 , {71,72,83},  181,3 , 0,7 , 8,5 , 4,0 , 2487,5 , 2500,4 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Ghana
    {     47,     7,   156,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 283,6 , 193,18 , 37,5 , 8,10 , 8412,48 , 8460,85 , 8545,24 , 8412,48 , 8460,85 , 8545,24 , 4042,21 , 4063,52 , 4115,14 , 4042,21 , 4063,52 , 4115,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 8107,36 , 8,5 , 4,0 , 2487,5 , 2504,5 ,     0,     0,     1,     6,     7 }, // Hausa/Latin/Niger
    {     48,    18,   105,    46,    44,    59,    37,    48,    45,    43,   101,  1524,  1524,  1523,  1523, 0,6 , 0,6 , 302,6 , 302,6 , 577,8 , 633,18 , 42,4 , 137,9 , 8569,58 , 8627,72 , 158,27 , 8569,58 , 8627,72 , 158,27 , 4129,46 , 4175,65 , 4240,21 , 4129,46 , 4175,65 , 4240,21 , 131,6 , 131,5 , {73,76,83},  54,1 , 8143,54 , 13,5 , 4,0 , 2509,5 , 2514,5 ,     2,     1,     7,     5,     6 }, // Hebrew/Hebrew/Israel
    {     49,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 308,9 , 317,8 , 283,6 , 10,17 , 18,7 , 25,12 , 8699,59 , 8758,73 , 8831,30 , 8699,59 , 8758,73 , 8831,30 , 4261,32 , 4293,53 , 4346,19 , 4261,32 , 4293,53 , 4346,19 , 137,9 , 136,7 , {73,78,82},  127,1 , 8197,42 , 4,4 , 4,0 , 2519,6 , 2525,4 ,     2,     1,     7,     7,     7 }, // Hindi/Devanagari/India
    {     50,     7,    98,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   187,   171, 0,6 , 0,6 , 325,8 , 325,8 , 651,13 , 664,19 , 42,4 , 137,9 , 8861,64 , 8925,98 , 9023,25 , 8861,64 , 8925,98 , 9023,25 , 4365,19 , 4384,52 , 4436,17 , 4365,19 , 4384,52 , 4436,17 , 146,3 , 143,3 , {72,85,70},  251,3 , 8239,46 , 13,5 , 4,0 , 2529,6 , 2535,12 ,     2,     0,     1,     6,     7 }, // Hungarian/Latin/Hungary
    {     51,     7,    99,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 196,8 , 196,8 , 577,8 , 542,18 , 37,5 , 8,10 , 9048,59 , 9107,82 , 9189,24 , 9048,59 , 9107,82 , 9189,24 , 4453,35 , 4488,81 , 4569,14 , 4453,35 , 4488,81 , 4569,14 , 149,4 , 146,4 , {73,83,75},  254,3 , 8285,49 , 13,5 , 4,0 , 2547,8 , 2555,6 ,     0,     0,     1,     6,     7 }, // Icelandic/Latin/Iceland
    {     52,     7,   101,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 333,10 , 343,9 , 27,8 , 80,18 , 146,5 , 151,10 , 9213,48 , 9261,87 , 134,24 , 9213,48 , 9261,87 , 134,24 , 4583,28 , 4611,43 , 4654,14 , 4583,28 , 4611,43 , 4654,14 , 0,2 , 0,2 , {73,68,82},  257,2 , 8334,39 , 4,4 , 4,0 , 2561,16 , 2577,9 ,     0,     0,     7,     6,     7 }, // Indonesian/Latin/Indonesia
    {     53,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Interlingua/Latin/France
    {     55,    44,    38,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,65,68},  259,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/CanadianAboriginal/Canada
    {     55,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,65,68},  259,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/Latin/Canada
    {     57,     7,   104,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 352,11 , 239,10 , 120,10 , 98,16 , 37,5 , 8,10 , 9348,62 , 9410,107 , 9517,24 , 9348,62 , 9410,107 , 9517,24 , 4668,37 , 4705,75 , 4780,14 , 4668,37 , 4705,75 , 4780,14 , 100,4 , 98,4 , {69,85,82},  14,1 , 8373,31 , 4,4 , 4,0 , 2586,7 , 2593,4 ,     2,     1,     7,     6,     7 }, // Irish/Latin/Ireland
    {     58,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 98,16 , 37,5 , 8,10 , 9541,48 , 9589,94 , 9683,24 , 9541,48 , 9707,94 , 9683,24 , 4794,28 , 4822,57 , 4879,14 , 4794,28 , 4893,57 , 4879,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 8404,19 , 13,5 , 4,0 , 2597,8 , 2605,6 ,     2,     1,     1,     6,     7 }, // Italian/Latin/Italy
    {     58,     7,   184,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 98,16 , 37,5 , 8,10 , 9541,48 , 9589,94 , 9683,24 , 9541,48 , 9707,94 , 9683,24 , 4794,28 , 4822,57 , 4879,14 , 4794,28 , 4893,57 , 4879,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 8404,19 , 13,5 , 4,0 , 2597,8 , 2611,10 ,     2,     1,     1,     6,     7 }, // Italian/Latin/SanMarino
    {     58,     7,   206,    46,    39,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 249,7 , 249,7 , 158,8 , 10,17 , 37,5 , 8,10 , 9541,48 , 9589,94 , 9683,24 , 9541,48 , 9707,94 , 9683,24 , 4794,28 , 4822,57 , 4879,14 , 4794,28 , 4893,57 , 4879,14 , 0,2 , 0,2 , {67,72,70},  240,3 , 8423,53 , 8,5 , 29,5 , 2597,8 , 2621,8 ,     2,     0,     1,     6,     7 }, // Italian/Latin/Switzerland
    {     59,    19,   108,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 179,5 , 179,5 , 179,5 , 179,5 , 247,10 , 407,13 , 42,4 , 295,10 , 4288,39 , 4288,39 , 158,27 , 4288,39 , 4288,39 , 158,27 , 4950,14 , 4964,28 , 4950,14 , 4950,14 , 4964,28 , 4950,14 , 153,2 , 150,2 , {74,80,89},  147,1 , 8476,11 , 4,4 , 4,0 , 2629,3 , 2632,2 ,     0,     0,     7,     6,     7 }, // Japanese/Japanese/Japan
    {     60,     7,   101,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,68,82},  257,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     7,     6,     7 }, // Javanese/Latin/Indonesia
    {     61,    21,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 363,12 , 375,11 , 519,6 , 35,18 , 274,8 , 282,13 , 9801,63 , 9864,87 , 9951,31 , 9801,63 , 9864,87 , 9951,31 , 4992,33 , 5025,54 , 5079,20 , 4992,33 , 5025,54 , 5079,20 , 155,9 , 152,7 , {73,78,82},  127,1 , 8487,46 , 4,4 , 4,0 , 2634,5 , 2639,4 ,     2,     1,     7,     7,     7 }, // Kannada/Kannada/India
    {     62,     1,   100,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 519,6 , 35,18 , 18,7 , 25,12 , 9982,72 , 9982,72 , 10054,24 , 9982,72 , 9982,72 , 10054,24 , 5099,54 , 5153,56 , 5209,14 , 5099,54 , 5153,56 , 5209,14 , 0,2 , 0,2 , {73,78,82},  127,1 , 8533,23 , 8,5 , 4,0 , 2643,5 , 2648,10 ,     2,     1,     7,     7,     7 }, // Kashmiri/Arabic/India
    {     63,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,  8220,    34,  8216,  8217, 0,6 , 0,6 , 0,6 , 386,10 , 27,8 , 10,17 , 37,5 , 8,10 , 10078,61 , 10139,83 , 10222,24 , 10078,61 , 10139,83 , 10222,24 , 5223,29 , 5252,56 , 5308,14 , 5322,29 , 5252,56 , 5308,14 , 164,10 , 159,14 , {75,90,84},  262,1 , 8556,58 , 13,5 , 4,0 , 2658,10 , 2668,9 ,     2,     1,     1,     6,     7 }, // Kazakh/Cyrillic/Kazakhstan
    {     64,     7,   179,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 683,8 , 691,18 , 37,5 , 8,10 , 10246,60 , 10306,101 , 158,27 , 10246,60 , 10306,101 , 158,27 , 5351,35 , 5386,84 , 85,14 , 5351,35 , 5386,84 , 85,14 , 0,2 , 0,2 , {82,87,70},  194,2 , 0,7 , 8,5 , 4,0 , 2677,11 , 1380,6 ,     0,     0,     1,     6,     7 }, // Kinyarwanda/Latin/Rwanda
    {     65,     2,   116,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 396,10 , 396,10 , 158,8 , 709,23 , 37,5 , 8,10 , 10407,48 , 10455,80 , 10535,24 , 10559,59 , 10618,80 , 10535,24 , 5470,38 , 5508,57 , 5565,14 , 5470,38 , 5508,57 , 5565,14 , 174,5 , 173,12 , {75,71,83},  263,3 , 8614,52 , 13,5 , 4,0 , 2688,8 , 2696,10 ,     2,     1,     1,     6,     7 }, // Kirghiz/Cyrillic/Kyrgyzstan
    {     66,    22,   114,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 406,7 , 406,7 , 732,9 , 741,16 , 305,7 , 312,13 , 10698,39 , 10698,39 , 10698,39 , 10698,39 , 10698,39 , 10698,39 , 5579,14 , 5593,28 , 5579,14 , 5579,14 , 5593,28 , 5579,14 , 179,2 , 185,2 , {75,82,87},  266,1 , 8666,19 , 4,4 , 4,0 , 2706,3 , 2709,4 ,     0,     0,     7,     6,     7 }, // Korean/Korean/SouthKorea
    {     66,    22,   113,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 406,7 , 406,7 , 732,9 , 741,16 , 305,7 , 312,13 , 10698,39 , 10698,39 , 10698,39 , 10698,39 , 10698,39 , 10698,39 , 5579,14 , 5593,28 , 5579,14 , 5579,14 , 5593,28 , 5579,14 , 179,2 , 185,2 , {75,80,87},  267,3 , 8685,39 , 4,4 , 4,0 , 2706,3 , 2713,11 ,     0,     0,     1,     6,     7 }, // Korean/Korean/NorthKorea
    {     67,     7,   217,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {84,82,89},  270,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Kurdish/Latin/Turkey
    {     68,     7,    35,    44,    46,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 10737,60 , 10797,106 , 158,27 , 10737,60 , 10797,106 , 158,27 , 5621,34 , 5655,89 , 85,14 , 5621,34 , 5655,89 , 85,14 , 181,5 , 187,5 , {66,73,70},  221,3 , 8724,27 , 0,4 , 4,0 , 2724,8 , 2732,8 ,     0,     0,     1,     6,     7 }, // Rundi/Latin/Burundi
    {     69,    23,   117,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 413,9 , 534,8 , 757,19 , 42,4 , 325,24 , 10903,61 , 10964,75 , 158,27 , 10903,61 , 10964,75 , 158,27 , 5744,36 , 5780,57 , 5837,16 , 5780,57 , 5780,57 , 1849,14 , 186,8 , 192,8 , {76,65,75},  271,1 , 8751,21 , 4,4 , 29,5 , 2740,3 , 2740,3 ,     0,     0,     7,     6,     7 }, // Lao/Lao/Laos
    {     71,     7,   118,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 422,8 , 422,8 , 158,8 , 776,26 , 37,5 , 8,10 , 11039,65 , 11104,101 , 134,24 , 11205,65 , 11270,101 , 134,24 , 5853,21 , 5874,72 , 5946,14 , 5853,21 , 5960,72 , 5946,14 , 194,14 , 200,11 , {69,85,82},  14,1 , 8772,23 , 4,4 , 4,0 , 2743,8 , 2751,7 ,     2,     1,     1,     6,     7 }, // Latvian/Latin/Latvia
    {     72,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 430,9 , 430,9 , 534,8 , 98,16 , 37,5 , 8,10 , 11371,48 , 11419,203 , 11622,24 , 11371,48 , 11419,203 , 11622,24 , 6032,28 , 6060,100 , 6160,14 , 6032,28 , 6060,100 , 6160,14 , 208,8 , 211,6 , {67,68,70},  226,2 , 8795,23 , 13,5 , 4,0 , 2758,7 , 2765,29 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/CongoKinshasa
    {     72,     7,     6,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 430,9 , 430,9 , 534,8 , 98,16 , 37,5 , 8,10 , 11371,48 , 11419,203 , 11622,24 , 11371,48 , 11419,203 , 11622,24 , 6032,28 , 6060,100 , 6160,14 , 6032,28 , 6060,100 , 6160,14 , 208,8 , 211,6 , {65,79,65},  272,2 , 8818,23 , 13,5 , 4,0 , 2758,7 , 2794,6 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/Angola
    {     72,     7,    41,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 430,9 , 430,9 , 534,8 , 98,16 , 37,5 , 8,10 , 11371,48 , 11419,203 , 11622,24 , 11371,48 , 11419,203 , 11622,24 , 6032,28 , 6060,100 , 6160,14 , 6032,28 , 6060,100 , 6160,14 , 208,8 , 211,6 , {88,65,70},  32,4 , 8841,23 , 13,5 , 4,0 , 2758,7 , 2800,26 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/CentralAfricanRepublic
    {     72,     7,    50,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 430,9 , 430,9 , 534,8 , 98,16 , 37,5 , 8,10 , 11371,48 , 11419,203 , 11622,24 , 11371,48 , 11419,203 , 11622,24 , 6032,28 , 6060,100 , 6160,14 , 6032,28 , 6060,100 , 6160,14 , 208,8 , 211,6 , {88,65,70},  32,4 , 8841,23 , 13,5 , 4,0 , 2758,7 , 2826,5 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/CongoBrazzaville
    {     73,     7,   124,    44,   160,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 439,8 , 439,8 , 53,10 , 802,27 , 37,5 , 8,10 , 11646,70 , 11716,96 , 11812,24 , 11646,70 , 11836,98 , 11812,24 , 6174,21 , 6195,89 , 6284,14 , 6174,21 , 6195,89 , 6284,14 , 216,9 , 217,6 , {69,85,82},  14,1 , 8864,30 , 13,5 , 4,0 , 2831,8 , 2839,7 ,     2,     1,     1,     6,     7 }, // Lithuanian/Latin/Lithuania
    {     74,     2,   127,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 125,7 , 0,6 , 829,7 , 80,18 , 37,5 , 8,10 , 11934,61 , 11995,85 , 12080,24 , 11934,61 , 11995,85 , 12080,24 , 6298,34 , 6332,54 , 1630,14 , 6298,34 , 6332,54 , 1630,14 , 225,10 , 223,8 , {77,75,68},  274,3 , 8894,55 , 8,5 , 4,0 , 2846,10 , 2856,10 ,     2,     1,     1,     6,     7 }, // Macedonian/Cyrillic/Macedonia
    {     75,     7,   128,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 12104,48 , 12152,92 , 134,24 , 12104,48 , 12152,92 , 134,24 , 6386,34 , 6420,60 , 6480,14 , 6386,34 , 6420,60 , 6480,14 , 0,2 , 0,2 , {77,71,65},  184,2 , 8949,13 , 4,4 , 4,0 , 2866,8 , 2874,12 ,     0,     0,     1,     6,     7 }, // Malagasy/Latin/Madagascar
    {     76,     7,   130,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 343,9 , 343,9 , 512,7 , 10,17 , 18,7 , 25,12 , 12244,48 , 12292,82 , 12374,24 , 12244,48 , 12292,82 , 12374,24 , 6494,28 , 6522,43 , 6565,14 , 6494,28 , 6522,43 , 6565,14 , 235,2 , 231,3 , {77,89,82},  188,2 , 8962,39 , 4,4 , 4,0 , 2886,13 , 1183,8 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Malaysia
    {     76,     1,   130,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {77,89,82},  188,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Malay/Arabic/Malaysia
    {     76,     7,    32,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 343,9 , 343,9 , 512,7 , 836,12 , 18,7 , 25,12 , 12244,48 , 12292,82 , 12374,24 , 12244,48 , 12292,82 , 12374,24 , 6494,28 , 6522,43 , 6565,14 , 6494,28 , 6522,43 , 6565,14 , 235,2 , 231,3 , {66,78,68},  6,1 , 9001,31 , 8,5 , 4,0 , 2886,13 , 2899,6 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Brunei
    {     76,     7,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 343,9 , 343,9 , 512,7 , 10,17 , 18,7 , 25,12 , 12244,48 , 12292,82 , 12374,24 , 12244,48 , 12292,82 , 12374,24 , 6494,28 , 6522,43 , 6565,14 , 6494,28 , 6522,43 , 6565,14 , 235,2 , 231,3 , {83,71,68},  6,1 , 9032,37 , 4,4 , 4,0 , 2886,13 , 2905,9 ,     2,     1,     7,     6,     7 }, // Malay/Latin/Singapore
    {     77,    24,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 447,13 , 460,12 , 27,8 , 848,18 , 18,7 , 25,12 , 12398,62 , 12460,88 , 12548,29 , 12398,62 , 12460,88 , 12577,29 , 6579,41 , 6620,77 , 6697,17 , 6579,41 , 6714,76 , 6697,17 , 0,2 , 0,2 , {73,78,82},  127,1 , 9069,40 , 4,4 , 4,0 , 2914,6 , 2920,6 ,     2,     1,     7,     7,     7 }, // Malayalam/Malayalam/India
    {     78,     7,   133,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 472,8 , 480,7 , 120,10 , 866,23 , 37,5 , 8,10 , 12606,48 , 12654,86 , 12740,36 , 12606,48 , 12654,86 , 12776,24 , 6790,28 , 6818,63 , 6881,21 , 6790,28 , 6818,63 , 6902,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 9109,27 , 4,4 , 4,0 , 2926,5 , 1191,5 ,     2,     1,     7,     6,     7 }, // Maltese/Latin/Malta
    {     79,     7,   154,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,90,68},  277,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Maori/Latin/NewZealand
    {     80,    13,   100,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 487,9 , 487,9 , 283,6 , 193,18 , 18,7 , 25,12 , 12800,66 , 12866,86 , 12952,32 , 12800,66 , 12866,86 , 12952,32 , 6916,32 , 6948,53 , 4346,19 , 6916,32 , 6948,53 , 4346,19 , 237,5 , 234,4 , {73,78,82},  127,1 , 9136,43 , 4,4 , 4,0 , 2931,5 , 2525,4 ,     2,     1,     7,     7,     7 }, // Marathi/Devanagari/India
    {     82,     2,   143,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 889,29 , 37,5 , 8,10 , 12984,99 , 13083,189 , 158,27 , 12984,99 , 13083,189 , 158,27 , 7001,21 , 7022,43 , 1849,14 , 7001,21 , 7022,43 , 1849,14 , 242,2 , 238,2 , {77,78,84},  280,1 , 9179,25 , 8,5 , 4,0 , 2936,6 , 2942,6 ,     0,     0,     1,     6,     7 }, // Mongolian/Cyrillic/Mongolia
    {     82,     8,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,78,89},  281,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Mongolian/Mongolian/China
    {     84,    13,   150,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 496,7 , 0,6 , 496,7 , 496,7 , 53,10 , 63,17 , 37,5 , 8,10 , 13272,85 , 13272,85 , 13357,27 , 13272,85 , 13384,85 , 13357,27 , 7065,33 , 7098,54 , 7152,18 , 7065,33 , 7098,54 , 7152,18 , 137,9 , 136,7 , {78,80,82},  284,4 , 9204,49 , 8,5 , 4,0 , 2948,6 , 2954,5 ,     2,     1,     7,     6,     7 }, // Nepali/Devanagari/Nepal
    {     84,    13,   100,    46,    44,    59,    37,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 496,7 , 0,6 , 496,7 , 496,7 , 53,10 , 63,17 , 37,5 , 8,10 , 13272,85 , 13272,85 , 13357,27 , 13272,85 , 13384,85 , 13357,27 , 7065,33 , 7098,54 , 7152,18 , 7065,33 , 7098,54 , 7152,18 , 137,9 , 136,7 , {73,78,82},  127,1 , 9253,49 , 8,5 , 4,0 , 2948,6 , 2525,4 ,     2,     1,     7,     7,     7 }, // Nepali/Devanagari/India
    {     85,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 196,8 , 196,8 , 918,10 , 472,17 , 146,5 , 151,10 , 5518,48 , 13469,83 , 134,24 , 13552,59 , 13469,83 , 134,24 , 7170,28 , 2282,51 , 2333,14 , 2347,35 , 2282,51 , 2333,14 , 100,4 , 98,4 , {78,79,75},  214,2 , 9302,44 , 8,5 , 4,0 , 2959,12 , 2971,5 ,     2,     1,     1,     6,     7 }, // NorwegianBokmal/Latin/Norway
    {     85,     7,   203,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 196,8 , 196,8 , 918,10 , 472,17 , 146,5 , 151,10 , 5518,48 , 13469,83 , 134,24 , 13552,59 , 13469,83 , 134,24 , 7170,28 , 2282,51 , 2333,14 , 2347,35 , 2282,51 , 2333,14 , 100,4 , 98,4 , {78,79,75},  214,2 , 9302,44 , 8,5 , 4,0 , 2959,12 , 2976,21 ,     2,     1,     1,     6,     7 }, // NorwegianBokmal/Latin/SvalbardAndJanMayenIslands
    {     86,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Occitan/Latin/France
    {     87,    26,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 928,6 , 10,17 , 18,7 , 25,12 , 13611,86 , 13611,86 , 13697,32 , 13611,86 , 13611,86 , 13697,32 , 7198,33 , 7231,54 , 7285,18 , 7198,33 , 7231,54 , 7285,18 , 244,2 , 240,2 , {73,78,82},  127,1 , 9346,11 , 8,5 , 4,0 , 2997,5 , 3002,4 ,     2,     1,     7,     7,     7 }, // Oriya/Oriya/India
    {     88,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 420,8 , 934,20 , 42,4 , 349,11 , 13729,68 , 13729,68 , 158,27 , 13729,68 , 13729,68 , 158,27 , 7303,49 , 7303,49 , 85,14 , 7303,49 , 7303,49 , 85,14 , 246,4 , 242,4 , {65,70,78},  288,1 , 9357,13 , 13,5 , 4,0 , 3006,4 , 3010,9 ,     0,     0,     6,     4,     5 }, // Pashto/Arabic/Afghanistan
    {     89,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 503,7 , 503,7 , 52,8 , 66,7 , 420,8 , 98,16 , 42,4 , 349,11 , 13797,70 , 13797,70 , 13867,24 , 13891,74 , 13891,74 , 13867,24 , 7303,49 , 7303,49 , 7352,14 , 7303,49 , 7303,49 , 7352,14 , 250,9 , 246,8 , {73,82,82},  289,4 , 9370,37 , 40,5 , 4,0 , 3019,5 , 3024,5 ,     0,     0,     6,     5,     5 }, // Persian/Arabic/Iran
    {     89,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 503,7 , 503,7 , 52,8 , 66,7 , 420,8 , 98,16 , 42,4 , 349,11 , 13797,70 , 13797,70 , 13965,24 , 13989,64 , 14053,68 , 13867,24 , 7303,49 , 7303,49 , 7352,14 , 7303,49 , 7303,49 , 7352,14 , 250,9 , 246,8 , {65,70,78},  288,1 , 9407,55 , 40,5 , 4,0 , 3019,5 , 3010,9 ,     0,     0,     6,     4,     5 }, // Persian/Arabic/Afghanistan
    {     90,     7,   172,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 172,7 , 172,7 , 918,10 , 10,17 , 37,5 , 8,10 , 14121,48 , 14169,97 , 14266,24 , 14121,48 , 14290,99 , 14266,24 , 7366,34 , 7400,59 , 7459,14 , 7366,34 , 7400,59 , 7459,14 , 0,2 , 0,2 , {80,76,78},  293,2 , 9462,77 , 13,5 , 4,0 , 3029,6 , 3035,6 ,     2,     1,     1,     6,     7 }, // Polish/Latin/Poland
    {     91,     7,    30,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 0,2 , 0,2 , {66,82,76},  295,2 , 9539,54 , 4,4 , 4,0 , 3041,19 , 3060,6 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Brazil
    {     91,     7,     6,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {65,79,65},  272,2 , 9593,54 , 13,5 , 4,0 , 3066,9 , 3075,6 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Angola
    {     91,     7,    39,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {67,86,69},  297,1 , 9647,69 , 13,5 , 4,0 , 3066,9 , 3081,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/CapeVerde
    {     91,     7,    62,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {85,83,68},  176,3 , 9716,81 , 13,5 , 4,0 , 3066,9 , 3091,11 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/EastTimor
    {     91,     7,    92,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {88,79,70},  218,3 , 9797,62 , 13,5 , 4,0 , 3066,9 , 3102,12 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/GuineaBissau
    {     91,     7,   126,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {77,79,80},  151,4 , 9859,53 , 13,5 , 4,0 , 3066,9 , 3114,19 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Macau
    {     91,     7,   146,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {77,90,78},  298,3 , 9912,72 , 13,5 , 4,0 , 3066,9 , 3133,10 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Mozambique
    {     91,     7,   173,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {69,85,82},  14,1 , 9984,20 , 13,5 , 4,0 , 3143,17 , 3160,8 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Portugal
    {     91,     7,   185,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 954,27 , 37,5 , 8,10 , 14389,48 , 14437,89 , 134,24 , 14389,48 , 14437,89 , 134,24 , 7473,28 , 7501,79 , 7580,14 , 7473,28 , 7501,79 , 7580,14 , 259,8 , 254,8 , {83,84,68},  301,2 , 10004,92 , 13,5 , 4,0 , 3066,9 , 3168,19 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/SaoTomeAndPrincipe
    {     92,     4,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 510,9 , 510,9 , 283,6 , 10,17 , 18,7 , 25,12 , 14526,50 , 14576,68 , 14644,28 , 14526,50 , 14576,68 , 14644,28 , 7594,36 , 7630,57 , 7687,23 , 7594,36 , 7630,57 , 7687,23 , 267,6 , 262,6 , {73,78,82},  127,1 , 10096,39 , 4,4 , 4,0 , 3187,6 , 3193,4 ,     2,     1,     7,     7,     7 }, // Punjabi/Gurmukhi/India
    {     92,     1,   163,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 80,18 , 18,7 , 25,12 , 14672,67 , 14672,67 , 158,27 , 14672,67 , 14672,67 , 158,27 , 7710,37 , 7710,37 , 85,14 , 7710,37 , 7710,37 , 85,14 , 0,2 , 0,2 , {80,75,82},  303,1 , 10135,13 , 8,5 , 4,0 , 3197,6 , 3203,6 ,     0,     0,     7,     6,     7 }, // Punjabi/Arabic/Pakistan
    {     93,     7,   169,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 193,18 , 274,8 , 8,10 , 14739,48 , 14787,128 , 158,27 , 14739,48 , 14787,128 , 158,27 , 7747,28 , 7775,53 , 7828,14 , 7747,28 , 7775,53 , 7828,14 , 100,4 , 98,4 , {80,69,78},  304,3 , 0,7 , 8,5 , 4,0 , 3209,8 , 3217,4 ,     2,     1,     7,     6,     7 }, // Quechua/Latin/Peru
    {     93,     7,    26,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 193,18 , 274,8 , 8,10 , 14739,48 , 14787,128 , 158,27 , 14739,48 , 14787,128 , 158,27 , 7747,28 , 7775,53 , 7828,14 , 7747,28 , 7775,53 , 7828,14 , 100,4 , 98,4 , {66,79,66},  307,2 , 0,7 , 8,5 , 4,0 , 3209,8 , 3221,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Bolivia
    {     93,     7,    63,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 193,18 , 274,8 , 8,10 , 14739,48 , 14787,128 , 158,27 , 14739,48 , 14787,128 , 158,27 , 7747,28 , 7775,53 , 7828,14 , 7747,28 , 7775,53 , 7828,14 , 100,4 , 98,4 , {85,83,68},  6,1 , 0,7 , 8,5 , 4,0 , 3209,8 , 3228,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Ecuador
    {     94,     7,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 353,8 , 981,28 , 37,5 , 8,10 , 14915,67 , 14982,92 , 15074,24 , 14915,67 , 14982,92 , 15074,24 , 7842,23 , 7865,56 , 7921,14 , 7842,23 , 7865,56 , 7921,14 , 244,2 , 268,2 , {67,72,70},  240,3 , 10148,46 , 13,5 , 4,0 , 3235,9 , 3244,6 ,     2,     0,     1,     6,     7 }, // Romansh/Latin/Switzerland
    {     95,     7,   177,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 519,8 , 519,8 , 918,10 , 10,17 , 37,5 , 8,10 , 15098,60 , 15158,98 , 15256,24 , 15098,60 , 15280,98 , 15256,24 , 7935,28 , 7963,48 , 3019,14 , 7935,28 , 8011,48 , 3019,14 , 100,4 , 98,4 , {82,79,78},  309,3 , 10194,57 , 13,5 , 4,0 , 3250,6 , 3256,7 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Romania
    {     95,     7,   141,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 519,8 , 519,8 , 918,10 , 10,17 , 37,5 , 8,10 , 15098,60 , 15158,98 , 15256,24 , 15098,60 , 15280,98 , 15256,24 , 7935,28 , 7963,48 , 3019,14 , 7935,28 , 8011,48 , 3019,14 , 100,4 , 98,4 , {77,68,76},  312,1 , 10251,69 , 13,5 , 4,0 , 3263,13 , 3276,17 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Moldova
    {     96,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 158,8 , 331,22 , 42,4 , 137,9 , 15378,62 , 10618,80 , 10535,24 , 15440,63 , 15503,82 , 10535,24 , 8059,21 , 8080,62 , 8142,14 , 8156,21 , 8177,62 , 8156,21 , 0,2 , 0,2 , {82,85,66},  313,4 , 10320,89 , 13,5 , 4,0 , 3293,7 , 3300,6 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Russia
    {     96,     2,    20,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 158,8 , 331,22 , 42,4 , 137,9 , 15378,62 , 10618,80 , 10535,24 , 15440,63 , 15503,82 , 10535,24 , 8059,21 , 8080,62 , 8142,14 , 8156,21 , 8177,62 , 8156,21 , 0,2 , 0,2 , {66,89,82},  144,2 , 10409,94 , 13,5 , 4,0 , 3293,7 , 465,8 ,     0,     0,     1,     6,     7 }, // Russian/Cyrillic/Belarus
    {     96,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 158,8 , 331,22 , 42,4 , 137,9 , 15378,62 , 10618,80 , 10535,24 , 15440,63 , 15503,82 , 10535,24 , 8059,21 , 8080,62 , 8142,14 , 8156,21 , 8177,62 , 8156,21 , 0,2 , 0,2 , {75,90,84},  262,1 , 10503,83 , 13,5 , 4,0 , 3293,7 , 3306,9 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kazakhstan
    {     96,     2,   116,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 158,8 , 331,22 , 42,4 , 137,9 , 15378,62 , 10618,80 , 10535,24 , 15440,63 , 15503,82 , 10535,24 , 8059,21 , 8080,62 , 8142,14 , 8156,21 , 8177,62 , 8156,21 , 0,2 , 0,2 , {75,71,83},  263,3 , 10586,81 , 13,5 , 4,0 , 3293,7 , 3315,8 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kyrgyzstan
    {     96,     2,   141,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 158,8 , 331,22 , 42,4 , 137,9 , 15378,62 , 10618,80 , 10535,24 , 15440,63 , 15503,82 , 10535,24 , 8059,21 , 8080,62 , 8142,14 , 8156,21 , 8177,62 , 8156,21 , 0,2 , 0,2 , {77,68,76},  312,1 , 10667,79 , 13,5 , 4,0 , 3293,7 , 3323,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Moldova
    {     96,     2,   222,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 125,7 , 125,7 , 158,8 , 331,22 , 37,5 , 8,10 , 15378,62 , 10618,80 , 10535,24 , 15440,63 , 15503,82 , 10535,24 , 8059,21 , 8080,62 , 8142,14 , 8156,21 , 8177,62 , 8156,21 , 0,2 , 0,2 , {85,65,72},  317,1 , 10746,92 , 13,5 , 4,0 , 3293,7 , 3330,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Ukraine
    {     98,     7,    41,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 15585,48 , 15633,91 , 15724,24 , 15585,48 , 15633,91 , 15724,24 , 8239,28 , 8267,66 , 8333,14 , 8239,28 , 8267,66 , 8333,14 , 273,2 , 270,2 , {88,65,70},  32,4 , 10838,25 , 4,4 , 29,5 , 3337,5 , 3342,22 ,     0,     0,     1,     6,     7 }, // Sango/Latin/CentralAfricanRepublic
    {     99,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,78,82},  127,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     7,     7 }, // Sanskrit/Devanagari/India
    {    100,     2,   243,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 125,7 , 125,7 , 1009,7 , 1016,20 , 146,5 , 151,10 , 15748,48 , 15796,81 , 12080,24 , 15748,48 , 15796,81 , 12080,24 , 8347,28 , 8375,52 , 8427,14 , 8347,28 , 8375,52 , 8427,14 , 275,9 , 272,8 , {82,83,68},  318,3 , 10863,58 , 13,5 , 4,0 , 3364,6 , 3370,6 ,     0,     0,     1,     6,     7 }, // Serbian/Cyrillic/Serbia
    {    100,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 172,7 , 172,7 , 1009,7 , 1016,20 , 37,5 , 8,10 , 15877,48 , 15925,81 , 16006,24 , 15877,48 , 15925,81 , 16006,24 , 8441,28 , 8469,54 , 2142,14 , 8441,28 , 8469,54 , 2142,14 , 284,9 , 280,8 , {66,65,77},  161,2 , 10921,174 , 13,5 , 4,0 , 3376,6 , 594,19 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/BosniaAndHerzegowina
    {    100,     7,   242,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 172,7 , 172,7 , 1009,7 , 1016,20 , 146,5 , 151,10 , 15877,48 , 15925,81 , 16006,24 , 15877,48 , 15925,81 , 16006,24 , 8441,28 , 8469,54 , 2142,14 , 8441,28 , 8469,54 , 2142,14 , 284,9 , 280,8 , {69,85,82},  14,1 , 11095,23 , 13,5 , 4,0 , 3376,6 , 3382,9 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Montenegro
    {    100,     7,   243,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 172,7 , 172,7 , 1009,7 , 1016,20 , 146,5 , 151,10 , 15877,48 , 15925,81 , 16006,24 , 15877,48 , 15925,81 , 16006,24 , 8441,28 , 8469,54 , 2142,14 , 8441,28 , 8469,54 , 2142,14 , 284,9 , 280,8 , {82,83,68},  318,3 , 11118,58 , 13,5 , 4,0 , 3376,6 , 3391,6 ,     0,     0,     1,     6,     7 }, // Serbian/Latin/Serbia
    {    100,     2,    27,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 125,7 , 125,7 , 1009,7 , 1016,20 , 37,5 , 8,10 , 15748,48 , 15796,81 , 12080,24 , 15748,48 , 15796,81 , 12080,24 , 8347,28 , 8375,52 , 8427,14 , 8347,28 , 8375,52 , 8427,14 , 275,9 , 272,8 , {66,65,77},  321,2 , 11176,174 , 13,5 , 4,0 , 3364,6 , 3397,19 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/BosniaAndHerzegowina
    {    100,     2,   242,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 125,7 , 125,7 , 1009,7 , 1016,20 , 146,5 , 151,10 , 15748,48 , 15796,81 , 12080,24 , 15748,48 , 15796,81 , 12080,24 , 8347,28 , 8375,52 , 8427,14 , 8347,28 , 8375,52 , 8427,14 , 275,9 , 272,8 , {69,85,82},  14,1 , 11350,23 , 13,5 , 4,0 , 3364,6 , 3416,9 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Montenegro
    {    100,     2,   257,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 125,7 , 125,7 , 1009,7 , 1016,20 , 146,5 , 151,10 , 15748,48 , 15796,81 , 12080,24 , 15748,48 , 15796,81 , 12080,24 , 8347,28 , 8375,52 , 8427,14 , 8347,28 , 8375,52 , 8427,14 , 275,9 , 272,8 , {69,85,82},  14,1 , 11350,23 , 13,5 , 4,0 , 3364,6 , 3425,6 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Kosovo
    {    100,     7,   257,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8216, 0,6 , 0,6 , 172,7 , 172,7 , 1009,7 , 1016,20 , 146,5 , 151,10 , 15877,48 , 15925,81 , 16006,24 , 15877,48 , 15925,81 , 16006,24 , 8441,28 , 8469,54 , 2142,14 , 8441,28 , 8469,54 , 2142,14 , 284,9 , 280,8 , {69,85,82},  14,1 , 11095,23 , 13,5 , 4,0 , 3376,6 , 3431,6 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Kosovo
    {    101,     2,    81,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 527,9 , 527,9 , 158,8 , 1036,23 , 37,5 , 8,10 , 16030,62 , 16092,82 , 10535,24 , 16174,59 , 16233,86 , 10535,24 , 8523,28 , 8551,61 , 8612,14 , 8626,28 , 8654,61 , 8612,14 , 293,15 , 288,15 , {71,69,76},  0,0 , 11373,17 , 8,5 , 4,0 , 3437,4 , 3441,11 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Georgia
    {    101,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 527,9 , 527,9 , 158,8 , 1036,23 , 37,5 , 8,10 , 16030,62 , 16092,82 , 10535,24 , 16174,59 , 16233,86 , 10535,24 , 8523,28 , 8551,61 , 8612,14 , 8626,28 , 8654,61 , 8612,14 , 293,15 , 288,15 , {82,85,66},  313,4 , 11390,17 , 8,5 , 4,0 , 3437,4 , 3452,6 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Russia
    {    102,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Southern Sotho/Latin/SouthAfrica
    {    103,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Tswana/Latin/SouthAfrica
    {    104,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 16319,47 , 16366,100 , 16466,24 , 16319,47 , 16366,100 , 16466,24 , 8715,32 , 8747,55 , 8802,14 , 8715,32 , 8747,55 , 8802,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 11407,22 , 4,4 , 4,0 , 3458,8 , 1698,8 ,     2,     1,     7,     6,     7 }, // Shona/Latin/Zimbabwe
    {    105,     1,   163,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {80,75,82},  190,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     7,     6,     7 }, // Sindhi/Arabic/Pakistan
    {    106,    32,   198,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 536,9 , 545,8 , 53,10 , 63,17 , 360,7 , 367,12 , 16490,59 , 16549,96 , 16645,32 , 16677,61 , 16549,96 , 16645,32 , 8816,39 , 8855,62 , 8917,19 , 8816,39 , 8855,62 , 8917,19 , 308,5 , 303,4 , {76,75,82},  323,3 , 11429,58 , 4,4 , 4,0 , 3466,5 , 3471,11 ,     2,     1,     1,     6,     7 }, // Sinhala/Sinhala/SriLanka
    {    107,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Swati/Latin/SouthAfrica
    {    108,     7,   191,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 189,7 , 189,7 , 158,8 , 542,18 , 42,4 , 137,9 , 16738,48 , 16786,82 , 16006,24 , 16738,48 , 16868,89 , 16006,24 , 8936,21 , 8957,52 , 9009,14 , 8936,21 , 8957,52 , 9009,14 , 313,10 , 307,10 , {69,85,82},  14,1 , 11487,26 , 13,5 , 4,0 , 3482,10 , 3492,9 ,     2,     1,     1,     6,     7 }, // Slovak/Latin/Slovakia
    {    109,     7,   192,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 553,8 , 553,8 , 1059,9 , 1068,19 , 37,5 , 8,10 , 15877,48 , 16957,86 , 16006,24 , 17043,59 , 16957,86 , 16006,24 , 9023,28 , 9051,52 , 9103,14 , 9117,35 , 9051,52 , 9103,14 , 323,4 , 317,4 , {69,85,82},  14,1 , 11513,28 , 13,5 , 4,0 , 3501,11 , 3512,9 ,     2,     1,     1,     6,     7 }, // Slovenian/Latin/Slovenia
    {    110,     7,   194,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1087,19 , 18,7 , 25,12 , 17102,48 , 17150,189 , 17339,24 , 17102,48 , 17150,189 , 17339,24 , 9152,28 , 9180,47 , 9227,14 , 9152,28 , 9180,47 , 9227,14 , 327,3 , 321,3 , {83,79,83},  100,1 , 11541,22 , 4,4 , 4,0 , 3521,8 , 3529,10 ,     0,     0,     1,     6,     7 }, // Somali/Latin/Somalia
    {    110,     7,    59,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1087,19 , 18,7 , 25,12 , 17102,48 , 17150,189 , 17339,24 , 17102,48 , 17150,189 , 17339,24 , 9152,28 , 9180,47 , 9227,14 , 9152,28 , 9180,47 , 9227,14 , 327,3 , 321,3 , {68,74,70},  43,3 , 11563,21 , 4,4 , 4,0 , 3521,8 , 3539,7 ,     0,     0,     6,     6,     7 }, // Somali/Latin/Djibouti
    {    110,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1087,19 , 18,7 , 25,12 , 17102,48 , 17150,189 , 17339,24 , 17102,48 , 17150,189 , 17339,24 , 9152,28 , 9180,47 , 9227,14 , 9152,28 , 9180,47 , 9227,14 , 327,3 , 321,3 , {69,84,66},  0,2 , 11584,22 , 4,4 , 4,0 , 3521,8 , 3546,8 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Ethiopia
    {    110,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1087,19 , 18,7 , 25,12 , 17102,48 , 17150,189 , 17339,24 , 17102,48 , 17150,189 , 17339,24 , 9152,28 , 9180,47 , 9227,14 , 9152,28 , 9180,47 , 9227,14 , 327,3 , 321,3 , {75,69,83},  2,3 , 0,7 , 4,4 , 4,0 , 3521,8 , 3554,7 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Kenya
    {    111,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 42,4 , 349,11 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 7828,14 , 9276,35 , 9311,53 , 7828,14 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 3561,17 , 2297,6 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Spain
    {    111,     7,    10,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {65,82,83},  6,1 , 11606,51 , 4,4 , 4,0 , 3578,7 , 3585,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Argentina
    {    111,     7,    26,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {66,79,66},  307,2 , 11657,35 , 4,4 , 4,0 , 3578,7 , 3221,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Bolivia
    {    111,     7,    43,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 353,8 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {67,76,80},  6,1 , 11692,45 , 4,4 , 29,5 , 3578,7 , 3594,5 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/Chile
    {    111,     7,    47,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 512,7 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {67,79,80},  6,1 , 11737,54 , 4,4 , 4,0 , 3578,7 , 3599,8 ,     0,     0,     7,     6,     7 }, // Spanish/Latin/Colombia
    {    111,     7,    52,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {67,82,67},  326,1 , 11791,67 , 4,4 , 4,0 , 3578,7 , 3607,10 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/CostaRica
    {    111,     7,    55,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {67,85,80},  6,1 , 11858,42 , 4,4 , 4,0 , 3578,7 , 3617,4 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Cuba
    {    111,     7,    61,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {68,79,80},  6,1 , 11900,54 , 4,4 , 4,0 , 3578,7 , 3621,20 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/DominicanRepublic
    {    111,     7,    63,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {85,83,68},  6,1 , 11954,70 , 4,4 , 29,5 , 3578,7 , 3228,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Ecuador
    {    111,     7,    65,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {85,83,68},  6,1 , 11954,70 , 4,4 , 4,0 , 3578,7 , 3641,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/ElSalvador
    {    111,     7,    66,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 42,4 , 349,11 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 7828,14 , 9276,35 , 9311,53 , 7828,14 , 84,5 , 82,5 , {88,65,70},  32,4 , 12024,53 , 4,4 , 4,0 , 3578,7 , 3652,17 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/EquatorialGuinea
    {    111,     7,    90,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 512,7 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {71,84,81},  327,1 , 12077,70 , 4,4 , 4,0 , 3578,7 , 3669,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Guatemala
    {    111,     7,    96,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 1106,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {72,78,76},  312,1 , 12147,60 , 4,4 , 4,0 , 3578,7 , 3678,8 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Honduras
    {    111,     7,   139,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 27,8 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17687,48 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 3019,14 , 100,4 , 98,4 , {77,88,78},  6,1 , 12207,48 , 4,4 , 4,0 , 3686,17 , 3703,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Mexico
    {    111,     7,   155,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {78,73,79},  328,2 , 12255,69 , 4,4 , 4,0 , 3578,7 , 3709,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Nicaragua
    {    111,     7,   166,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 1133,8 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {80,65,66},  330,3 , 12324,54 , 4,4 , 4,0 , 3578,7 , 3718,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Panama
    {    111,     7,   168,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {80,89,71},  250,1 , 12378,61 , 8,5 , 18,6 , 3578,7 , 3724,8 ,     0,     0,     7,     6,     7 }, // Spanish/Latin/Paraguay
    {    111,     7,   169,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 512,7 , 954,27 , 18,7 , 25,12 , 17735,60 , 17795,88 , 17513,24 , 17883,60 , 17943,88 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {80,69,78},  304,3 , 12439,62 , 4,4 , 4,0 , 3578,7 , 3217,4 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Peru
    {    111,     7,   170,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 42,4 , 349,11 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 7828,14 , 9276,35 , 9311,53 , 7828,14 , 84,5 , 82,5 , {80,72,80},  193,1 , 12501,48 , 13,5 , 4,0 , 3578,7 , 3732,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Philippines
    {    111,     7,   174,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 1133,8 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {85,83,68},  6,1 , 11954,70 , 4,4 , 4,0 , 3578,7 , 1369,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/PuertoRico
    {    111,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 11954,70 , 4,4 , 4,0 , 3578,7 , 3741,14 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/UnitedStates
    {    111,     7,   227,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17735,60 , 17795,88 , 17513,24 , 17883,60 , 17943,88 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {85,89,85},  6,1 , 12549,48 , 8,5 , 4,0 , 3578,7 , 3755,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Uruguay
    {    111,     7,   231,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {86,69,70},  333,3 , 12597,64 , 4,4 , 29,5 , 3578,7 , 3762,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Venezuela
    {    111,     7,   238,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 42,4 , 349,11 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 7828,14 , 9276,35 , 9311,53 , 7828,14 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 3578,7 , 3771,14 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/CanaryIslands
    {    111,     7,   246,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 18,7 , 25,12 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 3019,14 , 9276,35 , 9311,53 , 9364,14 , 84,5 , 82,5 , {0,0,0},  0,0 , 12661,0 , 4,4 , 4,0 , 3785,23 , 3808,13 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/LatinAmericaAndTheCaribbean
    {    111,     7,   250,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 954,27 , 42,4 , 349,11 , 17363,61 , 17424,89 , 17513,24 , 17537,61 , 17598,89 , 17513,24 , 9241,35 , 7775,53 , 7828,14 , 9276,35 , 9311,53 , 7828,14 , 84,5 , 82,5 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 3578,7 , 3821,15 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/CeutaAndMelilla
    {    113,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 568,9 , 577,8 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 18079,84 , 134,24 , 18031,48 , 18079,84 , 134,24 , 9378,60 , 9378,60 , 85,14 , 9378,60 , 9378,60 , 85,14 , 0,2 , 0,2 , {84,90,83},  204,3 , 12661,67 , 4,4 , 4,0 , 3836,9 , 1523,8 ,     0,     0,     1,     6,     7 }, // Swahili/Latin/Tanzania
    {    113,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 568,9 , 577,8 , 534,8 , 98,16 , 37,5 , 8,10 , 18031,48 , 18079,84 , 18163,24 , 18187,48 , 18235,188 , 134,24 , 9378,60 , 9378,60 , 9438,14 , 9452,28 , 9480,93 , 85,14 , 330,10 , 324,10 , {67,68,70},  226,2 , 12728,55 , 4,4 , 4,0 , 3836,9 , 3845,32 ,     2,     1,     1,     6,     7 }, // Swahili/Latin/CongoKinshasa
    {    113,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 568,9 , 577,8 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 18079,84 , 134,24 , 18031,48 , 18079,84 , 134,24 , 9378,60 , 9378,60 , 85,14 , 9378,60 , 9378,60 , 85,14 , 0,2 , 0,2 , {75,69,83},  2,3 , 12783,58 , 4,4 , 4,0 , 3836,9 , 1125,5 ,     2,     1,     7,     6,     7 }, // Swahili/Latin/Kenya
    {    113,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 568,9 , 577,8 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 18079,84 , 134,24 , 18031,48 , 18079,84 , 134,24 , 9378,60 , 9378,60 , 85,14 , 9378,60 , 9378,60 , 85,14 , 0,2 , 0,2 , {85,71,88},  209,3 , 12841,61 , 4,4 , 4,0 , 3836,9 , 1588,6 ,     0,     0,     1,     6,     7 }, // Swahili/Latin/Uganda
    {    114,     7,   205,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 585,9 , 585,9 , 53,10 , 98,16 , 37,5 , 379,16 , 18423,59 , 18482,86 , 134,24 , 18568,59 , 18627,86 , 134,24 , 9573,28 , 9601,50 , 2333,14 , 9651,29 , 9680,50 , 2333,14 , 340,2 , 334,2 , {83,69,75},  214,2 , 12902,45 , 13,5 , 4,0 , 3877,7 , 3884,7 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Sweden
    {    114,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 585,9 , 585,9 , 1141,10 , 98,16 , 37,5 , 379,16 , 18423,59 , 18482,86 , 134,24 , 18568,59 , 18627,86 , 134,24 , 9573,28 , 9601,50 , 2333,14 , 9651,29 , 9680,50 , 2333,14 , 340,2 , 334,2 , {69,85,82},  14,1 , 8404,19 , 13,5 , 4,0 , 3877,7 , 3891,7 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Finland
    {    114,     7,   248,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 585,9 , 585,9 , 53,10 , 98,16 , 37,5 , 379,16 , 18423,59 , 18482,86 , 134,24 , 18568,59 , 18627,86 , 134,24 , 9573,28 , 9601,50 , 2333,14 , 9651,29 , 9680,50 , 2333,14 , 340,2 , 334,2 , {69,85,82},  14,1 , 8404,19 , 13,5 , 4,0 , 3877,7 , 3898,5 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/AlandIslands
    {    116,     2,   209,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {84,74,83},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Tajik/Cyrillic/Tajikistan
    {    117,    27,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 594,13 , 594,13 , 928,6 , 193,18 , 18,7 , 25,12 , 18713,58 , 18771,86 , 18857,31 , 18713,58 , 18888,86 , 18857,31 , 9730,20 , 9750,49 , 9730,20 , 9730,20 , 9750,49 , 9730,20 , 342,8 , 336,8 , {73,78,82},  127,1 , 12947,49 , 8,5 , 4,0 , 3903,5 , 3908,7 ,     2,     1,     7,     7,     7 }, // Tamil/Tamil/India
    {    117,    27,   130,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 594,13 , 594,13 , 928,6 , 193,18 , 18,7 , 25,12 , 18713,58 , 18771,86 , 18857,31 , 18713,58 , 18888,86 , 18857,31 , 9730,20 , 9750,49 , 9730,20 , 9730,20 , 9750,49 , 9730,20 , 342,8 , 336,8 , {77,89,82},  188,2 , 12996,61 , 8,5 , 4,0 , 3903,5 , 3915,7 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/Malaysia
    {    117,    27,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 594,13 , 594,13 , 928,6 , 193,18 , 18,7 , 25,12 , 18713,58 , 18771,86 , 18857,31 , 18713,58 , 18888,86 , 18857,31 , 9730,20 , 9750,49 , 9730,20 , 9730,20 , 9750,49 , 9730,20 , 342,8 , 336,8 , {83,71,68},  6,1 , 13057,61 , 8,5 , 4,0 , 3903,5 , 3922,11 ,     2,     1,     7,     6,     7 }, // Tamil/Tamil/Singapore
    {    117,    27,   198,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 594,13 , 594,13 , 928,6 , 193,18 , 18,7 , 25,12 , 18713,58 , 18771,86 , 18857,31 , 18713,58 , 18888,86 , 18857,31 , 9730,20 , 9750,49 , 9730,20 , 9730,20 , 9750,49 , 9730,20 , 342,8 , 336,8 , {76,75,82},  336,3 , 13118,49 , 8,5 , 4,0 , 3903,5 , 3933,6 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/SriLanka
    {    118,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 918,10 , 1151,22 , 42,4 , 137,9 , 18974,62 , 19036,81 , 158,27 , 18974,62 , 19036,81 , 158,27 , 9799,36 , 9835,56 , 9891,14 , 9799,36 , 9835,56 , 9891,14 , 0,2 , 0,2 , {82,85,66},  135,1 , 0,7 , 0,4 , 4,0 , 3939,5 , 3300,6 ,     2,     1,     1,     6,     7 }, // Tatar/Cyrillic/Russia
    {    119,    28,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 607,11 , 607,11 , 353,8 , 1173,18 , 18,7 , 25,12 , 19117,66 , 19183,86 , 19269,31 , 19300,62 , 19183,86 , 19269,31 , 9905,32 , 9937,60 , 9997,18 , 9905,32 , 9937,60 , 9997,18 , 350,4 , 344,4 , {73,78,82},  127,1 , 13167,26 , 4,4 , 4,0 , 3944,6 , 3950,9 ,     2,     1,     7,     7,     7 }, // Telugu/Telugu/India
    {    120,    30,   211,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 158,5 , 158,5 , 618,8 , 626,7 , 283,6 , 1191,19 , 37,5 , 395,28 , 19362,63 , 19425,98 , 19362,63 , 19362,63 , 19425,98 , 19362,63 , 10015,23 , 10038,68 , 10106,16 , 10015,23 , 10038,68 , 10106,16 , 354,10 , 348,10 , {84,72,66},  339,3 , 13193,19 , 4,4 , 4,0 , 3959,3 , 3959,3 ,     2,     1,     7,     6,     7 }, // Thai/Thai/Thailand
    {    121,    31,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 2652,63 , 19523,158 , 158,27 , 2652,63 , 19523,158 , 158,27 , 10122,51 , 10173,79 , 10252,21 , 10122,51 , 10173,79 , 10252,21 , 364,7 , 358,8 , {67,78,89},  342,1 , 13212,13 , 8,5 , 4,0 , 3962,8 , 3970,6 ,     2,     1,     7,     6,     7 }, // Tibetan/Tibetan/China
    {    121,    31,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 2652,63 , 19523,158 , 158,27 , 2652,63 , 19523,158 , 158,27 , 10122,51 , 10173,79 , 10252,21 , 10122,51 , 10173,79 , 10252,21 , 364,7 , 358,8 , {73,78,82},  127,1 , 13225,22 , 8,5 , 4,0 , 3962,8 , 3976,7 ,     2,     1,     7,     7,     7 }, // Tibetan/Tibetan/India
    {    122,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1210,23 , 18,7 , 25,12 , 19681,46 , 19727,62 , 870,24 , 19681,46 , 19727,62 , 870,24 , 10273,29 , 10273,29 , 10302,14 , 10273,29 , 10273,29 , 10302,14 , 371,7 , 366,7 , {69,84,66},  0,2 , 13247,16 , 4,4 , 4,0 , 3983,4 , 82,5 ,     2,     1,     7,     6,     7 }, // Tigrinya/Ethiopic/Ethiopia
    {    122,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1233,23 , 18,7 , 25,12 , 19789,46 , 19835,54 , 870,24 , 19789,46 , 19835,54 , 870,24 , 10316,29 , 10316,29 , 10302,14 , 10316,29 , 10316,29 , 10302,14 , 371,7 , 366,7 , {69,82,78},  46,3 , 0,7 , 4,4 , 4,0 , 3983,4 , 3987,4 ,     2,     1,     1,     6,     7 }, // Tigrinya/Ethiopic/Eritrea
    {    123,     7,   214,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 633,8 , 633,8 , 633,8 , 633,8 , 283,6 , 98,16 , 18,7 , 25,12 , 19889,51 , 19940,87 , 20027,24 , 19889,51 , 19940,87 , 20027,24 , 10345,29 , 10374,60 , 10434,14 , 10345,29 , 10374,60 , 10434,14 , 0,2 , 0,2 , {84,79,80},  207,2 , 13263,41 , 8,5 , 4,0 , 3991,13 , 1538,5 ,     2,     1,     1,     6,     7 }, // Tongan/Latin/Tonga
    {    124,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Tsonga/Latin/SouthAfrica
    {    125,     7,   217,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 641,8 , 641,8 , 1256,9 , 1265,16 , 37,5 , 8,10 , 20051,48 , 20099,75 , 20174,24 , 20051,48 , 20099,75 , 20174,24 , 10448,28 , 10476,54 , 10530,14 , 10448,28 , 10476,54 , 10530,14 , 378,2 , 373,2 , {84,82,89},  270,1 , 13304,40 , 13,5 , 4,0 , 4004,6 , 4010,7 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Turkey
    {    125,     7,    56,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 641,8 , 641,8 , 1256,9 , 1265,16 , 37,5 , 8,10 , 20051,48 , 20099,75 , 20174,24 , 20051,48 , 20099,75 , 20174,24 , 10448,28 , 10476,54 , 10530,14 , 10448,28 , 10476,54 , 10530,14 , 378,2 , 373,2 , {69,85,82},  14,1 , 7891,19 , 13,5 , 4,0 , 4004,6 , 4017,23 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Cyprus
    {    126,     7,   218,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {84,77,84},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Turkmen/Latin/Turkmenistan
    {    128,     1,    44,    46,    44,    59,    37,    48,    45,    43,   101,   187,   171,  8250,  8249, 0,6 , 0,6 , 204,10 , 214,9 , 519,6 , 1281,18 , 18,7 , 25,12 , 20198,84 , 20282,84 , 158,27 , 20198,84 , 20282,84 , 158,27 , 10544,21 , 10565,55 , 10620,14 , 10544,21 , 10565,55 , 10620,14 , 380,12 , 375,12 , {67,78,89},  147,1 , 13344,40 , 4,4 , 4,0 , 4040,8 , 4048,5 ,     2,     1,     7,     6,     7 }, // Uighur/Arabic/China
    {    129,     2,   222,    44,   160,    59,    37,    48,    45,    43,  1077,   171,   187,  8222,  8220, 0,6 , 0,6 , 649,7 , 649,7 , 158,8 , 1299,22 , 37,5 , 8,10 , 20366,48 , 20414,95 , 20509,24 , 20533,67 , 20600,87 , 20509,24 , 10634,21 , 10655,56 , 10711,14 , 10634,21 , 10725,56 , 10711,14 , 392,2 , 387,2 , {85,65,72},  317,1 , 13384,49 , 13,5 , 4,0 , 4053,10 , 4063,7 ,     2,     1,     1,     6,     7 }, // Ukrainian/Cyrillic/Ukraine
    {    130,     1,   163,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 656,10 , 666,9 , 283,6 , 140,18 , 18,7 , 25,12 , 20687,68 , 20687,68 , 134,24 , 20687,68 , 20687,68 , 134,24 , 10781,39 , 10781,39 , 85,14 , 10781,39 , 10781,39 , 85,14 , 394,9 , 389,9 , {80,75,82},  190,2 , 13433,49 , 8,5 , 4,0 , 4070,4 , 4074,7 ,     0,     0,     7,     6,     7 }, // Urdu/Arabic/Pakistan
    {    130,     1,   100,    46,    44,    59,    37,  1776,    45,    43,  1602,  8221,  8220,  8217,  8216, 46,6 , 46,6 , 675,6 , 675,6 , 283,6 , 140,18 , 18,7 , 25,12 , 20687,68 , 20687,68 , 134,24 , 20687,68 , 20687,68 , 134,24 , 10781,39 , 10781,39 , 85,14 , 10781,39 , 10781,39 , 85,14 , 394,9 , 389,9 , {73,78,82},  127,1 , 13482,42 , 8,5 , 4,0 , 4070,4 , 4081,5 ,     2,     1,     7,     7,     7 }, // Urdu/Arabic/India
    {    131,     7,   228,    44,   160,    59,    37,    48,    45,    43,   101,    34,    34,    39,    39, 0,6 , 0,6 , 681,8 , 681,8 , 683,8 , 691,18 , 37,5 , 8,10 , 20755,52 , 20807,75 , 20882,24 , 20755,52 , 20807,75 , 20882,24 , 10820,34 , 10854,61 , 10915,14 , 10820,34 , 10854,61 , 10915,14 , 403,2 , 398,2 , {85,90,83},  343,4 , 13524,55 , 8,5 , 4,0 , 4086,9 , 4095,11 ,     0,     0,     1,     6,     7 }, // Uzbek/Latin/Uzbekistan
    {    131,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 420,8 , 1321,33 , 42,4 , 349,11 , 20906,48 , 14053,68 , 158,27 , 20906,48 , 14053,68 , 158,27 , 10929,21 , 7303,49 , 85,14 , 10929,21 , 7303,49 , 85,14 , 0,2 , 0,2 , {65,70,78},  288,1 , 13579,13 , 13,5 , 4,0 , 4106,6 , 3010,9 ,     0,     0,     6,     4,     5 }, // Uzbek/Arabic/Afghanistan
    {    131,     2,   228,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 683,8 , 691,18 , 37,5 , 8,10 , 10407,48 , 20954,71 , 10535,24 , 10407,48 , 20954,71 , 10535,24 , 10950,28 , 10978,53 , 11031,14 , 10950,28 , 10978,53 , 11031,14 , 0,2 , 0,2 , {85,90,83},  347,3 , 13592,49 , 8,5 , 4,0 , 4112,5 , 4117,10 ,     0,     0,     1,     6,     7 }, // Uzbek/Cyrillic/Uzbekistan
    {    132,     7,   232,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 689,8 , 689,8 , 120,10 , 1354,31 , 37,5 , 8,10 , 21025,75 , 21100,99 , 158,27 , 21199,75 , 21274,99 , 158,27 , 11045,33 , 11078,55 , 11133,21 , 11045,33 , 11078,55 , 11133,21 , 405,2 , 400,2 , {86,78,68},  350,1 , 13641,33 , 13,5 , 4,0 , 4127,10 , 4137,8 ,     0,     0,     1,     6,     7 }, // Vietnamese/Latin/Vietnam
    {    134,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 10,17 , 37,5 , 8,10 , 21373,52 , 21425,87 , 21512,26 , 21538,62 , 21425,87 , 21512,26 , 11154,29 , 11183,77 , 11260,15 , 11275,30 , 11183,77 , 11260,15 , 0,2 , 0,2 , {71,66,80},  125,1 , 13674,91 , 4,4 , 4,0 , 4145,7 , 4152,16 ,     2,     1,     1,     6,     7 }, // Welsh/Latin/UnitedKingdom
    {    135,     7,   187,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Wolof/Latin/Senegal
    {    136,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Xhosa/Latin/SouthAfrica
    {    138,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 21600,73 , 21673,121 , 158,27 , 21600,73 , 21673,121 , 158,27 , 11305,44 , 11349,69 , 85,14 , 11305,44 , 11349,69 , 85,14 , 407,5 , 402,5 , {78,71,78},  192,1 , 13765,34 , 4,4 , 4,0 , 4168,10 , 4178,18 ,     2,     1,     1,     6,     7 }, // Yoruba/Latin/Nigeria
    {    138,     7,    23,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 21794,74 , 21868,134 , 158,27 , 21794,74 , 21868,134 , 158,27 , 11418,44 , 11462,69 , 85,14 , 11418,44 , 11462,69 , 85,14 , 412,5 , 407,5 , {88,79,70},  218,3 , 13799,34 , 4,4 , 4,0 , 4168,10 , 4196,16 ,     0,     0,     1,     6,     7 }, // Yoruba/Latin/Benin
    {    140,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 697,9 , 706,10 , 519,6 , 35,18 , 18,7 , 25,12 , 22002,48 , 22050,90 , 134,24 , 22002,48 , 22050,90 , 134,24 , 11531,28 , 11559,67 , 11626,14 , 11531,28 , 11559,67 , 11640,14 , 417,7 , 412,8 , {90,65,82},  5,1 , 13833,67 , 4,4 , 4,0 , 4212,7 , 4219,14 ,     2,     1,     7,     6,     7 }, // Zulu/Latin/SouthAfrica
    {    141,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 196,8 , 196,8 , 918,10 , 472,17 , 37,5 , 379,16 , 5518,48 , 13469,83 , 134,24 , 22140,59 , 13469,83 , 134,24 , 11654,28 , 11682,51 , 2333,14 , 11733,28 , 11682,51 , 2333,14 , 424,9 , 420,11 , {78,79,75},  214,2 , 13900,42 , 13,5 , 4,0 , 4233,7 , 4240,5 ,     2,     1,     1,     6,     7 }, // NorwegianNynorsk/Latin/Norway
    {    142,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8217, 0,6 , 0,6 , 172,7 , 172,7 , 1385,9 , 1016,20 , 37,5 , 8,10 , 4859,48 , 22199,83 , 16006,24 , 4859,48 , 22199,83 , 16006,24 , 2056,28 , 2084,58 , 2142,14 , 2056,28 , 2084,58 , 2156,14 , 433,11 , 431,7 , {66,65,77},  161,2 , 13942,174 , 13,5 , 4,0 , 4245,8 , 594,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Latin/BosniaAndHerzegowina
    {    142,     2,    27,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 125,7 , 125,7 , 1009,7 , 1016,20 , 37,5 , 8,10 , 15748,48 , 22282,83 , 12080,24 , 15748,48 , 22282,83 , 12080,24 , 11761,28 , 11789,54 , 8427,14 , 11761,28 , 11789,54 , 8427,14 , 275,9 , 438,7 , {66,65,77},  321,2 , 14116,151 , 13,5 , 4,0 , 4253,8 , 3397,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Cyrillic/BosniaAndHerzegowina
    {    143,    29,   131,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {77,86,82},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     5,     6,     7 }, // Divehi/Thaana/Maldives
    {    144,     7,   251,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 560,17 , 37,5 , 8,10 , 22365,102 , 22467,140 , 158,27 , 22365,102 , 22467,140 , 158,27 , 11843,30 , 11873,57 , 85,14 , 11843,30 , 11873,57 , 85,14 , 100,4 , 98,4 , {71,66,80},  125,1 , 0,7 , 4,4 , 4,0 , 4261,5 , 4266,12 ,     2,     1,     1,     6,     7 }, // Manx/Latin/IsleOfMan
    {    145,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 98,16 , 37,5 , 8,10 , 22607,46 , 22653,130 , 158,27 , 22607,46 , 22653,130 , 158,27 , 11930,28 , 11958,61 , 85,14 , 11930,28 , 11958,61 , 85,14 , 100,4 , 98,4 , {71,66,80},  125,1 , 0,7 , 4,4 , 4,0 , 4278,8 , 4286,14 ,     2,     1,     1,     6,     7 }, // Cornish/Latin/UnitedKingdom
    {    146,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 683,8 , 691,18 , 37,5 , 8,10 , 22783,48 , 22831,192 , 158,27 , 22783,48 , 22831,192 , 158,27 , 12019,28 , 12047,49 , 12096,14 , 12019,28 , 12047,49 , 12096,14 , 444,2 , 445,2 , {71,72,83},  181,3 , 14267,17 , 4,4 , 4,0 , 4300,4 , 4304,5 ,     2,     1,     1,     6,     7 }, // Akan/Latin/Ghana
    {    147,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 928,6 , 98,16 , 18,7 , 25,12 , 23023,87 , 23023,87 , 158,27 , 23023,87 , 23023,87 , 158,27 , 6916,32 , 12110,55 , 85,14 , 6916,32 , 12110,55 , 85,14 , 237,5 , 447,5 , {73,78,82},  127,1 , 0,7 , 8,5 , 4,0 , 4309,6 , 2525,4 ,     2,     1,     7,     7,     7 }, // Konkani/Devanagari/India
    {    148,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {71,72,83},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Ga/Latin/Ghana
    {    149,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 23110,48 , 23158,86 , 158,27 , 23110,48 , 23158,86 , 158,27 , 12165,29 , 12194,57 , 85,14 , 12165,29 , 12194,57 , 85,14 , 54,4 , 452,4 , {78,71,78},  192,1 , 14284,12 , 4,4 , 4,0 , 4315,4 , 1264,7 ,     2,     1,     1,     6,     7 }, // Igbo/Latin/Nigeria
    {    150,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 23244,48 , 23292,189 , 23481,24 , 23244,48 , 23292,189 , 23481,24 , 12251,28 , 12279,74 , 12353,14 , 12251,28 , 12279,74 , 12353,14 , 446,9 , 456,7 , {75,69,83},  2,3 , 14296,23 , 4,4 , 4,0 , 4319,7 , 1125,5 ,     2,     1,     7,     6,     7 }, // Kamba/Latin/Kenya
    {    151,    33,   103,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,81,68},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     6,     5,     6 }, // Syriac/Syriac/Iraq
    {    152,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,82,78},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Blin/Ethiopic/Eritrea
    {    153,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,84,66},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Geez/Ethiopic/Ethiopia
    {    155,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,84,66},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Sidamo/Latin/Ethiopia
    {    156,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,71,78},  192,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Atsam/Latin/Nigeria
    {    157,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,82,78},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Tigre/Ethiopic/Eritrea
    {    158,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,71,78},  192,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Jju/Latin/Nigeria
    {    159,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 249,7 , 249,7 , 27,8 , 1394,27 , 37,5 , 8,10 , 23505,48 , 23553,77 , 23630,24 , 23505,48 , 23553,77 , 23630,24 , 12367,28 , 12395,50 , 3019,14 , 12367,28 , 12395,50 , 3019,14 , 455,2 , 463,2 , {69,85,82},  14,1 , 2889,20 , 8,5 , 4,0 , 4326,6 , 4332,6 ,     2,     1,     1,     6,     7 }, // Friulian/Latin/Italy
    {    160,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Venda/Latin/SouthAfrica
    {    161,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 716,11 , 727,10 , 519,6 , 1421,23 , 423,12 , 435,12 , 23654,48 , 23702,87 , 23789,24 , 23654,48 , 23702,87 , 23789,24 , 12445,28 , 12473,44 , 12517,14 , 12445,28 , 12473,44 , 12517,14 , 457,3 , 465,5 , {71,72,83},  181,3 , 14319,37 , 4,4 , 4,0 , 4338,6 , 4344,12 ,     2,     1,     1,     6,     7 }, // Ewe/Latin/Ghana
    {    161,     7,   212,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 716,11 , 727,10 , 519,6 , 1421,23 , 423,12 , 435,12 , 23654,48 , 23702,87 , 23789,24 , 23654,48 , 23702,87 , 23789,24 , 12445,28 , 12473,44 , 12517,14 , 12445,28 , 12473,44 , 12517,14 , 457,3 , 465,5 , {88,79,70},  218,3 , 14356,106 , 4,4 , 4,0 , 4338,6 , 4356,11 ,     0,     0,     1,     6,     7 }, // Ewe/Latin/Togo
    {    162,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,84,66},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Walamo/Ethiopic/Ethiopia
    {    163,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 283,6 , 10,17 , 18,7 , 25,12 , 23813,59 , 23872,95 , 158,27 , 23813,59 , 23872,95 , 158,27 , 12531,21 , 12552,57 , 85,14 , 12531,21 , 12552,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 0,7 , 4,4 , 4,0 , 4367,14 , 4381,19 ,     2,     1,     7,     6,     7 }, // Hawaiian/Latin/UnitedStates
    {    164,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {78,71,78},  192,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Tyap/Latin/Nigeria
    {    165,     7,   129,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {77,87,75},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Nyanja/Latin/Malawi
    {    166,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 737,9 , 746,8 , 519,6 , 35,18 , 18,7 , 25,12 , 23967,48 , 24015,88 , 24103,24 , 23967,48 , 24015,88 , 24103,24 , 12609,28 , 12637,55 , 12692,14 , 12609,28 , 12637,55 , 12692,14 , 0,2 , 0,2 , {80,72,80},  193,1 , 14462,58 , 4,4 , 4,0 , 4400,8 , 4408,9 ,     2,     1,     7,     6,     7 }, // Filipino/Latin/Philippines
    {    167,     7,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 24127,86 , 134,24 , 7333,48 , 24127,86 , 134,24 , 12706,28 , 12734,63 , 3659,14 , 12706,28 , 12734,63 , 3659,14 , 122,5 , 470,4 , {67,72,70},  240,3 , 14520,55 , 13,5 , 4,0 , 4417,16 , 4433,7 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Switzerland
    {    167,     7,    74,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 24127,86 , 134,24 , 7333,48 , 24127,86 , 134,24 , 12706,28 , 12734,63 , 3659,14 , 12706,28 , 12734,63 , 3659,14 , 122,5 , 470,4 , {69,85,82},  14,1 , 7891,19 , 13,5 , 4,0 , 4417,16 , 4440,10 ,     2,     1,     1,     6,     7 }, // Swiss German/Latin/France
    {    167,     7,   123,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 264,9 , 264,9 , 158,8 , 542,18 , 37,5 , 8,10 , 7333,48 , 24127,86 , 134,24 , 7333,48 , 24127,86 , 134,24 , 12706,28 , 12734,63 , 3659,14 , 12706,28 , 12734,63 , 3659,14 , 122,5 , 470,4 , {67,72,70},  240,3 , 14520,55 , 13,5 , 4,0 , 4417,16 , 4450,13 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Liechtenstein
    {    168,    34,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 158,27 , 24213,38 , 158,27 , 158,27 , 24213,38 , 158,27 , 12797,21 , 12818,28 , 12846,14 , 12797,21 , 12818,28 , 12846,14 , 460,2 , 474,2 , {67,78,89},  342,1 , 0,7 , 8,5 , 4,0 , 4463,3 , 4466,2 ,     2,     1,     7,     6,     7 }, // Sichuan Yi/Yi/China
    {    169,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {76,82,68},  6,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Kpelle/Latin/Liberia
    {    170,     7,    82,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Germany
    {    171,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // South Ndebele/Latin/SouthAfrica
    {    172,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {90,65,82},  5,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Northern Sotho/Latin/SouthAfrica
    {    173,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 223,8 , 223,8 , 53,10 , 63,17 , 37,5 , 8,10 , 24251,59 , 24310,145 , 24455,24 , 24251,59 , 24310,145 , 24455,24 , 12860,33 , 12893,75 , 12968,14 , 12860,33 , 12893,75 , 12968,14 , 462,11 , 476,13 , {78,79,75},  214,2 , 14575,63 , 13,5 , 4,0 , 4468,15 , 4483,5 ,     2,     1,     1,     6,     7 }, // Northern Sami/Latin/Norway
    {    173,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 223,8 , 223,8 , 53,10 , 63,17 , 37,5 , 8,10 , 24479,85 , 24310,145 , 24455,24 , 24479,85 , 24310,145 , 24455,24 , 12860,33 , 12982,65 , 13047,14 , 12860,33 , 12982,65 , 13047,14 , 462,11 , 476,13 , {69,85,82},  14,1 , 14638,23 , 13,5 , 4,0 , 4468,15 , 4488,6 ,     2,     1,     1,     6,     7 }, // Northern Sami/Latin/Finland
    {    173,     7,   205,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 223,8 , 223,8 , 53,10 , 63,17 , 37,5 , 8,10 , 24251,59 , 24310,145 , 24455,24 , 24251,59 , 24310,145 , 24455,24 , 12860,33 , 12893,75 , 12968,14 , 12860,33 , 12893,75 , 12968,14 , 462,11 , 476,13 , {83,69,75},  214,2 , 14661,63 , 13,5 , 4,0 , 4468,15 , 4494,6 ,     2,     1,     1,     6,     7 }, // Northern Sami/Latin/Sweden
    {    174,     7,   208,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {84,87,68},  155,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     0,     7,     6,     7 }, // Taroko/Latin/Taiwan
    {    175,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 24564,48 , 24612,88 , 24700,24 , 24564,48 , 24612,88 , 24700,24 , 13061,28 , 13089,62 , 13151,14 , 13061,28 , 13089,62 , 13151,14 , 473,5 , 489,10 , {75,69,83},  2,3 , 14724,24 , 4,4 , 4,0 , 4500,8 , 1125,5 ,     2,     1,     7,     6,     7 }, // Gusii/Latin/Kenya
    {    176,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 24724,48 , 24772,221 , 24993,24 , 24724,48 , 24772,221 , 24993,24 , 13165,28 , 13193,105 , 13298,14 , 13165,28 , 13193,105 , 13298,14 , 478,10 , 499,10 , {75,69,83},  2,3 , 14724,24 , 4,4 , 4,0 , 4508,7 , 1125,5 ,     2,     1,     7,     6,     7 }, // Taita/Latin/Kenya
    {    177,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 25017,48 , 25065,77 , 25142,24 , 25017,48 , 25065,77 , 25142,24 , 13312,28 , 13340,59 , 13399,14 , 13312,28 , 13340,59 , 13399,14 , 488,6 , 509,7 , {88,79,70},  218,3 , 14748,26 , 13,5 , 4,0 , 4515,6 , 4521,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Senegal
    {    177,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 25017,48 , 25065,77 , 25142,24 , 25017,48 , 25065,77 , 25142,24 , 13312,28 , 13340,59 , 13399,14 , 13312,28 , 13340,59 , 13399,14 , 488,6 , 509,7 , {88,65,70},  32,4 , 14774,25 , 13,5 , 4,0 , 4515,6 , 4529,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Cameroon
    {    177,     7,    91,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 25017,48 , 25065,77 , 25142,24 , 25017,48 , 25065,77 , 25142,24 , 13312,28 , 13340,59 , 13399,14 , 13312,28 , 13340,59 , 13399,14 , 488,6 , 509,7 , {71,78,70},  232,2 , 0,7 , 13,5 , 4,0 , 4515,6 , 4537,4 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Guinea
    {    177,     7,   136,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 25017,48 , 25065,77 , 25142,24 , 25017,48 , 25065,77 , 25142,24 , 13312,28 , 13340,59 , 13399,14 , 13312,28 , 13340,59 , 13399,14 , 488,6 , 509,7 , {77,82,79},  235,2 , 14799,22 , 13,5 , 4,0 , 4515,6 , 4541,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Mauritania
    {    178,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 25166,48 , 25214,185 , 25399,24 , 25166,48 , 25214,185 , 25399,24 , 13413,28 , 13441,63 , 13504,14 , 13413,28 , 13441,63 , 13504,14 , 494,6 , 516,8 , {75,69,83},  2,3 , 14821,23 , 4,4 , 4,0 , 4549,6 , 1125,5 ,     2,     1,     7,     6,     7 }, // Kikuyu/Latin/Kenya
    {    179,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 25423,48 , 25471,173 , 25644,24 , 25423,48 , 25471,173 , 25644,24 , 13518,28 , 13546,105 , 13651,14 , 13518,28 , 13546,105 , 13651,14 , 500,7 , 524,5 , {75,69,83},  2,3 , 14844,25 , 4,4 , 4,0 , 4555,8 , 1125,5 ,     2,     1,     7,     6,     7 }, // Samburu/Latin/Kenya
    {    180,     7,   146,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 954,27 , 37,5 , 8,10 , 25668,48 , 25716,88 , 134,24 , 25668,48 , 25716,88 , 134,24 , 13665,28 , 13693,55 , 13748,14 , 13665,28 , 13693,55 , 13748,14 , 0,2 , 0,2 , {77,90,78},  298,3 , 14869,28 , 0,4 , 4,0 , 4563,4 , 3133,10 ,     2,     1,     7,     6,     7 }, // Sena/Latin/Mozambique
    {    181,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 25804,52 , 25856,112 , 25968,24 , 25804,52 , 25856,112 , 25968,24 , 13762,28 , 13790,50 , 13840,14 , 13762,28 , 13790,50 , 13840,14 , 0,2 , 0,2 , {85,83,68},  176,3 , 14897,24 , 4,4 , 4,0 , 4567,10 , 1698,8 ,     2,     1,     7,     6,     7 }, // North Ndebele/Latin/Zimbabwe
    {    182,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 25992,39 , 26031,194 , 26225,24 , 25992,39 , 26031,194 , 26225,24 , 13854,29 , 13883,65 , 13948,14 , 13854,29 , 13883,65 , 13948,14 , 507,8 , 529,7 , {84,90,83},  204,3 , 14921,25 , 4,4 , 4,0 , 4577,9 , 1523,8 ,     0,     0,     1,     6,     7 }, // Rombo/Latin/Tanzania
    {    183,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 26249,48 , 26297,81 , 26378,24 , 26249,48 , 26297,81 , 26378,24 , 13962,30 , 13992,47 , 85,14 , 13962,30 , 13992,47 , 85,14 , 515,6 , 536,8 , {77,65,68},  0,0 , 14946,21 , 0,4 , 4,0 , 4586,8 , 4594,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/Tifinagh/Morocco
    {    183,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 26402,48 , 26450,81 , 26531,24 , 26402,48 , 26450,81 , 26531,24 , 14039,30 , 14069,48 , 85,14 , 14039,30 , 14069,48 , 85,14 , 521,6 , 544,8 , {77,65,68},  0,0 , 14967,21 , 0,4 , 4,0 , 4600,9 , 4609,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/Latin/Morocco
    {    184,     7,     3,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 26555,48 , 26603,84 , 26687,24 , 26555,48 , 26603,84 , 26687,24 , 14117,30 , 14147,51 , 14198,14 , 14117,30 , 14147,51 , 14198,14 , 527,7 , 552,9 , {68,90,68},  216,2 , 14988,21 , 0,4 , 4,0 , 4615,9 , 4624,8 ,     2,     1,     6,     5,     6 }, // Kabyle/Latin/Algeria
    {    185,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 26711,48 , 26759,152 , 134,24 , 26711,48 , 26759,152 , 134,24 , 14212,28 , 14240,74 , 14314,14 , 14212,28 , 14240,74 , 14314,14 , 0,2 , 0,2 , {85,71,88},  209,3 , 15009,26 , 4,4 , 4,0 , 4632,10 , 1588,6 ,     0,     0,     1,     6,     7 }, // Nyankole/Latin/Uganda
    {    186,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 26911,48 , 26959,254 , 27213,24 , 26911,48 , 26959,254 , 27213,24 , 14328,28 , 14356,82 , 14438,14 , 14328,28 , 14356,82 , 14438,14 , 534,7 , 561,7 , {84,90,83},  204,3 , 15035,29 , 0,4 , 4,0 , 4642,6 , 4648,10 ,     0,     0,     1,     6,     7 }, // Bena/Latin/Tanzania
    {    187,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 27237,87 , 134,24 , 18031,48 , 27237,87 , 134,24 , 14452,28 , 14480,62 , 14542,14 , 14452,28 , 14480,62 , 14542,14 , 541,5 , 568,9 , {84,90,83},  204,3 , 15064,27 , 4,4 , 4,0 , 4658,8 , 1523,8 ,     0,     0,     1,     6,     7 }, // Vunjo/Latin/Tanzania
    {    188,     7,   132,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 27324,47 , 27371,92 , 27463,24 , 27324,47 , 27371,92 , 27463,24 , 14556,28 , 14584,44 , 14628,14 , 14556,28 , 14584,44 , 14628,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 15091,24 , 4,4 , 4,0 , 4666,9 , 2049,4 ,     0,     0,     1,     6,     7 }, // Bambara/Latin/Mali
    {    188,    75,   132,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Bambara/Nko/Mali
    {    189,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 27487,48 , 27535,207 , 27742,24 , 27487,48 , 27535,207 , 27742,24 , 14642,28 , 14670,64 , 14734,14 , 14642,28 , 14670,64 , 14734,14 , 546,2 , 577,2 , {75,69,83},  2,3 , 14724,24 , 4,4 , 4,0 , 4675,6 , 1125,5 ,     2,     1,     7,     6,     7 }, // Embu/Latin/Kenya
    {    190,    12,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 519,6 , 35,18 , 18,7 , 25,12 , 27766,36 , 27802,58 , 27860,24 , 27766,36 , 27802,58 , 27860,24 , 14748,28 , 14776,49 , 14825,14 , 14748,28 , 14776,49 , 14825,14 , 548,3 , 579,6 , {85,83,68},  6,1 , 15115,19 , 4,4 , 4,0 , 4681,3 , 4684,4 ,     2,     1,     7,     6,     7 }, // Cherokee/Cherokee/UnitedStates
    {    191,     7,   137,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 27884,47 , 27931,68 , 27999,24 , 27884,47 , 27931,68 , 27999,24 , 14839,27 , 14866,48 , 14914,14 , 14839,27 , 14866,48 , 14914,14 , 0,2 , 0,2 , {77,85,82},  190,2 , 15134,21 , 8,5 , 4,0 , 4688,14 , 4702,5 ,     0,     0,     1,     6,     7 }, // Morisyen/Latin/Mauritius
    {    192,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 28023,264 , 134,24 , 18031,48 , 28023,264 , 134,24 , 14928,28 , 14956,133 , 13948,14 , 14928,28 , 14956,133 , 13948,14 , 551,4 , 585,5 , {84,90,83},  204,3 , 15064,27 , 4,4 , 4,0 , 4707,10 , 1523,8 ,     0,     0,     1,     6,     7 }, // Makonde/Latin/Tanzania
    {    193,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 28287,83 , 28370,111 , 28481,24 , 28287,83 , 28370,111 , 28481,24 , 15089,36 , 15125,63 , 15188,14 , 15089,36 , 15125,63 , 15188,14 , 555,3 , 590,3 , {84,90,83},  204,3 , 15155,29 , 8,5 , 4,0 , 4717,8 , 4725,9 ,     0,     0,     1,     6,     7 }, // Langi/Latin/Tanzania
    {    194,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 28505,48 , 28553,97 , 134,24 , 28505,48 , 28553,97 , 134,24 , 15202,28 , 15230,66 , 15296,14 , 15202,28 , 15230,66 , 15296,14 , 0,2 , 0,2 , {85,71,88},  209,3 , 15184,26 , 0,4 , 4,0 , 4734,7 , 4741,7 ,     0,     0,     1,     6,     7 }, // Ganda/Latin/Uganda
    {    195,     7,   239,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 28650,48 , 28698,83 , 28781,24 , 28650,48 , 28698,83 , 28781,24 , 15310,80 , 15310,80 , 85,14 , 15310,80 , 15310,80 , 85,14 , 558,8 , 593,7 , {90,77,87},  143,1 , 0,7 , 4,4 , 4,0 , 4748,9 , 1692,6 ,     2,     1,     1,     6,     7 }, // Bemba/Latin/Zambia
    {    196,     7,    39,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 561,7 , 561,7 , 534,8 , 1444,27 , 37,5 , 8,10 , 28805,48 , 28853,85 , 134,24 , 28805,48 , 28853,85 , 134,24 , 15390,28 , 15418,73 , 15491,14 , 15390,28 , 15418,73 , 15505,14 , 244,2 , 240,2 , {67,86,69},  297,1 , 15210,43 , 13,5 , 4,0 , 4757,12 , 4769,10 ,     2,     1,     1,     6,     7 }, // Kabuverdianu/Latin/CapeVerde
    {    197,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 28938,48 , 28986,86 , 29072,24 , 28938,48 , 28986,86 , 29072,24 , 15519,28 , 15547,51 , 15598,14 , 15519,28 , 15547,51 , 15598,14 , 566,2 , 600,2 , {75,69,83},  2,3 , 14724,24 , 4,4 , 4,0 , 4779,6 , 1125,5 ,     2,     1,     7,     6,     7 }, // Meru/Latin/Kenya
    {    198,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29096,49 , 29145,121 , 29266,24 , 29096,49 , 29145,121 , 29266,24 , 15612,28 , 15640,53 , 15693,14 , 15612,28 , 15640,53 , 15693,14 , 568,6 , 602,10 , {75,69,83},  2,3 , 15253,26 , 4,4 , 4,0 , 4785,8 , 4793,12 ,     2,     1,     7,     6,     7 }, // Kalenjin/Latin/Kenya
    {    199,     7,   148,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 0,48 , 29290,136 , 134,24 , 0,48 , 29290,136 , 134,24 , 15707,23 , 15730,92 , 15822,14 , 15707,23 , 15730,92 , 15822,14 , 574,7 , 612,5 , {78,65,68},  6,1 , 15279,22 , 4,4 , 4,0 , 4805,13 , 4818,8 ,     2,     1,     1,     6,     7 }, // Nama/Latin/Namibia
    {    200,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 27237,87 , 134,24 , 18031,48 , 27237,87 , 134,24 , 14452,28 , 14480,62 , 14542,14 , 14452,28 , 14480,62 , 14542,14 , 541,5 , 568,9 , {84,90,83},  204,3 , 15064,27 , 4,4 , 4,0 , 4826,9 , 1523,8 ,     0,     0,     1,     6,     7 }, // Machame/Latin/Tanzania
    {    201,     7,    82,    44,   160,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 422,8 , 422,8 , 1471,10 , 1481,23 , 37,5 , 8,10 , 29426,59 , 29485,87 , 134,24 , 29572,48 , 29485,87 , 134,24 , 15836,28 , 15864,72 , 3659,14 , 15836,28 , 15864,72 , 3659,14 , 581,16 , 617,16 , {69,85,82},  14,1 , 15301,11 , 13,5 , 4,0 , 4835,6 , 4841,11 ,     2,     1,     1,     6,     7 }, // Colognian/Latin/Germany
    {    202,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29620,51 , 29671,132 , 158,27 , 29620,51 , 29671,132 , 158,27 , 14452,28 , 15936,58 , 13948,14 , 14452,28 , 15936,58 , 13948,14 , 597,9 , 633,6 , {75,69,83},  2,3 , 15312,25 , 4,4 , 4,0 , 4852,3 , 1125,5 ,     2,     1,     7,     6,     7 }, // Masai/Latin/Kenya
    {    202,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29620,51 , 29671,132 , 158,27 , 29620,51 , 29671,132 , 158,27 , 14452,28 , 15936,58 , 13948,14 , 14452,28 , 15936,58 , 13948,14 , 597,9 , 633,6 , {84,90,83},  204,3 , 15337,28 , 4,4 , 4,0 , 4852,3 , 4855,8 ,     0,     0,     1,     6,     7 }, // Masai/Latin/Tanzania
    {    203,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 28505,48 , 28553,97 , 134,24 , 28505,48 , 28553,97 , 134,24 , 15994,35 , 16029,65 , 16094,14 , 15994,35 , 16029,65 , 16094,14 , 606,6 , 639,6 , {85,71,88},  209,3 , 15184,26 , 13,5 , 4,0 , 4863,7 , 4741,7 ,     0,     0,     1,     6,     7 }, // Soga/Latin/Uganda
    {    204,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29803,48 , 18079,84 , 134,24 , 29803,48 , 18079,84 , 134,24 , 16108,21 , 16129,75 , 85,14 , 16108,21 , 16129,75 , 85,14 , 100,4 , 98,4 , {75,69,83},  2,3 , 15365,23 , 4,4 , 45,6 , 4870,7 , 1125,5 ,     2,     1,     7,     6,     7 }, // Luyia/Latin/Kenya
    {    205,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29851,48 , 18079,84 , 134,24 , 29851,48 , 18079,84 , 134,24 , 16204,28 , 9378,60 , 14542,14 , 16204,28 , 9378,60 , 14542,14 , 612,9 , 645,8 , {84,90,83},  204,3 , 15388,28 , 13,5 , 4,0 , 4877,6 , 4883,8 ,     0,     0,     1,     6,     7 }, // Asu/Latin/Tanzania
    {    206,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29899,48 , 29947,94 , 30041,24 , 29899,48 , 29947,94 , 30041,24 , 16232,28 , 16260,69 , 16329,14 , 16232,28 , 16260,69 , 16329,14 , 621,9 , 653,6 , {85,71,88},  209,3 , 15416,28 , 4,4 , 4,0 , 4891,6 , 1588,6 ,     0,     0,     1,     6,     7 }, // Teso/Latin/Uganda
    {    206,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 29899,48 , 29947,94 , 30041,24 , 29899,48 , 29947,94 , 30041,24 , 16232,28 , 16260,69 , 16329,14 , 16232,28 , 16260,69 , 16329,14 , 621,9 , 653,6 , {75,69,83},  2,3 , 15444,27 , 4,4 , 4,0 , 4891,6 , 4897,5 ,     2,     1,     7,     6,     7 }, // Teso/Latin/Kenya
    {    207,     7,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,82,78},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Saho/Latin/Eritrea
    {    208,     7,   132,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 30065,46 , 30111,88 , 30199,24 , 30065,46 , 30111,88 , 30199,24 , 16343,28 , 16371,53 , 16424,14 , 16343,28 , 16371,53 , 16424,14 , 630,6 , 659,6 , {88,79,70},  218,3 , 15471,23 , 0,4 , 4,0 , 4902,11 , 4913,5 ,     0,     0,     1,     6,     7 }, // Koyra Chiini/Latin/Mali
    {    209,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 27237,87 , 134,24 , 18031,48 , 27237,87 , 134,24 , 14452,28 , 14480,62 , 14542,14 , 14452,28 , 14480,62 , 14542,14 , 541,5 , 568,9 , {84,90,83},  204,3 , 15064,27 , 0,4 , 4,0 , 4918,6 , 1523,8 ,     0,     0,     1,     6,     7 }, // Rwa/Latin/Tanzania
    {    210,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 30223,48 , 30271,186 , 30457,24 , 30223,48 , 30271,186 , 30457,24 , 16438,28 , 16466,69 , 16535,14 , 16438,28 , 16466,69 , 16535,14 , 636,2 , 665,2 , {75,69,83},  2,3 , 15494,23 , 0,4 , 4,0 , 4924,6 , 1125,5 ,     2,     1,     7,     6,     7 }, // Luo/Latin/Kenya
    {    211,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 26711,48 , 26759,152 , 134,24 , 26711,48 , 26759,152 , 134,24 , 14212,28 , 14240,74 , 14314,14 , 14212,28 , 14240,74 , 14314,14 , 0,2 , 0,2 , {85,71,88},  209,3 , 15009,26 , 4,4 , 4,0 , 4930,6 , 1588,6 ,     0,     0,     1,     6,     7 }, // Chiga/Latin/Uganda
    {    212,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 30481,48 , 30529,86 , 30615,24 , 30481,48 , 30529,86 , 30615,24 , 16549,28 , 16577,48 , 16625,14 , 16549,28 , 16577,48 , 16625,14 , 638,9 , 667,10 , {77,65,68},  0,0 , 15517,22 , 13,5 , 4,0 , 4936,8 , 4944,6 ,     2,     1,     6,     5,     6 }, // Central Morocco Tamazight/Latin/Morocco
    {    213,     7,   132,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 30065,46 , 30111,88 , 30199,24 , 30065,46 , 30111,88 , 30199,24 , 16639,28 , 16667,54 , 16424,14 , 16639,28 , 16667,54 , 16424,14 , 630,6 , 659,6 , {88,79,70},  218,3 , 15471,23 , 0,4 , 4,0 , 4950,15 , 4913,5 ,     0,     0,     1,     6,     7 }, // Koyraboro Senni/Latin/Mali
    {    214,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 18031,48 , 30639,84 , 134,24 , 18031,48 , 30639,84 , 134,24 , 16721,28 , 16749,63 , 16812,14 , 16721,28 , 16749,63 , 16812,14 , 647,5 , 677,8 , {84,90,83},  204,3 , 15539,27 , 0,4 , 4,0 , 4965,9 , 1523,8 ,     0,     0,     1,     6,     7 }, // Shambala/Latin/Tanzania
    {    215,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 519,6 , 35,18 , 18,7 , 25,12 , 30723,88 , 30723,88 , 30811,31 , 30723,88 , 30723,88 , 30811,31 , 16826,33 , 16859,54 , 16913,19 , 16826,33 , 16859,54 , 16913,19 , 652,3 , 685,6 , {73,78,82},  127,1 , 15566,10 , 8,5 , 4,0 , 4974,4 , 2525,4 ,     2,     1,     7,     7,     7 }, // Bodo/Devanagari/India
    {    218,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {82,85,66},  135,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Chechen/Cyrillic/Russia
    {    219,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {82,85,66},  135,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Church/Cyrillic/Russia
    {    230,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 30842,49 , 30891,99 , 30990,24 , 30842,49 , 30891,99 , 30990,24 , 16932,28 , 16960,50 , 17010,14 , 16932,28 , 16960,50 , 17010,14 , 655,5 , 691,6 , {67,68,70},  226,2 , 15576,24 , 0,4 , 4,0 , 4978,8 , 4986,16 ,     2,     1,     1,     6,     7 }, // LubaKatanga/Latin/CongoKinshasa
    {    231,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 754,10 , 754,10 , 158,8 , 542,18 , 37,5 , 8,10 , 31014,48 , 31062,85 , 134,24 , 31147,59 , 31062,85 , 134,24 , 17024,28 , 17052,65 , 3659,14 , 17117,35 , 17052,65 , 3659,14 , 660,5 , 697,8 , {69,85,82},  14,1 , 7891,19 , 13,5 , 4,0 , 5002,14 , 5016,10 ,     2,     1,     1,     6,     7 }, // Luxembourgish/Latin/Luxembourg
    {    236,     7,    21,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Walloon/Latin/Belgium
    {    237,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8218,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 31206,48 , 31254,195 , 31449,24 , 31206,48 , 31254,195 , 31449,24 , 17152,28 , 17180,72 , 17252,14 , 17152,28 , 17180,72 , 17252,14 , 665,3 , 705,3 , {88,65,70},  32,4 , 15600,21 , 0,4 , 4,0 , 5026,5 , 5031,7 ,     0,     0,     1,     6,     7 }, // Aghem/Latin/Cameroon
    {    238,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 31473,48 , 31521,90 , 31611,24 , 31473,48 , 31521,90 , 31611,24 , 17266,28 , 17294,70 , 17364,14 , 17266,28 , 17294,70 , 17364,14 , 668,10 , 708,9 , {88,65,70},  32,4 , 15621,22 , 13,5 , 4,0 , 5038,5 , 5043,8 ,     0,     0,     1,     6,     7 }, // Basaa/Latin/Cameroon
    {    239,     7,   156,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 30065,46 , 30111,88 , 30199,24 , 30065,46 , 30111,88 , 30199,24 , 16639,28 , 17378,53 , 17431,14 , 16639,28 , 17378,53 , 17431,14 , 678,8 , 717,10 , {88,79,70},  218,3 , 15471,23 , 0,4 , 4,0 , 5051,10 , 5061,5 ,     0,     0,     1,     6,     7 }, // Zarma/Latin/Niger
    {    240,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 31635,49 , 31684,99 , 31783,24 , 31635,49 , 31684,99 , 31783,24 , 17445,28 , 17473,45 , 17518,14 , 17445,28 , 17473,45 , 17518,14 , 686,5 , 727,6 , {88,65,70},  32,4 , 0,7 , 13,5 , 4,0 , 5066,5 , 1846,8 ,     0,     0,     1,     6,     7 }, // Duala/Latin/Cameroon
    {    241,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 31807,36 , 31843,82 , 31925,24 , 31807,36 , 31843,82 , 31925,24 , 17532,28 , 17560,50 , 17610,14 , 17532,28 , 17560,50 , 17610,14 , 0,2 , 0,2 , {88,79,70},  218,3 , 15643,23 , 13,5 , 4,0 , 5071,5 , 5076,7 ,     0,     0,     1,     6,     7 }, // JolaFonyi/Latin/Senegal
    {    242,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 31949,50 , 31999,141 , 32140,24 , 31949,50 , 31999,141 , 32140,24 , 17624,30 , 17654,85 , 17739,14 , 17624,30 , 17654,85 , 17739,14 , 691,7 , 733,9 , {88,65,70},  32,4 , 15666,23 , 13,5 , 4,0 , 5083,6 , 5089,7 ,     0,     0,     1,     6,     7 }, // Ewondo/Latin/Cameroon
    {    243,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 32164,39 , 32203,191 , 158,27 , 32164,39 , 32203,191 , 158,27 , 17753,29 , 17782,45 , 17827,14 , 17753,29 , 17782,45 , 17827,14 , 698,6 , 742,7 , {88,65,70},  32,4 , 15689,11 , 13,5 , 4,0 , 5096,5 , 5101,7 ,     0,     0,     1,     6,     7 }, // Bafia/Latin/Cameroon
    {    244,     7,   146,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 32394,48 , 32442,213 , 32655,24 , 32394,48 , 32442,213 , 32655,24 , 17841,28 , 17869,59 , 17928,14 , 17841,28 , 17869,59 , 17928,14 , 704,8 , 749,10 , {77,90,78},  298,3 , 0,7 , 8,5 , 4,0 , 5108,5 , 5113,10 ,     2,     1,     7,     6,     7 }, // MakhuwaMeetto/Latin/Mozambique
    {    245,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 32679,48 , 32727,139 , 32866,24 , 32679,48 , 32727,139 , 32866,24 , 17942,28 , 17970,74 , 18044,14 , 17942,28 , 17970,74 , 18044,14 , 712,5 , 759,5 , {88,65,70},  32,4 , 15700,17 , 4,4 , 4,0 , 5123,6 , 5129,7 ,     0,     0,     1,     6,     7 }, // Mundang/Latin/Cameroon
    {    246,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 32890,51 , 32941,143 , 158,27 , 32890,51 , 32941,143 , 158,27 , 18058,30 , 18088,89 , 18177,14 , 18058,30 , 18088,89 , 18177,14 , 717,4 , 764,4 , {88,65,70},  32,4 , 15717,20 , 13,5 , 4,0 , 5136,6 , 5142,7 ,     0,     0,     1,     6,     7 }, // Kwasio/Latin/Cameroon
    {    247,     7,   201,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 525,9 , 98,16 , 18,7 , 447,12 , 33084,54 , 33138,96 , 33234,24 , 33084,54 , 33138,96 , 33234,24 , 18191,38 , 18229,79 , 18308,14 , 18191,38 , 18229,79 , 18308,14 , 721,2 , 768,2 , {83,68,71},  0,0 , 0,7 , 4,4 , 4,0 , 5149,9 , 1509,5 ,     2,     1,     6,     5,     6 }, // Nuer/Latin/Sudan
    {    248,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 401,6 , 1504,30 , 37,5 , 8,10 , 33258,75 , 33333,121 , 33454,24 , 33258,75 , 33333,121 , 33454,24 , 18322,21 , 18343,73 , 18416,14 , 18322,21 , 18343,73 , 18416,14 , 723,2 , 770,2 , {82,85,66},  313,4 , 0,7 , 8,5 , 4,0 , 5158,9 , 0,0 ,     2,     1,     1,     6,     7 }, // Sakha/Cyrillic/Russia
    {    249,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 33478,48 , 33526,117 , 158,27 , 33478,48 , 33526,117 , 158,27 , 18430,28 , 18458,60 , 18518,14 , 18430,28 , 18458,60 , 18518,14 , 725,9 , 772,9 , {84,90,83},  204,3 , 15737,25 , 0,4 , 4,0 , 5167,9 , 5176,9 ,     0,     0,     1,     6,     7 }, // Sangu/Latin/Tanzania
    {    251,     7,   156,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 30065,46 , 30111,88 , 30199,24 , 30065,46 , 30111,88 , 30199,24 , 16639,28 , 16667,54 , 16424,14 , 16639,28 , 16667,54 , 16424,14 , 678,8 , 717,10 , {88,79,70},  218,3 , 15471,23 , 0,4 , 4,0 , 5185,13 , 5061,5 ,     0,     0,     1,     6,     7 }, // Tasawaq/Latin/Niger
    {    252,    35,   121,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 33643,50 , 33643,50 , 158,27 , 33643,50 , 33643,50 , 158,27 , 18532,30 , 18532,30 , 85,14 , 18532,30 , 18532,30 , 85,14 , 0,2 , 0,2 , {76,82,68},  6,1 , 15762,15 , 4,4 , 4,0 , 5198,2 , 5200,4 ,     2,     1,     1,     6,     7 }, // Vai/Vai/Liberia
    {    252,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 120,10 , 10,17 , 18,7 , 25,12 , 33693,81 , 33693,81 , 158,27 , 33693,81 , 33693,81 , 158,27 , 18562,48 , 18562,48 , 85,14 , 18562,48 , 18562,48 , 85,14 , 0,2 , 0,2 , {76,82,68},  6,1 , 15777,20 , 4,4 , 4,0 , 5204,3 , 5207,8 ,     2,     1,     1,     6,     7 }, // Vai/Latin/Liberia
    {    253,     7,   206,    44,  8217,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 264,9 , 264,9 , 53,10 , 542,18 , 37,5 , 8,10 , 33774,48 , 33822,99 , 33921,24 , 33774,48 , 33822,99 , 33921,24 , 18610,28 , 18638,53 , 18691,14 , 18610,28 , 18638,53 , 18691,14 , 0,2 , 0,2 , {67,72,70},  0,0 , 0,7 , 8,5 , 4,0 , 5215,6 , 5221,6 ,     2,     0,     1,     6,     7 }, // Walser/Latin/Switzerland
    {    254,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 33945,51 , 33996,191 , 158,27 , 33945,51 , 33996,191 , 158,27 , 18705,21 , 18726,71 , 18797,14 , 18705,21 , 18726,71 , 18797,14 , 734,8 , 781,8 , {88,65,70},  32,4 , 0,7 , 13,5 , 4,0 , 5227,6 , 5233,7 ,     0,     0,     1,     6,     7 }, // Yangben/Latin/Cameroon
    {    256,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 561,7 , 561,7 , 283,6 , 379,22 , 37,5 , 8,10 , 34187,48 , 34235,85 , 34320,24 , 34344,48 , 34392,117 , 34320,24 , 18811,28 , 18839,54 , 3383,14 , 18811,28 , 18839,54 , 3383,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 2889,20 , 13,5 , 4,0 , 5240,9 , 2297,6 ,     2,     1,     1,     6,     7 }, // Asturian/Latin/Spain
    {    257,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 764,11 , 764,11 , 775,16 , 791,9 , 53,10 , 691,18 , 37,5 , 8,10 , 34509,174 , 34509,174 , 158,27 , 34509,174 , 34509,174 , 158,27 , 18893,60 , 18893,60 , 18953,25 , 18893,60 , 18893,60 , 18953,25 , 742,8 , 789,13 , {88,65,70},  32,4 , 15797,12 , 8,5 , 4,0 , 5249,5 , 5254,7 ,     0,     0,     1,     6,     7 }, // Ngomba/Latin/Cameroon
    {    258,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 1534,10 , 560,17 , 37,5 , 8,10 , 34683,102 , 34683,102 , 158,27 , 34683,102 , 34683,102 , 158,27 , 18978,54 , 18978,54 , 19032,21 , 18978,54 , 18978,54 , 19032,21 , 0,2 , 0,2 , {88,65,70},  32,4 , 15809,16 , 8,5 , 4,0 , 5261,4 , 5265,7 ,     0,     0,     1,     6,     7 }, // Kako/Latin/Cameroon
    {    259,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 691,18 , 37,5 , 8,10 , 34785,137 , 34922,142 , 35064,36 , 34785,137 , 34922,142 , 35064,36 , 19053,49 , 19053,49 , 19102,21 , 19053,49 , 19053,49 , 19102,21 , 0,2 , 0,2 , {88,65,70},  32,4 , 15825,12 , 8,5 , 4,0 , 5272,5 , 5277,7 ,     0,     0,     1,     6,     7 }, // Meta/Latin/Cameroon
    {    260,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1544,32 , 37,5 , 8,10 , 35100,164 , 35100,164 , 158,27 , 35100,164 , 35100,164 , 158,27 , 19123,111 , 19123,111 , 85,14 , 19123,111 , 19123,111 , 85,14 , 750,9 , 802,8 , {88,65,70},  32,4 , 15837,16 , 8,5 , 4,0 , 5284,16 , 5300,7 ,     0,     0,     1,     6,     7 }, // Ngiemboon/Latin/Cameroon
    {    312,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Akoose/Latin/Cameroon
    {    313,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 519,6 , 35,18 , 18,7 , 25,12 , 35264,180 , 35264,180 , 158,27 , 35264,180 , 35264,180 , 158,27 , 19234,87 , 19234,87 , 85,14 , 19234,87 , 19234,87 , 19321,14 , 0,2 , 0,2 , {85,83,68},  6,1 , 0,7 , 8,5 , 4,0 , 5307,12 , 5319,22 ,     2,     1,     7,     6,     7 }, // Lakota/Latin/UnitedStates
    {    314,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 534,8 , 98,16 , 37,5 , 8,10 , 26249,48 , 26297,81 , 26378,24 , 26249,48 , 26297,81 , 26378,24 , 13962,30 , 19335,48 , 85,14 , 13962,30 , 19335,48 , 85,14 , 515,6 , 536,8 , {77,65,68},  0,0 , 14946,21 , 0,4 , 4,0 , 4586,8 , 4594,6 ,     2,     1,     6,     5,     6 }, // Standard Moroccan Tamazight/Tifinagh/Morocco
    {    315,     7,    43,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,76,80},  6,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Mapuche/Latin/Chile
    {    316,     1,   103,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {73,81,68},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     6,     5,     6 }, // Central Kurdish/Arabic/Iraq
    {    317,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 189,7 , 189,7 , 114,6 , 542,18 , 42,4 , 137,9 , 35444,48 , 35492,85 , 16006,24 , 35577,60 , 35637,93 , 16006,24 , 19383,28 , 19411,53 , 19464,14 , 19383,28 , 19411,53 , 19464,14 , 759,9 , 810,10 , {69,85,82},  14,1 , 15853,27 , 13,5 , 4,0 , 5341,14 , 5355,6 ,     2,     1,     1,     6,     7 }, // LowerSorbian/Latin/Germany
    {    318,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 189,7 , 189,7 , 114,6 , 542,18 , 459,12 , 137,9 , 35730,48 , 35778,86 , 16006,24 , 35864,60 , 35924,93 , 16006,24 , 19478,28 , 19506,53 , 19559,14 , 19478,28 , 19506,53 , 19559,14 , 759,9 , 820,9 , {69,85,82},  14,1 , 15880,29 , 13,5 , 4,0 , 5361,15 , 5376,6 ,     2,     1,     1,     6,     7 }, // UpperSorbian/Latin/Germany
    {    319,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {88,65,70},  32,4 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Kenyang/Latin/Cameroon
    {    320,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {67,65,68},  259,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     0,     7,     6,     7 }, // Mohawk/Latin/Canada
    {    321,    75,    91,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {71,78,70},  232,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     0,     0,     1,     6,     7 }, // Nko/Nko/Guinea
    {    323,     7,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {71,84,81},  327,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Kiche/Latin/Guatemala
    {    324,     7,   205,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {83,69,75},  214,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Southern Sami/Latin/Sweden
    {    325,     7,   205,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {83,69,75},  214,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Lule Sami/Latin/Sweden
    {    326,     7,    73,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 36017,140 , 158,27 , 344,48 , 344,48 , 158,27 , 19573,21 , 19594,70 , 85,14 , 19573,21 , 19664,73 , 19737,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 15909,11 , 8,5 , 4,0 , 5382,11 , 0,0 ,     2,     1,     1,     6,     7 }, // Inari Sami/Latin/Finland
    {    327,     7,    73,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {69,85,82},  14,1 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Skolt Sami/Latin/Finland
    {    328,     7,    13,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 53,10 , 63,17 , 37,5 , 8,10 , 344,48 , 344,48 , 158,27 , 344,48 , 344,48 , 158,27 , 0,28 , 0,28 , 85,14 , 0,28 , 0,28 , 85,14 , 0,2 , 0,2 , {65,85,68},  351,2 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Warlpiri/Latin/Australia
    {      0,      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,0,    0,0,    0,0,   0,0,     0,0,     0,0,     0,0,     0,0,     0,0,     0,0,     0,0,    0,0,    0,0,    0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0, {0,0,0}, 0,0, 0,0, 0,0, 0,0, 0, 0, 0, 0, 0, 0,0, 0,0 }  // trailing 0s
};

static const ushort list_pattern_part_data[] = {
0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x68, 0x65,
0x20, 0x25, 0x32, 0x25, 0x31, 0x1363, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x648, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x648, 0x25, 0x32, 0x25, 0x31, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x587, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x76, 0x259, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xf51,
0xf44, 0xf0b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x438, 0x20, 0x25, 0x32, 0x25, 0x31, 0x104a, 0x20, 0x25, 0x32, 0x25, 0x31,
0x104a, 0x20, 0x1014, 0x103e, 0x1004, 0x1037, 0x103a, 0x25, 0x32, 0x25, 0x31, 0x1014, 0x103e, 0x1004, 0x1037, 0x103a, 0x25, 0x32, 0x25, 0x31,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x200b, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x20, 0x25, 0x32, 0x25,
0x31, 0x3001, 0x25, 0x32, 0x25, 0x31, 0x548c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f,
0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x64,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6a, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x10d3,
0x10d0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x3ba, 0x3b1, 0x3b9, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa85, 0xaa8, 0xac7, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x5d5, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe9, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x64, 0x61, 0x6e,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x67, 0x75, 0x73,
0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xcae, 0xca4,
0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436, 0x4d9, 0x43d, 0x435, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436,
0x430, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbc0f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xec1, 0xea5, 0xeb0, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6d, 0x70, 0xe9, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x69, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x20, 0xd0e, 0xd28, 0xd4d, 0xd28, 0xd3f, 0xd35,
0x25, 0x31, 0x20, 0xd15, 0xd42, 0xd1f, 0xd3e, 0xd24, 0xd46, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x75, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x906, 0x923, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x930,
0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x200f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa05, 0xa24, 0xa47, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x219, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x4d5, 0x43c, 0x4d5, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x6e, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x79, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x63, 0x68, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbae, 0xbb1, 0xbcd,
0xbb1, 0xbc1, 0xbae, 0xbcd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xc2e, 0xc30, 0xc3f, 0xc2f, 0xc41, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6d, 0x6f, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x76, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x456, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20,
0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x32, 0x60c, 0x20, 0x25,
0x31, 0x25, 0x31, 0x20, 0x76, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0xe0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x6e, 0x65, 0x2d, 0x25, 0x32, 0x49, 0x2d, 0x25, 0x31, 0x20, 0x6e, 0x65, 0x2d, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x6e,
0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x1e3f,
0x62, 0x25b, 0x6e, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x70, 0x254, 0x70, 0x20, 0x25, 0x32,

};

static const ushort date_format_data[] = {
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d,
0x2d, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79,
0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x200f, 0x2f, 0x4d, 0x200f, 0x2f, 0x79, 0x79, 0x79, 0x79,
0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x569, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c,
0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x79, 0x79, 0x79,
0x79, 0x28, 0x27, 0x65, 0x27, 0x29, 0x27, 0x6b, 0x6f, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b,
0xf63, 0xf7c, 0xf0b, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x64, 0x64,
0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x104a, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x64, 0x64, 0x64, 0x64,
0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x20, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x2e, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x6e, 0x27, 0x20,
0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x4d,
0x2f, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79,
0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d,
0x2e, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d, 0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x27, 0x6d, 0x68, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x20, 0x5d1, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x2e,
0x20, 0x64, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x2c, 0x20, 0x64,
0x64, 0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79,
0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d,
0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x27, 0x436, 0x27, 0x2e, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x64,
0x2e, 0x79, 0x79, 0x79, 0x79, 0xb144, 0x20, 0x4d, 0xc6d4, 0x20, 0x64, 0xc77c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0x20, 0xe97, 0xeb5, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x27, 0x67, 0x61, 0x64, 0x61, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x27, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27,
0x64, 0x27, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64,
0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x74, 0x61, 0x27, 0x2019, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20,
0x27, 0x43e, 0x43d, 0x44b, 0x27, 0x20, 0x4d, 0x4d, 0x20, 0x27, 0x441, 0x430, 0x440, 0x44b, 0x43d, 0x27, 0x20, 0x64, 0x64, 0x64,
0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x62f,
0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x62f, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x69, 0x6c, 0x73, 0x27, 0x20, 0x64, 0x20, 0x27, 0x64, 0x61, 0x27, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x430, 0x437, 0x27, 0x64,
0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64,
0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79,
0x79, 0x64, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x20, 0x27, 0x435, 0x43b, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0xe17, 0xe35, 0xe48, 0x20, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1363, 0x20, 0x64, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1361, 0x20, 0x64,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x4d,
0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x60c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x440, 0x27,
0x2e, 0x79, 0x79, 0x79, 0x79, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x6cc, 0x6cc, 0x644, 0x20, 0x64, 0x20, 0x646, 0x686, 0x6cc, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x6a9, 0x648, 0x646, 0x6cc, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x27, 0x6e, 0x67, 0xe0, 0x79, 0x27, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x6e, 0x103, 0x6d, 0x27,
0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64,
0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x61, 0x6c, 0x27, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x6c, 0x69, 0x61, 0x27, 0x20,
0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0xe4, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x441, 0x44b, 0x43b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x64, 0x20, 0x27, 0x43a, 0x4af, 0x43d, 0x44d, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x20,
0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x2c, 0x20, 0x27, 0x6c, 0x79, 0x25b, 0x27, 0x30c, 0x2bc, 0x20, 0x64,
0x20, 0x27, 0x6e, 0x61, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79
};

static const ushort time_format_data[] = {
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x68, 0x3a,
0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x3a,
0x6d, 0x6d, 0x48, 0x3a, 0x6d, 0x6d, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x2e, 0x6d, 0x6d,
0x2e, 0x20, 0x41, 0x50, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90,
0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20,
0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20,
0x74, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x74, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x41, 0x50,
0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x5b, 0x74, 0x5d, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d,
0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x2e,
0x73, 0x73, 0x20, 0x74, 0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20, 0x27,
0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74,
0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x68, 0x27, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x20,
0x41, 0x50, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x6642, 0x6d, 0x6d, 0x5206,
0x73, 0x73, 0x79d2, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0xc2dc, 0x20, 0x6d, 0xbd84,
0x20, 0x73, 0xcd08, 0x20, 0x74, 0x48, 0x20, 0xec2, 0xea1, 0xe87, 0x20, 0x6d, 0x20, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x73, 0x73,
0x20, 0xea7, 0xeb4, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29,
0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x27,
0x6b, 0x6c, 0x27, 0x2e, 0x20, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20, 0xe19, 0xe32, 0xe2c,
0xe34, 0xe01, 0xe32, 0x20, 0x6d, 0x6d, 0x20, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x73, 0x73, 0x20, 0xe27, 0xe34, 0xe19, 0xe32, 0xe17,
0xe35, 0x20, 0x74, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0x3a,
0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x74, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x48,
0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x68, 0x6f, 0x64, 0x17a, 0x27, 0x2e
};

static const ushort months_data[] = {
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x63, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x31, 0x3b,
0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31,
0x31, 0x3b, 0x31, 0x32, 0x3b, 0x41, 0x6d, 0x61, 0x3b, 0x47, 0x75, 0x72, 0x3b, 0x42, 0x69, 0x74, 0x3b, 0x45, 0x6c, 0x62,
0x3b, 0x43, 0x61, 0x6d, 0x3b, 0x57, 0x61, 0x78, 0x3b, 0x41, 0x64, 0x6f, 0x3b, 0x48, 0x61, 0x67, 0x3b, 0x46, 0x75, 0x6c,
0x3b, 0x4f, 0x6e, 0x6b, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x41, 0x6d, 0x61, 0x6a, 0x6a, 0x69, 0x69,
0x3b, 0x47, 0x75, 0x72, 0x61, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x42, 0x69, 0x74, 0x6f, 0x6f, 0x74, 0x65,
0x65, 0x73, 0x73, 0x61, 0x3b, 0x45, 0x6c, 0x62, 0x61, 0x3b, 0x43, 0x61, 0x61, 0x6d, 0x73, 0x61, 0x3b, 0x57, 0x61, 0x78,
0x61, 0x62, 0x61, 0x6a, 0x6a, 0x69, 0x69, 0x3b, 0x41, 0x64, 0x6f, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x48,
0x61, 0x67, 0x61, 0x79, 0x79, 0x61, 0x3b, 0x46, 0x75, 0x75, 0x6c, 0x62, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6e, 0x6b, 0x6f,
0x6c, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x53, 0x61, 0x64, 0x61, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x75, 0x64,
0x64, 0x65, 0x65, 0x3b, 0x4d, 0x30, 0x31, 0x3b, 0x4d, 0x30, 0x32, 0x3b, 0x4d, 0x30, 0x33, 0x3b, 0x4d, 0x30, 0x34, 0x3b,
0x4d, 0x30, 0x35, 0x3b, 0x4d, 0x30, 0x36, 0x3b, 0x4d, 0x30, 0x37, 0x3b, 0x4d, 0x30, 0x38, 0x3b, 0x4d, 0x30, 0x39, 0x3b,
0x4d, 0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62,
0x2e, 0x3b, 0x4d, 0x72, 0x74, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a,
0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44,
0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69,
0x65, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x69, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x53,
0x68, 0x6b, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x50, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x51, 0x65, 0x72, 0x3b, 0x4b,
0x6f, 0x72, 0x3b, 0x47, 0x73, 0x68, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x54, 0x65, 0x74, 0x3b, 0x4e, 0xeb, 0x6e, 0x3b, 0x44,
0x68, 0x6a, 0x3b, 0x4a, 0x61, 0x6e, 0x61, 0x72, 0x3b, 0x53, 0x68, 0x6b, 0x75, 0x72, 0x74, 0x3b, 0x4d, 0x61, 0x72, 0x73,
0x3b, 0x50, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x51, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x3b, 0x4b,
0x6f, 0x72, 0x72, 0x69, 0x6b, 0x3b, 0x47, 0x75, 0x73, 0x68, 0x74, 0x3b, 0x53, 0x68, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x3b,
0x54, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x4e, 0xeb, 0x6e, 0x74, 0x6f, 0x72, 0x3b, 0x44, 0x68, 0x6a, 0x65, 0x74, 0x6f, 0x72,
0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x51, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x61, 0x72, 0x3b, 0x73, 0x68, 0x6b, 0x75, 0x72, 0x74, 0x3b, 0x6d, 0x61,
0x72, 0x73, 0x3b, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x71, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72,
0x3b, 0x6b, 0x6f, 0x72, 0x72, 0x69, 0x6b, 0x3b, 0x67, 0x75, 0x73, 0x68, 0x74, 0x3b, 0x73, 0x68, 0x74, 0x61, 0x74, 0x6f,
0x72, 0x3b, 0x74, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x6e, 0xeb, 0x6e, 0x74, 0x6f, 0x72, 0x3b, 0x64, 0x68, 0x6a, 0x65, 0x74,
0x6f, 0x72, 0x3b, 0x1303, 0x1295, 0x12e9, 0x3b, 0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x122a, 0x3b, 0x121c,
0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b, 0x1234, 0x1355, 0x1274, 0x3b, 0x12a6, 0x12ad, 0x1276,
0x3b, 0x1296, 0x126c, 0x121d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8, 0x122a, 0x3b, 0x134c, 0x1265, 0x1229, 0x12c8, 0x122a,
0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x122a, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b,
0x12a6, 0x1308, 0x1235, 0x1275, 0x3b, 0x1234, 0x1355, 0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6, 0x12ad, 0x1276, 0x1260, 0x122d, 0x3b, 0x1296, 0x126c,
0x121d, 0x1260, 0x122d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x1260, 0x122d, 0x3b, 0x1303, 0x3b, 0x134c, 0x3b, 0x121b, 0x3b, 0x12a4, 0x3b, 0x121c, 0x3b,
0x1301, 0x3b, 0x1301, 0x3b, 0x12a6, 0x3b, 0x1234, 0x3b, 0x12a6, 0x3b, 0x1296, 0x3b, 0x12f2, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b,
0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627,
0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x633, 0x637, 0x633,
0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628,
0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x648, 0x3b, 0x646,
0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x633, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x62c, 0x627, 0x646, 0x641, 0x64a, 0x3b, 0x641,
0x64a, 0x641, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x641, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b,
0x62c, 0x648, 0x627, 0x646, 0x3b, 0x62c, 0x648, 0x64a, 0x644, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x62a, 0x3b, 0x633, 0x628, 0x62a, 0x645,
0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633,
0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x623, 0x3b,
0x633, 0x3b, 0x623, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a,
0x3b, 0x634, 0x628, 0x627, 0x637, 0x3b, 0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a, 0x633, 0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627,
0x631, 0x3b, 0x62d, 0x632, 0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632, 0x3b, 0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644,
0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646,
0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b,
0x643, 0x3b, 0x634, 0x3b, 0x622, 0x3b, 0x646, 0x3b, 0x623, 0x3b, 0x62d, 0x3b, 0x62a, 0x3b, 0x622, 0x3b, 0x623, 0x3b, 0x62a, 0x3b,
0x62a, 0x3b, 0x643, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x634, 0x628, 0x627,
0x637, 0x3b, 0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a, 0x633, 0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627, 0x631, 0x3b, 0x62d, 0x632,
0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632, 0x3b, 0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644, 0x648, 0x644, 0x3b, 0x62a,
0x634, 0x631, 0x6cc, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x62b,
0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x64a, 0x646, 0x627, 0x64a,
0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x625, 0x628, 0x631, 0x64a, 0x644, 0x3b,
0x645, 0x627, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x634,
0x62a, 0x3b, 0x634, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628,
0x631, 0x3b, 0x62f, 0x62c, 0x645, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x625, 0x3b, 0x648, 0x3b, 0x646, 0x3b,
0x644, 0x3b, 0x63a, 0x3b, 0x634, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628,
0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b,
0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x632, 0x3b, 0x63a, 0x634, 0x62a, 0x3b, 0x634, 0x62a, 0x646,
0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x646, 0x628, 0x631, 0x3b, 0x62f, 0x62c, 0x646, 0x628,
0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x645, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x634, 0x3b,
0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x570, 0x576, 0x57e, 0x3b, 0x583, 0x57f, 0x57e, 0x3b, 0x574, 0x580, 0x57f, 0x3b, 0x561, 0x57a,
0x580, 0x3b, 0x574, 0x575, 0x57d, 0x3b, 0x570, 0x576, 0x57d, 0x3b, 0x570, 0x56c, 0x57d, 0x3b, 0x585, 0x563, 0x57d, 0x3b, 0x57d, 0x565,
0x57a, 0x3b, 0x570, 0x578, 0x56f, 0x3b, 0x576, 0x578, 0x575, 0x3b, 0x564, 0x565, 0x56f, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x57e, 0x561,
0x580, 0x3b, 0x583, 0x565, 0x57f, 0x580, 0x57e, 0x561, 0x580, 0x3b, 0x574, 0x561, 0x580, 0x57f, 0x3b, 0x561, 0x57a, 0x580, 0x56b, 0x56c,
0x3b, 0x574, 0x561, 0x575, 0x56b, 0x57d, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x3b, 0x570, 0x578, 0x582, 0x56c, 0x56b, 0x57d,
0x3b, 0x585, 0x563, 0x578, 0x57d, 0x57f, 0x578, 0x57d, 0x3b, 0x57d, 0x565, 0x57a, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x570,
0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x576, 0x578, 0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x564, 0x565,
0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x540, 0x3b, 0x553, 0x3b, 0x544, 0x3b, 0x531, 0x3b, 0x544, 0x3b, 0x540, 0x3b,
0x540, 0x3b, 0x555, 0x3b, 0x54d, 0x3b, 0x540, 0x3b, 0x546, 0x3b, 0x534, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x57e, 0x561, 0x580, 0x56b,
0x3b, 0x583, 0x565, 0x57f, 0x580, 0x57e, 0x561, 0x580, 0x56b, 0x3b, 0x574, 0x561, 0x580, 0x57f, 0x56b, 0x3b, 0x561, 0x57a, 0x580, 0x56b,
0x56c, 0x56b, 0x3b, 0x574, 0x561, 0x575, 0x56b, 0x57d, 0x56b, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x56b, 0x3b, 0x570, 0x578,
0x582, 0x56c, 0x56b, 0x57d, 0x56b, 0x3b, 0x585, 0x563, 0x578, 0x57d, 0x57f, 0x578, 0x57d, 0x56b, 0x3b, 0x57d, 0x565, 0x57a, 0x57f, 0x565,
0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x570, 0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x576, 0x578, 0x575,
0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x564, 0x565, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x99c, 0x9be,
0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0,
0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x3b, 0x9b8,
0x9c7, 0x9aa, 0x9cd, 0x99f, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x3b,
0x99c, 0x9be, 0x9a8, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b,
0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b,
0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b7, 0x9cd, 0x99f, 0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd, 0x9a4, 0x9c7, 0x9ae, 0x9cd,
0x9ac, 0x9f0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9f0, 0x3b, 0x9a8, 0x9f1, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x9a1,
0x9bf, 0x99a, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b,
0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79, 0x6e, 0x3b, 0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x3b,
0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x79, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76,
0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c,
0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x130, 0x79, 0x75, 0x6e, 0x3b, 0x130, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x71, 0x75, 0x73,
0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4e,
0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x79, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b,
0x66, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x61,
0x79, 0x3b, 0x69, 0x79, 0x75, 0x6e, 0x3b, 0x69, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0x79, 0x61,
0x62, 0x72, 0x3b, 0x64, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x458, 0x430, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432,
0x440, 0x430, 0x43b, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438,
0x458, 0x443, 0x43d, 0x3b, 0x438, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442,
0x458, 0x430, 0x431, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43d, 0x43e, 0x458, 0x430, 0x431, 0x440, 0x3b,
0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0x55, 0x72, 0x74, 0x2e, 0x3b, 0x4f, 0x74, 0x73, 0x2e, 0x3b, 0x4d, 0x61, 0x72,
0x2e, 0x3b, 0x41, 0x70, 0x69, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x2e, 0x3b, 0x45, 0x6b, 0x61, 0x2e, 0x3b, 0x55, 0x7a, 0x74,
0x2e, 0x3b, 0x41, 0x62, 0x75, 0x2e, 0x3b, 0x49, 0x72, 0x61, 0x2e, 0x3b, 0x55, 0x72, 0x72, 0x2e, 0x3b, 0x41, 0x7a, 0x61,
0x2e, 0x3b, 0x41, 0x62, 0x65, 0x2e, 0x3b, 0x55, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69, 0x6c, 0x61, 0x3b, 0x4f, 0x74, 0x73,
0x61, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x3b, 0x41, 0x70, 0x69, 0x72, 0x69, 0x6c, 0x61,
0x3b, 0x4d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x3b, 0x45, 0x6b, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x55, 0x7a, 0x74, 0x61,
0x69, 0x6c, 0x61, 0x3b, 0x41, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x3b, 0x49, 0x72, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x55,
0x72, 0x72, 0x69, 0x61, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x41, 0x62, 0x65, 0x6e, 0x64, 0x75, 0x61, 0x3b,
0x55, 0x3b, 0x4f, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x55, 0x3b,
0x41, 0x3b, 0x41, 0x3b, 0x75, 0x72, 0x74, 0x2e, 0x3b, 0x6f, 0x74, 0x73, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61,
0x70, 0x69, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x2e, 0x3b, 0x65, 0x6b, 0x61, 0x2e, 0x3b, 0x75, 0x7a, 0x74, 0x2e, 0x3b, 0x61,
0x62, 0x75, 0x2e, 0x3b, 0x69, 0x72, 0x61, 0x2e, 0x3b, 0x75, 0x72, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x61, 0x2e, 0x3b, 0x61,
0x62, 0x65, 0x2e, 0x3b, 0x75, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69, 0x6c, 0x61, 0x6b, 0x3b, 0x6f, 0x74, 0x73, 0x61, 0x69,
0x6c, 0x61, 0x6b, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x6b, 0x3b, 0x61, 0x70, 0x69, 0x72, 0x69, 0x6c, 0x61,
0x6b, 0x3b, 0x6d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x6b, 0x3b, 0x65, 0x6b, 0x61, 0x69, 0x6e, 0x61, 0x6b, 0x3b, 0x75,
0x7a, 0x74, 0x61, 0x69, 0x6c, 0x61, 0x6b, 0x3b, 0x61, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x6b, 0x3b, 0x69, 0x72, 0x61,
0x69, 0x6c, 0x61, 0x6b, 0x3b, 0x75, 0x72, 0x72, 0x69, 0x61, 0x6b, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x6b, 0x3b,
0x61, 0x62, 0x65, 0x6e, 0x64, 0x75, 0x61, 0x6b, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ab,
0x9c7, 0x9ac, 0x9cd, 0x9b0, 0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd,
0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8,
0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac,
0x9b0, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c,
0x9be, 0x3b, 0x9ab, 0x9c7, 0x3b, 0x9ae, 0x9be, 0x3b, 0x98f, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x3b,
0x986, 0x3b, 0x9b8, 0x9c7, 0x3b, 0x985, 0x3b, 0x9a8, 0x3b, 0x9a1, 0x9bf, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf22, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf23, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf25, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf26, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf27, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf29, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf21, 0xf20, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf22, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b,
0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42,
0xf0b, 0xf54, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66,
0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72,
0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45,
0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49,
0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0xf24, 0x3b, 0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b,
0xf28, 0x3b, 0xf29, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0xf21, 0xf22, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0xf24,
0x3b, 0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b, 0xf29, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0x31, 0x32, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0x34, 0x3b,
0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b, 0x39, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0xf21, 0xf22, 0x3b, 0x47,
0x65, 0x6e, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61,
0x65, 0x3b, 0x4d, 0x65, 0x7a, 0x68, 0x3b, 0x47, 0x6f, 0x75, 0x65, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65,
0x6e, 0x3b, 0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x72, 0x3b, 0x47, 0x65, 0x6e, 0x76, 0x65, 0x72,
0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x45, 0x62,
0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a, 0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x47, 0x6f, 0x75,
0x65, 0x72, 0x65, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x48, 0x65,
0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x72, 0x7a, 0x75, 0x3b, 0x30, 0x31, 0x3b, 0x30, 0x32, 0x3b, 0x30, 0x33,
0x3b, 0x30, 0x34, 0x3b, 0x30, 0x35, 0x3b, 0x30, 0x36, 0x3b, 0x30, 0x37, 0x3b, 0x30, 0x38, 0x3b, 0x30, 0x39, 0x3b, 0x31,
0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x44f, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430,
0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b,
0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c,
0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f, 0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430,
0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d,
0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432,
0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b,
0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x44f, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x44e,
0x3b, 0x44e, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x1007, 0x1014, 0x103a, 0x3b, 0x1016, 0x1031, 0x3b,
0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x1015, 0x103c, 0x102e, 0x3b, 0x1019, 0x1031, 0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x3b,
0x1029, 0x3b, 0x1005, 0x1000, 0x103a, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a, 0x3b, 0x1014, 0x102d, 0x102f, 0x3b, 0x1012, 0x102e, 0x3b, 0x1007,
0x1014, 0x103a, 0x1014, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1016, 0x1031, 0x1016, 0x1031, 0x102c, 0x103a, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1019,
0x1010, 0x103a, 0x3b, 0x1027, 0x1015, 0x103c, 0x102e, 0x3b, 0x1019, 0x1031, 0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x101c, 0x102d,
0x102f, 0x1004, 0x103a, 0x3b, 0x1029, 0x1002, 0x102f, 0x1010, 0x103a, 0x3b, 0x1005, 0x1000, 0x103a, 0x1010, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1021,
0x1031, 0x102c, 0x1000, 0x103a, 0x1010, 0x102d, 0x102f, 0x1018, 0x102c, 0x3b, 0x1014, 0x102d, 0x102f, 0x101d, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1012,
0x102e, 0x1007, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1007, 0x3b, 0x1016, 0x3b, 0x1019, 0x3b, 0x1027, 0x3b, 0x1019, 0x3b, 0x1007, 0x3b, 0x1007,
0x3b, 0x1029, 0x3b, 0x1005, 0x3b, 0x1021, 0x3b, 0x1014, 0x3b, 0x1012, 0x3b, 0x441, 0x442, 0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441,
0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x447, 0x44d, 0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436,
0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a, 0x430, 0x441, 0x3b, 0x43b, 0x456, 0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441,
0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x44e, 0x442, 0x44b, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a,
0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456, 0x43a, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d,
0x44c, 0x3b, 0x43b, 0x456, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x436, 0x43d, 0x456, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440,
0x430, 0x441, 0x435, 0x43d, 0x44c, 0x3b, 0x43a, 0x430, 0x441, 0x442, 0x440, 0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x3b, 0x43b, 0x456, 0x441,
0x442, 0x430, 0x43f, 0x430, 0x434, 0x3b, 0x441, 0x43d, 0x435, 0x436, 0x430, 0x43d, 0x44c, 0x3b, 0x441, 0x3b, 0x43b, 0x3b, 0x441, 0x3b,
0x43a, 0x3b, 0x43c, 0x3b, 0x447, 0x3b, 0x43b, 0x3b, 0x436, 0x3b, 0x432, 0x3b, 0x43a, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x441, 0x442,
0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x447, 0x44d,
0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a, 0x430, 0x441, 0x3b, 0x43b, 0x456,
0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44f, 0x3b, 0x43b, 0x44e, 0x442, 0x430, 0x433,
0x430, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a, 0x430, 0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456, 0x43a, 0x430,
0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d, 0x44f, 0x3b, 0x43b, 0x456, 0x43f, 0x435, 0x43d, 0x44f, 0x3b,
0x436, 0x43d, 0x456, 0x45e, 0x43d, 0x44f, 0x3b, 0x432, 0x435, 0x440, 0x430, 0x441, 0x43d, 0x44f, 0x3b, 0x43a, 0x430, 0x441, 0x442, 0x440,
0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x430, 0x3b, 0x43b, 0x456, 0x441, 0x442, 0x430, 0x43f, 0x430, 0x434, 0x430, 0x3b, 0x441, 0x43d, 0x435,
0x436, 0x43d, 0x44f, 0x3b, 0x1798, 0x1780, 0x179a, 0x17b6, 0x3b, 0x1780, 0x17bb, 0x1798, 0x17d2, 0x1797, 0x17c8, 0x3b, 0x1798, 0x17b8, 0x1793, 0x17b6,
0x3b, 0x1798, 0x17c1, 0x179f, 0x17b6, 0x3b, 0x17a7, 0x179f, 0x1797, 0x17b6, 0x3b, 0x1798, 0x17b7, 0x1790, 0x17bb, 0x1793, 0x17b6, 0x3b, 0x1780, 0x1780,
0x17d2, 0x1780, 0x178a, 0x17b6, 0x3b, 0x179f, 0x17b8, 0x17a0, 0x17b6, 0x3b, 0x1780, 0x1789, 0x17d2, 0x1789, 0x17b6, 0x3b, 0x178f, 0x17bb, 0x179b, 0x17b6,
0x3b, 0x179c, 0x17b7, 0x1785, 0x17d2, 0x1786, 0x17b7, 0x1780, 0x17b6, 0x3b, 0x1792, 0x17d2, 0x1793, 0x17bc, 0x3b, 0x67, 0x65, 0x6e, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x67,
0x3b, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b,
0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d,
0x61, 0x69, 0x67, 0x3b, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x73,
0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x47, 0x4e, 0x3b,
0x46, 0x42, 0x3b, 0x4d, 0xc7, 0x3b, 0x41, 0x42, 0x3b, 0x4d, 0x47, 0x3b, 0x4a, 0x4e, 0x3b, 0x4a, 0x4c, 0x3b, 0x41, 0x47,
0x3b, 0x53, 0x54, 0x3b, 0x4f, 0x43, 0x3b, 0x4e, 0x56, 0x3b, 0x44, 0x53, 0x3b, 0x64, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65,
0x72, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b,
0x64, 0x2019, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x64, 0x65, 0x20, 0x6a,
0x75, 0x6e, 0x79, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73,
0x74, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x74, 0x75,
0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x64,
0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b, 0x34, 0x6708, 0x3b,
0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31,
0x31, 0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x3b, 0x4e00, 0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b, 0x4e94,
0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708,
0x3b, 0x5341, 0x4e8c, 0x6708, 0x3b, 0x73, 0x69, 0x6a, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x3b, 0x6f, 0x17e, 0x75, 0x3b, 0x74, 0x72,
0x61, 0x3b, 0x73, 0x76, 0x69, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x72, 0x70, 0x3b, 0x6b, 0x6f, 0x6c, 0x3b, 0x72, 0x75,
0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x73, 0x74, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x61,
0x6e, 0x6a, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x61, 0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x61, 0x6b, 0x3b, 0x74, 0x72,
0x61, 0x76, 0x61, 0x6e, 0x6a, 0x3b, 0x73, 0x76, 0x69, 0x62, 0x61, 0x6e, 0x6a, 0x3b, 0x6c, 0x69, 0x70, 0x61, 0x6e, 0x6a,
0x3b, 0x73, 0x72, 0x70, 0x61, 0x6e, 0x6a, 0x3b, 0x6b, 0x6f, 0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x3b, 0x72, 0x75, 0x6a, 0x61,
0x6e, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x69, 0x3b, 0x70,
0x72, 0x6f, 0x73, 0x69, 0x6e, 0x61, 0x63, 0x3b, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b,
0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b, 0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31,
0x31, 0x2e, 0x3b, 0x31, 0x32, 0x2e, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x6e, 0x6a, 0x61, 0x3b, 0x76, 0x65, 0x6c, 0x6a,
0x61, 0x10d, 0x65, 0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x6b, 0x61, 0x3b, 0x74, 0x72, 0x61, 0x76, 0x6e, 0x6a, 0x61, 0x3b, 0x73,
0x76, 0x69, 0x62, 0x6e, 0x6a, 0x61, 0x3b, 0x6c, 0x69, 0x70, 0x6e, 0x6a, 0x61, 0x3b, 0x73, 0x72, 0x70, 0x6e, 0x6a, 0x61,
0x3b, 0x6b, 0x6f, 0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x61, 0x3b, 0x72, 0x75, 0x6a, 0x6e, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74,
0x6f, 0x70, 0x61, 0x64, 0x61, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x6f, 0x67, 0x61, 0x3b, 0x70, 0x72, 0x6f, 0x73,
0x69, 0x6e, 0x63, 0x61, 0x3b, 0x6c, 0x65, 0x64, 0x3b, 0xfa, 0x6e, 0x6f, 0x3b, 0x62, 0x159, 0x65, 0x3b, 0x64, 0x75, 0x62,
0x3b, 0x6b, 0x76, 0x11b, 0x3b, 0x10d, 0x76, 0x6e, 0x3b, 0x10d, 0x76, 0x63, 0x3b, 0x73, 0x72, 0x70, 0x3b, 0x7a, 0xe1, 0x159,
0x3b, 0x159, 0xed, 0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x70, 0x72, 0x6f, 0x3b, 0x6c, 0x65, 0x64, 0x65, 0x6e, 0x3b, 0xfa,
0x6e, 0x6f, 0x72, 0x3b, 0x62, 0x159, 0x65, 0x7a, 0x65, 0x6e, 0x3b, 0x64, 0x75, 0x62, 0x65, 0x6e, 0x3b, 0x6b, 0x76, 0x11b,
0x74, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65, 0x63, 0x3b,
0x73, 0x72, 0x70, 0x65, 0x6e, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x65, 0x6e, 0x3b, 0x6c, 0x69, 0x73,
0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x65, 0x63, 0x3b, 0x6c, 0x65, 0x64, 0x6e, 0x61,
0x3b, 0xfa, 0x6e, 0x6f, 0x72, 0x61, 0x3b, 0x62, 0x159, 0x65, 0x7a, 0x6e, 0x61, 0x3b, 0x64, 0x75, 0x62, 0x6e, 0x61, 0x3b,
0x6b, 0x76, 0x11b, 0x74, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e,
0x63, 0x65, 0x3b, 0x73, 0x72, 0x70, 0x6e, 0x61, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x6e, 0x61, 0x3b,
0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a,
0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75,
0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e,
0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b,
0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b,
0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b,
0x4d, 0x72, 0x74, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a,
0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e,
0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x63, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62,
0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73,
0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e,
0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x72, 0x74, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x69,
0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e,
0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75,
0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x61,
0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61,
0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b,
0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x3b, 0x76, 0x65, 0x65, 0x62, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73,
0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69,
0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65,
0x74, 0x73, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x76, 0x65, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b,
0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75,
0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61,
0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75,
0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f,
0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69,
0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69,
0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x3b,
0x6b, 0x65, 0x73, 0xe4, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x3b, 0x65, 0x6c, 0x6f, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x3b,
0x6c, 0x6f, 0x6b, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x3b, 0x74, 0x61,
0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x61, 0x61, 0x6c,
0x69, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f,
0x6b, 0x75, 0x75, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75, 0x75,
0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x75, 0x75, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6c, 0x6f, 0x6b, 0x61,
0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x6b,
0x75, 0x75, 0x3b, 0x54, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x48, 0x3b, 0x45, 0x3b, 0x53,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x65,
0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61,
0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75, 0x75,
0x74, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75,
0x74, 0x61, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b,
0x75, 0x75, 0x74, 0x61, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x76,
0x2e, 0x3b, 0x46, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x76, 0x72, 0x2e, 0x3b, 0x4d, 0x61,
0x69, 0x3b, 0x4a, 0x75, 0x69, 0x6e, 0x3b, 0x4a, 0x75, 0x69, 0x6c, 0x2e, 0x3b, 0x41, 0x6f, 0xfb, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x2e, 0x3b, 0x4f, 0x63, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0xe9, 0x63, 0x2e, 0x3b, 0x4a,
0x61, 0x6e, 0x76, 0x69, 0x65, 0x72, 0x3b, 0x46, 0xe9, 0x76, 0x72, 0x69, 0x65, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b,
0x41, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x69, 0x6e, 0x3b, 0x4a, 0x75, 0x69, 0x6c, 0x6c,
0x65, 0x74, 0x3b, 0x41, 0x6f, 0xfb, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x63,
0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0xe9, 0x63, 0x65, 0x6d,
0x62, 0x72, 0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73,
0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x2e,
0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76,
0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x72, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x69,
0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75,
0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x65, 0x74, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x64, 0xe9, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b,
0x6d, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b,
0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b,
0x6a, 0x61, 0x6e, 0x6e, 0x65, 0x77, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x77, 0x61, 0x72, 0x69,
0x73, 0x3b, 0x6d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x61, 0x69, 0x65, 0x3b,
0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x79, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x69, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76,
0x69, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x69, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x72, 0x74, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a,
0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f,
0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x46, 0x61, 0x6f, 0x69, 0x3b, 0x47,
0x65, 0x61, 0x72, 0x72, 0x3b, 0x4d, 0xe0, 0x72, 0x74, 0x3b, 0x47, 0x69, 0x62, 0x6c, 0x3b, 0x43, 0xe8, 0x69, 0x74, 0x3b,
0xd2, 0x67, 0x6d, 0x68, 0x3b, 0x49, 0x75, 0x63, 0x68, 0x3b, 0x4c, 0xf9, 0x6e, 0x61, 0x3b, 0x53, 0x75, 0x6c, 0x74, 0x3b,
0x44, 0xe0, 0x6d, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x68, 0x3b, 0x44, 0xf9, 0x62, 0x68, 0x3b, 0x41, 0x6d, 0x20, 0x46, 0x61,
0x6f, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x63, 0x68, 0x3b, 0x41, 0x6e, 0x20, 0x47, 0x65, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x3b,
0x41, 0x6d, 0x20, 0x4d, 0xe0, 0x72, 0x74, 0x3b, 0x41, 0x6e, 0x20, 0x47, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x6e, 0x3b, 0x41,
0x6e, 0x20, 0x43, 0xe8, 0x69, 0x74, 0x65, 0x61, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0xd2, 0x67, 0x6d, 0x68, 0x69,
0x6f, 0x73, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x49, 0x75, 0x63, 0x68, 0x61, 0x72, 0x3b, 0x41, 0x6e, 0x20, 0x4c, 0xf9,
0x6e, 0x61, 0x73, 0x74, 0x61, 0x6c, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x75, 0x6c, 0x74, 0x61, 0x69, 0x6e, 0x3b,
0x41, 0x6e, 0x20, 0x44, 0xe0, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x61, 0x6d, 0x68,
0x61, 0x69, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x44, 0xf9, 0x62, 0x68, 0x6c, 0x61, 0x63, 0x68, 0x64, 0x3b, 0x46, 0x3b, 0x47,
0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x43, 0x3b, 0xd2, 0x3b, 0x49, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x44,
0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x46, 0x68, 0x61, 0x6f, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x63, 0x68, 0x3b, 0x64, 0x68,
0x65, 0x6e, 0x20, 0x47, 0x68, 0x65, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x4d, 0x68, 0xe0,
0x72, 0x74, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x47, 0x68, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65,
0x6e, 0x20, 0x43, 0x68, 0xe8, 0x69, 0x74, 0x65, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0xd2, 0x67, 0x6d, 0x68,
0x69, 0x6f, 0x73, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x49, 0x75, 0x63, 0x68, 0x61, 0x72, 0x3b, 0x64, 0x68, 0x65, 0x6e,
0x20, 0x4c, 0xf9, 0x6e, 0x61, 0x73, 0x74, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x75, 0x6c,
0x74, 0x61, 0x69, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x44, 0xe0, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x64, 0x68,
0x65, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x44, 0xf9,
0x62, 0x68, 0x6c, 0x61, 0x63, 0x68, 0x64, 0x3b, 0x58, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x58, 0x75, 0xf1, 0x3b, 0x58, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b,
0x53, 0x65, 0x74, 0x3b, 0x4f, 0x75, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x58, 0x61, 0x6e, 0x65,
0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41,
0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x58, 0x75, 0xf1, 0x6f, 0x3b, 0x58, 0x75, 0x6c, 0x6c, 0x6f,
0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x75, 0x74,
0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x72, 0x6f, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x78, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61,
0x62, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x78, 0x75, 0xf1, 0x3b, 0x78, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73,
0x65, 0x74, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x78, 0x61, 0x6e, 0x65, 0x69,
0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x78, 0x75, 0xf1, 0x6f, 0x3b, 0x78, 0x75, 0x6c, 0x6c, 0x6f, 0x3b,
0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x75, 0x74, 0x75,
0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72,
0x6f, 0x3b, 0x10d8, 0x10d0, 0x10dc, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x3b, 0x10db, 0x10d0,
0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x3b, 0x10d0, 0x10d2, 0x10d5, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x3b, 0x10dd, 0x10e5,
0x10e2, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x3b, 0x10d8, 0x10d0, 0x10dc, 0x10d5, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10d7, 0x10d4,
0x10d1, 0x10d4, 0x10e0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x10e2, 0x10d8, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x10d8, 0x10da, 0x10d8,
0x3b, 0x10db, 0x10d0, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x10d8, 0x10e1, 0x10d8,
0x3b, 0x10d0, 0x10d2, 0x10d5, 0x10d8, 0x10e1, 0x10e2, 0x10dd, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x10e2, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b,
0x10dd, 0x10e5, 0x10e2, 0x10dd, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d3,
0x10d4, 0x10d9, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d7, 0x3b, 0x10db, 0x3b, 0x10d0, 0x3b, 0x10db, 0x3b, 0x10d8,
0x3b, 0x10d8, 0x3b, 0x10d0, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10dc, 0x3b, 0x10d3, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62,
0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c,
0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a,
0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a,
0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69,
0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b,
0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41,
0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75,
0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65,
0x7a, 0x2e, 0x3b, 0x4a, 0xe4, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d,
0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0xe4, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x46, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69,
0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0xe4, 0x6e, 0x2e, 0x3b, 0x46,
0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b,
0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2,
0x3b, 0x39c, 0x3ac, 0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3ac, 0x3b9, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b, 0x399, 0x3bf,
0x3cd, 0x3bb, 0x3b, 0x391, 0x3cd, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3b, 0x394,
0x3b5, 0x3ba, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3ac, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5,
0x3ac, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39c, 0x3ac, 0x3c1, 0x3c4, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3af, 0x3bb, 0x3b9,
0x3bf, 0x3c2, 0x3b, 0x39c, 0x3ac, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd,
0x3bb, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x391, 0x3cd, 0x3b3, 0x3bf, 0x3c5, 0x3c3, 0x3c4, 0x3bf, 0x3c2, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3ad,
0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3ce, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39d, 0x3bf, 0x3ad,
0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3b,
0x3a6, 0x3b, 0x39c, 0x3b, 0x391, 0x3b, 0x39c, 0x3b, 0x399, 0x3b, 0x399, 0x3b, 0x391, 0x3b, 0x3a3, 0x3b, 0x39f, 0x3b, 0x39d, 0x3b,
0x394, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3b1,
0x390, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b,
0x39f, 0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af,
0x3bf, 0x3c5, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3c4, 0x3af,
0x3bf, 0x3c5, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b9, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x390, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf,
0x3c5, 0x3bd, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3bf, 0x3cd, 0x3c3,
0x3c4, 0x3bf, 0x3c5, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3c9,
0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b5,
0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75,
0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x61,
0x6a, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75,
0x73, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65,
0x72, 0x69, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x69, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0x3b, 0xaae, 0xabe, 0xab0,
0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2,
0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacb,
0x3b, 0xaa8, 0xab5, 0xac7, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b,
0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0,
0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd,
0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacb, 0xaac, 0xab0, 0x3b,
0xaa8, 0xab5, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa9c, 0xabe, 0x3b,
0xaab, 0xac7, 0x3b, 0xaae, 0xabe, 0x3b, 0xa8f, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0x3b, 0xa9c, 0xac1, 0x3b, 0xa91, 0x3b, 0xab8,
0x3b, 0xa91, 0x3b, 0xaa8, 0x3b, 0xaa1, 0xabf, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0,
0xac1, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2,
0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0x3b, 0xa91, 0xa95, 0xacd,
0xa9f, 0xacb, 0x3b, 0xaa8, 0xab5, 0xac7, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x61, 0x62, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x66, 0x69, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b,
0x41, 0x67, 0x75, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x75, 0x77, 0x3b, 0x44, 0x69, 0x73, 0x3b,
0x4a, 0x61, 0x6e, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x46, 0x61, 0x62, 0x75, 0x72, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x4d, 0x61,
0x72, 0x69, 0x73, 0x3b, 0x41, 0x66, 0x69, 0x72, 0x69, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e,
0x69, 0x3b, 0x59, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x74, 0x75, 0x6d, 0x62,
0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x75, 0x77, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73,
0x61, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x41,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5f3, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5f3, 0x3b, 0x5de,
0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5f3, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc,
0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5f3, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5f3, 0x3b, 0x5d0, 0x5d5, 0x5e7, 0x5f3, 0x3b, 0x5e0, 0x5d5, 0x5d1,
0x5f3, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5f3, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5d5, 0x5d0, 0x5e8, 0x3b,
0x5de, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5d9, 0x5dc, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9,
0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5d5, 0x5e1, 0x5d8, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d0, 0x5d5,
0x5e7, 0x5d8, 0x5d5, 0x5d1, 0x5e8, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x91c,
0x928, 0x970, 0x3b, 0x92b, 0x93c, 0x930, 0x970, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932,
0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x970, 0x3b, 0x905, 0x917, 0x970, 0x3b, 0x938, 0x93f, 0x924,
0x970, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x970, 0x3b, 0x928, 0x935, 0x970, 0x3b, 0x926, 0x93f, 0x938, 0x970, 0x3b, 0x91c, 0x928,
0x935, 0x930, 0x940, 0x3b, 0x92b, 0x93c, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d,
0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938,
0x94d, 0x924, 0x3b, 0x938, 0x93f, 0x924, 0x902, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935,
0x902, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x93c, 0x3b, 0x92e, 0x93e, 0x3b, 0x905,
0x3b, 0x92e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x3b, 0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f,
0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x2e, 0x3b, 0xe1, 0x70,
0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x6a, 0x2e, 0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c, 0x2e, 0x3b, 0x61, 0x75,
0x67, 0x2e, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b,
0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b,
0x6d, 0xe1, 0x72, 0x63, 0x69, 0x75, 0x73, 0x3b, 0xe1, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0xe1, 0x6a, 0x75,
0x73, 0x3b, 0x6a, 0xfa, 0x6e, 0x69, 0x75, 0x73, 0x3b, 0x6a, 0xfa, 0x6c, 0x69, 0x75, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75,
0x73, 0x7a, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74,
0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0xc1, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53,
0x7a, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61,
0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c,
0x2e, 0x3b, 0xe1, 0x67, 0xfa, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0xf3, 0x76,
0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0xfa, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0xfa, 0x61,
0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e,
0xed, 0x3b, 0x6a, 0xfa, 0x6c, 0xed, 0x3b, 0xe1, 0x67, 0xfa, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0xf3, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a,
0x3b, 0x4a, 0x3b, 0xc1, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62,
0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c,
0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73,
0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61,
0x72, 0x65, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a,
0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44,
0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x45, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x61, 0x62, 0x68, 0x3b, 0x4d, 0xe1,
0x72, 0x74, 0x61, 0x3b, 0x41, 0x69, 0x62, 0x3b, 0x42, 0x65, 0x61, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x74, 0x68, 0x3b, 0x49,
0xfa, 0x69, 0x6c, 0x3b, 0x4c, 0xfa, 0x6e, 0x3b, 0x4d, 0x46, 0xf3, 0x6d, 0x68, 0x3b, 0x44, 0x46, 0xf3, 0x6d, 0x68, 0x3b,
0x53, 0x61, 0x6d, 0x68, 0x3b, 0x4e, 0x6f, 0x6c, 0x6c, 0x3b, 0x45, 0x61, 0x6e, 0xe1, 0x69, 0x72, 0x3b, 0x46, 0x65, 0x61,
0x62, 0x68, 0x72, 0x61, 0x3b, 0x4d, 0xe1, 0x72, 0x74, 0x61, 0x3b, 0x41, 0x69, 0x62, 0x72, 0x65, 0xe1, 0x6e, 0x3b, 0x42,
0x65, 0x61, 0x6c, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x74, 0x68, 0x65, 0x61, 0x6d, 0x68, 0x3b, 0x49,
0xfa, 0x69, 0x6c, 0x3b, 0x4c, 0xfa, 0x6e, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x65, 0xe1, 0x6e, 0x20, 0x46, 0xf3, 0x6d, 0x68,
0x61, 0x69, 0x72, 0x3b, 0x44, 0x65, 0x69, 0x72, 0x65, 0x61, 0x64, 0x68, 0x20, 0x46, 0xf3, 0x6d, 0x68, 0x61, 0x69, 0x72,
0x3b, 0x53, 0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e, 0x3b, 0x4e, 0x6f, 0x6c, 0x6c, 0x61, 0x69, 0x67, 0x3b, 0x45, 0x3b, 0x46,
0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x42, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x4e,
0x3b, 0x67, 0x65, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x67,
0x3b, 0x67, 0x69, 0x75, 0x3b, 0x6c, 0x75, 0x67, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x74, 0x74,
0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x47, 0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f, 0x3b, 0x46, 0x65, 0x62,
0x62, 0x72, 0x61, 0x69, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x4d,
0x61, 0x67, 0x67, 0x69, 0x6f, 0x3b, 0x47, 0x69, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x4c, 0x75, 0x67, 0x6c, 0x69, 0x6f, 0x3b,
0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x74, 0x74,
0x6f, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x67, 0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x62, 0x72,
0x61, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x6d, 0x61, 0x67,
0x67, 0x69, 0x6f, 0x3b, 0x67, 0x69, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x6c, 0x75, 0x67, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67,
0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x74, 0x74, 0x6f, 0x62,
0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0xc9c, 0xca8, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd,
0xcb0, 0xcbf, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0x3b, 0xcb8,
0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0x3b, 0xca1, 0xcbf,
0xcb8, 0xcc6, 0xc82, 0x3b, 0xc9c, 0xca8, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcae,
0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0xcb2, 0xccd, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8,
0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0xcb8, 0xccd, 0xc9f, 0xccd, 0x3b, 0xcb8, 0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6,
0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0xcac, 0xcb0,
0xccd, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc9c, 0x3b, 0xcab, 0xcc6, 0x3b, 0xcae, 0xcbe, 0x3b, 0xc8f,
0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0x3b, 0xc9c, 0xcc1, 0x3b, 0xc86, 0x3b, 0xcb8, 0xcc6, 0x3b, 0xc85, 0x3b, 0xca8, 0x3b, 0xca1,
0xcbf, 0x3b, 0x62c, 0x646, 0x624, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x624, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x655, 0x686, 0x3b,
0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x654, 0x3b, 0x62c, 0x648, 0x657, 0x646, 0x3b, 0x62c, 0x648, 0x657, 0x644, 0x627,
0x6cc, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x657, 0x628,
0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b,
0x627, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x49b, 0x430,
0x4a3, 0x2e, 0x3b, 0x430, 0x49b, 0x43f, 0x2e, 0x3b, 0x43d, 0x430, 0x443, 0x2e, 0x3b, 0x441, 0x4d9, 0x443, 0x2e, 0x3b, 0x43c, 0x430,
0x43c, 0x2e, 0x3b, 0x43c, 0x430, 0x443, 0x2e, 0x3b, 0x448, 0x456, 0x43b, 0x2e, 0x3b, 0x442, 0x430, 0x43c, 0x2e, 0x3b, 0x49b, 0x44b,
0x440, 0x2e, 0x3b, 0x49b, 0x430, 0x437, 0x2e, 0x3b, 0x49b, 0x430, 0x440, 0x2e, 0x3b, 0x436, 0x435, 0x43b, 0x442, 0x2e, 0x3b, 0x49b,
0x430, 0x4a3, 0x442, 0x430, 0x440, 0x3b, 0x430, 0x49b, 0x43f, 0x430, 0x43d, 0x3b, 0x43d, 0x430, 0x443, 0x440, 0x44b, 0x437, 0x3b, 0x441,
0x4d9, 0x443, 0x456, 0x440, 0x3b, 0x43c, 0x430, 0x43c, 0x44b, 0x440, 0x3b, 0x43c, 0x430, 0x443, 0x441, 0x44b, 0x43c, 0x3b, 0x448, 0x456,
0x43b, 0x434, 0x435, 0x3b, 0x442, 0x430, 0x43c, 0x44b, 0x437, 0x3b, 0x49b, 0x44b, 0x440, 0x43a, 0x4af, 0x439, 0x435, 0x43a, 0x3b, 0x49b,
0x430, 0x437, 0x430, 0x43d, 0x3b, 0x49b, 0x430, 0x440, 0x430, 0x448, 0x430, 0x3b, 0x436, 0x435, 0x43b, 0x442, 0x43e, 0x49b, 0x441, 0x430,
0x43d, 0x3b, 0x49a, 0x3b, 0x410, 0x3b, 0x41d, 0x3b, 0x421, 0x3b, 0x41c, 0x3b, 0x41c, 0x3b, 0x428, 0x3b, 0x422, 0x3b, 0x49a, 0x3b,
0x49a, 0x3b, 0x49a, 0x3b, 0x416, 0x3b, 0x6d, 0x75, 0x74, 0x2e, 0x3b, 0x67, 0x61, 0x73, 0x2e, 0x3b, 0x77, 0x65, 0x72, 0x2e,
0x3b, 0x6d, 0x61, 0x74, 0x2e, 0x3b, 0x67, 0x69, 0x63, 0x2e, 0x3b, 0x6b, 0x61, 0x6d, 0x2e, 0x3b, 0x6e, 0x79, 0x61, 0x2e,
0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x6e, 0x7a, 0x65, 0x2e, 0x3b, 0x75, 0x6b, 0x77, 0x2e, 0x3b, 0x75, 0x67, 0x75, 0x2e,
0x3b, 0x75, 0x6b, 0x75, 0x2e, 0x3b, 0x4d, 0x75, 0x74, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0x47, 0x61, 0x73, 0x68, 0x79,
0x61, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x3b, 0x57, 0x65, 0x72, 0x75, 0x72, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x74, 0x61, 0x3b,
0x47, 0x69, 0x63, 0x75, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x65, 0x6e, 0x61, 0x3b, 0x4e, 0x79, 0x61,
0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x4b, 0x61, 0x6e, 0x61, 0x6d, 0x61, 0x3b, 0x4e, 0x7a, 0x65, 0x6c, 0x69, 0x3b, 0x55,
0x6b, 0x77, 0x61, 0x6b, 0x69, 0x72, 0x61, 0x3b, 0x55, 0x67, 0x75, 0x73, 0x68, 0x79, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x55,
0x6b, 0x75, 0x62, 0x6f, 0x7a, 0x61, 0x3b, 0x42f, 0x43d, 0x432, 0x3b, 0x424, 0x435, 0x432, 0x3b, 0x41c, 0x430, 0x440, 0x3b, 0x410,
0x43f, 0x440, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x3b, 0x421,
0x435, 0x43d, 0x3b, 0x41e, 0x43a, 0x442, 0x3b, 0x41d, 0x43e, 0x44f, 0x3b, 0x414, 0x435, 0x43a, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440,
0x44c, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b,
0x44c, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x443,
0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b,
0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x42f, 0x3b, 0x424, 0x3b, 0x41c,
0x3b, 0x410, 0x3b, 0x41c, 0x3b, 0x418, 0x3b, 0x418, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x41e, 0x3b, 0x41d, 0x3b, 0x414, 0x3b, 0x44f,
0x43d, 0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c,
0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x2e, 0x3b, 0x438, 0x44e, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435,
0x43d, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f, 0x43d,
0x432, 0x430, 0x440, 0x44c, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f,
0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430,
0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431,
0x440, 0x44c, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x31, 0xc6d4,
0x3b, 0x32, 0xc6d4, 0x3b, 0x33, 0xc6d4, 0x3b, 0x34, 0xc6d4, 0x3b, 0x35, 0xc6d4, 0x3b, 0x36, 0xc6d4, 0x3b, 0x37, 0xc6d4, 0x3b, 0x38,
0xc6d4, 0x3b, 0x39, 0xc6d4, 0x3b, 0x31, 0x30, 0xc6d4, 0x3b, 0x31, 0x31, 0xc6d4, 0x3b, 0x31, 0x32, 0xc6d4, 0x3b, 0x4d, 0x75, 0x74,
0x2e, 0x3b, 0x47, 0x61, 0x73, 0x2e, 0x3b, 0x57, 0x65, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x74, 0x2e, 0x3b, 0x47, 0x69, 0x63,
0x2e, 0x3b, 0x4b, 0x61, 0x6d, 0x2e, 0x3b, 0x4e, 0x79, 0x61, 0x2e, 0x3b, 0x4b, 0x61, 0x6e, 0x2e, 0x3b, 0x4e, 0x7a, 0x65,
0x2e, 0x3b, 0x55, 0x6b, 0x77, 0x2e, 0x3b, 0x55, 0x67, 0x75, 0x2e, 0x3b, 0x55, 0x6b, 0x75, 0x2e, 0x3b, 0x4e, 0x7a, 0x65,
0x72, 0x6f, 0x3b, 0x52, 0x75, 0x68, 0x75, 0x68, 0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x74, 0x77, 0x61, 0x72, 0x61, 0x6e, 0x74,
0x65, 0x3b, 0x4e, 0x64, 0x61, 0x6d, 0x75, 0x6b, 0x69, 0x7a, 0x61, 0x3b, 0x52, 0x75, 0x73, 0x61, 0x6d, 0x61, 0x3b, 0x52,
0x75, 0x68, 0x65, 0x73, 0x68, 0x69, 0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x6b, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6e,
0x64, 0x61, 0x67, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x47, 0x69, 0x74, 0x75,
0x67, 0x75, 0x74, 0x75, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x6f, 0x6e, 0x79, 0x6f, 0x3b, 0x4b, 0x69, 0x67, 0x61, 0x72, 0x61,
0x6d, 0x61, 0x3b, 0xea1, 0x2e, 0xe81, 0x2e, 0x3b, 0xe81, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0x2e, 0xe99, 0x2e, 0x3b, 0xea1, 0x2e,
0xeaa, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0xeb4, 0x2e, 0xe96, 0x2e, 0x3b, 0xe81, 0x2e, 0xea5, 0x2e, 0x3b, 0xeaa,
0x2e, 0xeab, 0x2e, 0x3b, 0xe81, 0x2e, 0xe8d, 0x2e, 0x3b, 0xe95, 0x2e, 0xea5, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe88, 0x2e, 0x3b, 0xe97,
0x2e, 0xea7, 0x2e, 0x3b, 0xea1, 0xeb1, 0xe87, 0xe81, 0xead, 0xe99, 0x3b, 0xe81, 0xeb8, 0xea1, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb5, 0xe99,
0xeb2, 0x3b, 0xec0, 0xea1, 0xeaa, 0xeb2, 0x3b, 0xe9e, 0xeb6, 0xe94, 0xeaa, 0xeb0, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb4, 0xe96, 0xeb8, 0xe99,
0xeb2, 0x3b, 0xe81, 0xecd, 0xea5, 0xeb0, 0xe81, 0xebb, 0xe94, 0x3b, 0xeaa, 0xeb4, 0xe87, 0xeab, 0xeb2, 0x3b, 0xe81, 0xeb1, 0xe99, 0xe8d,
0xeb2, 0x3b, 0xe95, 0xeb8, 0xea5, 0xeb2, 0x3b, 0xe9e, 0xeb0, 0xe88, 0xeb4, 0xe81, 0x3b, 0xe97, 0xeb1, 0xe99, 0xea7, 0xeb2, 0x3b, 0x4a,
0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x41, 0x70, 0x72,
0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x6a, 0x73, 0x3b, 0x4a, 0x16b, 0x6e, 0x2e, 0x3b, 0x4a, 0x16b, 0x6c, 0x2e, 0x3b, 0x41, 0x75,
0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44,
0x65, 0x63, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x76, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x101, 0x72,
0x69, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x41, 0x70, 0x72, 0x12b, 0x6c, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x69,
0x6a, 0x73, 0x3b, 0x4a, 0x16b, 0x6e, 0x69, 0x6a, 0x73, 0x3b, 0x4a, 0x16b, 0x6c, 0x69, 0x6a, 0x73, 0x3b, 0x41, 0x75, 0x67,
0x75, 0x73, 0x74, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x4f, 0x6b, 0x74, 0x6f,
0x62, 0x72, 0x69, 0x73, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d,
0x62, 0x72, 0x69, 0x73, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72,
0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x2e, 0x3b, 0x6a,
0x16b, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b,
0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x12b, 0x6c,
0x69, 0x73, 0x3b, 0x6d, 0x61, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6c, 0x69,
0x6a, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69,
0x73, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73,
0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x62, 0x6c, 0x3b, 0x6d,
0x73, 0x69, 0x3b, 0x61, 0x70, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x61,
0x67, 0x74, 0x3b, 0x73, 0x74, 0x62, 0x3b, 0x254, 0x74, 0x62, 0x3b, 0x6e, 0x76, 0x62, 0x3b, 0x64, 0x73, 0x62, 0x3b, 0x73,
0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20,
0x79, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d,
0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0x65, 0x69,
0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x73, 0xe1, 0x6e,
0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x6f, 0x74, 0xf3, 0x62, 0xe1, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79,
0x61, 0x20, 0x6e, 0x73, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x77,
0x61, 0x6d, 0x62, 0x65, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6c, 0x69, 0x62, 0x77, 0x61, 0x3b,
0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20,
0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x254, 0x30c, 0x6b, 0x254, 0x301, 0x3b, 0x73, 0xe1,
0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c,
0xe9, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x61, 0x3b, 0x73, 0x3b,
0x254, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x73, 0x61, 0x75, 0x73, 0x2e, 0x3b, 0x76, 0x61, 0x73, 0x2e, 0x3b, 0x6b, 0x6f, 0x76,
0x2e, 0x3b, 0x62, 0x61, 0x6c, 0x2e, 0x3b, 0x67, 0x65, 0x67, 0x2e, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x2e, 0x3b, 0x6c, 0x69,
0x65, 0x70, 0x2e, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x2e, 0x3b, 0x72, 0x75, 0x67, 0x73, 0x2e, 0x3b, 0x73, 0x70, 0x61, 0x6c,
0x2e, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x2e, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64, 0x2e, 0x3b, 0x73, 0x61, 0x75, 0x73,
0x69, 0x73, 0x3b, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x6b, 0x6f, 0x76, 0x61, 0x73, 0x3b, 0x62, 0x61, 0x6c,
0x61, 0x6e, 0x64, 0x69, 0x73, 0x3b, 0x67, 0x65, 0x67, 0x75, 0x17e, 0x117, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x65, 0x6c, 0x69,
0x73, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x61, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x6a, 0x16b, 0x74, 0x69, 0x73, 0x3b, 0x72, 0x75,
0x67, 0x73, 0x117, 0x6a, 0x69, 0x73, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x69,
0x74, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4b, 0x3b, 0x42, 0x3b,
0x47, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x52, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x47, 0x3b, 0x73, 0x61, 0x75, 0x73,
0x69, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69, 0x6f, 0x3b, 0x6b, 0x6f, 0x76, 0x6f, 0x3b, 0x62, 0x61, 0x6c, 0x61,
0x6e, 0x64, 0x17e, 0x69, 0x6f, 0x3b, 0x67, 0x65, 0x67, 0x75, 0x17e, 0x117, 0x73, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x65, 0x6c,
0x69, 0x6f, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x6f, 0x73, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x6a, 0x16b, 0x10d, 0x69, 0x6f, 0x3b,
0x72, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x6f, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x69, 0x6f, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72,
0x69, 0x10d, 0x69, 0x6f, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64, 0x17e, 0x69, 0x6f, 0x3b, 0x458, 0x430, 0x43d, 0x2e, 0x3b, 0x444,
0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443,
0x43d, 0x2e, 0x3b, 0x458, 0x443, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e, 0x3b, 0x43e,
0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430,
0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440,
0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433,
0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c, 0x432,
0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b,
0x458, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x458, 0x3b, 0x458, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b,
0x43d, 0x3b, 0x434, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f, 0x6e, 0x3b, 0x4a, 0x6f, 0x6c, 0x3b, 0x41, 0x6f, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6f, 0x61, 0x72, 0x79, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x6f, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x73, 0x61, 0x3b, 0x41, 0x70, 0x72, 0x69,
0x6c, 0x79, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f, 0x6e, 0x61, 0x3b, 0x4a, 0x6f, 0x6c, 0x61, 0x79, 0x3b, 0x41, 0x6f,
0x67, 0x6f, 0x73, 0x69, 0x74, 0x72, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x61, 0x6d,
0x62, 0x72, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xd1c, 0xd28,
0xd41, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0x3b, 0xd2e, 0xd3e, 0xd7c, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0x3b, 0xd2e,
0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0x3b, 0xd38, 0xd46, 0xd2a, 0xd4d,
0xd31, 0xd4d, 0xd31, 0xd02, 0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f, 0xd4b, 0x3b, 0xd28, 0xd35, 0xd02, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0x3b,
0xd1c, 0xd28, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2e, 0xd3e, 0xd7c,
0xd1a, 0xd4d, 0xd1a, 0xd4d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0xd7d, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd7a,
0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd06, 0xd17, 0xd38, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd4d, 0x3b, 0xd38, 0xd46, 0xd2a, 0xd4d, 0xd31,
0xd4d, 0xd31, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd12, 0xd15, 0xd4d, 0x200c, 0xd1f, 0xd4b, 0xd2c, 0xd7c, 0x3b, 0xd28, 0xd35, 0xd02, 0xd2c, 0xd7c,
0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd1c, 0x3b, 0xd2b, 0x3b, 0xd2e, 0xd3e, 0x3b, 0xd0f, 0x3b, 0xd2e, 0xd47, 0x3b,
0xd1c, 0xd42, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd13, 0x3b, 0xd38, 0x3b, 0xd12, 0x3b, 0xd28, 0x3b, 0xd21, 0xd3f, 0x3b, 0xd1c, 0x3b, 0xd2b,
0x3b, 0xd2e, 0xd3e, 0x3b, 0xd0f, 0x3b, 0xd2e, 0xd46, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd13, 0x3b, 0xd38, 0x3b, 0xd12,
0x3b, 0xd28, 0x3b, 0xd21, 0xd3f, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x72, 0x61, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70,
0x72, 0x3b, 0x4d, 0x65, 0x6a, 0x3b, 0x120, 0x75, 0x6e, 0x3b, 0x4c, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x77, 0x3b, 0x53, 0x65,
0x74, 0x3b, 0x4f, 0x74, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x10b, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x61, 0x72,
0x3b, 0x46, 0x72, 0x61, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65,
0x6a, 0x6a, 0x75, 0x3b, 0x120, 0x75, 0x6e, 0x6a, 0x75, 0x3b, 0x4c, 0x75, 0x6c, 0x6a, 0x75, 0x3b, 0x41, 0x77, 0x77, 0x69,
0x73, 0x73, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x74, 0x75, 0x62, 0x72,
0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x10b, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b,
0x4a, 0x6e, 0x3b, 0x46, 0x72, 0x3b, 0x4d, 0x7a, 0x3b, 0x41, 0x70, 0x3b, 0x4d, 0x6a, 0x3b, 0x120, 0x6e, 0x3b, 0x4c, 0x6a,
0x3b, 0x41, 0x77, 0x3b, 0x53, 0x74, 0x3b, 0x4f, 0x62, 0x3b, 0x4e, 0x76, 0x3b, 0x44, 0x10b, 0x3b, 0x4a, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x120, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b,
0x91c, 0x93e, 0x928, 0x947, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a,
0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x911, 0x917, 0x3b, 0x938,
0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x3b,
0x921, 0x93f, 0x938, 0x947, 0x902, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930,
0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e,
0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x911, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x92a, 0x94d,
0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947,
0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x93e, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e,
0x3b, 0x90f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x911, 0x3b, 0x938, 0x3b, 0x911, 0x3b, 0x928, 0x94b,
0x3b, 0x921, 0x93f, 0x3b, 0x31, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x32, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b,
0x33, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x34, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x35, 0x2d, 0x440, 0x20,
0x441, 0x430, 0x440, 0x3b, 0x36, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x37, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b,
0x38, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x39, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31, 0x30, 0x2d, 0x440,
0x20, 0x441, 0x430, 0x440, 0x3b, 0x31, 0x31, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31, 0x32, 0x2d, 0x440, 0x20, 0x441,
0x430, 0x440, 0x3b, 0x41d, 0x44d, 0x433, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x425, 0x43e, 0x451,
0x440, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x413, 0x443, 0x440, 0x430, 0x432, 0x434, 0x443, 0x433,
0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x414, 0x4e9, 0x440, 0x4e9, 0x432, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20,
0x441, 0x430, 0x440, 0x3b, 0x422, 0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x417, 0x443,
0x440, 0x433, 0x430, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x414, 0x43e, 0x43b, 0x434, 0x443, 0x433,
0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x41d, 0x430, 0x439, 0x43c, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441,
0x430, 0x440, 0x3b, 0x415, 0x441, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x430, 0x432,
0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x432, 0x430, 0x43d, 0x20, 0x43d, 0x44d, 0x433,
0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x432, 0x430, 0x43d, 0x20, 0x445, 0x43e, 0x451,
0x440, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x947,
0x92c, 0x94d, 0x930, 0x941, 0x905, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x932,
0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x91f, 0x3b,
0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928,
0x94b, 0x92d, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x967, 0x3b, 0x968,
0x3b, 0x969, 0x3b, 0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d, 0x3b, 0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967,
0x3b, 0x967, 0x968, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x905, 0x930, 0x940, 0x3b,
0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x941, 0x928, 0x3b,
0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x92e, 0x94d,
0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b,
0x921, 0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a,
0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62,
0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x2e,
0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e,
0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0xb1c, 0xb3e, 0xb28, 0xb41, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2b,
0xb47, 0xb2c, 0xb43, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2e, 0xb3e, 0xb30, 0xb4d, 0xb1a, 0xb4d, 0xb1a, 0x3b, 0xb05, 0xb2a, 0xb4d, 0xb30, 0xb47,
0xb32, 0x3b, 0xb2e, 0xb07, 0x3b, 0xb1c, 0xb41, 0xb28, 0x3b, 0xb1c, 0xb41, 0xb32, 0xb3e, 0xb07, 0x3b, 0xb05, 0xb17, 0xb37, 0xb4d, 0xb1f,
0x3b, 0xb38, 0xb47, 0xb2a, 0xb4d, 0xb1f, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb05, 0xb15, 0xb4d, 0xb1f, 0xb4b, 0xb2c, 0xb30, 0x3b,
0xb28, 0xb2d, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb21, 0xb3f, 0xb38, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb1c, 0xb3e, 0x3b,
0xb2b, 0xb47, 0x3b, 0xb2e, 0xb3e, 0x3b, 0xb05, 0x3b, 0xb2e, 0xb07, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb05, 0x3b, 0xb38,
0xb47, 0x3b, 0xb05, 0x3b, 0xb28, 0x3b, 0xb21, 0xb3f, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631,
0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b,
0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6ab, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9,
0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x698, 0x627, 0x646,
0x648, 0x6cc, 0x647, 0x3b, 0x641, 0x648, 0x631, 0x6cc, 0x647, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644,
0x3b, 0x645, 0x647, 0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633,
0x67e, 0x62a, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b,
0x62f, 0x633, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x698, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x622, 0x3b, 0x645, 0x3b, 0x698, 0x3b, 0x698,
0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x698, 0x627, 0x646, 0x648, 0x6cc, 0x647, 0x654, 0x3b, 0x641,
0x648, 0x631, 0x6cc, 0x647, 0x654, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x647, 0x654,
0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x654, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a,
0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633,
0x627, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x627, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x627,
0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x648, 0x631, 0x6cc, 0x647, 0x654, 0x3b,
0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x640, 0x6cc, 0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b,
0x62c, 0x648, 0x644, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628,
0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641,
0x628, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b,
0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628,
0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631,
0x3b, 0x73, 0x74, 0x79, 0x3b, 0x6c, 0x75, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6b, 0x77, 0x69, 0x3b, 0x6d, 0x61, 0x6a,
0x3b, 0x63, 0x7a, 0x65, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x69, 0x65, 0x3b, 0x77, 0x72, 0x7a, 0x3b, 0x70, 0x61, 0x17a,
0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x3b, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x65, 0x144, 0x3b, 0x6c, 0x75, 0x74,
0x79, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x65, 0x63, 0x3b, 0x6b, 0x77, 0x69, 0x65, 0x63, 0x69, 0x65, 0x144, 0x3b, 0x6d, 0x61,
0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x72, 0x77, 0x69, 0x65, 0x63, 0x3b, 0x6c, 0x69, 0x70, 0x69, 0x65, 0x63, 0x3b, 0x73, 0x69,
0x65, 0x72, 0x70, 0x69, 0x65, 0x144, 0x3b, 0x77, 0x72, 0x7a, 0x65, 0x73, 0x69, 0x65, 0x144, 0x3b, 0x70, 0x61, 0x17a, 0x64,
0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x67, 0x72, 0x75,
0x64, 0x7a, 0x69, 0x65, 0x144, 0x3b, 0x73, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x63, 0x3b, 0x6c, 0x3b,
0x73, 0x3b, 0x77, 0x3b, 0x70, 0x3b, 0x6c, 0x3b, 0x67, 0x3b, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x6e, 0x69, 0x61, 0x3b, 0x6c,
0x75, 0x74, 0x65, 0x67, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b, 0x6b, 0x77, 0x69, 0x65, 0x74, 0x6e, 0x69, 0x61,
0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b, 0x63, 0x7a, 0x65, 0x72, 0x77, 0x63, 0x61, 0x3b, 0x6c, 0x69, 0x70, 0x63, 0x61, 0x3b,
0x73, 0x69, 0x65, 0x72, 0x70, 0x6e, 0x69, 0x61, 0x3b, 0x77, 0x72, 0x7a, 0x65, 0x15b, 0x6e, 0x69, 0x61, 0x3b, 0x70, 0x61,
0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x61,
0x3b, 0x67, 0x72, 0x75, 0x64, 0x6e, 0x69, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72,
0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f,
0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x7a, 0x3b, 0x6a, 0x61, 0x6e,
0x65, 0x69, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x6f,
0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x6a, 0x75,
0x6c, 0x68, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b,
0x6f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x7a,
0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0xa1c, 0xa28, 0x3b, 0xa2b, 0xa3c, 0xa30, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a,
0xa4d, 0xa30, 0xa48, 0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c, 0xa42, 0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0x3b, 0xa05, 0xa17, 0x3b, 0xa38,
0xa24, 0xa70, 0x3b, 0xa05, 0xa15, 0xa24, 0xa42, 0x3b, 0xa28, 0xa35, 0xa70, 0x3b, 0xa26, 0xa38, 0xa70, 0x3b, 0xa1c, 0xa28, 0xa35, 0xa30,
0xa40, 0x3b, 0xa2b, 0xa3c, 0xa30, 0xa35, 0xa30, 0xa40, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30, 0xa48, 0xa32,
0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c, 0xa42, 0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0xa08, 0x3b, 0xa05, 0xa17, 0xa38, 0xa24, 0x3b, 0xa38,
0xa24, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa05, 0xa15, 0xa24, 0xa42, 0xa2c, 0xa30, 0x3b, 0xa28, 0xa35, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa26, 0xa38,
0xa70, 0xa2c, 0xa30, 0x3b, 0xa1c, 0x3b, 0xa2b, 0xa3c, 0x3b, 0xa2e, 0xa3e, 0x3b, 0xa05, 0x3b, 0xa2e, 0x3b, 0xa1c, 0xa42, 0x3b, 0xa1c,
0xa41, 0x3b, 0xa05, 0x3b, 0xa38, 0x3b, 0xa05, 0x3b, 0xa28, 0x3b, 0xa26, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631,
0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648,
0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b,
0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x51,
0x75, 0x6c, 0x3b, 0x48, 0x61, 0x74, 0x3b, 0x50, 0x61, 0x75, 0x3b, 0x41, 0x79, 0x72, 0x3b, 0x41, 0x79, 0x6d, 0x3b, 0x49,
0x6e, 0x74, 0x3b, 0x41, 0x6e, 0x74, 0x3b, 0x51, 0x68, 0x61, 0x3b, 0x55, 0x6d, 0x61, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x41,
0x79, 0x61, 0x3b, 0x4b, 0x61, 0x70, 0x3b, 0x51, 0x75, 0x6c, 0x6c, 0x61, 0x20, 0x70, 0x75, 0x71, 0x75, 0x79, 0x3b, 0x48,
0x61, 0x74, 0x75, 0x6e, 0x20, 0x70, 0x75, 0x71, 0x75, 0x79, 0x3b, 0x50, 0x61, 0x75, 0x71, 0x61, 0x72, 0x20, 0x77, 0x61,
0x72, 0x61, 0x79, 0x3b, 0x41, 0x79, 0x72, 0x69, 0x77, 0x61, 0x3b, 0x41, 0x79, 0x6d, 0x75, 0x72, 0x61, 0x79, 0x3b, 0x49,
0x6e, 0x74, 0x69, 0x20, 0x72, 0x61, 0x79, 0x6d, 0x69, 0x3b, 0x41, 0x6e, 0x74, 0x61, 0x20, 0x53, 0x69, 0x74, 0x77, 0x61,
0x3b, 0x51, 0x68, 0x61, 0x70, 0x61, 0x71, 0x20, 0x53, 0x69, 0x74, 0x77, 0x61, 0x3b, 0x55, 0x6d, 0x61, 0x20, 0x72, 0x61,
0x79, 0x6d, 0x69, 0x3b, 0x4b, 0x61, 0x6e, 0x74, 0x61, 0x72, 0x61, 0x79, 0x3b, 0x41, 0x79, 0x61, 0x6d, 0x61, 0x72, 0x71,
0x2bc, 0x61, 0x3b, 0x4b, 0x61, 0x70, 0x61, 0x71, 0x20, 0x52, 0x61, 0x79, 0x6d, 0x69, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e,
0x2e, 0x3b, 0x66, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61,
0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x2e, 0x3b, 0x66, 0x61, 0x6e, 0x2e, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74,
0x3b, 0x73, 0x65, 0x74, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63,
0x2e, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x65, 0x72, 0x3b, 0x66, 0x61, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72,
0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x67, 0x6c, 0x3b, 0x6d, 0x61, 0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x61,
0x64, 0x75, 0x72, 0x3b, 0x66, 0x61, 0x6e, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65,
0x74, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x69, 0x61,
0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61,
0x69, 0x3b, 0x69, 0x75, 0x6e, 0x2e, 0x3b, 0x69, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x49, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x72,
0x74, 0x69, 0x65, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x69,
0x65, 0x3b, 0x49, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65,
0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x4e, 0x6f, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x49, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b,
0x69, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x6d,
0x61, 0x72, 0x74, 0x69, 0x65, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x69, 0x75,
0x6e, 0x69, 0x65, 0x3b, 0x69, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x6e, 0x6f,
0x69, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x44f, 0x43d,
0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c,
0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435,
0x43d, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b,
0x44f, 0x43d, 0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x430, 0x3b, 0x430, 0x43f, 0x440,
0x2e, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d, 0x44f, 0x3b, 0x438, 0x44e, 0x43b, 0x44f, 0x3b, 0x430, 0x432, 0x433, 0x2e,
0x3b, 0x441, 0x435, 0x43d, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435,
0x43a, 0x2e, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44f, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44f, 0x3b, 0x43c, 0x430,
0x440, 0x442, 0x430, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44f, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d, 0x44f, 0x3b,
0x438, 0x44e, 0x43b, 0x44f, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440,
0x44f, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x434, 0x435, 0x43a,
0x430, 0x431, 0x440, 0x44f, 0x3b, 0x4e, 0x79, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4d, 0x62, 0xe4, 0x3b, 0x4e, 0x67, 0x75,
0x3b, 0x42, 0xea, 0x6c, 0x3b, 0x46, 0xf6, 0x6e, 0x3b, 0x4c, 0x65, 0x6e, 0x3b, 0x4b, 0xfc, 0x6b, 0x3b, 0x4d, 0x76, 0x75,
0x3b, 0x4e, 0x67, 0x62, 0x3b, 0x4e, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6b, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x65, 0x3b,
0x46, 0x75, 0x6c, 0x75, 0x6e, 0x64, 0xef, 0x67, 0x69, 0x3b, 0x4d, 0x62, 0xe4, 0x6e, 0x67, 0xfc, 0x3b, 0x4e, 0x67, 0x75,
0x62, 0xf9, 0x65, 0x3b, 0x42, 0xea, 0x6c, 0xe4, 0x77, 0xfc, 0x3b, 0x46, 0xf6, 0x6e, 0x64, 0x6f, 0x3b, 0x4c, 0x65, 0x6e,
0x67, 0x75, 0x61, 0x3b, 0x4b, 0xfc, 0x6b, 0xfc, 0x72, 0xfc, 0x3b, 0x4d, 0x76, 0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x67, 0x62,
0x65, 0x72, 0x65, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x62, 0xe4, 0x6e, 0x64, 0xfc, 0x72, 0x75, 0x3b, 0x4b, 0x61, 0x6b, 0x61,
0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b,
0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c, 0x430, 0x440, 0x3b,
0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b,
0x441, 0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x458, 0x430, 0x43d, 0x443,
0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438,
0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442,
0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d,
0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x6a, 0x61, 0x6e,
0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e,
0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76,
0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b,
0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a,
0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b,
0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63,
0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b,
0x61, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x42f, 0x43d, 0x432, 0x2e, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x2e,
0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x2e, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b,
0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x2e, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x2e, 0x3b, 0x41e, 0x43a, 0x442, 0x2e,
0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x414, 0x435, 0x43a, 0x2e, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440, 0x44c, 0x3b, 0x424,
0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x44a, 0x438, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x44c,
0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441,
0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41d,
0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x44f, 0x43d, 0x432, 0x2e, 0x3b, 0x444,
0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e,
0x43d, 0x44b, 0x3b, 0x438, 0x44e, 0x43b, 0x44b, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x2e, 0x3b, 0x43e, 0x43a,
0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44b, 0x3b,
0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44b, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x44a, 0x438, 0x439, 0x44b, 0x3b, 0x430, 0x43f, 0x440,
0x435, 0x43b, 0x44b, 0x3b, 0x43c, 0x430, 0x439, 0x44b, 0x3b, 0x438, 0x44e, 0x43d, 0x44b, 0x3b, 0x438, 0x44e, 0x43b, 0x44b, 0x3b, 0x430,
0x432, 0x433, 0x443, 0x441, 0x442, 0x44b, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44b, 0x3b, 0x43e, 0x43a, 0x442, 0x44f,
0x431, 0x440, 0x44b, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44b, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44b, 0x3b, 0x4e,
0x64, 0x69, 0x3b, 0x4b, 0x75, 0x6b, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x4b, 0x75, 0x62, 0x3b, 0x43, 0x68, 0x76, 0x3b, 0x43,
0x68, 0x6b, 0x3b, 0x43, 0x68, 0x67, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x47, 0x75, 0x6e, 0x3b, 0x47, 0x75, 0x6d, 0x3b, 0x4d,
0x62, 0x3b, 0x5a, 0x76, 0x69, 0x3b, 0x4e, 0x64, 0x69, 0x72, 0x61, 0x3b, 0x4b, 0x75, 0x6b, 0x61, 0x64, 0x7a, 0x69, 0x3b,
0x4b, 0x75, 0x72, 0x75, 0x6d, 0x65, 0x3b, 0x4b, 0x75, 0x62, 0x76, 0x75, 0x6d, 0x62, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x76,
0x61, 0x62, 0x76, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6e, 0x67,
0x75, 0x72, 0x75, 0x3b, 0x4e, 0x79, 0x61, 0x6d, 0x61, 0x76, 0x68, 0x75, 0x76, 0x68, 0x75, 0x3b, 0x47, 0x75, 0x6e, 0x79,
0x61, 0x6e, 0x61, 0x3b, 0x47, 0x75, 0x6d, 0x69, 0x67, 0x75, 0x72, 0x75, 0x3b, 0x4d, 0x62, 0x75, 0x64, 0x7a, 0x69, 0x3b,
0x5a, 0x76, 0x69, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b,
0x4e, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb,
0xdca, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2,
0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1,
0xddc, 0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0xda2, 0xdb1, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0xdbb,
0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad, 0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca,
0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0xdc3,
0xdca, 0xdad, 0xdd4, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0xdad, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0xdad,
0xddd, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0xdb8,
0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xda2, 0x3b, 0xdb4, 0xdd9, 0x3b, 0xdb8, 0xdcf, 0x3b, 0xd85, 0x3b, 0xdb8, 0xdd0, 0x3b, 0xda2, 0xdd6,
0x3b, 0xda2, 0xdd6, 0x3b, 0xd85, 0x3b, 0xdc3, 0xdd0, 0x3b, 0xd94, 0x3b, 0xdb1, 0xdd9, 0x3b, 0xdaf, 0xdd9, 0x3b, 0xda2, 0xdb1, 0x3b,
0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad, 0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b,
0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b, 0xdc3,
0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0x6a, 0x61,
0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa,
0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f,
0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72,
0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e,
0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64,
0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72,
0x75, 0xe1, 0x72, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x61, 0x3b, 0x6d, 0xe1,
0x6a, 0x61, 0x3b, 0x6a, 0xfa, 0x6e, 0x61, 0x3b, 0x6a, 0xfa, 0x6c, 0x61, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x61,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x72, 0x61, 0x3b, 0x6e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61, 0x70,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b,
0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70,
0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x76, 0x67,
0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63,
0x2e, 0x3b, 0x4b, 0x6f, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x41, 0x66, 0x72, 0x3b, 0x53, 0x68,
0x61, 0x3b, 0x4c, 0x69, 0x78, 0x3b, 0x54, 0x6f, 0x64, 0x3b, 0x53, 0x69, 0x64, 0x3b, 0x53, 0x61, 0x67, 0x3b, 0x54, 0x6f,
0x62, 0x3b, 0x4b, 0x49, 0x54, 0x3b, 0x4c, 0x49, 0x54, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x6f, 0x62,
0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73,
0x68, 0x61, 0x20, 0x53, 0x61, 0x64, 0x64, 0x65, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x41,
0x66, 0x72, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x68, 0x61, 0x6e, 0x61, 0x61, 0x64, 0x3b,
0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x69, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54,
0x6f, 0x64, 0x6f, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x69, 0x64, 0x65, 0x65, 0x64,
0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x61, 0x67, 0x61, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x3b,
0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20,
0x4b, 0x6f, 0x77, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68,
0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x4b,
0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b,
0x3b, 0x4c, 0x3b, 0x45, 0x6e, 0x65, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41, 0x62,
0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x79, 0x2e, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x67,
0x6f, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x4f, 0x63, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44,
0x69, 0x63, 0x2e, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d, 0x61,
0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x6f,
0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x44, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41,
0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x65, 0x6e, 0x65,
0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x79,
0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b, 0x65, 0x6e,
0x65, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f,
0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f,
0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63,
0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x65, 0x6e, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61,
0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73,
0x65, 0x70, 0x3b, 0x6f, 0x63, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x45, 0x6e, 0x65, 0x2e, 0x3b,
0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x79, 0x2e, 0x3b,
0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x67, 0x6f, 0x2e, 0x3b, 0x53, 0x65, 0x74, 0x2e, 0x3b,
0x4f, 0x63, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x69, 0x63, 0x2e, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f,
0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c,
0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x41, 0x67,
0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x63, 0x74, 0x75, 0x62,
0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x65, 0x6e, 0x65, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62,
0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x79, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67,
0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x69,
0x63, 0x2e, 0x3b, 0x65, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72,
0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b,
0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x64, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d,
0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41,
0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68,
0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x6b, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x69, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x74,
0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x6b, 0x77, 0x3b, 0x6d, 0x70, 0x69, 0x3b, 0x6d, 0x74, 0x75, 0x3b, 0x6d,
0x69, 0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x73, 0x62, 0x3b, 0x6d, 0x75, 0x6e, 0x3b, 0x6d,
0x74, 0x73, 0x3b, 0x6d, 0x6b, 0x75, 0x3b, 0x6d, 0x6b, 0x6d, 0x3b, 0x6d, 0x6b, 0x62, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69,
0x20, 0x79, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20,
0x70, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x6d,
0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x69, 0x6e, 0x65, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61,
0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b,
0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20,
0x79, 0x61, 0x20, 0x6d, 0x75, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74,
0x69, 0x73, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x6d, 0x77,
0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x79, 0x61, 0x3b,
0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x62, 0x69,
0x6c, 0x69, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x70,
0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67,
0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x63,
0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d,
0x61, 0x72, 0x73, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a,
0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44,
0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61,
0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c,
0x69, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76,
0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75,
0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a,
0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xb9c, 0xba9, 0x2e, 0x3b, 0xbaa, 0xbbf, 0xbaa,
0xbcd, 0x2e, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9,
0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0x2e, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xb85, 0xb95, 0xbcd,
0x2e, 0x3b, 0xba8, 0xbb5, 0x2e, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0x2e, 0x3b, 0xb9c, 0xba9, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbaa, 0xbbf, 0xbaa,
0xbcd, 0xbb0, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0xb9a, 0xbcd, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0xbb0, 0xbb2, 0xbcd, 0x3b,
0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0xbb8, 0xbcd, 0xb9f, 0xbc1, 0x3b,
0xb9a, 0xbc6, 0xbaa, 0xbcd, 0xb9f, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb85, 0xb95, 0xbcd, 0xb9f, 0xbcb, 0xbaa, 0xbb0, 0xbcd, 0x3b,
0xba8, 0xbb5, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9c, 0x3b, 0xbaa,
0xbbf, 0x3b, 0xbae, 0xbbe, 0x3b, 0xb8f, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb86, 0x3b, 0xb9a, 0xbc6,
0x3b, 0xb85, 0x3b, 0xba8, 0x3b, 0xb9f, 0xbbf, 0x3b, 0xb9c, 0xba9, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0xbb0, 0xbb5,
0xbb0, 0xbbf, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0xb9a, 0xbcd, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0xbb0, 0xbb2, 0xbcd, 0x3b, 0xbae, 0xbc7, 0x3b,
0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0xbb8, 0xbcd, 0xb9f, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbaa,
0xbcd, 0xb9f, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb85, 0xb95, 0xbcd, 0xb9f, 0xbcb, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xba8, 0xbb5, 0xbae,
0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0x433, 0x44b, 0x439, 0x43d, 0x2e, 0x3b,
0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438,
0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x2e, 0x3b,
0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x433, 0x44b, 0x439, 0x43d,
0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440,
0x435, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432,
0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440,
0x44c, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0xc1c, 0xc28, 0x3b,
0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0x3b, 0xc2e,
0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc41, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d, 0xc1f, 0xc41, 0x3b, 0xc38,
0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0x3b, 0xc28, 0xc35, 0xc02, 0x3b, 0xc21, 0xc3f, 0xc38,
0xc46, 0xc02, 0x3b, 0xc1c, 0xc28, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc3e,
0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0xc32, 0xc4d, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d,
0x3b, 0xc1c, 0xc41, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d, 0xc1f, 0xc41, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02,
0xc2c, 0xc30, 0xc4d, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc28, 0xc35, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b,
0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c, 0x3b, 0xc2b, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0x3b, 0xc0f, 0x3b, 0xc2e,
0xc47, 0x3b, 0xc1c, 0xc42, 0x3b, 0xc1c, 0xc41, 0x3b, 0xc06, 0x3b, 0xc38, 0xc46, 0x3b, 0xc05, 0x3b, 0xc28, 0x3b, 0xc21, 0xc3f, 0x3b,
0xc1c, 0xc28, 0x3b, 0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30,
0xc3f, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc41, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0x3b, 0xc38, 0xc46,
0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0x3b, 0xc28, 0xc35, 0xc02, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46,
0xc02, 0x3b, 0xe21, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe1e, 0x2e, 0x3b, 0xe21, 0xe35, 0x2e, 0xe04, 0x2e, 0x3b, 0xe40, 0xe21,
0x2e, 0xe22, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe34, 0x2e, 0xe22, 0x2e, 0x3b, 0xe01, 0x2e, 0xe04, 0x2e, 0x3b,
0xe2a, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe22, 0x2e, 0x3b, 0xe15, 0x2e, 0xe04, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe22, 0x2e, 0x3b,
0xe18, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe01, 0xe23, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe38, 0xe21, 0xe20, 0xe32, 0xe1e, 0xe31, 0xe19,
0xe18, 0xe4c, 0x3b, 0xe21, 0xe35, 0xe19, 0xe32, 0xe04, 0xe21, 0x3b, 0xe40, 0xe21, 0xe29, 0xe32, 0xe22, 0xe19, 0x3b, 0xe1e, 0xe24, 0xe29,
0xe20, 0xe32, 0xe04, 0xe21, 0x3b, 0xe21, 0xe34, 0xe16, 0xe38, 0xe19, 0xe32, 0xe22, 0xe19, 0x3b, 0xe01, 0xe23, 0xe01, 0xe0e, 0xe32, 0xe04,
0xe21, 0x3b, 0xe2a, 0xe34, 0xe07, 0xe2b, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe31, 0xe19, 0xe22, 0xe32, 0xe22, 0xe19, 0x3b, 0xe15, 0xe38,
0xe25, 0xe32, 0xe04, 0xe21, 0x3b, 0xe1e, 0xe24, 0xe28, 0xe08, 0xe34, 0xe01, 0xe32, 0xe22, 0xe19, 0x3b, 0xe18, 0xe31, 0xe19, 0xe27, 0xe32,
0xe04, 0xe21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b,
0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63, 0xf94, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b,
0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b,
0x3b, 0x1303, 0x1295, 0x12e9, 0x3b, 0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x1228, 0x3b, 0x121c, 0x12ed, 0x3b,
0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b, 0x1234, 0x1355, 0x1274, 0x3b, 0x12a6, 0x12ad, 0x1270, 0x3b, 0x1296,
0x126c, 0x121d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8, 0x122a, 0x3b, 0x134c, 0x1265, 0x1229, 0x12c8, 0x122a, 0x3b, 0x121b,
0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x1228, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308,
0x1235, 0x1275, 0x3b, 0x1234, 0x1355, 0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6, 0x12ad, 0x1270, 0x12cd, 0x1260, 0x122d, 0x3b, 0x1296, 0x126c, 0x121d,
0x1260, 0x122d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x1260, 0x122d, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab, 0x1272, 0x3b, 0x1218, 0x130b, 0x1262, 0x3b,
0x121a, 0x12eb, 0x12dd, 0x3b, 0x130d, 0x1295, 0x1266, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x1208, 0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218,
0x1235, 0x12a8, 0x3b, 0x1325, 0x1245, 0x121d, 0x3b, 0x1215, 0x12f3, 0x122d, 0x3b, 0x1273, 0x1215, 0x1233, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab,
0x1272, 0x1275, 0x3b, 0x1218, 0x130b, 0x1262, 0x1275, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x12eb, 0x3b, 0x130d, 0x1295, 0x1266, 0x1275, 0x3b, 0x1230, 0x1290,
0x3b, 0x1213, 0x121d, 0x1208, 0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8, 0x1228, 0x121d, 0x3b, 0x1325, 0x1245, 0x121d, 0x1272, 0x3b,
0x1215, 0x12f3, 0x122d, 0x3b, 0x1273, 0x1215, 0x1233, 0x1235, 0x3b, 0x53, 0x101, 0x6e, 0x3b, 0x46, 0x113, 0x70, 0x3b, 0x4d, 0x61, 0x2bb,
0x61, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x53, 0x69, 0x75, 0x3b, 0x2bb, 0x41,
0x6f, 0x6b, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x3b, 0x4e, 0x14d, 0x76, 0x3b, 0x54, 0x12b, 0x73, 0x3b,
0x53, 0x101, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x113, 0x70, 0x75, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x2bb, 0x61,
0x73, 0x69, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x6c, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x65, 0x3b,
0x53, 0x69, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x69, 0x74,
0x65, 0x6d, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x14d, 0x76, 0x65, 0x6d, 0x61, 0x3b,
0x54, 0x12b, 0x73, 0x65, 0x6d, 0x61, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53,
0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4f, 0x63, 0x61, 0x3b, 0x15e, 0x75, 0x62, 0x3b, 0x4d,
0x61, 0x72, 0x3b, 0x4e, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x61, 0x7a, 0x3b, 0x54, 0x65, 0x6d, 0x3b, 0x41,
0x11f, 0x75, 0x3b, 0x45, 0x79, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x4f,
0x63, 0x61, 0x6b, 0x3b, 0x15e, 0x75, 0x62, 0x61, 0x74, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x4e, 0x69, 0x73, 0x61, 0x6e,
0x3b, 0x4d, 0x61, 0x79, 0x131, 0x73, 0x3b, 0x48, 0x61, 0x7a, 0x69, 0x72, 0x61, 0x6e, 0x3b, 0x54, 0x65, 0x6d, 0x6d, 0x75,
0x7a, 0x3b, 0x41, 0x11f, 0x75, 0x73, 0x74, 0x6f, 0x73, 0x3b, 0x45, 0x79, 0x6c, 0xfc, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x6d,
0x3b, 0x4b, 0x61, 0x73, 0x131, 0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6c, 0x131, 0x6b, 0x3b, 0x4f, 0x3b, 0x15e, 0x3b, 0x4d, 0x3b,
0x4e, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x45, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x41, 0x3b, 0x64a, 0x627,
0x646, 0x6cb, 0x627, 0x631, 0x3b, 0x641, 0x6d0, 0x6cb, 0x631, 0x627, 0x644, 0x3b, 0x645, 0x627, 0x631, 0x62a, 0x3b, 0x626, 0x627, 0x67e,
0x631, 0x6d0, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x646, 0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x644, 0x3b,
0x626, 0x627, 0x6cb, 0x63a, 0x6c7, 0x633, 0x62a, 0x3b, 0x633, 0x6d0, 0x646, 0x62a, 0x6d5, 0x628, 0x649, 0x631, 0x3b, 0x626, 0x6c6, 0x643,
0x62a, 0x6d5, 0x628, 0x649, 0x631, 0x3b, 0x646, 0x648, 0x64a, 0x627, 0x628, 0x649, 0x631, 0x3b, 0x62f, 0x6d0, 0x643, 0x627, 0x628, 0x649,
0x631, 0x3b, 0x64a, 0x627, 0x646, 0x6cb, 0x627, 0x631, 0x3b, 0x641, 0x6d0, 0x6cb, 0x631, 0x627, 0x644, 0x3b, 0x645, 0x627, 0x631, 0x62a,
0x3b, 0x626, 0x627, 0x67e, 0x631, 0x6d0, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x646, 0x3b, 0x626, 0x649,
0x64a, 0x6c7, 0x644, 0x3b, 0x626, 0x627, 0x6cb, 0x63a, 0x6c7, 0x633, 0x62a, 0x3b, 0x633, 0x6d0, 0x646, 0x62a, 0x6d5, 0x628, 0x649, 0x631,
0x3b, 0x626, 0x6c6, 0x643, 0x62a, 0x6d5, 0x628, 0x649, 0x631, 0x3b, 0x628, 0x648, 0x64a, 0x627, 0x628, 0x649, 0x631, 0x3b, 0x62f, 0x6d0,
0x643, 0x627, 0x628, 0x649, 0x631, 0x3b, 0x421, 0x456, 0x447, 0x3b, 0x41b, 0x44e, 0x442, 0x3b, 0x411, 0x435, 0x440, 0x3b, 0x41a, 0x432,
0x456, 0x3b, 0x422, 0x440, 0x430, 0x3b, 0x427, 0x435, 0x440, 0x3b, 0x41b, 0x438, 0x43f, 0x3b, 0x421, 0x435, 0x440, 0x3b, 0x412, 0x435,
0x440, 0x3b, 0x416, 0x43e, 0x432, 0x3b, 0x41b, 0x438, 0x441, 0x3b, 0x413, 0x440, 0x443, 0x3b, 0x421, 0x456, 0x447, 0x435, 0x43d, 0x44c,
0x3b, 0x41b, 0x44e, 0x442, 0x438, 0x439, 0x3b, 0x411, 0x435, 0x440, 0x435, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x41a, 0x432, 0x456, 0x442,
0x435, 0x43d, 0x44c, 0x3b, 0x422, 0x440, 0x430, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x427, 0x435, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b,
0x41b, 0x438, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x421, 0x435, 0x440, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x412, 0x435, 0x440, 0x435, 0x441,
0x435, 0x43d, 0x44c, 0x3b, 0x416, 0x43e, 0x432, 0x442, 0x435, 0x43d, 0x44c, 0x3b, 0x41b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434,
0x3b, 0x413, 0x440, 0x443, 0x434, 0x435, 0x43d, 0x44c, 0x3b, 0x421, 0x3b, 0x41b, 0x3b, 0x411, 0x3b, 0x41a, 0x3b, 0x422, 0x3b, 0x427,
0x3b, 0x41b, 0x3b, 0x421, 0x3b, 0x412, 0x3b, 0x416, 0x3b, 0x41b, 0x3b, 0x413, 0x3b, 0x441, 0x456, 0x447, 0x2e, 0x3b, 0x43b, 0x44e,
0x442, 0x2e, 0x3b, 0x431, 0x435, 0x440, 0x2e, 0x3b, 0x43a, 0x432, 0x456, 0x442, 0x2e, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x2e, 0x3b,
0x447, 0x435, 0x440, 0x432, 0x2e, 0x3b, 0x43b, 0x438, 0x43f, 0x2e, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x2e, 0x3b, 0x432, 0x435, 0x440,
0x2e, 0x3b, 0x436, 0x43e, 0x432, 0x442, 0x2e, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x2e, 0x3b, 0x433, 0x440, 0x443, 0x434, 0x2e, 0x3b,
0x441, 0x456, 0x447, 0x43d, 0x44f, 0x3b, 0x43b, 0x44e, 0x442, 0x43e, 0x433, 0x43e, 0x3b, 0x431, 0x435, 0x440, 0x435, 0x437, 0x43d, 0x44f,
0x3b, 0x43a, 0x432, 0x456, 0x442, 0x43d, 0x44f, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x43d, 0x44f, 0x3b, 0x447, 0x435, 0x440, 0x432, 0x43d,
0x44f, 0x3b, 0x43b, 0x438, 0x43f, 0x43d, 0x44f, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x43d, 0x44f, 0x3b, 0x432, 0x435, 0x440, 0x435, 0x441,
0x43d, 0x44f, 0x3b, 0x436, 0x43e, 0x432, 0x442, 0x43d, 0x44f, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x430, 0x3b,
0x433, 0x440, 0x443, 0x434, 0x43d, 0x44f, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645,
0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648,
0x644, 0x627, 0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648,
0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x3b,
0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e,
0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f,
0x79, 0x61, 0x3b, 0x44, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c,
0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e,
0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x61, 0x62, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62,
0x72, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b,
0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x628, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x3b, 0x627, 0x67e,
0x631, 0x3b, 0x645, 0x640, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x3b, 0x627, 0x6af, 0x633, 0x3b, 0x633, 0x67e,
0x62a, 0x3b, 0x627, 0x6a9, 0x62a, 0x3b, 0x646, 0x648, 0x645, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440, 0x3b,
0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x41c, 0x430,
0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d,
0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x3b, 0x414, 0x435,
0x43a, 0x430, 0x431, 0x440, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x32, 0x3b, 0x54, 0x68, 0x67,
0x20, 0x33, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x35, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x36,
0x3b, 0x54, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x38, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x39, 0x3b, 0x54,
0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x32, 0x3b,
0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x32, 0x3b, 0x54, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x33, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x34, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x35, 0x3b,
0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x36, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x37, 0x3b, 0x54, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x38, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x39, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x30,
0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x74,
0x68, 0x67, 0x20, 0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x32, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x33, 0x3b, 0x74, 0x68, 0x67,
0x20, 0x34, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x35, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x36, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x37,
0x3b, 0x74, 0x68, 0x67, 0x20, 0x38, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x39, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x30, 0x3b,
0x74, 0x68, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x31, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x32, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x33, 0x3b, 0x74, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x35, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x36, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x37, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x38, 0x3b, 0x74, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x39, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67,
0x20, 0x31, 0x31, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x49, 0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x77,
0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72,
0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b,
0x52, 0x68, 0x61, 0x67, 0x3b, 0x49, 0x6f, 0x6e, 0x61, 0x77, 0x72, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x72, 0x6f, 0x72,
0x3b, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d,
0x65, 0x68, 0x65, 0x66, 0x69, 0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x65, 0x6e, 0x6e, 0x61, 0x66, 0x3b, 0x41, 0x77,
0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x72, 0x65, 0x66, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x77,
0x65, 0x64, 0x64, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x66, 0x79, 0x72, 0x3b, 0x49, 0x3b, 0x43, 0x68, 0x3b, 0x4d, 0x3b, 0x45,
0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x52, 0x68, 0x3b, 0x49, 0x6f,
0x6e, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x3b, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c,
0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x3b, 0x41, 0x77, 0x73, 0x74,
0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x3b,
0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9, 0x301, 0x3b, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0xe0, 0x3b,
0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x1eb8, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67,
0x1eb9, 0x6d, 0x1ecd, 0x3b, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x1ecc, 0x300, 0x77, 0xe0, 0x72,
0xe0, 0x3b, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1e62, 0x1eb9, 0x301,
0x72, 0x1eb9, 0x301, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x72,
0x1eb9, 0x300, 0x6e, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x300,
0x62, 0x69, 0x62, 0x69, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x41,
0x67, 0x1eb9, 0x6d, 0x1ecd, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x4f, 0x77,
0x65, 0x77, 0x65, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x42,
0xe9, 0x6c, 0xfa, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x25b,
0x301, 0x3b, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x190, 0x72, 0x25b, 0x300, 0x6e, 0xe0, 0x3b, 0xcc, 0x67, 0x62, 0xe9, 0x3b,
0x190, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67, 0x25b, 0x6d, 0x254, 0x3b, 0xd2,
0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x186, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x42, 0xe9, 0x6c,
0xfa, 0x3b, 0x186, 0x300, 0x70, 0x25b, 0x300, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x25b, 0x301,
0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x190, 0x72, 0x25b,
0x300, 0x6e, 0xe0, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x190,
0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x73, 0x68,
0xf9, 0x20, 0x41, 0x67, 0x25b, 0x6d, 0x254, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x73,
0x68, 0xf9, 0x20, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x186, 0x300, 0x77, 0xe0, 0x72, 0xe0,
0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x186, 0x300, 0x70, 0x25b,
0x300, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65,
0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b,
0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x46,
0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x73, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c,
0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69, 0x3b, 0x41,
0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x68,
0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b,
0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73,
0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x6a,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61,
0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61,
0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f,
0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440,
0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b,
0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e,
0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435,
0x43c, 0x431, 0x430, 0x440, 0x3b, 0x4a, 0x2d, 0x67, 0x75, 0x65, 0x72, 0x3b, 0x54, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b,
0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x72, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79,
0x6e, 0x3b, 0x4d, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b,
0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a,
0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d, 0x2e, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x2e, 0x4e,
0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x67, 0x65, 0x75, 0x72, 0x65, 0x65,
0x3b, 0x54, 0x6f, 0x73, 0x68, 0x69, 0x61, 0x67, 0x68, 0x74, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x79,
0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x65, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79, 0x6e, 0x3b, 0x4d,
0x65, 0x61, 0x6e, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x73, 0x6f,
0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d,
0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72,
0x3b, 0x4d, 0x65, 0x65, 0x20, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x6e, 0x79, 0x20, 0x4e,
0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x47, 0x65, 0x6e, 0x3b, 0x48, 0x77, 0x65, 0x3b, 0x4d, 0x65, 0x75, 0x3b, 0x45,
0x62, 0x72, 0x3b, 0x4d, 0x65, 0x3b, 0x4d, 0x65, 0x74, 0x3b, 0x47, 0x6f, 0x72, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x47, 0x77,
0x6e, 0x3b, 0x48, 0x65, 0x64, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x76, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x47, 0x65, 0x6e,
0x76, 0x65, 0x72, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x48, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x69, 0x73, 0x20,
0x4d, 0x65, 0x75, 0x72, 0x74, 0x68, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x69, 0x73,
0x20, 0x4d, 0x65, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4d, 0x65, 0x74, 0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x6d, 0x69, 0x73,
0x20, 0x47, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x45, 0x73, 0x74, 0x3b, 0x6d,
0x69, 0x73, 0x20, 0x47, 0x77, 0x79, 0x6e, 0x6e, 0x67, 0x61, 0x6c, 0x61, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x48, 0x65, 0x64,
0x72, 0x61, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x44, 0x75, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4b, 0x65, 0x76, 0x61, 0x72, 0x64,
0x68, 0x75, 0x3b, 0x53, 0x2d, 0x186, 0x3b, 0x4b, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x4f, 0x3b, 0x45,
0x2d, 0x4b, 0x3b, 0x4f, 0x2d, 0x41, 0x3b, 0x41, 0x2d, 0x4b, 0x3b, 0x44, 0x2d, 0x186, 0x3b, 0x46, 0x2d, 0x190, 0x3b, 0x186,
0x2d, 0x41, 0x3b, 0x186, 0x2d, 0x4f, 0x3b, 0x4d, 0x2d, 0x186, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x61, 0x2d, 0x186, 0x70, 0x25b,
0x70, 0x254, 0x6e, 0x3b, 0x4b, 0x77, 0x61, 0x6b, 0x77, 0x61, 0x72, 0x2d, 0x186, 0x67, 0x79, 0x65, 0x66, 0x75, 0x6f, 0x3b,
0x45, 0x62, 0x254, 0x77, 0x2d, 0x186, 0x62, 0x65, 0x6e, 0x65, 0x6d, 0x3b, 0x45, 0x62, 0x254, 0x62, 0x69, 0x72, 0x61, 0x2d,
0x4f, 0x66, 0x6f, 0x72, 0x69, 0x73, 0x75, 0x6f, 0x3b, 0x45, 0x73, 0x75, 0x73, 0x6f, 0x77, 0x20, 0x41, 0x6b, 0x65, 0x74,
0x73, 0x65, 0x61, 0x62, 0x61, 0x2d, 0x4b, 0x254, 0x74, 0x254, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x62, 0x69, 0x72,
0x61, 0x64, 0x65, 0x2d, 0x41, 0x79, 0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x6d, 0x75, 0x6d, 0x75, 0x3b, 0x41, 0x79, 0x25b, 0x77,
0x6f, 0x68, 0x6f, 0x2d, 0x4b, 0x69, 0x74, 0x61, 0x77, 0x6f, 0x6e, 0x73, 0x61, 0x3b, 0x44, 0x69, 0x66, 0x75, 0x75, 0x2d,
0x186, 0x73, 0x61, 0x6e, 0x64, 0x61, 0x61, 0x3b, 0x46, 0x61, 0x6e, 0x6b, 0x77, 0x61, 0x2d, 0x190, 0x62, 0x254, 0x3b, 0x186,
0x62, 0x25b, 0x73, 0x25b, 0x2d, 0x41, 0x68, 0x69, 0x6e, 0x69, 0x6d, 0x65, 0x3b, 0x186, 0x62, 0x65, 0x72, 0x25b, 0x66, 0x25b,
0x77, 0x2d, 0x4f, 0x62, 0x75, 0x62, 0x75, 0x6f, 0x3b, 0x4d, 0x75, 0x6d, 0x75, 0x2d, 0x186, 0x70, 0x25b, 0x6e, 0x69, 0x6d,
0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e,
0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x913, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947,
0x902, 0x92c, 0x930, 0x3b, 0x913, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c,
0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x61, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x1ecc, 0x67,
0x1ecd, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x1ecc, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x65,
0x6e, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x4d, 0x61, 0x61,
0x63, 0x68, 0x1ecb, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4a,
0x75, 0x6c, 0x61, 0x1ecb, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x1ecd, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x1ecc, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x65, 0x6c, 0x3b, 0x4b, 0x74, 0x169, 0x3b, 0x4b, 0x61, 0x6e, 0x3b,
0x4b, 0x74, 0x6e, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x4b, 0x6e, 0x64, 0x3b,
0x128, 0x6b, 0x75, 0x3b, 0x128, 0x6b, 0x6d, 0x3b, 0x128, 0x6b, 0x6c, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6d, 0x62, 0x65, 0x65, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x4d, 0x77,
0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61,
0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f,
0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d,
0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x75, 0x6f, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77,
0x61, 0x20, 0x6e, 0x79, 0x61, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65,
0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77,
0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x129, 0x6d, 0x77, 0x65, 0x3b,
0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x6c, 0x129,
0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x128,
0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x5a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x76, 0x72,
0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x3b, 0x53, 0x65, 0x74,
0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x63, 0x3b, 0x5a, 0x65, 0x6e, 0xe2, 0x72, 0x3b, 0x46,
0x65, 0x76, 0x72, 0xe2, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0xe7, 0x3b, 0x41, 0x76, 0x72, 0xee, 0x6c, 0x3b, 0x4d, 0x61, 0x69,
0x3b, 0x4a, 0x75, 0x67, 0x6e, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72,
0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b,
0x4a, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a,
0x64, 0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66, 0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69,
0x61, 0x3b, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x6e, 0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a,
0x6d, 0x3b, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78,
0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x129, 0x65, 0x3b, 0x64, 0x61, 0x6d, 0x61, 0x3b, 0x6d, 0x61, 0x73, 0x61, 0x3b, 0x73,
0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64, 0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65, 0x3b, 0x61, 0x6e,
0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65, 0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254,
0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65, 0x3b, 0x64, 0x3b, 0x64, 0x3b, 0x74, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x6d,
0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6b, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x49, 0x61, 0x6e, 0x2e, 0x3b, 0x50, 0x65,
0x70, 0x2e, 0x3b, 0x4d, 0x61, 0x6c, 0x2e, 0x3b, 0x2bb, 0x41, 0x70, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e,
0x2e, 0x3b, 0x49, 0x75, 0x6c, 0x2e, 0x3b, 0x2bb, 0x41, 0x75, 0x2e, 0x3b, 0x4b, 0x65, 0x70, 0x2e, 0x3b, 0x2bb, 0x4f, 0x6b,
0x2e, 0x3b, 0x4e, 0x6f, 0x77, 0x2e, 0x3b, 0x4b, 0x65, 0x6b, 0x2e, 0x3b, 0x49, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b,
0x50, 0x65, 0x70, 0x65, 0x6c, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x6b, 0x69, 0x3b, 0x2bb, 0x41, 0x70,
0x65, 0x6c, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x65, 0x3b, 0x49, 0x75, 0x6c, 0x61, 0x69,
0x3b, 0x2bb, 0x41, 0x75, 0x6b, 0x61, 0x6b, 0x65, 0x3b, 0x4b, 0x65, 0x70, 0x61, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b,
0x2bb, 0x4f, 0x6b, 0x61, 0x6b, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x6f, 0x77, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x4b, 0x65,
0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x45, 0x6e, 0x65, 0x3b, 0x50, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41,
0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53,
0x65, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f,
0x3b, 0x50, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c,
0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6e, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6c, 0x79, 0x6f, 0x3b, 0x41, 0x67,
0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x6b, 0x74, 0x75, 0x62,
0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x62, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x73, 0x79, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x63, 0x68, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74,
0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xa2cd, 0xa1aa, 0x3b, 0xa44d, 0xa1aa, 0x3b, 0xa315,
0xa1aa, 0x3b, 0xa1d6, 0xa1aa, 0x3b, 0xa26c, 0xa1aa, 0x3b, 0xa0d8, 0xa1aa, 0x3b, 0xa3c3, 0xa1aa, 0x3b, 0xa246, 0xa1aa, 0x3b, 0xa22c, 0xa1aa, 0x3b,
0xa2b0, 0xa1aa, 0x3b, 0xa2b0, 0xa2aa, 0xa1aa, 0x3b, 0xa2b0, 0xa44b, 0xa1aa, 0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76,
0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b,
0x73, 0x75, 0x6f, 0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b,
0x73, 0x6b, 0xe1, 0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x3b, 0x6f, 0x111, 0x111, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x6d, 0xe1,
0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6e, 0x6a, 0x75, 0x6b,
0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x63, 0x75, 0x6f, 0x14b, 0x6f, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6d,
0x69, 0x65, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e,
0x6e, 0x75, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x62, 0x6f, 0x72, 0x67,
0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x6f,
0x6c, 0x67, 0x67, 0x6f, 0x74, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x6d, 0xe1, 0x6e,
0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x4f, 0x3b, 0x47, 0x3b, 0x4e,
0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x10c, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x6f,
0x111, 0x111, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76, 0x61, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x10d,
0x61, 0x3b, 0x63, 0x75, 0x6f, 0x14b, 0x6f, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x73,
0x65, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x65, 0x3b, 0x10d, 0x61, 0x6b, 0x10d,
0x61, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x67, 0x6f, 0x74, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x3b, 0x6a, 0x75, 0x6f,
0x76, 0x6c, 0x61, 0x3b, 0x43, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x43, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x43, 0x68, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69,
0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x69, 0x72,
0x69, 0x72, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6c, 0x61, 0x69, 0x3b,
0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74,
0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x43, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b,
0x4e, 0x3b, 0x44, 0x3b, 0x49, 0x6d, 0x62, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b,
0x4b, 0x61, 0x73, 0x3b, 0x4b, 0x61, 0x72, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x57, 0x75, 0x6e, 0x3b, 0x49, 0x6b, 0x65, 0x3b,
0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49, 0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77,
0x61, 0x20, 0x69, 0x6d, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b,
0x61, 0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75,
0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69,
0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68,
0x77, 0x61, 0x20, 0x6b, 0x61, 0x72, 0x61, 0x6e, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68,
0x77, 0x61, 0x20, 0x6d, 0x66, 0x75, 0x6e, 0x67, 0x61, 0x64, 0x65, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77,
0x61, 0x20, 0x77, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61,
0x20, 0x69, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b,
0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20,
0x6e, 0x61, 0x20, 0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20,
0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x77, 0x69, 0x3b, 0x49, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x73, 0x69, 0x69,
0x3b, 0x63, 0x6f, 0x6c, 0x3b, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x64, 0x75, 0x75, 0x3b, 0x6b, 0x6f, 0x72,
0x3b, 0x6d, 0x6f, 0x72, 0x3b, 0x6a, 0x75, 0x6b, 0x3b, 0x73, 0x6c, 0x74, 0x3b, 0x79, 0x61, 0x72, 0x3b, 0x6a, 0x6f, 0x6c,
0x3b, 0x62, 0x6f, 0x77, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x6f, 0x3b, 0x63, 0x6f, 0x6c, 0x74, 0x65, 0x3b, 0x6d, 0x62, 0x6f,
0x6f, 0x79, 0x3b, 0x73, 0x65, 0x65, 0x257, 0x74, 0x6f, 0x3b, 0x64, 0x75, 0x75, 0x6a, 0x61, 0x6c, 0x3b, 0x6b, 0x6f, 0x72,
0x73, 0x65, 0x3b, 0x6d, 0x6f, 0x72, 0x73, 0x6f, 0x3b, 0x6a, 0x75, 0x6b, 0x6f, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x74, 0x6f,
0x3b, 0x79, 0x61, 0x72, 0x6b, 0x6f, 0x6d, 0x61, 0x61, 0x3b, 0x6a, 0x6f, 0x6c, 0x61, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x74,
0x65, 0x3b, 0x73, 0x3b, 0x63, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x73, 0x3b,
0x79, 0x3b, 0x6a, 0x3b, 0x62, 0x3b, 0x4a, 0x45, 0x4e, 0x3b, 0x57, 0x4b, 0x52, 0x3b, 0x57, 0x47, 0x54, 0x3b, 0x57, 0x4b,
0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x57, 0x54, 0x44, 0x3b, 0x57, 0x4d, 0x4a, 0x3b, 0x57, 0x4e, 0x4e, 0x3b, 0x57, 0x4b,
0x44, 0x3b, 0x57, 0x49, 0x4b, 0x3b, 0x57, 0x4d, 0x57, 0x3b, 0x44, 0x49, 0x54, 0x3b, 0x4e, 0x6a, 0x65, 0x6e, 0x75, 0x61,
0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65,
0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61,
0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74,
0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20,
0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69,
0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4e, 0x64, 0x69, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a,
0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49,
0x3b, 0x44, 0x3b, 0x4f, 0x62, 0x6f, 0x3b, 0x57, 0x61, 0x61, 0x3b, 0x4f, 0x6b, 0x75, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49,
0x6d, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x49, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x3b, 0x54,
0x6f, 0x6d, 0x3b, 0x54, 0x6f, 0x62, 0x3b, 0x54, 0x6f, 0x77, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f,
0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4c, 0x61, 0x70,
0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f,
0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6d, 0x65, 0x74, 0x3b,
0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6c, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20,
0x73, 0x61, 0x70, 0x61, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x69, 0x65, 0x74, 0x3b, 0x4c,
0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x61, 0x6c, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20,
0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20,
0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x77, 0x61,
0x61, 0x72, 0x65, 0x3b, 0x4f, 0x3b, 0x57, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x49, 0x3b,
0x53, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b,
0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x65,
0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x6f, 0x3b, 0x41,
0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68,
0x6f, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f,
0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d,
0x62, 0x72, 0x6f, 0x3b, 0x5a, 0x69, 0x62, 0x3b, 0x4e, 0x68, 0x6c, 0x6f, 0x3b, 0x4d, 0x62, 0x69, 0x3b, 0x4d, 0x61, 0x62,
0x3b, 0x4e, 0x6b, 0x77, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x3b, 0x4e, 0x74, 0x75, 0x3b, 0x4e, 0x63, 0x77, 0x3b, 0x4d, 0x70,
0x61, 0x6e, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x4d, 0x70, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x62, 0x61,
0x6e, 0x64, 0x6c, 0x65, 0x6c, 0x61, 0x3b, 0x4e, 0x68, 0x6c, 0x6f, 0x6c, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x62, 0x69,
0x6d, 0x62, 0x69, 0x74, 0x68, 0x6f, 0x3b, 0x4d, 0x61, 0x62, 0x61, 0x73, 0x61, 0x3b, 0x4e, 0x6b, 0x77, 0x65, 0x6e, 0x6b,
0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x3b, 0x4e, 0x74, 0x75, 0x6c, 0x69,
0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4e, 0x63, 0x77, 0x61, 0x62, 0x61, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6e,
0x64, 0x75, 0x6c, 0x61, 0x3b, 0x4d, 0x66, 0x75, 0x6d, 0x66, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4d, 0x70,
0x61, 0x6c, 0x61, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x5a, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x4e, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x31, 0x3b, 0x4d, 0x32, 0x3b, 0x4d, 0x33,
0x3b, 0x4d, 0x34, 0x3b, 0x4d, 0x35, 0x3b, 0x4d, 0x36, 0x3b, 0x4d, 0x37, 0x3b, 0x4d, 0x38, 0x3b, 0x4d, 0x39, 0x3b, 0x4d,
0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x69, 0x6c,
0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x69,
0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d,
0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e,
0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x3b, 0x2d4e, 0x2d30, 0x2d55,
0x3b, 0x2d49, 0x2d31, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x3b, 0x2d62, 0x2d53, 0x2d4d, 0x3b, 0x2d56, 0x2d53, 0x2d5b,
0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x3b, 0x2d49, 0x2d4f, 0x2d4f,
0x2d30, 0x2d62, 0x2d54, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x2d62, 0x2d55, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x2d5a, 0x3b, 0x2d49, 0x2d31, 0x2d54, 0x2d49, 0x2d54,
0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4d, 0x2d62, 0x2d53, 0x2d63, 0x3b,
0x2d56, 0x2d53, 0x2d5b, 0x2d5c, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x2d31, 0x2d54, 0x3b,
0x2d4f, 0x2d53, 0x2d61, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d49, 0x3b,
0x2d31, 0x3b, 0x2d4e, 0x3b, 0x2d49, 0x3b, 0x2d4e, 0x3b, 0x2d62, 0x3b, 0x2d62, 0x3b, 0x2d56, 0x3b, 0x2d5b, 0x3b, 0x2d3d, 0x3b, 0x2d4f, 0x3b,
0x2d37, 0x3b, 0x69, 0x6e, 0x6e, 0x3b, 0x62, 0x1e5b, 0x61, 0x3b, 0x6d, 0x61, 0x1e5b, 0x3b, 0x69, 0x62, 0x72, 0x3b, 0x6d, 0x61,
0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x263, 0x75, 0x63, 0x3b, 0x63, 0x75, 0x74, 0x3b, 0x6b, 0x74,
0x75, 0x3b, 0x6e, 0x75, 0x77, 0x3b, 0x64, 0x75, 0x6a, 0x3b, 0x69, 0x6e, 0x6e, 0x61, 0x79, 0x72, 0x3b, 0x62, 0x1e5b, 0x61,
0x79, 0x1e5b, 0x3b, 0x6d, 0x61, 0x1e5b, 0x1e63, 0x3b, 0x69, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x79, 0x75, 0x3b,
0x79, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x263, 0x75, 0x63, 0x74, 0x3b, 0x63, 0x75,
0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x3b, 0x6e, 0x75, 0x77, 0x61, 0x6e, 0x62, 0x69,
0x72, 0x3b, 0x64, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x69, 0x3b, 0x62, 0x3b, 0x6d, 0x3b, 0x69, 0x3b, 0x6d,
0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x263, 0x3b, 0x63, 0x3b, 0x6b, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x46,
0x75, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59,
0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x74, 0x65, 0x3b, 0x54, 0x75, 0x62, 0x3b, 0x4e, 0x75, 0x6e, 0x3b, 0x44,
0x75, 0x1e7, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x46, 0x75, 0x1e5b, 0x61, 0x72, 0x3b, 0x4d, 0x65,
0x263, 0x72, 0x65, 0x73, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75,
0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x3b, 0x194, 0x75, 0x63, 0x74, 0x3b, 0x43, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x1e5b, 0x3b, 0x54, 0x75, 0x62, 0x65, 0x1e5b, 0x3b, 0x4e, 0x75, 0x6e, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x44, 0x75,
0x1e7, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59,
0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4b, 0x42, 0x5a, 0x3b, 0x4b, 0x42, 0x52, 0x3b, 0x4b,
0x53, 0x54, 0x3b, 0x4b, 0x4b, 0x4e, 0x3b, 0x4b, 0x54, 0x4e, 0x3b, 0x4b, 0x4d, 0x4b, 0x3b, 0x4b, 0x4d, 0x53, 0x3b, 0x4b,
0x4d, 0x4e, 0x3b, 0x4b, 0x4d, 0x57, 0x3b, 0x4b, 0x4b, 0x4d, 0x3b, 0x4b, 0x4e, 0x4b, 0x3b, 0x4b, 0x4e, 0x42, 0x3b, 0x4f,
0x6b, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72,
0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61,
0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d,
0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x6a, 0x75, 0x3b,
0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6e, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x77, 0x65, 0x6e,
0x64, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x77, 0x65, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d,
0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x48, 0x75, 0x74, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x44,
0x61, 0x74, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x48, 0x61, 0x6e, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e,
0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4b, 0x6d, 0x6a, 0x3b, 0x4b, 0x6d, 0x62, 0x3b, 0x70,
0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x68, 0x75, 0x74, 0x61, 0x6c, 0x61, 0x3b,
0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x76, 0x69, 0x6c, 0x69,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x64, 0x61, 0x74,
0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x74, 0x61,
0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x68, 0x61,
0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74,
0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b,
0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x70,
0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x70, 0x61,
0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b,
0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x48, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x54,
0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b,
0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x79, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x79, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x77, 0x69, 0x3b,
0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x3b, 0x7a, 0x75, 0x6c, 0x3b, 0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x3b, 0x254,
0x6b, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x77, 0x75, 0x79, 0x65, 0x3b, 0x66,
0x65, 0x62, 0x75, 0x72, 0x75, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x61, 0x77, 0x69, 0x72, 0x69,
0x6c, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x25b, 0x6e, 0x3b, 0x7a, 0x75, 0x6c, 0x75, 0x79, 0x65, 0x3b, 0x75,
0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x254, 0x6b, 0x75, 0x74, 0x254, 0x62, 0x75,
0x72, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75,
0x72, 0x75, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x5a, 0x3b, 0x55, 0x3b, 0x53,
0x3b, 0x186, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x61, 0x69, 0x3b, 0x4b, 0x61, 0x74, 0x3b, 0x4b,
0x61, 0x6e, 0x3b, 0x47, 0x61, 0x74, 0x3b, 0x47, 0x61, 0x6e, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x4b, 0x6e, 0x6e, 0x3b, 0x4b,
0x65, 0x6e, 0x3b, 0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49, 0x67, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b,
0x61, 0x129, 0x72, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x68, 0x61, 0x74,
0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61,
0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x4b, 0x61, 0x129, 0x72,
0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x13a4, 0x13c3, 0x3b, 0x13a7, 0x13a6, 0x3b, 0x13a0, 0x13c5, 0x3b, 0x13a7, 0x13ec, 0x3b, 0x13a0, 0x13c2,
0x3b, 0x13d5, 0x13ad, 0x3b, 0x13ab, 0x13f0, 0x3b, 0x13a6, 0x13b6, 0x3b, 0x13da, 0x13b5, 0x3b, 0x13da, 0x13c2, 0x3b, 0x13c5, 0x13d3, 0x3b, 0x13a5,
0x13cd, 0x3b, 0x13a4, 0x13c3, 0x13b8, 0x13d4, 0x13c5, 0x3b, 0x13a7, 0x13a6, 0x13b5, 0x3b, 0x13a0, 0x13c5, 0x13f1, 0x3b, 0x13a7, 0x13ec, 0x13c2, 0x3b,
0x13a0, 0x13c2, 0x13cd, 0x13ac, 0x13d8, 0x3b, 0x13d5, 0x13ad, 0x13b7, 0x13f1, 0x3b, 0x13ab, 0x13f0, 0x13c9, 0x13c2, 0x3b, 0x13a6, 0x13b6, 0x13c2, 0x3b,
0x13da, 0x13b5, 0x13cd, 0x13d7, 0x3b, 0x13da, 0x13c2, 0x13c5, 0x13d7, 0x3b, 0x13c5, 0x13d3, 0x13d5, 0x13c6, 0x3b, 0x13a5, 0x13cd, 0x13a9, 0x13f1, 0x3b,
0x13a4, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13d5, 0x3b, 0x13ab, 0x3b, 0x13a6, 0x3b, 0x13da, 0x3b, 0x13da, 0x3b,
0x13c5, 0x3b, 0x13a5, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x76, 0x72, 0x3b,
0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x66, 0x65,
0x76, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x3b,
0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x79, 0x65, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x61, 0x6d,
0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x3b, 0x6e, 0x6f, 0x76, 0x61, 0x6d, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6d, 0x3b, 0x7a,
0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x7a, 0x3b, 0x7a, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e,
0x3b, 0x64, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x4e, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64,
0x69, 0x20, 0x77, 0x61, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x54,
0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69,
0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65,
0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x6d, 0x6f, 0x3b,
0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d,
0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61,
0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d,
0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e,
0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f,
0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x3b, 0x4d, 0x77, 0x65, 0x64,
0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x3b, 0x46, 0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b, 0x4e, 0x61, 0x61, 0x6e, 0x268,
0x3b, 0x4b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x49, 0x6b, 0xfa, 0x6d, 0x69, 0x3b, 0x49, 0x6e, 0x79, 0x61, 0x6d, 0x62,
0x61, 0x6c, 0x61, 0x3b, 0x49, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4d, 0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b,
0x56, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x53, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x49, 0x6e, 0x79, 0x69, 0x3b, 0x53, 0x61, 0x61,
0x6e, 0x6f, 0x3b, 0x53, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x289, 0x66, 0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b,
0x4b, 0x289, 0x6e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x289, 0x6b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4b, 0x77, 0x69,
0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x61, 0x6d, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x4b,
0x77, 0x69, 0x69, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4b, 0x289, 0x6d, 0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b,
0x4b, 0x289, 0x76, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x77, 0x69, 0x69,
0x6e, 0x79, 0x69, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x73, 0x61, 0x74, 0x289,
0x3b, 0x46, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x49,
0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x75,
0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x62,
0x3b, 0x4f, 0x6b, 0x69, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x77, 0x61, 0x6c, 0x69,
0x79, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b,
0x41, 0x70, 0x75, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x69, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x62, 0x75, 0x74, 0x74,
0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x63, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67,
0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69,
0x3b, 0x45, 0x70, 0x72, 0x65, 0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61,
0x69, 0x3b, 0x4f, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72,
0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74,
0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x75, 0x76, 0x3b, 0x44, 0x69, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x72, 0x75, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x75, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b,
0x4d, 0x61, 0x69, 0x75, 0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x75, 0x3b, 0x41, 0x67, 0x6f,
0x73, 0x74, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b,
0x4e, 0x75, 0x76, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x7a, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x41,
0x4e, 0x3b, 0x46, 0x45, 0x42, 0x3b, 0x4d, 0x41, 0x43, 0x3b, 0x128, 0x50, 0x55, 0x3b, 0x4d, 0x128, 0x128, 0x3b, 0x4e, 0x4a,
0x55, 0x3b, 0x4e, 0x4a, 0x52, 0x3b, 0x41, 0x47, 0x41, 0x3b, 0x53, 0x50, 0x54, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4e, 0x4f,
0x56, 0x3b, 0x44, 0x45, 0x43, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x75,
0x61, 0x72, 0x129, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x128, 0x70, 0x75, 0x72, 0x169, 0x3b, 0x4d, 0x129, 0x129, 0x3b,
0x4e, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x72, 0x61, 0x129, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b,
0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x169, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x128, 0x3b,
0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x75, 0x6c, 0x3b,
0x4e, 0x67, 0x61, 0x74, 0x3b, 0x54, 0x61, 0x61, 0x3b, 0x49, 0x77, 0x6f, 0x3b, 0x4d, 0x61, 0x6d, 0x3b, 0x50, 0x61, 0x61,
0x3b, 0x4e, 0x67, 0x65, 0x3b, 0x52, 0x6f, 0x6f, 0x3b, 0x42, 0x75, 0x72, 0x3b, 0x45, 0x70, 0x65, 0x3b, 0x4b, 0x70, 0x74,
0x3b, 0x4b, 0x70, 0x61, 0x3b, 0x4d, 0x75, 0x6c, 0x67, 0x75, 0x6c, 0x3b, 0x4e, 0x67, 0x2019, 0x61, 0x74, 0x79, 0x61, 0x61,
0x74, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x74, 0x61, 0x61, 0x6d, 0x6f, 0x3b, 0x49, 0x77, 0x6f, 0x6f, 0x74, 0x6b, 0x75, 0x75,
0x74, 0x3b, 0x4d, 0x61, 0x6d, 0x75, 0x75, 0x74, 0x3b, 0x50, 0x61, 0x61, 0x67, 0x69, 0x3b, 0x4e, 0x67, 0x2019, 0x65, 0x69,
0x79, 0x65, 0x65, 0x74, 0x3b, 0x52, 0x6f, 0x6f, 0x70, 0x74, 0x75, 0x69, 0x3b, 0x42, 0x75, 0x72, 0x65, 0x65, 0x74, 0x3b,
0x45, 0x70, 0x65, 0x65, 0x73, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x20,
0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x62, 0x6f, 0x20,
0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4e, 0x3b,
0x52, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e, 0x6e, 0x69, 0x3b, 0x1c3, 0x4b,
0x68, 0x61, 0x6e, 0x1c0, 0x67, 0xf4, 0x61, 0x62, 0x3b, 0x1c0, 0x4b, 0x68, 0x75, 0x75, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b,
0x1c3, 0x48, 0xf4, 0x61, 0x1c2, 0x6b, 0x68, 0x61, 0x69, 0x62, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x69, 0x74, 0x73, 0xe2, 0x62,
0x3b, 0x47, 0x61, 0x6d, 0x61, 0x1c0, 0x61, 0x65, 0x62, 0x3b, 0x1c2, 0x4b, 0x68, 0x6f, 0x65, 0x73, 0x61, 0x6f, 0x62, 0x3b,
0x41, 0x6f, 0x1c1, 0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x54, 0x61, 0x72, 0x61, 0x1c0,
0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x1c2, 0x4e, 0xfb, 0x1c1, 0x6e, 0xe2, 0x69, 0x73,
0x65, 0x62, 0x3b, 0x1c0, 0x48, 0x6f, 0x6f, 0x1c2, 0x67, 0x61, 0x65, 0x62, 0x3b, 0x48, 0xf4, 0x61, 0x73, 0x6f, 0x72, 0x65,
0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0xe4, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x7a, 0x2e,
0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0xe4, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b,
0x4f, 0x75, 0x6a, 0x2e, 0x3b, 0x53, 0xe4, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b,
0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x65, 0x77, 0x61, 0x3b, 0x46, 0xe4, 0x62, 0x72, 0x6f, 0x77, 0x61,
0x3b, 0x4d, 0xe4, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x6c, 0x3b, 0x4d, 0xe4, 0x69, 0x3b, 0x4a, 0x75, 0x75,
0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x4f, 0x75, 0x6a, 0x6f, 0xdf, 0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0xe4, 0x62, 0x3b,
0x4d, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0xe4, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x4f, 0x75, 0x6a, 0x3b, 0x53, 0xe4, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b,
0x44, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0xe1, 0x3b, 0x186, 0x25b, 0x6e, 0x3b, 0x44, 0x6f, 0x79, 0x3b, 0x4c, 0xe9, 0x70, 0x3b,
0x52, 0x6f, 0x6b, 0x3b, 0x53, 0xe1, 0x73, 0x3b, 0x42, 0x254, 0x301, 0x72, 0x3b, 0x4b, 0xfa, 0x73, 0x3b, 0x47, 0xed, 0x73,
0x3b, 0x53, 0x68, 0x289, 0x301, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x3b, 0x4f, 0x6c, 0x61, 0x64, 0x61, 0x6c, 0x289, 0x301, 0x3b,
0x41, 0x72, 0xe1, 0x74, 0x3b, 0x186, 0x25b, 0x6e, 0x268, 0x301, 0x254, 0x268, 0x14b, 0x254, 0x6b, 0x3b, 0x4f, 0x6c, 0x6f, 0x64,
0x6f, 0x79, 0xed, 0xf3, 0x72, 0xed, 0xea, 0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4f, 0x6c, 0x6f, 0x69,
0x6c, 0xe9, 0x70, 0x16b, 0x6e, 0x79, 0x12b, 0x113, 0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4b, 0xfa, 0x6a,
0xfa, 0x254, 0x72, 0x254, 0x6b, 0x3b, 0x4d, 0xf3, 0x72, 0x75, 0x73, 0xe1, 0x73, 0x69, 0x6e, 0x3b, 0x186, 0x6c, 0x254, 0x301,
0x268, 0x301, 0x62, 0x254, 0x301, 0x72, 0xe1, 0x72, 0x25b, 0x3b, 0x4b, 0xfa, 0x73, 0x68, 0xee, 0x6e, 0x3b, 0x4f, 0x6c, 0x67,
0xed, 0x73, 0x61, 0x6e, 0x3b, 0x50, 0x289, 0x73, 0x68, 0x289, 0x301, 0x6b, 0x61, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x14b, 0x289,
0x301, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d,
0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41,
0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x52,
0x61, 0x72, 0x3b, 0x4d, 0x75, 0x6b, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d,
0x6f, 0x64, 0x3b, 0x4a, 0x6f, 0x6c, 0x3b, 0x50, 0x65, 0x64, 0x3b, 0x53, 0x6f, 0x6b, 0x3b, 0x54, 0x69, 0x62, 0x3b, 0x4c,
0x61, 0x62, 0x3b, 0x50, 0x6f, 0x6f, 0x3b, 0x4f, 0x72, 0x61, 0x72, 0x61, 0x3b, 0x4f, 0x6d, 0x75, 0x6b, 0x3b, 0x4f, 0x6b,
0x77, 0x61, 0x6d, 0x67, 0x2019, 0x3b, 0x4f, 0x64, 0x75, 0x6e, 0x67, 0x2019, 0x65, 0x6c, 0x3b, 0x4f, 0x6d, 0x61, 0x72, 0x75,
0x6b, 0x3b, 0x4f, 0x6d, 0x6f, 0x64, 0x6f, 0x6b, 0x2019, 0x6b, 0x69, 0x6e, 0x67, 0x2019, 0x6f, 0x6c, 0x3b, 0x4f, 0x6a, 0x6f,
0x6c, 0x61, 0x3b, 0x4f, 0x70, 0x65, 0x64, 0x65, 0x6c, 0x3b, 0x4f, 0x73, 0x6f, 0x6b, 0x6f, 0x73, 0x6f, 0x6b, 0x6f, 0x6d,
0x61, 0x3b, 0x4f, 0x74, 0x69, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x3b, 0x4f, 0x70, 0x6f, 0x6f,
0x3b, 0x52, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x4c, 0x3b, 0x50, 0x3b, 0x17d, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x69,
0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x3b, 0x17d, 0x75, 0x79, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x6f, 0x3b, 0x44, 0x65, 0x65, 0x3b, 0x17d, 0x61, 0x6e, 0x77, 0x69, 0x79, 0x65, 0x3b, 0x46,
0x65, 0x65, 0x77, 0x69, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x69, 0x3b, 0x41, 0x77, 0x69, 0x72, 0x69,
0x6c, 0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x65, 0x14b, 0x3b, 0x17d, 0x75, 0x79, 0x79, 0x65, 0x3b, 0x55, 0x74, 0x3b,
0x53, 0x65, 0x6b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x75, 0x72, 0x3b, 0x4e,
0x6f, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x44, 0x65, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x17d,
0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x17d, 0x3b, 0x17d, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x44, 0x41, 0x43, 0x3b, 0x44, 0x41, 0x52, 0x3b, 0x44, 0x41, 0x44, 0x3b, 0x44, 0x41, 0x4e, 0x3b, 0x44,
0x41, 0x48, 0x3b, 0x44, 0x41, 0x55, 0x3b, 0x44, 0x41, 0x4f, 0x3b, 0x44, 0x41, 0x42, 0x3b, 0x44, 0x4f, 0x43, 0x3b, 0x44,
0x41, 0x50, 0x3b, 0x44, 0x47, 0x49, 0x3b, 0x44, 0x41, 0x47, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41,
0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b,
0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72,
0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69,
0x63, 0x68, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x75, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44,
0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x62, 0x6f, 0x72, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4f, 0x63, 0x68,
0x69, 0x6b, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x3b, 0x44, 0x77, 0x65,
0x20, 0x6d, 0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x43, 0x3b, 0x52,
0x3b, 0x44, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x55, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x50,
0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x49, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x75, 0x74, 0x3b, 0x4b, 0x1e6d, 0x75,
0x3b, 0x4e, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6a, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x59, 0x65,
0x62, 0x72, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x49, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61,
0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x194, 0x75, 0x63,
0x74, 0x3b, 0x43, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x4b, 0x1e6d, 0x75, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x77,
0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x44, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x4d,
0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a,
0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x6c, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68,
0x69, 0x3b, 0x41, 0x70, 0x6c, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e,
0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x938, 0x3b, 0x90f, 0x92b, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x907, 0x3b, 0x906, 0x917, 0x938, 0x94d, 0x925, 0x3b, 0x938, 0x947, 0x92c, 0x925, 0x947,
0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x905, 0x916, 0x925, 0x92c, 0x930, 0x3b, 0x928, 0x92c, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930,
0x3b, 0x926, 0x93f, 0x938, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f,
0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x3b, 0x91c, 0x941, 0x3b, 0x906, 0x3b, 0x938, 0x947, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926,
0x93f, 0x3b, 0x43, 0x69, 0x6f, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x75, 0x3b, 0x4c, 0x75,
0x6d, 0x3b, 0x4c, 0x75, 0x66, 0x3b, 0x4b, 0x61, 0x62, 0x3b, 0x4c, 0x75, 0x73, 0x68, 0x3b, 0x4c, 0x75, 0x74, 0x3b, 0x4c,
0x75, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x43, 0x69, 0x73, 0x3b, 0x43, 0x69, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0xf9,
0x69, 0x73, 0x68, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0xf2, 0x6c, 0x6f, 0x3b, 0x4d, 0xf9, 0x75, 0x79, 0xe0, 0x3b, 0x4c, 0x75,
0x6d, 0xf9, 0x6e, 0x67, 0xf9, 0x6c, 0xf9, 0x3b, 0x4c, 0x75, 0x66, 0x75, 0x69, 0x6d, 0x69, 0x3b, 0x4b, 0x61, 0x62, 0xe0,
0x6c, 0xe0, 0x73, 0x68, 0xec, 0x70, 0xf9, 0x3b, 0x4c, 0xf9, 0x73, 0x68, 0xec, 0x6b, 0xe0, 0x3b, 0x4c, 0x75, 0x74, 0x6f,
0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x67, 0xf9, 0x64, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x77, 0xe8, 0x6b,
0xe8, 0x73, 0xe8, 0x3b, 0x43, 0x69, 0x73, 0x77, 0xe0, 0x3b, 0x43, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b,
0x4c, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65,
0x62, 0x3b, 0x4d, 0xe4, 0x65, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75,
0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65,
0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x65,
0x72, 0x7a, 0x3b, 0x41, 0x62, 0x72, 0xeb, 0x6c, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a,
0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65,
0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x65,
0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69,
0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e,
0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x6e, 0xf9, 0x6d, 0x3b, 0x6b, 0x268, 0x7a, 0x3b, 0x74, 0x268, 0x64, 0x3b, 0x74, 0x61,
0x61, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x6e, 0x7a, 0x75, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x66, 0x254, 0x65, 0x3b, 0x64, 0x7a,
0x75, 0x3b, 0x6c, 0x254, 0x6d, 0x3b, 0x6b, 0x61, 0x61, 0x3b, 0x66, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b,
0x254, 0x300, 0x6e, 0xf9, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x197, 0x300, 0x7a, 0xf9, 0x294,
0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x64, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x3b, 0x6e,
0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x1ce, 0x61, 0x66, 0x289, 0x304, 0x67, 0x68, 0x101, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0xe8, 0x73, 0xe8, 0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0x7a, 0xf9, 0x67,
0x68, 0xf2, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x64, 0xf9, 0x6d, 0x6c, 0x6f, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x77, 0xee, 0x66, 0x254, 0x300, 0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254,
0x300, 0x74, 0x197, 0x300, 0x66, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x64, 0x7a, 0x75, 0x67, 0x68, 0xf9, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0x254, 0x300, 0x67, 0x68, 0x1d4, 0x75, 0x77, 0x65, 0x6c, 0x254, 0x300, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254,
0x300, 0x14b, 0x254, 0x300, 0x63, 0x68, 0x77, 0x61, 0x294, 0xe0, 0x6b, 0x61, 0x61, 0x20, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0xe8, 0x66, 0x77, 0xf2, 0x6f, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x74, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a,
0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x63, 0x3b, 0x66, 0x3b, 0x6b, 0x254, 0x6e, 0x3b, 0x6d, 0x61, 0x63,
0x3b, 0x6d, 0x61, 0x74, 0x3b, 0x6d, 0x74, 0x6f, 0x3b, 0x6d, 0x70, 0x75, 0x3b, 0x68, 0x69, 0x6c, 0x3b, 0x6e, 0x6a, 0x65,
0x3b, 0x68, 0x69, 0x6b, 0x3b, 0x64, 0x69, 0x70, 0x3b, 0x62, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6c, 0x69, 0x253,
0x3b, 0x4b, 0x254, 0x6e, 0x64, 0x254, 0x14b, 0x3b, 0x4d, 0xe0, 0x63, 0x25b, 0x302, 0x6c, 0x3b, 0x4d, 0xe0, 0x74, 0xf9, 0x6d,
0x62, 0x3b, 0x4d, 0xe0, 0x74, 0x6f, 0x70, 0x3b, 0x4d, 0x300, 0x70, 0x75, 0x79, 0x25b, 0x3b, 0x48, 0xec, 0x6c, 0xf2, 0x6e,
0x64, 0x25b, 0x300, 0x3b, 0x4e, 0x6a, 0xe8, 0x62, 0xe0, 0x3b, 0x48, 0xec, 0x6b, 0x61, 0x14b, 0x3b, 0x44, 0xec, 0x70, 0x254,
0x300, 0x73, 0x3b, 0x42, 0xec, 0xf2, 0xf4, 0x6d, 0x3b, 0x4d, 0xe0, 0x79, 0x25b, 0x73, 0xe8, 0x70, 0x3b, 0x4c, 0xec, 0x62,
0x75, 0x79, 0x20, 0x6c, 0x69, 0x20, 0x144, 0x79, 0xe8, 0x65, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d,
0x3b, 0x68, 0x3b, 0x6e, 0x3b, 0x68, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x6d, 0x3b, 0x6c, 0x3b, 0x64, 0x69, 0x3b, 0x14b, 0x67,
0x254, 0x6e, 0x3b, 0x73, 0x254, 0x14b, 0x3b, 0x64, 0x69, 0x253, 0x3b, 0x65, 0x6d, 0x69, 0x3b, 0x65, 0x73, 0x254, 0x3b, 0x6d,
0x61, 0x64, 0x3b, 0x64, 0x69, 0x14b, 0x3b, 0x6e, 0x79, 0x25b, 0x74, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x74, 0x69, 0x6e, 0x3b,
0x65, 0x6c, 0xe1, 0x3b, 0x64, 0x69, 0x6d, 0x254, 0x301, 0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x64, 0x25b, 0x3b, 0x73,
0x254, 0x14b, 0x25b, 0x3b, 0x64, 0x69, 0x253, 0xe1, 0x253, 0xe1, 0x3b, 0x65, 0x6d, 0x69, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x3b,
0x65, 0x73, 0x254, 0x70, 0x25b, 0x73, 0x254, 0x70, 0x25b, 0x3b, 0x6d, 0x61, 0x64, 0x69, 0x253, 0x25b, 0x301, 0x64, 0xed, 0x253,
0x25b, 0x301, 0x3b, 0x64, 0x69, 0x14b, 0x67, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6e, 0x79, 0x25b, 0x74, 0x25b, 0x6b, 0x69, 0x3b,
0x6d, 0x61, 0x79, 0xe9, 0x73, 0x25b, 0x301, 0x3b, 0x74, 0x69, 0x6e, 0xed, 0x6e, 0xed, 0x3b, 0x65, 0x6c, 0xe1, 0x14b, 0x67,
0x25b, 0x301, 0x3b, 0x64, 0x3b, 0x14b, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x65, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x64, 0x3b, 0x6e,
0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x65, 0x3b, 0x53, 0x61, 0x3b, 0x46, 0x65, 0x3b, 0x4d, 0x61, 0x3b, 0x41, 0x62, 0x3b, 0x4d,
0x65, 0x3b, 0x53, 0x75, 0x3b, 0x53, 0xfa, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x3b, 0x4f, 0x6b, 0x3b, 0x4e, 0x6f, 0x3b,
0x44, 0x65, 0x3b, 0x53, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x46, 0xe9, 0x62, 0x69, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61,
0x72, 0x73, 0x3b, 0x41, 0x62, 0x75, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x65, 0x14b, 0x3b, 0x53,
0xfa, 0x75, 0x79, 0x65, 0x65, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f,
0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x61,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x55,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6e, 0x67, 0x6f, 0x3b, 0x6e, 0x67, 0x62, 0x3b, 0x6e, 0x67, 0x6c,
0x3b, 0x6e, 0x67, 0x6e, 0x3b, 0x6e, 0x67, 0x74, 0x3b, 0x6e, 0x67, 0x73, 0x3b, 0x6e, 0x67, 0x7a, 0x3b, 0x6e, 0x67, 0x6d,
0x3b, 0x6e, 0x67, 0x65, 0x3b, 0x6e, 0x67, 0x61, 0x3b, 0x6e, 0x67, 0x61, 0x64, 0x3b, 0x6e, 0x67, 0x61, 0x62, 0x3b, 0x6e,
0x67, 0x254, 0x6e, 0x20, 0x6f, 0x73, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6e, 0x67, 0x254,
0x6e, 0x20, 0x6c, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6e, 0x79, 0x69, 0x6e, 0x61, 0x3b, 0x6e, 0x67,
0x254, 0x6e, 0x20, 0x74, 0xe1, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x73, 0x61, 0x6d, 0x259, 0x6e, 0x61, 0x3b,
0x6e, 0x67, 0x254, 0x6e, 0x20, 0x7a, 0x61, 0x6d, 0x67, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6d,
0x77, 0x6f, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x65, 0x62, 0x75, 0x6c, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20,
0x61, 0x77, 0xf3, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x64, 0x7a,
0x69, 0xe1, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x62, 0x25b, 0x30c, 0x3b,
0x6f, 0x3b, 0x62, 0x3b, 0x6c, 0x3b, 0x6e, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x61, 0x3b,
0x64, 0x3b, 0x62, 0x3b, 0x14b, 0x31, 0x3b, 0x14b, 0x32, 0x3b, 0x14b, 0x33, 0x3b, 0x14b, 0x34, 0x3b, 0x14b, 0x35, 0x3b, 0x14b,
0x36, 0x3b, 0x14b, 0x37, 0x3b, 0x14b, 0x38, 0x3b, 0x14b, 0x39, 0x3b, 0x14b, 0x31, 0x30, 0x3b, 0x14b, 0x31, 0x31, 0x3b, 0x14b,
0x31, 0x32, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x20, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x74, 0x254, 0x3b, 0x14b, 0x77,
0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x62, 0x25b, 0x301, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd,
0x20, 0x72, 0xe1, 0xe1, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77,
0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd,
0x20, 0x74, 0xe1, 0x61, 0x66, 0x254, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61,
0x62, 0x25b, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x72, 0x61, 0x61, 0x3b,
0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed,
0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e,
0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x254, 0x301, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd,
0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x25b, 0x301, 0x25b, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x55, 0x6e,
0x61, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x43, 0x68, 0x65, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x63, 0x3b, 0x53, 0x61,
0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4d, 0x6f, 0x6a, 0x3b, 0x59, 0x65,
0x6c, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x61, 0x79, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x72, 0x61, 0x72, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f,
0x20, 0x75, 0x6e, 0x65, 0x63, 0x68, 0x65, 0x73, 0x68, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20,
0x75, 0x6e, 0x65, 0x74, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x68,
0x61, 0x6e, 0x75, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x63, 0x68, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x6f, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6e, 0x61, 0x6e, 0x65,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20,
0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x79, 0x65, 0x6c, 0x2019, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x55, 0x3b, 0x52,
0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x46,
0x4c, 0x4f, 0x3b, 0x43, 0x4c, 0x41, 0x3b, 0x43, 0x4b, 0x49, 0x3b, 0x46, 0x4d, 0x46, 0x3b, 0x4d, 0x41, 0x44, 0x3b, 0x4d,
0x42, 0x49, 0x3b, 0x4d, 0x4c, 0x49, 0x3b, 0x4d, 0x41, 0x4d, 0x3b, 0x46, 0x44, 0x45, 0x3b, 0x46, 0x4d, 0x55, 0x3b, 0x46,
0x47, 0x57, 0x3b, 0x46, 0x59, 0x55, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4c, 0x6f, 0x6f, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77,
0x61, 0x6b, 0x6c, 0x61, 0x14b, 0x6e, 0x65, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x69, 0x69, 0x3b, 0x46,
0x129, 0x69, 0x20, 0x4d, 0x61, 0x72, 0x66, 0x6f, 0x6f, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x1dd, 0x75, 0x75, 0x74, 0x1dd, 0x62,
0x69, 0x6a, 0x61, 0x14b, 0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x66, 0x61, 0x68, 0x62, 0x69, 0x69,
0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x6c, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x6d, 0x62,
0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x44, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x75,
0x6e, 0x64, 0x61, 0x14b, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x47, 0x77, 0x61, 0x68, 0x6c, 0x6c, 0x65, 0x3b, 0x46, 0x129, 0x69,
0x20, 0x59, 0x75, 0x72, 0x75, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b,
0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x6e, 0x67, 0x31, 0x3b, 0x6e, 0x67, 0x32, 0x3b, 0x6e, 0x67,
0x33, 0x3b, 0x6e, 0x67, 0x34, 0x3b, 0x6e, 0x67, 0x35, 0x3b, 0x6e, 0x67, 0x36, 0x3b, 0x6e, 0x67, 0x37, 0x3b, 0x6e, 0x67,
0x38, 0x3b, 0x6e, 0x67, 0x39, 0x3b, 0x6e, 0x67, 0x31, 0x30, 0x3b, 0x6e, 0x67, 0x31, 0x31, 0x3b, 0x6b, 0x72, 0x69, 0x73,
0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6d, 0x61, 0x74, 0xe1, 0x68, 0x72, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e,
0x20, 0x144, 0x6d, 0x62, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6c, 0x61, 0x6c, 0x3b, 0x6e, 0x67, 0x77,
0x25b, 0x6e, 0x20, 0x144, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x61, 0x6e, 0x3b, 0x6e, 0x67,
0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x75, 0xf3, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x68, 0x25b, 0x6d, 0x62, 0x75,
0x25b, 0x72, 0xed, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6c, 0x254, 0x6d, 0x62, 0x69, 0x3b, 0x6e, 0x67, 0x77, 0x25b,
0x6e, 0x20, 0x72, 0x25b, 0x62, 0x76, 0x75, 0xe2, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x3b, 0x6e,
0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x20, 0x6e, 0x61, 0x76, 0x1d4, 0x72, 0x3b, 0x6b, 0x72, 0xed, 0x73, 0x69,
0x6d, 0x69, 0x6e, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254, 0x331, 0x3b,
0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x3b, 0x4b, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x54, 0x68, 0x6f,
0x6f, 0x3b, 0x54, 0x25b, 0x25b, 0x3b, 0x4c, 0x61, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69, 0x64, 0x3b, 0x54, 0x69,
0x6f, 0x70, 0x20, 0x74, 0x68, 0x61, 0x72, 0x20, 0x70, 0x25b, 0x74, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331,
0x254, 0x331, 0x14b, 0x3b, 0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x74, 0x3b, 0x4b, 0x6f, 0x72, 0x6e, 0x79, 0x6f,
0x6f, 0x74, 0x3b, 0x50, 0x61, 0x79, 0x20, 0x79, 0x69, 0x65, 0x331, 0x74, 0x6e, 0x69, 0x3b, 0x54, 0x68, 0x6f, 0x331, 0x6f,
0x331, 0x72, 0x3b, 0x54, 0x25b, 0x25b, 0x72, 0x3b, 0x4c, 0x61, 0x61, 0x74, 0x68, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69,
0x6f, 0x331, 0x70, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x331, 0x69, 0x331, 0x74, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x44, 0x3b,
0x47, 0x3b, 0x44, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x422, 0x43e,
0x445, 0x441, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x3b, 0x41a, 0x43b, 0x43d, 0x5f, 0x442, 0x442, 0x440, 0x3b, 0x41c, 0x443, 0x441, 0x5f,
0x443, 0x441, 0x442, 0x3b, 0x42b, 0x430, 0x43c, 0x5f, 0x439, 0x43d, 0x3b, 0x411, 0x44d, 0x441, 0x5f, 0x439, 0x43d, 0x3b, 0x41e, 0x442,
0x5f, 0x439, 0x43d, 0x3b, 0x410, 0x442, 0x440, 0x434, 0x44c, 0x5f, 0x439, 0x43d, 0x3b, 0x411, 0x43b, 0x495, 0x43d, 0x5f, 0x439, 0x43d,
0x3b, 0x410, 0x43b, 0x442, 0x3b, 0x421, 0x44d, 0x442, 0x3b, 0x410, 0x445, 0x441, 0x3b, 0x422, 0x43e, 0x445, 0x441, 0x443, 0x43d, 0x43d,
0x44c, 0x443, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41a, 0x443, 0x43b, 0x443, 0x43d, 0x20, 0x442, 0x443, 0x442,
0x430, 0x440, 0x3b, 0x41c, 0x443, 0x443, 0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x42b, 0x430, 0x43c, 0x20, 0x44b, 0x439,
0x44b, 0x43d, 0x3b, 0x411, 0x44d, 0x441, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x41e, 0x442, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b,
0x410, 0x442, 0x44b, 0x440, 0x434, 0x44c, 0x44b, 0x445, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x430, 0x43b, 0x430, 0x495, 0x430,
0x43d, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x421, 0x44d, 0x442, 0x438,
0x43d, 0x43d, 0x44c, 0x438, 0x3b, 0x410, 0x445, 0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x422, 0x3b, 0x41e, 0x3b, 0x41a, 0x3b,
0x41c, 0x3b, 0x42b, 0x3b, 0x411, 0x3b, 0x41e, 0x3b, 0x410, 0x3b, 0x411, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x410, 0x3b, 0x4d, 0x75,
0x70, 0x3b, 0x4d, 0x77, 0x69, 0x3b, 0x4d, 0x73, 0x68, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x67, 0x3b, 0x4d, 0x75,
0x6a, 0x3b, 0x4d, 0x73, 0x70, 0x3b, 0x4d, 0x70, 0x67, 0x3b, 0x4d, 0x79, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b, 0x4d, 0x75,
0x73, 0x3b, 0x4d, 0x75, 0x68, 0x3b, 0x4d, 0x75, 0x70, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x77, 0x61, 0x3b, 0x4d,
0x77, 0x69, 0x74, 0x6f, 0x70, 0x65, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x75, 0x6e, 0x79,
0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x67, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x75,
0x6a, 0x69, 0x6d, 0x62, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x69, 0x70, 0x65, 0x70, 0x6f, 0x3b, 0x4d, 0x75, 0x70, 0x75,
0x67, 0x75, 0x74, 0x6f, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x68, 0x75, 0x3b,
0x4d, 0x75, 0x73, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x6d, 0x62, 0x77, 0x65, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x61,
0x6e, 0x6f, 0x3b, 0xa5a8, 0xa56a, 0xa583, 0x20, 0xa51e, 0xa56e, 0x3b, 0xa552, 0xa561, 0xa59d, 0xa595, 0x3b, 0xa57e, 0xa5ba, 0x3b, 0xa5a2, 0xa595,
0x3b, 0xa591, 0xa571, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0xa5db, 0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d, 0xa583, 0x3b, 0xa51e, 0xa60b, 0xa554,
0xa57f, 0x20, 0xa578, 0xa583, 0xa5cf, 0x3b, 0xa5a8, 0xa56a, 0xa571, 0x20, 0xa5cf, 0xa56e, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20,
0x6b, 0x65, 0x6d, 0xe3, 0x3b, 0x253, 0x61, 0x6e, 0x64, 0x61, 0x253, 0x75, 0x3b, 0x76, 0x254, 0x254, 0x3b, 0x66, 0x75, 0x6c,
0x75, 0x3b, 0x67, 0x6f, 0x6f, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x6b, 0x254, 0x6e, 0x64, 0x65, 0x3b, 0x73, 0x61, 0x61, 0x68,
0x3b, 0x67, 0x61, 0x6c, 0x6f, 0x3b, 0x6b, 0x65, 0x6e, 0x70, 0x6b, 0x61, 0x74, 0x6f, 0x20, 0x253, 0x6f, 0x6c, 0x6f, 0x6c,
0x254, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20, 0x6c, 0x254, 0x6d, 0x61, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x48, 0x6f,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x42, 0x72, 0xe1, 0x3b, 0x48, 0x65,
0x69, 0x3b, 0xd6, 0x69, 0x67, 0x3b, 0x48, 0x65, 0x72, 0x3b, 0x57, 0xed, 0x6d, 0x3b, 0x57, 0x69, 0x6e, 0x3b, 0x43, 0x68,
0x72, 0x3b, 0x4a, 0x65, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x48, 0x6f, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0x72, 0x7a,
0x65, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x6a, 0x65, 0x3b, 0x42, 0x72, 0xe1, 0x10d,
0x65, 0x74, 0x3b, 0x48, 0x65, 0x69, 0x77, 0x65, 0x74, 0x3b, 0xd6, 0x69, 0x67, 0x161, 0x74, 0x65, 0x3b, 0x48, 0x65, 0x72,
0x62, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0xed, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0x69, 0x6e,
0x74, 0x65, 0x72, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x43, 0x68, 0x72, 0x69, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74,
0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x48, 0x3b, 0xd6, 0x3b, 0x48, 0x3b, 0x57,
0x3b, 0x57, 0x3b, 0x43, 0x3b, 0x6f, 0x2e, 0x31, 0x3b, 0x6f, 0x2e, 0x32, 0x3b, 0x6f, 0x2e, 0x33, 0x3b, 0x6f, 0x2e, 0x34,
0x3b, 0x6f, 0x2e, 0x35, 0x3b, 0x6f, 0x2e, 0x36, 0x3b, 0x6f, 0x2e, 0x37, 0x3b, 0x6f, 0x2e, 0x38, 0x3b, 0x6f, 0x2e, 0x39,
0x3b, 0x6f, 0x2e, 0x31, 0x30, 0x3b, 0x6f, 0x2e, 0x31, 0x31, 0x3b, 0x6f, 0x2e, 0x31, 0x32, 0x3b, 0x70, 0x69, 0x6b, 0xed,
0x74, 0xed, 0x6b, 0xed, 0x74, 0x69, 0x65, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0xed, 0x20, 0xfa, 0x20, 0x6b, 0x75, 0x74, 0xfa,
0x61, 0x6e, 0x3b, 0x73, 0x69, 0x25b, 0x79, 0x25b, 0x301, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1,
0x6e, 0x64, 0xed, 0x25b, 0x3b, 0x254, 0x6e, 0x73, 0xfa, 0x6d, 0x62, 0x254, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20,
0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x74, 0xfa, 0x25b, 0x3b, 0x6d, 0x65, 0x73, 0x69, 0x14b, 0x2c, 0x20, 0x6f, 0xf3, 0x6c,
0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe9, 0x6e, 0x69, 0x65, 0x3b, 0x65, 0x6e, 0x73, 0x69, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c,
0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x6e, 0x75, 0x25b, 0x3b, 0x254, 0x73, 0x254, 0x6e, 0x3b, 0x65, 0x66, 0x75,
0x74, 0x65, 0x3b, 0x70, 0x69, 0x73, 0x75, 0x79, 0xfa, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x254,
0x73, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x74, 0xfa, 0x6b, 0x2c, 0x6f, 0xf3, 0x6c, 0x69, 0x20,
0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xed, 0x25b, 0x3b, 0x6d, 0x61, 0x6b, 0x61, 0x6e, 0x64, 0x69, 0x6b, 0x25b, 0x3b, 0x70, 0x69,
0x6c, 0x254, 0x6e, 0x64, 0x254, 0x301, 0x3b, 0x58, 0x69, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41,
0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x58, 0x75, 0x6e, 0x3b, 0x58, 0x6e, 0x74, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53,
0x65, 0x74, 0x3b, 0x4f, 0x63, 0x68, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x41, 0x76, 0x69, 0x3b, 0x78, 0x69, 0x6e, 0x65, 0x72,
0x75, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x61, 0x62, 0x72, 0x69,
0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x75, 0x3b, 0x78, 0x75, 0x6e, 0x75, 0x3b, 0x78, 0x75, 0x6e, 0x65, 0x74, 0x75, 0x3b, 0x61,
0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x68, 0x6f,
0x62, 0x72, 0x65, 0x3b, 0x70, 0x61, 0x79, 0x61, 0x72, 0x65, 0x73, 0x3b, 0x61, 0x76, 0x69, 0x65, 0x6e, 0x74, 0x75, 0x3b,
0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b,
0x50, 0x3b, 0x41, 0x3b, 0x78, 0x69, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b,
0x6d, 0x61, 0x79, 0x3b, 0x78, 0x75, 0x6e, 0x3b, 0x78, 0x6e, 0x74, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b,
0x6f, 0x63, 0x68, 0x3b, 0x70, 0x61, 0x79, 0x3b, 0x61, 0x76, 0x69, 0x3b, 0x64, 0x65, 0x20, 0x78, 0x69, 0x6e, 0x65, 0x72,
0x75, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x7a,
0x75, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x79, 0x75, 0x3b, 0x64, 0x65,
0x20, 0x78, 0x75, 0x6e, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x78, 0x75, 0x6e, 0x65, 0x74, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x67,
0x6f, 0x73, 0x74, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019,
0x6f, 0x63, 0x68, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x70, 0x61, 0x79, 0x61, 0x72, 0x65, 0x73, 0x3b, 0x64,
0x2019, 0x61, 0x76, 0x69, 0x65, 0x6e, 0x74, 0x75, 0x3b, 0x4e, 0x64, 0x75, 0x14b, 0x6d, 0x62, 0x69, 0x20, 0x53, 0x61, 0x14b,
0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x70, 0xe1, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50,
0x25b, 0x301, 0x74, 0xe1, 0x74, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x6b, 0x77,
0x61, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x61, 0x74, 0x61, 0x61, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20,
0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x6e, 0x74, 0xfa, 0x6b, 0xfa, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x53, 0x61,
0x61, 0x6d, 0x62, 0xe1, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x66, 0x254, 0x6d,
0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x70, 0x66, 0xfa, 0xa78b, 0xfa, 0x3b, 0x50,
0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x25b, 0x67, 0x25b, 0x301, 0x6d, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x74,
0x73, 0x254, 0x30c, 0x70, 0x6d, 0x254, 0x301, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x74, 0x73, 0x254, 0x30c, 0x70,
0x70, 0xe1, 0x3b, 0x70, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x6d, 0x62, 0x69, 0x79, 0x254,
0x20, 0x6d, 0x25b, 0x6e, 0x64, 0x6f, 0x14b, 0x67, 0x254, 0x3b, 0x4e, 0x79, 0x254, 0x6c, 0x254, 0x6d, 0x62, 0x254, 0x14b, 0x67,
0x254, 0x3b, 0x4d, 0x254, 0x6e, 0x254, 0x20, 0x14b, 0x67, 0x62, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x14b, 0x67,
0x77, 0x25b, 0x20, 0x14b, 0x67, 0x62, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x6b, 0x75, 0x14b, 0x67, 0x77, 0x25b, 0x3b, 0x66, 0x25b,
0x3b, 0x6e, 0x6a, 0x61, 0x70, 0x69, 0x3b, 0x6e, 0x79, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x31, 0x31, 0x3b, 0x253, 0x75, 0x6c,
0x253, 0x75, 0x73, 0x25b, 0x3b, 0x6d, 0x62, 0x65, 0x67, 0x74, 0x75, 0x67, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0xe0, 0x62,
0xf9, 0x62, 0xec, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0x6d, 0x62, 0x259, 0x14b, 0x63, 0x68, 0x75, 0x62, 0x69, 0x3b, 0x69,
0x6d, 0x259, 0x67, 0x20, 0x6e, 0x67, 0x77, 0x259, 0x300, 0x74, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x66, 0x6f, 0x67, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x69, 0x62, 0x254, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0xe0,
0x64, 0xf9, 0x6d, 0x62, 0x259, 0x300, 0x14b, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x6b, 0x61, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x75, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x74, 0xe8, 0x73, 0x69, 0x2bc, 0x65,
0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x7a, 0xf2, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x72, 0x69, 0x7a, 0x6d, 0x65,
0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6d, 0x62, 0x65, 0x67, 0x74, 0x75, 0x67, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20,
0xe0, 0x62, 0xf9, 0x62, 0xec, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0x6d, 0x62, 0x259, 0x14b, 0x63, 0x68, 0x75, 0x62, 0x69,
0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6e, 0x67, 0x77, 0x259, 0x300, 0x74, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x66, 0x6f,
0x67, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x69, 0x62, 0x254, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67,
0x20, 0xe0, 0x64, 0xf9, 0x6d, 0x62, 0x259, 0x300, 0x14b, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x6b,
0x61, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x75, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x74, 0xe8, 0x73, 0x69,
0x2bc, 0x65, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x7a, 0xf2, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x72, 0x69, 0x7a,
0x6d, 0x65, 0x64, 0x3b, 0x4d, 0x31, 0x3b, 0x41, 0x32, 0x3b, 0x4d, 0x33, 0x3b, 0x4e, 0x34, 0x3b, 0x46, 0x35, 0x3b, 0x49,
0x36, 0x3b, 0x41, 0x37, 0x3b, 0x49, 0x38, 0x3b, 0x4b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b,
0x73, 0x61, 0x14b, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c, 0xf9, 0x6d, 0x3b, 0x73, 0x61, 0x14b,
0x20, 0x6b, 0xe0, 0x67, 0x20, 0x6e, 0x67, 0x77, 0xf3, 0x14b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6c, 0x65, 0x70, 0x79, 0xe8,
0x20, 0x73, 0x68, 0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x63, 0xff, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0x73,
0x25b, 0x300, 0x25b, 0x20, 0x63, 0xff, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6e, 0x6a, 0xff, 0x6f, 0x6c, 0xe1, 0x2bc, 0x3b,
0x73, 0x61, 0x14b, 0x20, 0x74, 0x79, 0x25b, 0x300, 0x62, 0x20, 0x74, 0x79, 0x25b, 0x300, 0x62, 0x20, 0x6d, 0x62, 0x289, 0x300,
0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6d, 0x62, 0x289, 0x300, 0x14b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6e, 0x67, 0x77, 0x254, 0x300,
0x2bc, 0x20, 0x6d, 0x62, 0xff, 0x25b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0xe0, 0x14b, 0x61, 0x20, 0x74, 0x73, 0x65, 0x74,
0x73, 0xe1, 0x2bc, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6d, 0x65, 0x6a, 0x77, 0x6f, 0x14b, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20,
0x6c, 0xf9, 0x6d, 0x3b, 0x57, 0x69, 0xf3, 0x74, 0x68, 0x65, 0x21f, 0x69, 0x6b, 0x61, 0x20, 0x57, 0xed, 0x3b, 0x54, 0x68,
0x69, 0x79, 0xf3, 0x21f, 0x65, 0x79, 0x75, 0x14b, 0x6b, 0x61, 0x20, 0x57, 0xed, 0x3b, 0x49, 0x161, 0x74, 0xe1, 0x77, 0x69,
0x10d, 0x68, 0x61, 0x79, 0x61, 0x7a, 0x61, 0x14b, 0x20, 0x57, 0xed, 0x3b, 0x50, 0x21f, 0x65, 0x17e, 0xed, 0x74, 0x21f, 0x6f,
0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77, 0xe1, 0x70, 0x65, 0x74, 0x21f, 0x6f, 0x20, 0x57, 0xed, 0x3b, 0x57,
0xed, 0x70, 0x61, 0x7a, 0x75, 0x6b, 0x21f, 0x61, 0x2d, 0x77, 0x61, 0x161, 0x74, 0xe9, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68,
0x61, 0x14b, 0x70, 0x21f, 0xe1, 0x73, 0x61, 0x70, 0x61, 0x20, 0x57, 0xed, 0x3b, 0x57, 0x61, 0x73, 0xfa, 0x74, 0x21f, 0x75,
0x14b, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77, 0xe1, 0x70, 0x65, 0x1e7, 0x69, 0x20, 0x57, 0xed, 0x3b, 0x10c,
0x68, 0x61, 0x14b, 0x77, 0xe1, 0x70, 0x65, 0x2d, 0x6b, 0x61, 0x73, 0x6e, 0xe1, 0x20, 0x57, 0xed, 0x3b, 0x57, 0x61, 0x6e,
0xed, 0x79, 0x65, 0x74, 0x75, 0x20, 0x57, 0xed, 0x3b, 0x54, 0x21f, 0x61, 0x68, 0xe9, 0x6b, 0x61, 0x70, 0x161, 0x75, 0x14b,
0x20, 0x57, 0xed, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x11b, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b,
0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x77, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b,
0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x3b, 0x61, 0x70, 0x72, 0x79, 0x6c, 0x3b, 0x6d, 0x61,
0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e,
0x6f, 0x77, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e,
0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x11b, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a,
0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x77, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70,
0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x77, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x61, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x61, 0x3b,
0x61, 0x70, 0x72, 0x79, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x61, 0x3b, 0x6a,
0x75, 0x6c, 0x69, 0x6a, 0x61, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d, 0x62, 0x72, 0x61,
0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x11b,
0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x65, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x77,
0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x3b, 0x61, 0x70,
0x72, 0x79, 0x6c, 0x3b, 0x6d, 0x65, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a,
0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b,
0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x11b, 0x72, 0x2e, 0x3b, 0x61,
0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x6a, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61,
0x77, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x77, 0x2e, 0x3b, 0x64,
0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x61,
0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0x79, 0x6c, 0x61, 0x3b, 0x6d, 0x65, 0x6a, 0x65, 0x3b, 0x6a,
0x75, 0x6e, 0x69, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x61, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x61,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x6e,
0x6f, 0x77, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x75, 0x111, 0x111,
0xe2, 0x69, 0x76, 0x65, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6b, 0x75, 0x6f, 0x76, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75,
0x3b, 0x6e, 0x6a, 0x75, 0x68, 0x10d, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x63, 0x75, 0xe1, 0x14b, 0x75, 0x69, 0x6d,
0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x76, 0x79, 0x65, 0x73, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6b, 0x65, 0x73, 0x69,
0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x73, 0x79, 0x65, 0x69, 0x6e, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x70, 0x6f,
0x72, 0x67, 0x65, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x10d, 0x6f, 0x68, 0x10d, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b,
0x72, 0x6f, 0x6f, 0x76, 0x76, 0xe2, 0x64, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x73, 0x6b, 0x61, 0x6d, 0x6d, 0xe2, 0x6d,
0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b
};

static const ushort days_data[] = {
0x53, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6e, 0x3b, 0x54, 0x75, 0x65, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0x68, 0x75, 0x3b,
0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x4d, 0x6f, 0x6e, 0x64, 0x61,
0x79, 0x3b, 0x54, 0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x57, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b,
0x54, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x46, 0x72, 0x69, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x61, 0x74, 0x75,
0x72, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x37,
0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x44, 0x69, 0x6c, 0x3b, 0x57, 0x69, 0x78,
0x3b, 0x51, 0x69, 0x62, 0x3b, 0x52, 0x6f, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x6e,
0x3b, 0x44, 0x69, 0x6c, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x57, 0x69, 0x69, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x69, 0x62,
0x78, 0x61, 0x74, 0x61, 0x3b, 0x52, 0x6f, 0x6f, 0x62, 0x69, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b,
0x4a, 0x69, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x6f, 0x3b, 0x4d,
0x61, 0x3b, 0x44, 0x69, 0x3b, 0x57, 0x6f, 0x3b, 0x44, 0x6f, 0x3b, 0x56, 0x72, 0x3b, 0x53, 0x61, 0x3b, 0x53, 0x6f, 0x6e,
0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b,
0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x56,
0x72, 0x79, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44,
0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x44, 0x69, 0x65, 0x3b, 0x48, 0xeb, 0x6e, 0x3b, 0x4d, 0x61, 0x72,
0x3b, 0x4d, 0xeb, 0x72, 0x3b, 0x45, 0x6e, 0x6a, 0x3b, 0x50, 0x72, 0x65, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x45, 0x20, 0x64,
0x69, 0x65, 0x6c, 0x3b, 0x45, 0x20, 0x68, 0xeb, 0x6e, 0xeb, 0x3b, 0x45, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b, 0x45,
0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb, 0x3b, 0x45, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x45, 0x20, 0x70,
0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b, 0x45, 0x20, 0x73, 0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x44, 0x3b, 0x48, 0x3b, 0x4d,
0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x65, 0x20, 0x64, 0x69, 0x65, 0x6c, 0x3b, 0x65, 0x20, 0x68, 0xeb,
0x6e, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb,
0x3b, 0x65, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b, 0x65, 0x20,
0x73, 0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x3b, 0x1228, 0x1261,
0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e,
0x3b, 0x121b, 0x12ad, 0x1230, 0x129e, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3,
0x121c, 0x3b, 0x12a5, 0x3b, 0x1230, 0x3b, 0x121b, 0x3b, 0x1228, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1245, 0x3b, 0x627, 0x644, 0x623, 0x62d,
0x62f, 0x3b, 0x627, 0x644, 0x627, 0x62b, 0x646, 0x64a, 0x646, 0x3b, 0x627, 0x644, 0x62b, 0x644, 0x627, 0x62b, 0x627, 0x621, 0x3b, 0x627,
0x644, 0x623, 0x631, 0x628, 0x639, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x627, 0x644, 0x62c, 0x645, 0x639,
0x629, 0x3b, 0x627, 0x644, 0x633, 0x628, 0x62a, 0x3b, 0x62d, 0x3b, 0x646, 0x3b, 0x62b, 0x3b, 0x631, 0x3b, 0x62e, 0x3b, 0x62c, 0x3b,
0x633, 0x3b, 0x56f, 0x56b, 0x580, 0x3b, 0x565, 0x580, 0x56f, 0x3b, 0x565, 0x580, 0x584, 0x3b, 0x579, 0x580, 0x584, 0x3b, 0x570, 0x576,
0x563, 0x3b, 0x578, 0x582, 0x580, 0x3b, 0x577, 0x562, 0x569, 0x3b, 0x56f, 0x56b, 0x580, 0x561, 0x56f, 0x56b, 0x3b, 0x565, 0x580, 0x56f,
0x578, 0x582, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x565, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x579, 0x578,
0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x570, 0x56b, 0x576, 0x563, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x578,
0x582, 0x580, 0x562, 0x561, 0x569, 0x3b, 0x577, 0x561, 0x562, 0x561, 0x569, 0x3b, 0x53f, 0x3b, 0x535, 0x3b, 0x535, 0x3b, 0x549, 0x3b,
0x540, 0x3b, 0x548, 0x582, 0x3b, 0x547, 0x3b, 0x9f0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2,
0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b7, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x3b,
0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9a6, 0x9c7, 0x993, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ae, 0x999,
0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b7, 0x9cd, 0x9aa,
0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be,
0x9f0, 0x3b, 0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x45, 0x2e, 0x3b, 0xc7, 0x2e, 0x41, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e,
0x41, 0x2e, 0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72,
0x20, 0x65, 0x72, 0x74, 0x259, 0x73, 0x69, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x20, 0x61, 0x78, 0x15f,
0x61, 0x6d, 0x131, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x20, 0x61, 0x78,
0x15f, 0x61, 0x6d, 0x131, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x3b, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x431, 0x430, 0x437, 0x430,
0x440, 0x3b, 0x431, 0x430, 0x437, 0x430, 0x440, 0x20, 0x435, 0x440, 0x442, 0x4d9, 0x441, 0x438, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9,
0x43d, 0x431, 0x4d9, 0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b,
0x4b9, 0x4af, 0x43c, 0x4d9, 0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x3b, 0x448, 0x4d9, 0x43d,
0x431, 0x4d9, 0x3b, 0x49, 0x67, 0x2e, 0x3b, 0x41, 0x6c, 0x2e, 0x3b, 0x41, 0x72, 0x2e, 0x3b, 0x41, 0x7a, 0x2e, 0x3b, 0x4f,
0x67, 0x2e, 0x3b, 0x4f, 0x72, 0x2e, 0x3b, 0x4c, 0x72, 0x2e, 0x3b, 0x49, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x41,
0x73, 0x74, 0x65, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b, 0x41, 0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b,
0x41, 0x73, 0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 0x3b, 0x4f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b,
0x4f, 0x73, 0x74, 0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x49,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x4c, 0x3b, 0x69, 0x67, 0x2e, 0x3b, 0x61, 0x6c, 0x2e,
0x3b, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x2e, 0x3b, 0x6f, 0x67, 0x2e, 0x3b, 0x6f, 0x72, 0x2e, 0x3b, 0x6c, 0x72, 0x2e,
0x3b, 0x69, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b,
0x61, 0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61,
0x3b, 0x6f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x6c,
0x61, 0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd,
0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd,
0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b,
0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b7,
0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf,
0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x9c1, 0x3b, 0x9ac, 0x9c3, 0x3b, 0x9b6, 0x9c1, 0x3b,
0x9b6, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997,
0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf,
0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0x3b, 0xf66,
0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0x3b, 0xf49, 0xf72, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3,
0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b,
0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf62, 0x3b,
0xf63, 0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xfb6, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0xf49, 0xf72, 0x3b,
0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x2e, 0x3b, 0x4d, 0x65, 0x72, 0x2e, 0x3b, 0x59, 0x61,
0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x64, 0x2e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e,
0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x2bc, 0x68, 0x65, 0x72, 0x3b, 0x59, 0x61, 0x6f,
0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x3b, 0x4c,
0x3b, 0x4d, 0x7a, 0x3b, 0x4d, 0x63, 0x3b, 0x59, 0x3b, 0x47, 0x3b, 0x53, 0x61, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b,
0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b,
0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a,
0x3b, 0x441, 0x440, 0x44f, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x44a, 0x440, 0x442, 0x44a, 0x43a, 0x3b, 0x43f, 0x435, 0x442,
0x44a, 0x43a, 0x3b, 0x441, 0x44a, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x432, 0x3b, 0x441, 0x3b, 0x447, 0x3b,
0x43f, 0x3b, 0x441, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x1002, 0x1014, 0x103d, 0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x101c,
0x102c, 0x3b, 0x1021, 0x1004, 0x103a, 0x1039, 0x1002, 0x102b, 0x3b, 0x1017, 0x102f, 0x1012, 0x1039, 0x1013, 0x101f, 0x1030, 0x1038, 0x3b, 0x1000, 0x103c,
0x102c, 0x101e, 0x1015, 0x1010, 0x1031, 0x1038, 0x3b, 0x101e, 0x1031, 0x102c, 0x1000, 0x103c, 0x102c, 0x3b, 0x1005, 0x1014, 0x1031, 0x3b, 0x1010, 0x3b,
0x1010, 0x3b, 0x1021, 0x3b, 0x1017, 0x3b, 0x1000, 0x3b, 0x101e, 0x3b, 0x1005, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x430, 0x45e,
0x3b, 0x441, 0x440, 0x3b, 0x447, 0x446, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x44f,
0x3b, 0x43f, 0x430, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x430, 0x43a, 0x3b, 0x430, 0x45e, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b,
0x441, 0x435, 0x440, 0x430, 0x434, 0x430, 0x3b, 0x447, 0x430, 0x446, 0x432, 0x435, 0x440, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x456, 0x446,
0x430, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f,
0x3b, 0x441, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2, 0x1782,
0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x179f, 0x17bb,
0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36,
0x3b, 0x37, 0x3b, 0x64, 0x67, 0x2e, 0x3b, 0x64, 0x6c, 0x2e, 0x3b, 0x64, 0x74, 0x2e, 0x3b, 0x64, 0x63, 0x2e, 0x3b, 0x64,
0x6a, 0x2e, 0x3b, 0x64, 0x76, 0x2e, 0x3b, 0x64, 0x73, 0x2e, 0x3b, 0x64, 0x69, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b,
0x64, 0x69, 0x6c, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65,
0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0x6f, 0x75, 0x73, 0x3b, 0x64, 0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65,
0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0x64, 0x67, 0x3b, 0x64, 0x6c, 0x3b, 0x64, 0x74, 0x3b,
0x64, 0x63, 0x3b, 0x64, 0x6a, 0x3b, 0x64, 0x76, 0x3b, 0x64, 0x73, 0x3b, 0x5468, 0x65e5, 0x3b, 0x5468, 0x4e00, 0x3b, 0x5468, 0x4e8c,
0x3b, 0x5468, 0x4e09, 0x3b, 0x5468, 0x56db, 0x3b, 0x5468, 0x4e94, 0x3b, 0x5468, 0x516d, 0x3b, 0x661f, 0x671f, 0x65e5, 0x3b, 0x661f, 0x671f, 0x4e00,
0x3b, 0x661f, 0x671f, 0x4e8c, 0x3b, 0x661f, 0x671f, 0x4e09, 0x3b, 0x661f, 0x671f, 0x56db, 0x3b, 0x661f, 0x671f, 0x4e94, 0x3b, 0x661f, 0x671f, 0x516d,
0x3b, 0x65e5, 0x3b, 0x4e00, 0x3b, 0x4e8c, 0x3b, 0x4e09, 0x3b, 0x56db, 0x3b, 0x4e94, 0x3b, 0x516d, 0x3b, 0x9031, 0x65e5, 0x3b, 0x9031, 0x4e00,
0x3b, 0x9031, 0x4e8c, 0x3b, 0x9031, 0x4e09, 0x3b, 0x9031, 0x56db, 0x3b, 0x9031, 0x4e94, 0x3b, 0x9031, 0x516d, 0x3b, 0x6e, 0x65, 0x64, 0x3b,
0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x69, 0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b,
0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x6a, 0x65,
0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b,
0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74,
0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x4e, 0x3b, 0x50, 0x3b,
0x55, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0xfa, 0x74, 0x3b, 0x73,
0x74, 0x3b, 0x10d, 0x74, 0x3b, 0x70, 0xe1, 0x3b, 0x73, 0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x11b, 0x6c, 0x65, 0x3b, 0x70, 0x6f,
0x6e, 0x64, 0x11b, 0x6c, 0xed, 0x3b, 0xfa, 0x74, 0x65, 0x72, 0xfd, 0x3b, 0x73, 0x74, 0x159, 0x65, 0x64, 0x61, 0x3b, 0x10d,
0x74, 0x76, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0xe1, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b,
0x4e, 0x3b, 0x50, 0x3b, 0xda, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0x61,
0x6e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf8,
0x72, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x72, 0x73,
0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66,
0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf8, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4f,
0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x73, 0xf8, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x6e, 0x2e, 0x3b, 0x74, 0x69, 0x72,
0x2e, 0x3b, 0x6f, 0x6e, 0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x6c, 0xf8, 0x72,
0x2e, 0x3b, 0x5a, 0x6f, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x69, 0x3b, 0x57, 0x6f, 0x3b, 0x44, 0x6f, 0x3b, 0x56, 0x72, 0x3b,
0x5a, 0x61, 0x3b, 0x5a, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69,
0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65,
0x72, 0x64, 0x61, 0x67, 0x3b, 0x56, 0x72, 0x69, 0x6a, 0x64, 0x61, 0x67, 0x3b, 0x5a, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61,
0x67, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x5a, 0x3b, 0x7a, 0x6f, 0x3b, 0x6d,
0x61, 0x3b, 0x64, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x64, 0x6f, 0x3b, 0x76, 0x72, 0x3b, 0x7a, 0x61, 0x3b, 0x7a, 0x6f, 0x6e,
0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b,
0x77, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x76,
0x72, 0x69, 0x6a, 0x64, 0x61, 0x67, 0x3b, 0x7a, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x50, 0x3b, 0x45, 0x3b,
0x54, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x52, 0x3b, 0x4c, 0x3b, 0x70, 0xfc, 0x68, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x65,
0x73, 0x6d, 0x61, 0x73, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x74, 0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b,
0x6f, 0x6c, 0x6d, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x72,
0x65, 0x65, 0x64, 0x65, 0x3b, 0x6c, 0x61, 0x75, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e,
0x3b, 0x74, 0xfd, 0x73, 0x3b, 0x6d, 0x69, 0x6b, 0x3b, 0x68, 0xf3, 0x73, 0x3b, 0x66, 0x72, 0xed, 0x3b, 0x6c, 0x65, 0x79,
0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75,
0x72, 0x3b, 0x74, 0xfd, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72,
0x3b, 0x68, 0xf3, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x72, 0xed, 0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 0x67,
0x75, 0x72, 0x3b, 0x6c, 0x65, 0x79, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54,
0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x73, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x74, 0x69, 0x3b, 0x6b, 0x65,
0x3b, 0x74, 0x6f, 0x3b, 0x70, 0x65, 0x3b, 0x6c, 0x61, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x3b,
0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x6b, 0x65,
0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x65,
0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x53, 0x3b, 0x4d,
0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x4c, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69,
0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74,
0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x6e, 0x61, 0x3b, 0x74,
0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61,
0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x44, 0x69, 0x6d, 0x2e, 0x3b, 0x4c, 0x75, 0x6e,
0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x72, 0x2e, 0x3b, 0x4a, 0x65, 0x75, 0x2e, 0x3b, 0x56, 0x65, 0x6e,
0x2e, 0x3b, 0x53, 0x61, 0x6d, 0x2e, 0x3b, 0x44, 0x69, 0x6d, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x3b, 0x4c, 0x75, 0x6e, 0x64,
0x69, 0x3b, 0x4d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x4a, 0x65, 0x75,
0x64, 0x69, 0x3b, 0x56, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x53, 0x61, 0x6d, 0x65, 0x64, 0x69, 0x3b, 0x44,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x69, 0x6d, 0x2e, 0x3b, 0x6c, 0x75,
0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x72, 0x2e, 0x3b, 0x6a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65,
0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x6d, 0x2e, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x3b, 0x6c, 0x75, 0x6e,
0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x6a, 0x65,
0x75, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x65, 0x64, 0x69, 0x3b,
0x73, 0x69, 0x3b, 0x6d, 0x6f, 0x3b, 0x74, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x74, 0x6f, 0x3b, 0x66, 0x72, 0x3b, 0x73, 0x6f,
0x3b, 0x73, 0x6e, 0x65, 0x69, 0x6e, 0x3b, 0x6d, 0x6f, 0x61, 0x6e, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x64,
0x65, 0x69, 0x3b, 0x77, 0x6f, 0x61, 0x6e, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x73, 0x64,
0x65, 0x69, 0x3b, 0x66, 0x72, 0x65, 0x65, 0x64, 0x3b, 0x73, 0x6e, 0x65, 0x6f, 0x6e, 0x3b, 0x44, 0x69, 0x44, 0x3b, 0x44,
0x69, 0x4c, 0x3b, 0x44, 0x69, 0x4d, 0x3b, 0x44, 0x69, 0x43, 0x3b, 0x44, 0x69, 0x61, 0x3b, 0x44, 0x69, 0x68, 0x3b, 0x44,
0x69, 0x53, 0x3b, 0x44, 0x69, 0x44, 0xf2, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x4c, 0x75, 0x61,
0x69, 0x6e, 0x3b, 0x44, 0x69, 0x4d, 0xe0, 0x69, 0x72, 0x74, 0x3b, 0x44, 0x69, 0x43, 0x69, 0x61, 0x64, 0x61, 0x69, 0x6e,
0x3b, 0x44, 0x69, 0x61, 0x72, 0x44, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b,
0x44, 0x69, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 0x65, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43, 0x3b,
0x41, 0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0xe9,
0x72, 0x3b, 0x58, 0x6f, 0x76, 0x3b, 0x56, 0x65, 0x6e, 0x3b, 0x53, 0xe1, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67,
0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0xe9, 0x72, 0x63, 0x6f, 0x72,
0x65, 0x73, 0x3b, 0x58, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61,
0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d,
0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0xe9, 0x72, 0x3b, 0x78, 0x6f, 0x76, 0x3b, 0x76, 0x65, 0x6e,
0x3b, 0x73, 0xe1, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61,
0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x78, 0x6f, 0x76, 0x65, 0x73, 0x3b,
0x76, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x3b, 0x10dd, 0x10e0,
0x10e8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x3b, 0x10e8, 0x10d0,
0x10d1, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x10e0, 0x10d0, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10e1, 0x10d0, 0x10db,
0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10e3, 0x10d7,
0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x10d0, 0x10e1, 0x10d9, 0x10d4, 0x10d5, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d1,
0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10d9, 0x3b, 0x10dd, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10ee, 0x3b, 0x10de, 0x3b, 0x10e8, 0x3b, 0x53, 0x6f,
0x3b, 0x4d, 0x6f, 0x3b, 0x44, 0x69, 0x3b, 0x4d, 0x69, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x3b, 0x53,
0x6f, 0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x65, 0x6e, 0x73, 0x74,
0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x74,
0x61, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x53,
0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e,
0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e,
0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3ad, 0x3bc,
0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b9, 0x3b1, 0x3ba, 0x3ae, 0x3b, 0x394, 0x3b5, 0x3c5,
0x3c4, 0x3ad, 0x3c1, 0x3b1, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3c4, 0x3b7, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3ac, 0x3c1, 0x3c4, 0x3b7, 0x3b, 0x3a0,
0x3ad, 0x3bc, 0x3c0, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b1, 0x3c3, 0x3ba, 0x3b5, 0x3c5, 0x3ae, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b2,
0x3b1, 0x3c4, 0x3bf, 0x3b, 0x39a, 0x3b, 0x394, 0x3b, 0x3a4, 0x3b, 0x3a4, 0x3b, 0x3a0, 0x3b, 0x3a0, 0x3b, 0x3a3, 0x3b, 0x73, 0x61,
0x62, 0x3b, 0x61, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x69, 0x6e, 0x3b, 0x73, 0x69, 0x73, 0x3b, 0x74, 0x61,
0x6c, 0x3b, 0x61, 0x72, 0x66, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x61, 0x74, 0x3b, 0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e,
0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x6d, 0x61, 0x72, 0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65,
0x71, 0x3b, 0x70, 0x69, 0x6e, 0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x73, 0x69,
0x73, 0x61, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x74, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x61,
0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72,
0x6e, 0x65, 0x71, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0xab0, 0xab5,
0xabf, 0x3b, 0xab8, 0xacb, 0xaae, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0x3b, 0xaac, 0xac1, 0xaa7, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0x3b,
0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0x3b, 0xab0, 0xab5, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab8, 0xacb, 0xaae,
0xab5, 0xabe, 0xab0, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0xab5, 0xabe, 0xab0, 0x3b, 0xaac, 0xac1, 0xaa7, 0xab5, 0xabe, 0xab0, 0x3b, 0xa97,
0xac1, 0xab0, 0xac1, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab5,
0xabe, 0xab0, 0x3b, 0xab0, 0x3b, 0xab8, 0xacb, 0x3b, 0xaae, 0xa82, 0x3b, 0xaac, 0xac1, 0x3b, 0xa97, 0xac1, 0x3b, 0xab6, 0xac1, 0x3b,
0xab6, 0x3b, 0x4c, 0x68, 0x3b, 0x4c, 0x69, 0x3b, 0x54, 0x61, 0x3b, 0x4c, 0x72, 0x3b, 0x41, 0x6c, 0x3b, 0x4a, 0x75, 0x3b,
0x41, 0x73, 0x3b, 0x4c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x4c, 0x69, 0x74, 0x69, 0x6e, 0x69, 0x6e, 0x3b, 0x54, 0x61,
0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b,
0x4a, 0x75, 0x6d, 0x6d, 0x61, 0x2bc, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x72, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x54,
0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20,
0x5d1, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d2, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d3, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd,
0x20, 0x5d4, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8,
0x5d0, 0x5e9, 0x5d5, 0x5df, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5dc, 0x5d9,
0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d7, 0x5de, 0x5d9,
0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d1, 0x5ea, 0x3b,
0x5d0, 0x5f3, 0x3b, 0x5d1, 0x5f3, 0x3b, 0x5d2, 0x5f3, 0x3b, 0x5d3, 0x5f3, 0x3b, 0x5d4, 0x5f3, 0x3b, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5f3,
0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941,
0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b,
0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e,
0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936,
0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b,
0x936, 0x941, 0x3b, 0x936, 0x3b, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x65, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b,
0x53, 0x7a, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0xe1, 0x72, 0x6e, 0x61, 0x70, 0x3b, 0x68, 0xe9, 0x74, 0x66, 0x151, 0x3b, 0x6b,
0x65, 0x64, 0x64, 0x3b, 0x73, 0x7a, 0x65, 0x72, 0x64, 0x61, 0x3b, 0x63, 0x73, 0xfc, 0x74, 0xf6, 0x72, 0x74, 0xf6, 0x6b,
0x3b, 0x70, 0xe9, 0x6e, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x7a, 0x6f, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x56, 0x3b, 0x48, 0x3b,
0x4b, 0x3b, 0x53, 0x7a, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x3b, 0x73, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1,
0x6e, 0x2e, 0x3b, 0xfe, 0x72, 0x69, 0x2e, 0x3b, 0x6d, 0x69, 0xf0, 0x2e, 0x3b, 0x66, 0x69, 0x6d, 0x2e, 0x3b, 0x66, 0xf6,
0x73, 0x2e, 0x3b, 0x6c, 0x61, 0x75, 0x2e, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d,
0xe1, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0xfe, 0x72, 0x69, 0xf0, 0x6a, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72,
0x3b, 0x6d, 0x69, 0xf0, 0x76, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x69, 0x6d, 0x6d, 0x74, 0x75,
0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0xf6, 0x73, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x61, 0x75,
0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0xde, 0x3b, 0x4d, 0x3b, 0x46, 0x3b, 0x46,
0x3b, 0x4c, 0x3b, 0x4d, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b,
0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4d, 0x69, 0x6e, 0x67, 0x67, 0x75, 0x3b, 0x53, 0x65,
0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69,
0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b,
0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x44, 0x6f, 0x6d, 0x68, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x3b, 0x4d, 0xe1,
0x69, 0x72, 0x74, 0x3b, 0x43, 0xe9, 0x61, 0x64, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x3b, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b,
0x53, 0x61, 0x74, 0x68, 0x3b, 0x44, 0xe9, 0x20, 0x44, 0x6f, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x67, 0x68, 0x3b, 0x44, 0xe9,
0x20, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x20, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x44, 0xe9, 0x20, 0x43,
0xe9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9,
0x20, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0xe9, 0x20, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 0x3b,
0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x44, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75,
0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x67, 0x69, 0x6f, 0x3b, 0x76, 0x65, 0x6e, 0x3b, 0x73, 0x61,
0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x64, 0xec, 0x3b, 0x4d, 0x61,
0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec, 0x3b, 0x47, 0x69, 0x6f, 0x76,
0x65, 0x64, 0xec, 0x3b, 0x56, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x44,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63,
0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x65, 0x72,
0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec, 0x3b, 0x67, 0x69, 0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72,
0x64, 0xec, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x65e5, 0x3b, 0x6708, 0x3b, 0x706b, 0x3b, 0x6c34, 0x3b, 0x6728, 0x3b,
0x91d1, 0x3b, 0x571f, 0x3b, 0x65e5, 0x66dc, 0x65e5, 0x3b, 0x6708, 0x66dc, 0x65e5, 0x3b, 0x706b, 0x66dc, 0x65e5, 0x3b, 0x6c34, 0x66dc, 0x65e5, 0x3b,
0x6728, 0x66dc, 0x65e5, 0x3b, 0x91d1, 0x66dc, 0x65e5, 0x3b, 0x571f, 0x66dc, 0x65e5, 0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0x3b, 0xcb8, 0xccb, 0xcae,
0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0x3b, 0xcac, 0xcc1, 0xca7, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0,
0x3b, 0xcb6, 0xca8, 0xcbf, 0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb8, 0xccb, 0xcae, 0xcb5, 0xcbe, 0xcb0, 0x3b,
0xcae, 0xc82, 0xc97, 0xcb3, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcac, 0xcc1, 0xca7, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0xcb5,
0xcbe, 0xcb0, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcad,
0xcbe, 0x3b, 0xcb8, 0xccb, 0x3b, 0xcae, 0xc82, 0x3b, 0xcac, 0xcc1, 0x3b, 0xc97, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0x3b, 0xcb6, 0x3b, 0x622,
0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x65b, 0x62f, 0x655, 0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x65a,
0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x65b, 0x66e, 0x6ea, 0x633, 0x648, 0x627,
0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x3b, 0x627, 0x64e, 0x62a, 0x6be, 0x648, 0x627, 0x631,
0x3b, 0x698, 0x654, 0x646, 0x65b, 0x62f, 0x631, 0x655, 0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x65a, 0x645, 0x648, 0x627, 0x631,
0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x65b, 0x66e, 0x6ea, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f,
0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x3b, 0x627, 0x3b, 0x698, 0x3b, 0x628, 0x3b, 0x628, 0x3b, 0x628, 0x3b, 0x62c,
0x3b, 0x628, 0x3b, 0x436, 0x435, 0x43a, 0x3b, 0x434, 0x4af, 0x439, 0x3b, 0x441, 0x435, 0x439, 0x3b, 0x441, 0x4d9, 0x440, 0x3b, 0x431,
0x435, 0x439, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x431, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x434, 0x4af, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441,
0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x431, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x436, 0x4b1, 0x43c,
0x430, 0x3b, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x421, 0x3b, 0x411, 0x3b, 0x416, 0x3b,
0x421, 0x3b, 0x436, 0x435, 0x43a, 0x3b, 0x434, 0x4af, 0x439, 0x3b, 0x441, 0x435, 0x439, 0x3b, 0x441, 0x4d9, 0x440, 0x3b, 0x431, 0x435,
0x439, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x3b, 0x63, 0x79, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e,
0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e,
0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x63, 0x79, 0x75, 0x6d, 0x77, 0x65, 0x72, 0x75, 0x3b, 0x4b, 0x75,
0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69,
0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20,
0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x436, 0x435, 0x43a, 0x2e, 0x3b, 0x434, 0x4af, 0x439, 0x2e, 0x3b,
0x448, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x2e, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x436, 0x443,
0x43c, 0x430, 0x3b, 0x438, 0x448, 0x43c, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x434, 0x4af, 0x439,
0x448, 0x4e9, 0x43c, 0x431, 0x4af, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x435,
0x43c, 0x431, 0x438, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448,
0x435, 0x43c, 0x431, 0x438, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x428, 0x3b, 0x428, 0x3b, 0x411, 0x3b, 0x416, 0x3b, 0x418, 0x3b, 0xc77c,
0x3b, 0xc6d4, 0x3b, 0xd654, 0x3b, 0xc218, 0x3b, 0xbaa9, 0x3b, 0xae08, 0x3b, 0xd1a0, 0x3b, 0xc77c, 0xc694, 0xc77c, 0x3b, 0xc6d4, 0xc694, 0xc77c,
0x3b, 0xd654, 0xc694, 0xc77c, 0x3b, 0xc218, 0xc694, 0xc77c, 0x3b, 0xbaa9, 0xc694, 0xc77c, 0x3b, 0xae08, 0xc694, 0xc77c, 0x3b, 0xd1a0, 0xc694, 0xc77c,
0x3b, 0x63, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b,
0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x2019,
0x69, 0x6e, 0x64, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74,
0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61,
0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64,
0x61, 0x74, 0x75, 0x3b, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xe88, 0xeb1, 0xe99, 0x3b, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99,
0x3b, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b,
0xea7, 0xeb1, 0xe99, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe88, 0xeb1, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead,
0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb0, 0xeab, 0xeb1,
0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xea7, 0xeb1, 0xe99, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0xead, 0x3b, 0xe88,
0x3b, 0xead, 0x3b, 0xe9e, 0x3b, 0xe9e, 0xeab, 0x3b, 0xeaa, 0xeb8, 0x3b, 0xeaa, 0x3b, 0x53, 0x76, 0x3b, 0x50, 0x72, 0x3b, 0x4f,
0x74, 0x3b, 0x54, 0x72, 0x3b, 0x43, 0x65, 0x3b, 0x50, 0x6b, 0x3b, 0x53, 0x65, 0x3b, 0x53, 0x76, 0x113, 0x74, 0x64, 0x69,
0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x69, 0x65,
0x6e, 0x61, 0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64,
0x69, 0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x65, 0x73, 0x74,
0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b,
0x73, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b,
0x6f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x74, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x63,
0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e,
0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x65, 0x79, 0x65, 0x3b, 0x79, 0x62, 0x6f, 0x3b,
0x6d, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x69, 0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x70, 0x73, 0x3b,
0x65, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x79, 0x61,
0x6d, 0x62, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c,
0xe9, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b,
0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0xe9, 0x69, 0x3b, 0x6d, 0x6f, 0x6b, 0x254,
0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x6d, 0x70, 0x254, 0x301, 0x73, 0x254, 0x3b,
0x65, 0x3b, 0x79, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x70, 0x3b, 0x73, 0x6b, 0x3b, 0x70, 0x72, 0x3b,
0x61, 0x6e, 0x3b, 0x74, 0x72, 0x3b, 0x6b, 0x74, 0x3b, 0x70, 0x6e, 0x3b, 0x161, 0x74, 0x3b, 0x73, 0x65, 0x6b, 0x6d, 0x61,
0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x61,
0x6e, 0x74, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x74, 0x72, 0x65, 0x10d, 0x69, 0x61, 0x64, 0x69, 0x65,
0x6e, 0x69, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x76, 0x69, 0x72, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70,
0x65, 0x6e, 0x6b, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x161, 0x65, 0x161, 0x74, 0x61, 0x64, 0x69, 0x65,
0x6e, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x160, 0x3b, 0x43d, 0x435,
0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x2e, 0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442,
0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x430, 0x3b, 0x43f,
0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440,
0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x43e, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x43e, 0x43a, 0x3b, 0x441,
0x430, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x3b, 0x54, 0x61, 0x6c,
0x3b, 0x41, 0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x3b, 0x5a, 0x6f, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x3b,
0x41, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x79, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x79, 0x3b,
0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x6f, 0x62, 0x69, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x6b,
0x61, 0x6d, 0x69, 0x73, 0x79, 0x3b, 0x5a, 0x6f, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x6f, 0x74, 0x73, 0x79, 0x3b,
0x41, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x5a, 0x3b, 0x41, 0x3b, 0x41, 0x68, 0x64, 0x3b, 0x49, 0x73,
0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61,
0x62, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b,
0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x3b, 0x53,
0x61, 0x62, 0x74, 0x75, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0xd1e,
0xd3e, 0xd2f, 0xd7c, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd7e, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0x3b, 0xd2c, 0xd41, 0xd27,
0xd7b, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd02, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0x3b, 0xd36, 0xd28, 0xd3f, 0x3b,
0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c,
0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d,
0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f,
0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1e, 0x3b, 0xd24,
0xd3f, 0x3b, 0xd1a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34,
0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d,
0xd35, 0xd3e, 0xd34, 0xd4d, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e,
0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b,
0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0x126, 0x61, 0x64, 0x3b, 0x54, 0x6e, 0x65, 0x3b, 0x54, 0x6c,
0x69, 0x3b, 0x45, 0x72, 0x62, 0x3b, 0x126, 0x61, 0x6d, 0x3b, 0x120, 0x69, 0x6d, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x49, 0x6c,
0x2d, 0x126, 0x61, 0x64, 0x64, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6e, 0x65, 0x6a, 0x6e, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6c,
0x69, 0x65, 0x74, 0x61, 0x3b, 0x4c, 0x2d, 0x45, 0x72, 0x62, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x6d,
0x69, 0x73, 0x3b, 0x49, 0x6c, 0x2d, 0x120, 0x69, 0x6d, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x73, 0x2d, 0x53, 0x69, 0x62, 0x74,
0x3b, 0x126, 0x64, 0x3b, 0x54, 0x6e, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53,
0x62, 0x3b, 0x126, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x126, 0x3b, 0x120, 0x3b, 0x53, 0x3b, 0x930, 0x935, 0x93f, 0x3b,
0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941,
0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e,
0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930,
0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930,
0x3b, 0x41d, 0x44f, 0x3b, 0x414, 0x430, 0x3b, 0x41c, 0x44f, 0x3b, 0x41b, 0x445, 0x3b, 0x41f, 0x4af, 0x3b, 0x411, 0x430, 0x3b, 0x411,
0x44f, 0x3b, 0x43d, 0x44f, 0x43c, 0x3b, 0x434, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x43c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x43b,
0x445, 0x430, 0x433, 0x432, 0x430, 0x3b, 0x43f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x431, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x431,
0x44f, 0x43c, 0x431, 0x430, 0x3b, 0x906, 0x907, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x3b, 0x92c,
0x941, 0x927, 0x3b, 0x92c, 0x93f, 0x939, 0x940, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x906, 0x907,
0x924, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x92c, 0x93e, 0x930,
0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d,
0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x3b, 0x92c,
0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0x61, 0x2e, 0x3b, 0x74, 0x69,
0x2e, 0x3b, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0xf8, 0x2e, 0x3b, 0xb30, 0xb2c,
0xb3f, 0x3b, 0xb38, 0xb4b, 0xb2e, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0x3b, 0xb2c, 0xb41, 0xb27, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41,
0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0x3b, 0xb30, 0xb2c, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb38, 0xb4b,
0xb2e, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2c, 0xb41, 0xb27, 0xb2c, 0xb3e, 0xb30,
0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb28,
0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb30, 0x3b, 0xb38, 0xb4b, 0x3b, 0xb2e, 0x3b, 0xb2c, 0xb41, 0x3b, 0xb17, 0xb41, 0x3b, 0xb36, 0xb41,
0x3b, 0xb36, 0x3b, 0x6cc, 0x6a9, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62f, 0x648, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x633, 0x647, 0x200c,
0x634, 0x646, 0x628, 0x647, 0x3b, 0x686, 0x647, 0x627, 0x631, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x67e, 0x646, 0x62c, 0x634, 0x646, 0x628,
0x647, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b,
0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x77, 0x74,
0x2e, 0x3b, 0x15b, 0x72, 0x2e, 0x3b, 0x63, 0x7a, 0x77, 0x2e, 0x3b, 0x70, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b,
0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x61, 0x142,
0x65, 0x6b, 0x3b, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x15b, 0x72, 0x6f, 0x64, 0x61, 0x3b, 0x63, 0x7a, 0x77, 0x61,
0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x69, 0x105, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e,
0x3b, 0x50, 0x3b, 0x57, 0x3b, 0x15a, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x73, 0x65, 0x67,
0x3b, 0x74, 0x65, 0x72, 0x3b, 0x71, 0x75, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x3b, 0x73, 0x65, 0x78, 0x3b, 0x73, 0xe1, 0x62,
0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x69,
0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72, 0x74,
0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61,
0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b,
0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0xa10, 0xa24, 0x3b, 0xa38, 0xa4b, 0xa2e,
0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0x3b, 0xa35, 0xa40, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15,
0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30, 0x3b, 0xa10, 0xa24, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa4b, 0xa2e, 0xa35,
0xa3e, 0xa30, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa35,
0xa40, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f,
0xa71, 0xa1a, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa10, 0x3b, 0xa38, 0xa4b, 0x3b, 0xa2e, 0xa70, 0x3b, 0xa2c, 0xa41, 0xa71, 0x3b, 0xa35,
0xa40, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0x3b, 0xa38, 0xa3c, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631, 0x3b,
0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x64f, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639,
0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d,
0x69, 0xe9, 0x3b, 0x4a, 0x75, 0x65, 0x3b, 0x56, 0x69, 0x65, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e,
0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0xe9, 0x72,
0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x4a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73,
0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x4a, 0x3b, 0x56, 0x3b,
0x53, 0x3b, 0x64, 0x75, 0x3b, 0x67, 0x6c, 0x69, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x67, 0x69, 0x65, 0x3b, 0x76,
0x65, 0x3b, 0x73, 0x6f, 0x3b, 0x64, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x69, 0x61, 0x3b, 0x67, 0x6c, 0x69, 0x6e, 0x64, 0x65,
0x73, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x73, 0x65, 0x6d, 0x6e, 0x61, 0x3b, 0x67, 0x69,
0x65, 0x76, 0x67, 0x69, 0x61, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x6e, 0x64, 0x61,
0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x44, 0x75, 0x6d, 0x3b, 0x4c,
0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x65, 0x3b, 0x4a, 0x6f, 0x69, 0x3b, 0x56, 0x69, 0x6e, 0x3b, 0x53,
0xe2, 0x6d, 0x3b, 0x44, 0x75, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x103, 0x3b, 0x4c, 0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x61, 0x72,
0x21b, 0x69, 0x3b, 0x4d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x3b, 0x4a, 0x6f, 0x69, 0x3b, 0x56, 0x69, 0x6e, 0x65,
0x72, 0x69, 0x3b, 0x53, 0xe2, 0x6d, 0x62, 0x103, 0x74, 0x103, 0x3b, 0x64, 0x75, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x103, 0x3b,
0x6c, 0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x21b, 0x69, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x3b,
0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x65, 0x72, 0x69, 0x3b, 0x73, 0xe2, 0x6d, 0x62, 0x103, 0x74, 0x103, 0x3b, 0x412,
0x441, 0x3b, 0x41f, 0x43d, 0x3b, 0x412, 0x442, 0x3b, 0x421, 0x440, 0x3b, 0x427, 0x442, 0x3b, 0x41f, 0x442, 0x3b, 0x421, 0x431, 0x3b,
0x412, 0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x41f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44c,
0x43d, 0x438, 0x43a, 0x3b, 0x412, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x421, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x427, 0x435,
0x442, 0x432, 0x435, 0x440, 0x433, 0x3b, 0x41f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x421, 0x443, 0x431, 0x431, 0x43e, 0x442,
0x430, 0x3b, 0x412, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x432, 0x441, 0x3b, 0x43f,
0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x432, 0x43e, 0x441,
0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44c, 0x43d, 0x438, 0x43a,
0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435,
0x440, 0x433, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x42,
0x6b, 0x31, 0x3b, 0x42, 0x6b, 0x32, 0x3b, 0x42, 0x6b, 0x33, 0x3b, 0x42, 0x6b, 0x34, 0x3b, 0x42, 0x6b, 0x35, 0x3b, 0x4c,
0xe2, 0x70, 0x3b, 0x4c, 0xe2, 0x79, 0x3b, 0x42, 0x69, 0x6b, 0x75, 0x61, 0x2d, 0xf4, 0x6b, 0x6f, 0x3b, 0x42, 0xef, 0x6b,
0x75, 0x61, 0x2d, 0xfb, 0x73, 0x65, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x70, 0x74, 0xe2, 0x3b, 0x42, 0xef, 0x6b,
0x75, 0x61, 0x2d, 0x75, 0x73, 0xef, 0xf6, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x6f, 0x6b, 0xfc, 0x3b, 0x4c, 0xe2,
0x70, 0xf4, 0x73, 0xf6, 0x3b, 0x4c, 0xe2, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x53,
0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x59, 0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441,
0x440, 0x435, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x459,
0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441,
0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b,
0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x443, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441,
0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x65, 0x3b, 0x10d, 0x65, 0x74,
0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e,
0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61,
0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f,
0x74, 0x61, 0x3b, 0x425, 0x446, 0x431, 0x3b, 0x41a, 0x440, 0x441, 0x3b, 0x414, 0x446, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x3b, 0x426,
0x43f, 0x440, 0x3b, 0x41c, 0x440, 0x431, 0x3b, 0x421, 0x431, 0x442, 0x3b, 0x425, 0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d,
0x3b, 0x41a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x414, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d4, 0x440,
0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x426, 0x44b, 0x43f, 0x43f, 0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x41c, 0x430, 0x439, 0x440,
0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x421, 0x430, 0x431, 0x430, 0x442, 0x3b, 0x425, 0x3b, 0x41a, 0x3b, 0x414, 0x3b, 0x4d4, 0x3b,
0x426, 0x3b, 0x41c, 0x3b, 0x421, 0x3b, 0x445, 0x446, 0x431, 0x3b, 0x43a, 0x440, 0x441, 0x3b, 0x434, 0x446, 0x433, 0x3b, 0x4d5, 0x440,
0x442, 0x3b, 0x446, 0x43f, 0x440, 0x3b, 0x43c, 0x440, 0x431, 0x3b, 0x441, 0x431, 0x442, 0x3b, 0x445, 0x443, 0x44b, 0x446, 0x430, 0x443,
0x431, 0x43e, 0x43d, 0x3b, 0x43a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x434, 0x44b, 0x446, 0x446, 0x4d5, 0x433,
0x3b, 0x4d5, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x446, 0x44b, 0x43f, 0x43f, 0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x43c,
0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x441, 0x430, 0x431, 0x430, 0x442, 0x3b, 0x53, 0x76, 0x6f, 0x3b, 0x4d,
0x75, 0x76, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x3b, 0x43, 0x68,
0x69, 0x73, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x76, 0x6f, 0x6e, 0x64, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x68, 0x75, 0x72,
0x6f, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68,
0x69, 0x6e, 0x61, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67, 0x6f, 0x76, 0x65, 0x72,
0x61, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf,
0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca,
0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf,
0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0xdbb, 0xdd4, 0xdc0, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdaf, 0xdcf,
0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0xdb4, 0xdad, 0xdd2, 0xdb1, 0xdca, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd2,
0xd9a, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0xdc3, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xd89, 0x3b, 0xdc3,
0x3b, 0xd85, 0x3b, 0xdb6, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0x3b, 0xdc3, 0xdd2, 0x3b, 0xdc3, 0xdd9, 0x3b, 0x6e, 0x65, 0x3b, 0x70,
0x6f, 0x3b, 0x75, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x161, 0x74, 0x3b, 0x70, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6e, 0x65, 0x64,
0x65, 0x13e, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x65, 0x6c, 0x6f, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x6f, 0x6b, 0x3b,
0x73, 0x74, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x76, 0x72, 0x74, 0x6f, 0x6b, 0x3b, 0x70, 0x69, 0x61, 0x74, 0x6f,
0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x160, 0x3b, 0x50,
0x3b, 0x53, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x73, 0x72, 0x65, 0x3b, 0x10d,
0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70,
0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x65, 0x6b, 0x3b, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64,
0x61, 0x3b, 0x10d, 0x65, 0x74, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f,
0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x65, 0x64,
0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x73, 0x72, 0x65, 0x2e, 0x3b, 0x10d, 0x65, 0x74,
0x2e, 0x3b, 0x70, 0x65, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x41, 0x78, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b,
0x54, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b,
0x41, 0x78, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x6f, 0x3b,
0x41, 0x72, 0x62, 0x61, 0x63, 0x6f, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x3b, 0x4a, 0x69, 0x6d, 0x63, 0x6f,
0x3b, 0x53, 0x61, 0x62, 0x74, 0x69, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53,
0x3b, 0x44, 0x6f, 0x6d, 0x2e, 0x3b, 0x4c, 0x75, 0x6e, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x4d, 0x69, 0xe9, 0x2e,
0x3b, 0x4a, 0x75, 0x65, 0x2e, 0x3b, 0x56, 0x69, 0x65, 0x2e, 0x3b, 0x53, 0xe1, 0x62, 0x2e, 0x3b, 0x64, 0x6f, 0x6d, 0x2e,
0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x69, 0xe9, 0x2e, 0x3b, 0x6a, 0x75, 0x65, 0x2e,
0x3b, 0x76, 0x69, 0x65, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c,
0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65,
0x73, 0x3b, 0x6a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62,
0x61, 0x64, 0x6f, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73,
0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x79, 0x3b,
0x6b, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x69, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x79, 0x65, 0x6e, 0x3b, 0x6b, 0x77, 0x61, 0x3b,
0x70, 0x69, 0x6c, 0x3b, 0x74, 0x61, 0x74, 0x3b, 0x69, 0x6e, 0x65, 0x3b, 0x74, 0x61, 0x6e, 0x3b, 0x73, 0x69, 0x74, 0x3b,
0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79,
0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x70, 0x69, 0x6c,
0x69, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20,
0x79, 0x61, 0x20, 0x69, 0x6e, 0x65, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b,
0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x53, 0xf6, 0x6e, 0x3b, 0x4d, 0xe5, 0x6e,
0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4f, 0x6e, 0x73, 0x3b, 0x54, 0x6f, 0x72, 0x3b, 0x46, 0x72, 0x65, 0x3b, 0x4c, 0xf6, 0x72,
0x3b, 0x53, 0xf6, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x54, 0x69, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x4f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x54, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x65,
0x64, 0x61, 0x67, 0x3b, 0x4c, 0xf6, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf6, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e, 0x3b, 0x74,
0x69, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf6, 0x72, 0x3b,
0x73, 0xf6, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x73, 0x64, 0x61, 0x67,
0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64,
0x61, 0x67, 0x3b, 0x6c, 0xf6, 0x72, 0x64, 0x61, 0x67, 0x3b, 0xb9e, 0xbbe, 0x3b, 0xba4, 0xbbf, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xbaa,
0xbc1, 0x3b, 0xbb5, 0xbbf, 0x3b, 0xbb5, 0xbc6, 0x3b, 0xb9a, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0xbb1, 0xbc1, 0x3b, 0xba4, 0xbbf, 0xb99,
0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0xbaa, 0xbc1, 0xba4, 0xba9, 0xbcd, 0x3b,
0xbb5, 0xbbf, 0xbaf, 0xbbe, 0xbb4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0xbb3, 0xbbf, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0x44f,
0x43a, 0x448, 0x2e, 0x3b, 0x434, 0x4af, 0x448, 0x2e, 0x3b, 0x441, 0x438, 0x448, 0x2e, 0x3b, 0x447, 0x4d9, 0x440, 0x2e, 0x3b, 0x43f,
0x4d9, 0x43d, 0x497, 0x2e, 0x3b, 0x497, 0x43e, 0x43c, 0x2e, 0x3b, 0x448, 0x438, 0x43c, 0x2e, 0x3b, 0x44f, 0x43a, 0x448, 0x4d9, 0x43c,
0x431, 0x435, 0x3b, 0x434, 0x4af, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x441, 0x438, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x447,
0x4d9, 0x440, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x435, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x497,
0x43e, 0x43c, 0x433, 0x430, 0x3b, 0x448, 0x438, 0x43c, 0x431, 0x4d9, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f,
0x3b, 0x496, 0x3b, 0x428, 0x3b, 0xc06, 0xc26, 0xc3f, 0x3b, 0xc38, 0xc4b, 0xc2e, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0x3b, 0xc2c, 0xc41,
0xc27, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0x3b, 0xc36, 0xc28, 0xc3f, 0x3b, 0xc06, 0xc26, 0xc3f,
0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc38, 0xc4b, 0xc2e, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0xc35, 0xc3e, 0xc30,
0xc02, 0x3b, 0xc2c, 0xc41, 0xc27, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36,
0xc41, 0xc15, 0xc4d, 0xc30, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc28, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc06, 0x3b, 0xc38,
0xc4b, 0x3b, 0xc2e, 0x3b, 0xc2c, 0xc41, 0x3b, 0xc17, 0xc41, 0x3b, 0xc36, 0xc41, 0x3b, 0xc36, 0x3b, 0xe2d, 0xe32, 0x2e, 0x3b, 0xe08,
0x2e, 0x3b, 0xe2d, 0x2e, 0x3b, 0xe1e, 0x2e, 0x3b, 0xe1e, 0xe24, 0x2e, 0x3b, 0xe28, 0x2e, 0x3b, 0xe2a, 0x2e, 0x3b, 0xe27, 0xe31,
0xe19, 0xe2d, 0xe32, 0xe17, 0xe34, 0xe15, 0xe22, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe08, 0xe31, 0xe19, 0xe17, 0xe23, 0xe4c, 0x3b, 0xe27,
0xe31, 0xe19, 0xe2d, 0xe31, 0xe07, 0xe04, 0xe32, 0xe23, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe38, 0xe18, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e,
0xe24, 0xe2b, 0xe31, 0xe2a, 0xe1a, 0xe14, 0xe35, 0x3b, 0xe27, 0xe31, 0xe19, 0xe28, 0xe38, 0xe01, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19,
0xe40, 0xe2a, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe2d, 0xe32, 0x3b, 0xe08, 0x3b, 0xe2d, 0x3b, 0xe1e, 0x3b, 0xe1e, 0xe24, 0x3b, 0xe28, 0x3b,
0xe2a, 0x3b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58,
0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf54, 0xf0b,
0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b,
0xf58, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42,
0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b,
0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf49, 0xf72, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72,
0x3b, 0xf63, 0xfb7, 0x3b, 0xf55, 0xf74, 0x3b, 0xf54, 0x3b, 0xf66, 0xfa4, 0xf7a, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x3b, 0x1230, 0x1291,
0x12ed, 0x3b, 0x1220, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1283, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262, 0x3b, 0x1240, 0x12f3,
0x121d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1220, 0x3b, 0x1228, 0x3b, 0x1283, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275,
0x3b, 0x1230, 0x1291, 0x12ed, 0x3b, 0x1230, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1213, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262,
0x3b, 0x1240, 0x12f3, 0x121d, 0x3b, 0x53, 0x101, 0x70, 0x3b, 0x4d, 0x14d, 0x6e, 0x3b, 0x54, 0x16b, 0x73, 0x3b, 0x50, 0x75, 0x6c,
0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x3b, 0x46, 0x61, 0x6c, 0x3b, 0x54, 0x6f, 0x6b, 0x3b, 0x53, 0x101, 0x70, 0x61, 0x74, 0x65,
0x3b, 0x4d, 0x14d, 0x6e, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x16b, 0x73, 0x69, 0x74, 0x65, 0x3b, 0x50, 0x75, 0x6c, 0x65, 0x6c,
0x75, 0x6c, 0x75, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x70, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x46, 0x61, 0x6c,
0x61, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x6f, 0x6b, 0x6f, 0x6e, 0x61, 0x6b, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b,
0x50, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x54, 0x3b, 0x50, 0x61, 0x7a, 0x3b, 0x50, 0x7a, 0x74, 0x3b, 0x53, 0x61, 0x6c, 0x3b,
0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x72, 0x3b, 0x43, 0x75, 0x6d, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x50, 0x61, 0x7a, 0x61,
0x72, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x6c, 0x131, 0x3b, 0xc7, 0x61, 0x72,
0x15f, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x72, 0x15f, 0x65, 0x6d, 0x62, 0x65, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x3b,
0x43, 0x75, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b,
0x43, 0x3b, 0x43, 0x3b, 0x64a, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x3b, 0x633, 0x6d5, 0x3b, 0x686, 0x627, 0x3b, 0x67e, 0x6d5, 0x3b, 0x686,
0x6c8, 0x3b, 0x634, 0x6d5, 0x3b, 0x64a, 0x6d5, 0x643, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x634, 0x6d5, 0x646, 0x628,
0x6d5, 0x3b, 0x633, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x686, 0x627, 0x631, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b,
0x67e, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62c, 0x6c8, 0x645, 0x6d5, 0x3b, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b,
0x64a, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x41d, 0x434, 0x3b, 0x41f, 0x43d, 0x3b,
0x412, 0x442, 0x3b, 0x421, 0x440, 0x3b, 0x427, 0x442, 0x3b, 0x41f, 0x442, 0x3b, 0x421, 0x431, 0x3b, 0x41d, 0x435, 0x434, 0x456, 0x43b,
0x44f, 0x3b, 0x41f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e, 0x43a, 0x3b, 0x412, 0x456, 0x432, 0x442, 0x43e, 0x440, 0x43e, 0x43a,
0x3b, 0x421, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x427, 0x435, 0x442, 0x432, 0x435, 0x440, 0x3b, 0x41f, 0x2bc, 0x44f, 0x442, 0x43d,
0x438, 0x446, 0x44f, 0x3b, 0x421, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x41d, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427,
0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e,
0x43a, 0x3b, 0x432, 0x456, 0x432, 0x442, 0x43e, 0x440, 0x43e, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435,
0x442, 0x432, 0x435, 0x440, 0x3b, 0x43f, 0x2bc, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x44f, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430,
0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x633, 0x648, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628,
0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b,
0x59, 0x61, 0x6b, 0x73, 0x68, 0x3b, 0x44, 0x75, 0x73, 0x68, 0x3b, 0x53, 0x65, 0x73, 0x68, 0x3b, 0x43, 0x68, 0x6f, 0x72,
0x3b, 0x50, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x68, 0x61, 0x6e, 0x3b, 0x79, 0x61, 0x6b, 0x73, 0x68, 0x61,
0x6e, 0x62, 0x61, 0x3b, 0x64, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x68, 0x61, 0x6e, 0x62,
0x61, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x70, 0x61, 0x79, 0x73, 0x68, 0x61, 0x6e,
0x62, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x59, 0x3b, 0x44, 0x3b, 0x53,
0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x6cc, 0x2e, 0x3b, 0x62f, 0x2e, 0x3b, 0x633, 0x2e, 0x3b, 0x686, 0x2e,
0x3b, 0x67e, 0x2e, 0x3b, 0x62c, 0x2e, 0x3b, 0x634, 0x2e, 0x3b, 0x42f, 0x43a, 0x448, 0x3b, 0x414, 0x443, 0x448, 0x3b, 0x421, 0x435,
0x448, 0x3b, 0x427, 0x43e, 0x440, 0x3b, 0x41f, 0x430, 0x439, 0x3b, 0x416, 0x443, 0x43c, 0x3b, 0x428, 0x430, 0x43d, 0x3b, 0x44f, 0x43a,
0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x434, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x441, 0x435, 0x448, 0x430, 0x43d, 0x431,
0x430, 0x3b, 0x447, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x43f, 0x430, 0x439, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b,
0x436, 0x443, 0x43c, 0x430, 0x3b, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f,
0x3b, 0x416, 0x3b, 0x428, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x68, 0x20, 0x32, 0x3b, 0x54, 0x68, 0x20, 0x33, 0x3b, 0x54, 0x68,
0x20, 0x34, 0x3b, 0x54, 0x68, 0x20, 0x35, 0x3b, 0x54, 0x68, 0x20, 0x36, 0x3b, 0x54, 0x68, 0x20, 0x37, 0x3b, 0x43, 0x68,
0x1ee7, 0x20, 0x4e, 0x68, 0x1ead, 0x74, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x48, 0x61, 0x69, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42,
0x61, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x54, 0x1b0, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x4e, 0x103, 0x6d, 0x3b, 0x54, 0x68, 0x1ee9,
0x20, 0x53, 0xe1, 0x75, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x1ea3, 0x79, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x32, 0x3b, 0x54,
0x33, 0x3b, 0x54, 0x34, 0x3b, 0x54, 0x35, 0x3b, 0x54, 0x36, 0x3b, 0x54, 0x37, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c,
0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53,
0x61, 0x64, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4c, 0x6c, 0x75,
0x6e, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d,
0x65, 0x72, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x49, 0x61, 0x75, 0x3b, 0x44, 0x79, 0x64, 0x64,
0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x61, 0x64, 0x77, 0x72, 0x6e, 0x3b,
0x53, 0x3b, 0x4c, 0x6c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c,
0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e,
0x3b, 0x53, 0x61, 0x64, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75,
0x6e, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1eb8, 0x74, 0xec, 0x3b,
0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x1ecc,
0x6a, 0x1ecd, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e,
0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20,
0x1eb8, 0x74, 0xec, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0xec,
0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72,
0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x190, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74,
0x61, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0x41, 0x6a, 0xe9,
0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0xfa,
0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0x190, 0x74, 0xec, 0x3b, 0x186, 0x6a, 0x254,
0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x73, 0x6f, 0x3b, 0x42,
0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x53,
0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x73, 0x6f, 0x6d, 0x62, 0x75, 0x6c, 0x75, 0x6b, 0x6f, 0x3b, 0x4c, 0x77, 0x65, 0x73,
0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x4c, 0x77,
0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71,
0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x4d, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0xe5,
0x6e, 0x3b, 0x74, 0x79, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0x61,
0x75, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x79, 0x73, 0x64,
0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72,
0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0x61, 0x75, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0xe5, 0x2e,
0x3b, 0x74, 0x79, 0x2e, 0x3b, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0x61, 0x2e,
0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x438, 0x3b, 0x447, 0x435, 0x442,
0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435,
0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430,
0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e,
0x442, 0x430, 0x3b, 0x4a, 0x65, 0x64, 0x3b, 0x4a, 0x65, 0x6c, 0x3b, 0x4a, 0x65, 0x6d, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x3b,
0x4a, 0x65, 0x72, 0x64, 0x3b, 0x4a, 0x65, 0x68, 0x3b, 0x4a, 0x65, 0x73, 0x3b, 0x4a, 0x65, 0x64, 0x6f, 0x6f, 0x6e, 0x65,
0x65, 0x3b, 0x4a, 0x65, 0x6c, 0x68, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74, 0x3b, 0x4a, 0x65,
0x72, 0x63, 0x65, 0x61, 0x6e, 0x3b, 0x4a, 0x65, 0x72, 0x64, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x68, 0x65, 0x69, 0x6e,
0x65, 0x79, 0x3b, 0x4a, 0x65, 0x73, 0x61, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x74,
0x68, 0x3b, 0x4d, 0x68, 0x72, 0x3b, 0x59, 0x6f, 0x77, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x64, 0x79,
0x20, 0x53, 0x75, 0x6c, 0x3b, 0x64, 0x79, 0x20, 0x4c, 0x75, 0x6e, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x75, 0x72, 0x74,
0x68, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x72, 0x68, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x59, 0x6f, 0x77, 0x3b, 0x64,
0x79, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x3b, 0x4b,
0x77, 0x65, 0x3b, 0x44, 0x77, 0x6f, 0x3b, 0x42, 0x65, 0x6e, 0x3b, 0x57, 0x75, 0x6b, 0x3b, 0x59, 0x61, 0x77, 0x3b, 0x46,
0x69, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x3b, 0x4b, 0x77, 0x65, 0x73, 0x69, 0x64, 0x61, 0x3b, 0x44, 0x77, 0x6f, 0x77, 0x64,
0x61, 0x3b, 0x42, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x3b, 0x57, 0x75, 0x6b, 0x75, 0x64, 0x61, 0x3b, 0x59, 0x61, 0x77, 0x64,
0x61, 0x3b, 0x46, 0x69, 0x64, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x64, 0x61, 0x3b, 0x4b, 0x3b, 0x44, 0x3b,
0x42, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x906, 0x926, 0x93f, 0x924, 0x94d, 0x92f, 0x935, 0x93e, 0x930, 0x3b,
0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930,
0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928,
0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x1ee4, 0x6b, 0x61, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x3b, 0x54, 0x69, 0x75, 0x3b, 0x57, 0x65, 0x6e,
0x3b, 0x54, 0x1ecd, 0x1ecd, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x4d, 0x62, 0x1ecd, 0x73, 0x1ecb, 0x20,
0x1ee4, 0x6b, 0x61, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x64, 0x65, 0x3b, 0x54, 0x69, 0x75, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x65,
0x6e, 0x65, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x64,
0x65, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x1ecd, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x6b, 0x79, 0x3b, 0x57, 0x6b, 0x77, 0x3b, 0x57,
0x6b, 0x6c, 0x3b, 0x57, 0x74, 0x169, 0x3b, 0x57, 0x6b, 0x6e, 0x3b, 0x57, 0x74, 0x6e, 0x3b, 0x57, 0x74, 0x68, 0x3b, 0x57,
0x61, 0x20, 0x6b, 0x79, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6d, 0x62, 0x129, 0x6c, 0x129,
0x6c, 0x79, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74,
0x169, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b,
0x57, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x59, 0x3b, 0x57, 0x3b, 0x45, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d,
0x69, 0x65, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e,
0x69, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x61, 0x72, 0x73, 0x3b, 0x6d, 0x69, 0x65,
0x72, 0x63, 0x75, 0x73, 0x3b, 0x6a, 0x6f, 0x69, 0x62, 0x65, 0x3b, 0x76, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x3b, 0x73, 0x61,
0x62, 0x69, 0x64, 0x65, 0x3b, 0x6b, 0x254, 0x73, 0x3b, 0x64, 0x7a, 0x6f, 0x3b, 0x62, 0x6c, 0x61, 0x3b, 0x6b, 0x75, 0x256,
0x3b, 0x79, 0x61, 0x77, 0x3b, 0x66, 0x69, 0x256, 0x3b, 0x6d, 0x65, 0x6d, 0x3b, 0x6b, 0x254, 0x73, 0x69, 0x256, 0x61, 0x3b,
0x64, 0x7a, 0x6f, 0x256, 0x61, 0x3b, 0x62, 0x6c, 0x61, 0x256, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x61, 0x3b, 0x79, 0x61, 0x77,
0x6f, 0x256, 0x61, 0x3b, 0x66, 0x69, 0x256, 0x61, 0x3b, 0x6d, 0x65, 0x6d, 0x6c, 0x65, 0x256, 0x61, 0x3b, 0x6b, 0x3b, 0x64,
0x3b, 0x62, 0x3b, 0x6b, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x4c, 0x50, 0x3b, 0x50, 0x31, 0x3b, 0x50, 0x32, 0x3b,
0x50, 0x33, 0x3b, 0x50, 0x34, 0x3b, 0x50, 0x35, 0x3b, 0x50, 0x36, 0x3b, 0x4c, 0x101, 0x70, 0x75, 0x6c, 0x65, 0x3b, 0x50,
0x6f, 0x2bb, 0x61, 0x6b, 0x61, 0x68, 0x69, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x75, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61,
0x6b, 0x6f, 0x6c, 0x75, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x68, 0x101, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x69, 0x6d, 0x61,
0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6f, 0x6e, 0x6f, 0x3b, 0x4c, 0x69, 0x6e, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72,
0x3b, 0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4c, 0x69, 0x6e,
0x67, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79,
0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73, 0x3b, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65,
0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b,
0x48, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0xe4, 0x2e, 0x3b, 0x5a, 0x69, 0x2e, 0x3b, 0x4d, 0x69,
0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74, 0x69,
0x67, 0x3b, 0x4d, 0xe4, 0xe4, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x5a, 0x69, 0x69, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b,
0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x46,
0x72, 0x69, 0x69, 0x74, 0x69, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0xa46d, 0xa18f, 0x3b,
0xa18f, 0xa2cd, 0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa315, 0x3b, 0xa18f, 0xa1d6, 0x3b, 0xa18f, 0xa26c, 0x3b, 0xa18f, 0xa0d8, 0x3b, 0xa46d, 0xa18f,
0xa44d, 0x3b, 0xa18f, 0xa282, 0xa2cd, 0x3b, 0xa18f, 0xa282, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa315, 0x3b, 0xa18f, 0xa282, 0xa1d6, 0x3b, 0xa18f, 0xa282,
0xa26c, 0x3b, 0xa18f, 0xa282, 0xa0d8, 0x3b, 0xa18f, 0x3b, 0xa2cd, 0x3b, 0xa44d, 0x3b, 0xa315, 0x3b, 0xa1d6, 0x3b, 0xa26c, 0x3b, 0xa0d8, 0x3b,
0x73, 0x6f, 0x74, 0x6e, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x3b, 0x6d, 0x61, 0x14b, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x3b, 0x64,
0x75, 0x6f, 0x72, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65,
0x61, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x6d, 0x61, 0x14b, 0x14b, 0x65,
0x62, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75,
0x6f, 0x72, 0x61, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1,
0x76, 0x76, 0x61, 0x72, 0x64, 0x61, 0x74, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b,
0x4c, 0x3b, 0x61, 0x65, 0x6a, 0x6c, 0x65, 0x67, 0x65, 0x3b, 0x6d, 0xe5, 0x61, 0x6e, 0x74, 0x61, 0x3b, 0x64, 0xe4, 0x6a,
0x73, 0x74, 0x61, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x65, 0x76, 0x61, 0x68, 0x6b, 0x6f, 0x65, 0x3b, 0x64, 0xe5, 0x61, 0x72,
0x73, 0x74, 0x61, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x68, 0x6b, 0x65, 0x3b, 0x6c, 0x61, 0x61, 0x76,
0x61, 0x64, 0x61, 0x68, 0x6b, 0x65, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c,
0x3b, 0x43, 0x70, 0x72, 0x3b, 0x43, 0x74, 0x74, 0x3b, 0x43, 0x6d, 0x6e, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x41, 0x72, 0x73,
0x3b, 0x49, 0x63, 0x6d, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43,
0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x43, 0x68,
0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x63, 0x68, 0x75,
0x6d, 0x61, 0x3b, 0x45, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x41,
0x3b, 0x49, 0x3b, 0x45, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64,
0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4e, 0x67, 0x75, 0x3b, 0x49, 0x74, 0x75, 0x6b, 0x75, 0x20, 0x6a,
0x61, 0x20, 0x6a, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6a, 0x69, 0x6d,
0x77, 0x65, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69, 0x3b, 0x4b,
0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d,
0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61,
0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x69, 0x66, 0x75, 0x6c, 0x61, 0x20, 0x6e, 0x67, 0x75, 0x77, 0x6f, 0x3b, 0x4a, 0x3b,
0x4a, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x64, 0x65, 0x77, 0x3b, 0x61, 0x61, 0x253, 0x3b,
0x6d, 0x61, 0x77, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x3b, 0x6d, 0x77, 0x64, 0x3b, 0x68, 0x62, 0x69, 0x3b,
0x64, 0x65, 0x77, 0x6f, 0x3b, 0x61, 0x61, 0x253, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x62, 0x61, 0x61, 0x72, 0x65,
0x3b, 0x6e, 0x6a, 0x65, 0x73, 0x6c, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x73, 0x61, 0x61, 0x6e, 0x64, 0x65,
0x3b, 0x6d, 0x61, 0x77, 0x6e, 0x64, 0x65, 0x3b, 0x68, 0x6f, 0x6f, 0x72, 0x65, 0x2d, 0x62, 0x69, 0x69, 0x72, 0x3b, 0x64,
0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x4b, 0x4d, 0x41, 0x3b, 0x4e, 0x54, 0x54,
0x3b, 0x4e, 0x4d, 0x4e, 0x3b, 0x4e, 0x4d, 0x54, 0x3b, 0x41, 0x52, 0x54, 0x3b, 0x4e, 0x4d, 0x41, 0x3b, 0x4e, 0x4d, 0x4d,
0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4e, 0x6a,
0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x61,
0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f,
0x74, 0x68, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x72,
0x65, 0x3b, 0x4b, 0x75, 0x6e, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61,
0x70, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x61, 0x72, 0x65, 0x3b,
0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f,
0x74, 0x20, 0x65, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20,
0x65, 0x65, 0x20, 0x69, 0x6e, 0x65, 0x74, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6c,
0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4d, 0x64, 0x65,
0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x77, 0x65, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49,
0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x50, 0x6f, 0x73, 0x3b, 0x50, 0x69, 0x72, 0x3b, 0x54, 0x61, 0x74,
0x3b, 0x4e, 0x61, 0x69, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x75,
0x3b, 0x43, 0x68, 0x69, 0x70, 0x6f, 0x73, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75,
0x3b, 0x53, 0x61, 0x62, 0x75, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x53, 0x3b,
0x53, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x69,
0x6e, 0x3b, 0x53, 0x69, 0x68, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x76, 0x75, 0x6c,
0x6f, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x53, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x53, 0x69,
0x6e, 0x65, 0x3b, 0x53, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x49, 0x6a, 0x70, 0x3b, 0x49, 0x6a,
0x74, 0x3b, 0x49, 0x6a, 0x6e, 0x3b, 0x49, 0x6a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x49,
0x6a, 0x6d, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61,
0x74, 0x75, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e,
0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x49, 0x6a,
0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b,
0x31, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x3b, 0x2d30, 0x2d3d,
0x2d61, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30,
0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d,
0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x61,
0x73, 0x61, 0x3b, 0x61, 0x79, 0x6e, 0x3b, 0x61, 0x73, 0x69, 0x3b, 0x61, 0x6b, 0x1e5b, 0x3b, 0x61, 0x6b, 0x77, 0x3b, 0x61,
0x73, 0x69, 0x6d, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x3b, 0x61, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x61, 0x79, 0x6e, 0x61,
0x73, 0x3b, 0x61, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x1e5b, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x77, 0x61, 0x73,
0x3b, 0x61, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x59, 0x61, 0x6e,
0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x3b, 0x4b, 0x75, 0x1e93, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x1e0d,
0x69, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x3b, 0x59, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6e, 0x61, 0x73, 0x73,
0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x75, 0x1e93, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x61,
0x73, 0x73, 0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x61, 0x73, 0x73, 0x3b, 0x59, 0x3b,
0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x41, 0x4e, 0x3b, 0x4f, 0x52, 0x4b, 0x3b,
0x4f, 0x4b, 0x42, 0x3b, 0x4f, 0x4b, 0x53, 0x3b, 0x4f, 0x4b, 0x4e, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4f, 0x4d, 0x4b, 0x3b,
0x53, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x4f, 0x72, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x72,
0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75,
0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e,
0x6f, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x52, 0x3b,
0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x48, 0x69, 0x76, 0x3b,
0x48, 0x69, 0x64, 0x3b, 0x48, 0x69, 0x74, 0x3b, 0x48, 0x69, 0x68, 0x3b, 0x4c, 0x65, 0x6d, 0x3b, 0x70, 0x61, 0x20, 0x6d,
0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x76, 0x69, 0x6c, 0x75, 0x68,
0x61, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x64, 0x61, 0x74,
0x75, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x74, 0x61, 0x79, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x68, 0x61, 0x6e,
0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x6c, 0x65, 0x6d, 0x62, 0x65, 0x6c, 0x61, 0x3b, 0x4d, 0x3b,
0x4a, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b,
0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x75, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x41, 0x6c, 0x68,
0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73,
0x69, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x6b, 0x61, 0x72, 0x3b,
0x6e, 0x74, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x3b, 0x61, 0x72, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x3b,
0x73, 0x69, 0x62, 0x3b, 0x6b, 0x61, 0x72, 0x69, 0x3b, 0x6e, 0x74, 0x25b, 0x6e, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x61, 0x74,
0x61, 0x3b, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61,
0x3b, 0x73, 0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4a, 0x3b,
0x53, 0x3b, 0x4b, 0x6d, 0x61, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x41, 0x72,
0x6d, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4e, 0x4d, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75,
0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d,
0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61,
0x61, 0x3b, 0x4e, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x4e, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x3b,
0x13e6, 0x13a2, 0x13c1, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x3b, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3,
0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e6, 0x13a2,
0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x13b6, 0x13cd, 0x13d7, 0x3b, 0x13a4, 0x13be, 0x13d9,
0x13d3, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13c6, 0x3b, 0x13c9, 0x3b, 0x13d4, 0x3b, 0x13e6, 0x3b, 0x13c5, 0x3b, 0x13e7, 0x3b, 0x13a4, 0x3b, 0x64,
0x69, 0x6d, 0x3b, 0x6c, 0x69, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x7a, 0x65, 0x3b, 0x76, 0x61,
0x6e, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6d,
0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x7a, 0x65, 0x64, 0x69, 0x3b, 0x76,
0x61, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0x69, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b,
0x6d, 0x3b, 0x7a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x4c, 0x6c, 0x32, 0x3b, 0x4c, 0x6c, 0x33, 0x3b, 0x4c, 0x6c, 0x34, 0x3b,
0x4c, 0x6c, 0x35, 0x3b, 0x4c, 0x6c, 0x36, 0x3b, 0x4c, 0x6c, 0x37, 0x3b, 0x4c, 0x6c, 0x31, 0x3b, 0x4c, 0x69, 0x64, 0x75,
0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79,
0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x63, 0x68, 0x65,
0x63, 0x68, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f,
0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61,
0x20, 0x6c, 0x69, 0x6e, 0x6a, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79,
0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61,
0x20, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x50, 0xed, 0x69, 0x6c, 0x69, 0x3b, 0x54, 0xe1, 0x61, 0x74, 0x75,
0x3b, 0xcd, 0x6e, 0x65, 0x3b, 0x54, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4d,
0xf3, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0xed, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x61, 0x6e,
0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x6d, 0xed, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x6d, 0xf3, 0x6f, 0x73, 0x69, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b,
0x4d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x42, 0x61, 0x6c, 0x3b, 0x4c, 0x77, 0x32, 0x3b, 0x4c, 0x77, 0x33, 0x3b, 0x4c, 0x77,
0x34, 0x3b, 0x4c, 0x77, 0x35, 0x3b, 0x4c, 0x77, 0x36, 0x3b, 0x53, 0x61, 0x62, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42,
0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x6b,
0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x74,
0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b,
0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x50, 0x61, 0x20, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75,
0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6d, 0x6f, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x62, 0x75,
0x6c, 0x69, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63,
0x68, 0x69, 0x6e, 0x65, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x6f, 0x3b, 0x50, 0x61, 0x63,
0x68, 0x69, 0x62, 0x65, 0x6c, 0x75, 0x73, 0x68, 0x69, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x67, 0x3b, 0x74, 0x65,
0x72, 0x3b, 0x6b, 0x75, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x3b, 0x73, 0x65, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x75,
0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x74,
0x65, 0x72, 0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72,
0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x61, 0x2d, 0x66,
0x65, 0x72, 0x61, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x64, 0x3b, 0x73, 0x3b, 0x74, 0x3b, 0x6b, 0x3b, 0x6b,
0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4b,
0x49, 0x55, 0x3b, 0x4d, 0x52, 0x41, 0x3b, 0x57, 0x41, 0x49, 0x3b, 0x57, 0x45, 0x54, 0x3b, 0x57, 0x45, 0x4e, 0x3b, 0x57,
0x54, 0x4e, 0x3b, 0x4a, 0x55, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x6d, 0x75,
0x6b, 0x6f, 0x3b, 0x57, 0x61, 0x69, 0x72, 0x69, 0x3b, 0x57, 0x65, 0x74, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x57, 0x65, 0x6e,
0x61, 0x3b, 0x57, 0x65, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4b, 0x3b,
0x4d, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x4b, 0x74, 0x73, 0x3b, 0x4b, 0x6f, 0x74, 0x3b,
0x4b, 0x6f, 0x6f, 0x3b, 0x4b, 0x6f, 0x73, 0x3b, 0x4b, 0x6f, 0x61, 0x3b, 0x4b, 0x6f, 0x6d, 0x3b, 0x4b, 0x6f, 0x6c, 0x3b,
0x4b, 0x6f, 0x74, 0x69, 0x73, 0x61, 0x70, 0x3b, 0x4b, 0x6f, 0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x6f, 0x61, 0x65, 0x6e,
0x67, 0x2019, 0x3b, 0x4b, 0x6f, 0x73, 0x6f, 0x6d, 0x6f, 0x6b, 0x3b, 0x4b, 0x6f, 0x61, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e,
0x3b, 0x4b, 0x6f, 0x6d, 0x75, 0x75, 0x74, 0x3b, 0x4b, 0x6f, 0x6c, 0x6f, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x53,
0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x65, 0x3b, 0x57, 0x75, 0x3b,
0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65,
0x73, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x65, 0x6e, 0x73, 0x74, 0x61,
0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x57, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b,
0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x74,
0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65,
0x73, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x75, 0x2e, 0x3b,
0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x65, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b,
0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x6f, 0x6f, 0x6e, 0x64, 0x61,
0x61, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x6e, 0x6e, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x65, 0x74, 0x77, 0x6f,
0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x46, 0x72, 0x69, 0x69,
0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x70, 0xed, 0x6c, 0xed, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x65,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x6e, 0x254, 0x3b, 0x41, 0x6c, 0x61, 0xe1, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x4a,
0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x3b, 0x42,
0x61, 0x6c, 0x61, 0x3b, 0x4b, 0x75, 0x62, 0x69, 0x3b, 0x4b, 0x75, 0x73, 0x61, 0x3b, 0x4b, 0x75, 0x6e, 0x61, 0x3b, 0x4b,
0x75, 0x74, 0x61, 0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c,
0x61, 0x7a, 0x61, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x73,
0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x74, 0x61, 0x61,
0x6e, 0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x42, 0x3b,
0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x4a, 0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a, 0x34, 0x3b, 0x4a, 0x35, 0x3b,
0x41, 0x6c, 0x3b, 0x49, 0x6a, 0x3b, 0x4a, 0x31, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4d,
0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d,
0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b,
0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x42, 0x61, 0x72, 0x3b,
0x41, 0x61, 0x72, 0x3b, 0x55, 0x6e, 0x69, 0x3b, 0x55, 0x6e, 0x67, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x62, 0x3b,
0x4e, 0x61, 0x6b, 0x61, 0x65, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x62, 0x61, 0x72, 0x61, 0x73,
0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x61,
0x6b, 0x61, 0x75, 0x6e, 0x67, 0x2019, 0x6f, 0x6e, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x6b, 0x61, 0x6e, 0x79, 0x3b, 0x4e, 0x61,
0x6b, 0x61, 0x73, 0x61, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x4a, 0x3b, 0x42, 0x3b, 0x41, 0x3b, 0x55, 0x3b, 0x55, 0x3b, 0x4b,
0x3b, 0x53, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41,
0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x6a, 0x3b, 0x41, 0x73, 0x73, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74,
0x69, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41,
0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x73, 0x61,
0x62, 0x64, 0x75, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x4a, 0x4d,
0x50, 0x3b, 0x57, 0x55, 0x54, 0x3b, 0x54, 0x41, 0x52, 0x3b, 0x54, 0x41, 0x44, 0x3b, 0x54, 0x41, 0x4e, 0x3b, 0x54, 0x41,
0x42, 0x3b, 0x4e, 0x47, 0x53, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x3b, 0x57, 0x75, 0x6f, 0x6b, 0x20, 0x54,
0x69, 0x63, 0x68, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20,
0x41, 0x64, 0x65, 0x6b, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x54, 0x69,
0x63, 0x68, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68, 0x3b, 0x4e, 0x67, 0x65, 0x73, 0x6f, 0x3b, 0x4a, 0x3b, 0x57, 0x3b, 0x54,
0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x41, 0x79, 0x6e, 0x3b, 0x41, 0x73, 0x6e,
0x3b, 0x41, 0x6b, 0x72, 0x3b, 0x41, 0x6b, 0x77, 0x3b, 0x41, 0x73, 0x6d, 0x3b, 0x41, 0x73, 0x1e0d, 0x3b, 0x41, 0x73, 0x61,
0x6d, 0x61, 0x73, 0x3b, 0x41, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x72,
0x61, 0x73, 0x3b, 0x41, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69,
0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41,
0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41,
0x6c, 0x7a, 0x3b, 0x41, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69,
0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68,
0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69,
0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6d, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68,
0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x70, 0x69, 0x69, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61,
0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b,
0x41, 0x3b, 0x49, 0x3b, 0x31, 0x3b, 0x930, 0x92c, 0x93f, 0x3b, 0x938, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941,
0x926, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x3b, 0x930,
0x92c, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b,
0x92c, 0x941, 0x926, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x916, 0x941,
0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x3b, 0x92e, 0x902, 0x3b,
0x92c, 0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x938, 0x941, 0x3b, 0x938, 0x941, 0x3b, 0x4c, 0x75, 0x6d, 0x3b, 0x4e, 0x6b, 0x6f, 0x3b,
0x4e, 0x64, 0x79, 0x3b, 0x4e, 0x64, 0x67, 0x3b, 0x4e, 0x6a, 0x77, 0x3b, 0x4e, 0x67, 0x76, 0x3b, 0x4c, 0x75, 0x62, 0x3b,
0x4c, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4e, 0x6b, 0x6f, 0x64, 0x79, 0x61, 0x3b, 0x4e, 0x64, 0xe0, 0x61, 0x79,
0xe0, 0x3b, 0x4e, 0x64, 0x61, 0x6e, 0x67, 0xf9, 0x3b, 0x4e, 0x6a, 0xf2, 0x77, 0x61, 0x3b, 0x4e, 0x67, 0xf2, 0x76, 0x79,
0x61, 0x3b, 0x4c, 0x75, 0x62, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4c, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x4e, 0x3b, 0x4c, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0xe9, 0x69, 0x3b, 0x44, 0xeb, 0x6e, 0x3b, 0x4d, 0xeb, 0x74, 0x3b,
0x44, 0x6f, 0x6e, 0x3b, 0x46, 0x72, 0x65, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x6f, 0x6e, 0x6e, 0x64, 0x65, 0x67, 0x3b,
0x4d, 0xe9, 0x69, 0x6e, 0x64, 0x65, 0x67, 0x3b, 0x44, 0xeb, 0x6e, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x4d, 0xeb,
0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x46,
0x72, 0x65, 0x69, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x6f, 0x6e,
0x2e, 0x3b, 0x4d, 0xe9, 0x69, 0x2e, 0x3b, 0x44, 0xeb, 0x6e, 0x2e, 0x3b, 0x4d, 0xeb, 0x74, 0x2e, 0x3b, 0x44, 0x6f, 0x6e,
0x2e, 0x3b, 0x46, 0x72, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x6d, 0x2e, 0x3b, 0x6e, 0x74, 0x73, 0x3b, 0x6b, 0x70, 0x61, 0x3b,
0x67, 0x68, 0x254, 0x3b, 0x74, 0x254, 0x6d, 0x3b, 0x75, 0x6d, 0x65, 0x3b, 0x67, 0x68, 0x268, 0x3b, 0x64, 0x7a, 0x6b, 0x3b,
0x74, 0x73, 0x75, 0x294, 0x6e, 0x74, 0x73, 0x268, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6b, 0x70, 0xe0, 0x3b, 0x74, 0x73,
0x75, 0x294, 0x75, 0x67, 0x68, 0x254, 0x65, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x74, 0x254, 0x300, 0x6d, 0x6c, 0xf2, 0x3b,
0x74, 0x73, 0x75, 0x294, 0x75, 0x6d, 0xe8, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x268, 0x302, 0x6d, 0x3b, 0x74,
0x73, 0x75, 0x294, 0x6e, 0x64, 0x7a, 0x268, 0x6b, 0x254, 0x294, 0x254, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x67, 0x3b, 0x74, 0x3b,
0x75, 0x3b, 0x67, 0x3b, 0x64, 0x3b, 0x6e, 0x254, 0x79, 0x3b, 0x6e, 0x6a, 0x61, 0x3b, 0x75, 0x75, 0x6d, 0x3b, 0x14b, 0x67,
0x65, 0x3b, 0x6d, 0x62, 0x254, 0x3b, 0x6b, 0x254, 0x254, 0x3b, 0x6a, 0x6f, 0x6e, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e,
0x254, 0x302, 0x79, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x6a, 0x61, 0x14b, 0x67, 0x75, 0x6d, 0x62, 0x61, 0x3b, 0x14b,
0x67, 0x77, 0xe0, 0x20, 0xfb, 0x6d, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x14b, 0x67, 0xea, 0x3b, 0x14b, 0x67, 0x77, 0xe0,
0x20, 0x6d, 0x62, 0x254, 0x6b, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6b, 0x254, 0x254, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20,
0x6a, 0xf4, 0x6e, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x75, 0x3b, 0x14b, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6a, 0x3b, 0x41, 0x6c,
0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61,
0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x7a,
0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4d,
0x3b, 0x5a, 0x3b, 0x53, 0x3b, 0xe9, 0x74, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0x3b, 0x6b, 0x77, 0x61, 0x3b, 0x6d, 0x75, 0x6b,
0x3b, 0x14b, 0x67, 0x69, 0x3b, 0x257, 0xf3, 0x6e, 0x3b, 0x65, 0x73, 0x61, 0x3b, 0xe9, 0x74, 0x69, 0x3b, 0x6d, 0x254, 0x301,
0x73, 0xfa, 0x3b, 0x6b, 0x77, 0x61, 0x73, 0xfa, 0x3b, 0x6d, 0x75, 0x6b, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x14b, 0x67, 0x69,
0x73, 0xfa, 0x3b, 0x257, 0xf3, 0x6e, 0x25b, 0x73, 0xfa, 0x3b, 0x65, 0x73, 0x61, 0x253, 0x61, 0x73, 0xfa, 0x3b, 0x65, 0x3b,
0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x14b, 0x3b, 0x257, 0x3b, 0x65, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x54, 0x65, 0x6e, 0x3b,
0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x41, 0x72, 0x6a, 0x3b, 0x53, 0x69, 0x62, 0x3b,
0x44, 0x69, 0x6d, 0x61, 0x73, 0x3b, 0x54, 0x65, 0x6e, 0x65, 0x14b, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41,
0x6c, 0x61, 0x72, 0x62, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x73, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x6a, 0x75,
0x6d, 0x61, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b,
0x41, 0x3b, 0x53, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d,
0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x66, 0xfa, 0x6c, 0x3b, 0x73, 0xe9, 0x72, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254,
0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20,
0x6d, 0x259, 0x301, 0x62, 0x25b, 0x30c, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d,
0x259, 0x301, 0x6c, 0x25b, 0x301, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259,
0x301, 0x6e, 0x79, 0x69, 0x3b, 0x66, 0xfa, 0x6c, 0x61, 0x64, 0xe9, 0x3b, 0x73, 0xe9, 0x72, 0x61, 0x64, 0xe9, 0x3b, 0x73,
0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x66, 0x3b, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6c, 0x1dd,
0x6e, 0x3b, 0x6d, 0x61, 0x61, 0x3b, 0x6d, 0x25b, 0x6b, 0x3b, 0x6a, 0x1dd, 0x1dd, 0x3b, 0x6a, 0xfa, 0x6d, 0x3b, 0x73, 0x61,
0x6d, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x1dd, 0x3b, 0x6c, 0x1dd, 0x6e, 0x64, 0xed, 0x3b, 0x6d, 0x61, 0x61, 0x64, 0xed,
0x3b, 0x6d, 0x25b, 0x6b, 0x72, 0x25b, 0x64, 0xed, 0x3b, 0x6a, 0x1dd, 0x1dd, 0x64, 0xed, 0x3b, 0x6a, 0xfa, 0x6d, 0x62, 0xe1,
0x3b, 0x73, 0x61, 0x6d, 0x64, 0xed, 0x3b, 0x73, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x73,
0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x72, 0x61,
0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e,
0x6f, 0x3b, 0x41, 0x72, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b,
0x4a, 0x3b, 0x43, 0x79, 0x61, 0x3b, 0x43, 0x6c, 0x61, 0x3b, 0x43, 0x7a, 0x69, 0x3b, 0x43, 0x6b, 0x6f, 0x3b, 0x43, 0x6b,
0x61, 0x3b, 0x43, 0x67, 0x61, 0x3b, 0x43, 0x7a, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x2019, 0x79, 0x61, 0x6b, 0x6b, 0x65, 0x3b,
0x43, 0x6f, 0x6d, 0x6c, 0x61, 0x61, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x69, 0x69, 0x257, 0x69, 0x69,
0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x6f, 0x6c, 0x6c, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x61, 0x6c, 0x64, 0x1dd, 0x253, 0x6c,
0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x67, 0x61, 0x69, 0x73, 0x75, 0x75, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x65, 0x253,
0x73, 0x75, 0x75, 0x3b, 0x59, 0x3b, 0x4c, 0x3b, 0x5a, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x45, 0x3b, 0x73, 0x254,
0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b,
0x6d, 0x62, 0x73, 0x3b, 0x73, 0x61, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64,
0x254, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x62, 0x61, 0x3b, 0x73,
0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6c, 0x61, 0x6c, 0x3b, 0x73, 0x254, 0x301,
0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x62, 0xe1, 0x67, 0xe1,
0x20, 0x6d, 0xe1, 0x20, 0x73, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x73, 0xe1, 0x73, 0x61, 0x64, 0x69, 0x3b, 0x73, 0x3b, 0x6d,
0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x43, 0xe4, 0x14b, 0x3b, 0x4a, 0x69, 0x65, 0x63, 0x3b,
0x52, 0x25b, 0x77, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x3b, 0x44, 0x68, 0x69, 0x65,
0x65, 0x63, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x3b, 0x43, 0xe4, 0x14b, 0x20, 0x6b, 0x75, 0x254, 0x74, 0x68, 0x3b, 0x4a,
0x69, 0x65, 0x63, 0x20, 0x6c, 0x61, 0x331, 0x74, 0x3b, 0x52, 0x25b, 0x77, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44,
0x69, 0x254, 0x331, 0x6b, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x20, 0x6c, 0xe4, 0x74,
0x6e, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x42, 0xe4, 0x6b, 0x25b,
0x6c, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x14a, 0x3b, 0x44, 0x3b,
0x42, 0x3b, 0x411, 0x441, 0x3b, 0x411, 0x43d, 0x3b, 0x41e, 0x43f, 0x3b, 0x421, 0x44d, 0x3b, 0x427, 0x43f, 0x3b, 0x411, 0x44d, 0x3b,
0x421, 0x431, 0x3b, 0x411, 0x430, 0x441, 0x43a, 0x44b, 0x4bb, 0x44b, 0x430, 0x43d, 0x43d, 0x44c, 0x430, 0x3b, 0x411, 0x44d, 0x43d, 0x438,
0x434, 0x438, 0x44d, 0x43b, 0x438, 0x43d, 0x43d, 0x44c, 0x438, 0x43a, 0x3b, 0x41e, 0x43f, 0x442, 0x443, 0x43e, 0x440, 0x443, 0x43d, 0x43d,
0x44c, 0x443, 0x43a, 0x3b, 0x421, 0x44d, 0x440, 0x44d, 0x434, 0x44d, 0x3b, 0x427, 0x44d, 0x43f, 0x43f, 0x438, 0x44d, 0x440, 0x3b, 0x411,
0x44d, 0x44d, 0x442, 0x438, 0x4a5, 0x441, 0x44d, 0x3b, 0x421, 0x443, 0x431, 0x443, 0x43e, 0x442, 0x430, 0x3b, 0x411, 0x3b, 0x411, 0x3b,
0x41e, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x411, 0x3b, 0x421, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e,
0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4d, 0x75,
0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e,
0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73,
0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4d, 0x3b,
0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0xa55e, 0xa54c, 0xa535, 0x3b, 0xa5f3, 0xa5e1, 0xa609, 0x3b,
0xa55a, 0xa55e, 0xa55a, 0x3b, 0xa549, 0xa55e, 0xa552, 0x3b, 0xa549, 0xa524, 0xa546, 0xa562, 0x3b, 0xa549, 0xa524, 0xa540, 0xa56e, 0x3b, 0xa53b, 0xa52c,
0xa533, 0x3b, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x74, 0x25b, 0x25b, 0x6e, 0x25b, 0x25b, 0x3b, 0x74, 0x61, 0x6c, 0x61,
0x74, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x69, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x61, 0x69, 0x6a, 0x69,
0x6d, 0x61, 0x3b, 0x73, 0x69, 0x253, 0x69, 0x74, 0x69, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x4d, 0xe4, 0x6e, 0x3b, 0x5a, 0x69,
0x161, 0x3b, 0x4d, 0x69, 0x74, 0x3b, 0x46, 0x72, 0xf3, 0x3b, 0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x75,
0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0xe4, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x5a, 0x69, 0x161, 0x74, 0x61, 0x67, 0x3b,
0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x10d, 0x3b, 0x46, 0x72, 0xf3, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x74,
0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x46,
0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x73, 0x64, 0x3b, 0x6d, 0x64, 0x3b, 0x6d, 0x77, 0x3b, 0x65, 0x74, 0x3b, 0x6b, 0x6c, 0x3b,
0x66, 0x6c, 0x3b, 0x73, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x25b, 0x3b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65,
0x3b, 0x6d, 0x75, 0xe1, 0x6e, 0x79, 0xe1, 0x14b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x65, 0x74, 0xfa, 0x6b,
0x70, 0xed, 0xe1, 0x70, 0x25b, 0x3b, 0x6b, 0xfa, 0x70, 0xe9, 0x6c, 0x69, 0x6d, 0x65, 0x74, 0xfa, 0x6b, 0x70, 0x69, 0x61,
0x70, 0x25b, 0x3b, 0x66, 0x65, 0x6c, 0xe9, 0x74, 0x65, 0x3b, 0x73, 0xe9, 0x73, 0x65, 0x6c, 0xe9, 0x3b, 0x73, 0x3b, 0x6d,
0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x73, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x6c, 0x75, 0x3b, 0x6d,
0x61, 0x72, 0x3b, 0x6d, 0x69, 0x65, 0x3b, 0x78, 0x75, 0x65, 0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64,
0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x6c, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73,
0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x78, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69,
0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x53, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b,
0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0xc1, 0x70, 0x74, 0x61, 0x20, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x57,
0x25b, 0x301, 0x6e, 0x25b, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x54, 0x254, 0x301, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x46, 0x25b, 0x6c,
0xe2, 0x79, 0x25b, 0x64, 0x25b, 0x3b, 0x53, 0xe1, 0x73, 0x69, 0x64, 0x25b, 0x3b, 0x53, 0x254, 0x301, 0x3b, 0x4d, 0x254, 0x301,
0x3b, 0xc1, 0x4d, 0x3b, 0x57, 0x25b, 0x301, 0x3b, 0x54, 0x254, 0x301, 0x3b, 0x46, 0x25b, 0x3b, 0x53, 0xe1, 0x3b, 0x73, 0x254,
0x6e, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x25b, 0x72, 0x6b,
0x25b, 0x72, 0x25b, 0x64, 0x69, 0x3b, 0x79, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x14b, 0x64, 0x25b, 0x72, 0x25b, 0x64, 0x69,
0x3b, 0x6d, 0x254, 0x6e, 0x254, 0x20, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61,
0x3b, 0x6d, 0x25b, 0x3b, 0x79, 0x65, 0x3b, 0x76, 0x61, 0x3b, 0x6d, 0x73, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x31, 0x3b,
0x41, 0x6e, 0x65, 0x67, 0x20, 0x32, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x33, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x34,
0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x35, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x36, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20,
0x37, 0x3b, 0x41, 0x31, 0x3b, 0x41, 0x32, 0x3b, 0x41, 0x33, 0x3b, 0x41, 0x34, 0x3b, 0x41, 0x35, 0x3b, 0x41, 0x36, 0x3b,
0x41, 0x37, 0x3b, 0x6c, 0x79, 0x25b, 0x2bc, 0x25b, 0x301, 0x20, 0x73, 0x1e85, 0xed, 0x14b, 0x74, 0xe8, 0x3b, 0x6d, 0x76, 0x66,
0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20, 0x6d, 0x76, 0x66,
0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x74, 0x73, 0xe8, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b,
0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0x25b, 0x300, 0x25b,
0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b,
0x30c, 0x2bc, 0x3b, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75,
0x77, 0x61, 0x6b, 0x21f, 0x61, 0x14b, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x77, 0x61, 0x14b, 0x17e, 0x69, 0x3b, 0x41,
0x14b, 0x70, 0xe9, 0x74, 0x75, 0x6e, 0x75, 0x14b, 0x70, 0x61, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x79, 0x61, 0x6d,
0x6e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75,
0x7a, 0x61, 0x70, 0x74, 0x61, 0x14b, 0x3b, 0x4f, 0x77, 0xe1, 0x14b, 0x67, 0x79, 0x75, 0x17e, 0x61, 0x17e, 0x61, 0x70, 0x69,
0x3b, 0x41, 0x3b, 0x57, 0x3b, 0x4e, 0x3b, 0x59, 0x3b, 0x54, 0x3b, 0x5a, 0x3b, 0x4f, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59,
0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62,
0x2d30, 0x2d59, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x61, 0x142, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x73,
0x74, 0x77, 0x3b, 0x70, 0x11b, 0x74, 0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70,
0xf3, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x65, 0x3b, 0x77, 0x61, 0x142, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a,
0x6f, 0x64, 0x61, 0x3b, 0x73, 0x74, 0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x11b, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62,
0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x6a,
0x65, 0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x75, 0x74, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x161, 0x74, 0x77, 0x3b, 0x70, 0x6a,
0x61, 0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x6a, 0x65, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x64, 0x17a,
0x65, 0x6c, 0x61, 0x3b, 0x77, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74,
0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x6a, 0x61, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e,
0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x70, 0x61, 0x3b, 0x76, 0x75, 0x3b, 0x6d,
0x61, 0x3b, 0x6b, 0x6f, 0x3b, 0x74, 0x75, 0x3b, 0x76, 0xe1, 0x3b, 0x6c, 0xe1, 0x3b, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65,
0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61,
0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73, 0x6b, 0x6f, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74,
0xe2, 0x68, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75, 0x70, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72,
0x64, 0xe2, 0x68, 0x3b, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73,
0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73,
0x6b, 0x6f, 0x68, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74, 0x75, 0x76, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75,
0x70, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0x75, 0x76, 0x3b, 0x50, 0x3b, 0x56,
0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x4c, 0x3b
};

static const ushort am_data[] = {
0x41, 0x4d, 0x57, 0x44, 0x76, 0x6d, 0x2e, 0x70, 0x61, 0x72, 0x61, 0x64, 0x69, 0x74, 0x65, 0x1325, 0x12cb, 0x1275, 0x635, 0x56f,
0x565, 0x57d, 0x585, 0x580, 0x56b, 0x581, 0x20, 0x561, 0x57c, 0x561, 0x57b, 0x9aa, 0x9c2, 0x9f0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a3,
0x9aa, 0x9c2, 0x9b0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a3, 0xf66, 0xf94, 0xf0b, 0xf46, 0xf0b, 0x41, 0x2e, 0x4d, 0x2e, 0x43f, 0x440,
0x2e, 0x43e, 0x431, 0x2e, 0x1014, 0x1036, 0x1014, 0x1000, 0x103a, 0x434, 0x430, 0x20, 0x43f, 0x430, 0x43b, 0x443, 0x434, 0x43d, 0x44f, 0x1796,
0x17d2, 0x179a, 0x17b9, 0x1780, 0x61, 0x2e, 0x20, 0x6d, 0x2e, 0x4e0a, 0x5348, 0x64, 0x6f, 0x70, 0x6f, 0x6c, 0x65, 0x64, 0x6e, 0x65,
0x61, 0x2e, 0x6d, 0x2e, 0x75, 0x6d, 0x20, 0x66, 0x79, 0x72, 0x72, 0x61, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x61, 0x70,
0x2e, 0x6d, 0x76, 0x6f, 0x72, 0x6d, 0x2e, 0x3c0, 0x2e, 0x3bc, 0x2e, 0x5dc, 0x5e4, 0x5e0, 0x5d4, 0x5f4, 0x5e6, 0x92a, 0x942, 0x930,
0x94d, 0x935, 0x93e, 0x939, 0x94d, 0x928, 0x64, 0x65, 0x2e, 0x66, 0x2e, 0x68, 0x2e, 0x5348, 0x524d, 0xcaa, 0xcc2, 0xcb0, 0xccd, 0xcb5,
0xcbe, 0xcb9, 0xccd, 0xca8, 0x442, 0x430, 0x4a3, 0x435, 0x440, 0x442, 0x435, 0x4a3, 0x433, 0x456, 0x442, 0x430, 0x4a3, 0x43a, 0x44b, 0xc624,
0xc804, 0x5a, 0x2e, 0x4d, 0x55, 0x2e, 0xe81, 0xec8, 0xead, 0xe99, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x72, 0x69, 0x65, 0x6b, 0x161,
0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x67, 0x254, 0x301, 0x70, 0x72, 0x69, 0x65,
0x161, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x440, 0x435, 0x442, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x47, 0x92e, 0x2e, 0x92a,
0x942, 0x2e, 0x4ae, 0x4e8, 0x61, 0x6d, 0x63a, 0x2e, 0x645, 0x2e, 0x642, 0x628, 0x644, 0x200c, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64,
0x61, 0x20, 0x6d, 0x61, 0x6e, 0x68, 0xe3, 0xa2a, 0xa42, 0x2e, 0xa26, 0xa41, 0x2e, 0x4e, 0x44, 0x43f, 0x440, 0x435, 0x20, 0x43f,
0x43e, 0x434, 0x43d, 0x435, 0x70, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e,
0x43d, 0x44b, 0x20, 0x440, 0x430, 0x437, 0x43c, 0x4d5, 0xdb4, 0xdd9, 0x2e, 0xdc0, 0x2e, 0x64, 0x6f, 0x70, 0x6f, 0x6c, 0x75, 0x64,
0x6e, 0x69, 0x61, 0x64, 0x6f, 0x70, 0x2e, 0x73, 0x6e, 0x2e, 0x79, 0x61, 0x20, 0x61, 0x73, 0x75, 0x62, 0x75, 0x79, 0x69,
0x66, 0x6d, 0xbae, 0xbc1, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0x5b, 0x41, 0x4d, 0x5d, 0xe01, 0xe48, 0xe2d, 0xe19, 0xe40, 0xe17,
0xe35, 0xe48, 0xe22, 0xe07, 0xf66, 0xf94, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x1295, 0x1309, 0x1206, 0x20, 0x1230, 0x12d3, 0x1270, 0xd6, 0xd6,
0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x628, 0x6c7, 0x631, 0x6c7, 0x646, 0x434, 0x43f, 0x642, 0x628, 0x644, 0x20, 0x62f, 0x648,
0x67e, 0x6c1, 0x631, 0x54, 0x4f, 0x53, 0x41, 0xc0, 0xe1, 0x72, 0x1ecd, 0x300, 0xc0, 0xe1, 0x72, 0x254, 0x300, 0x45, 0x6b, 0x75,
0x73, 0x65, 0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x20, 0x70,
0x6f, 0x64, 0x6e, 0x65, 0x41, 0x4e, 0x128, 0x79, 0x61, 0x6b, 0x77, 0x61, 0x6b, 0x79, 0x61, 0x61, 0x2e, 0x14b, 0x64, 0x69,
0xa3b8, 0xa111, 0x69, 0x111, 0x69, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x4d, 0x61, 0x2f, 0x4d, 0x6f, 0x4c, 0x75,
0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x4b, 0x73, 0x75, 0x62, 0x61, 0x6b, 0x61, 0x4b, 0x69, 0x72, 0x6f, 0x6b, 0x6f,
0x54, 0x65, 0x73, 0x69, 0x72, 0x61, 0x6e, 0x6b, 0x61, 0x6e, 0x67, 0x2019, 0x61, 0x6d, 0x61, 0x2d5c, 0x2d49, 0x2d3c, 0x2d30, 0x2d61,
0x2d5c, 0x74, 0x69, 0x66, 0x61, 0x77, 0x74, 0x6e, 0x20, 0x74, 0x75, 0x66, 0x61, 0x74, 0x70, 0x61, 0x6d, 0x69, 0x6c, 0x61,
0x75, 0x75, 0x74, 0x75, 0x6b, 0x6f, 0x4b, 0x49, 0x13cc, 0x13be, 0x13b4, 0x4d, 0x75, 0x68, 0x69, 0x54, 0x4f, 0x4f, 0x75, 0x6c,
0x75, 0x63, 0x68, 0x65, 0x6c, 0x6f, 0x52, 0x168, 0x6b, 0x61, 0x72, 0x6f, 0x6f, 0x6e, 0x1c1, 0x67, 0x6f, 0x61, 0x67, 0x61,
0x73, 0x55, 0x68, 0x72, 0x20, 0x76, 0xf6, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x190, 0x6e, 0x6b,
0x61, 0x6b, 0x25b, 0x6e, 0x79, 0xe1, 0x4d, 0x75, 0x6e, 0x6b, 0x79, 0x6f, 0x69, 0x63, 0x68, 0x65, 0x68, 0x65, 0x61, 0x76,
0x6f, 0x54, 0x61, 0x70, 0x61, 0x72, 0x61, 0x63, 0x68, 0x75, 0x41, 0x64, 0x64, 0x75, 0x68, 0x61, 0x4f, 0x44, 0x5a, 0x64,
0x61, 0x74, 0x20, 0x61, 0x7a, 0x61, 0x6c, 0x6d, 0x61, 0x6b, 0x65, 0x6f, 0x92b, 0x941, 0x902, 0x44, 0x69, 0x6e, 0x64, 0x61,
0x6d, 0x6f, 0x69, 0x65, 0x73, 0x61, 0x2e, 0x67, 0x49, 0x20, 0x62, 0x69, 0x6b, 0x25b, 0x302, 0x67, 0x6c, 0xe0, 0x53, 0x75,
0x62, 0x62, 0x61, 0x61, 0x68, 0x69, 0x69, 0x64, 0x69, 0x253, 0x61, 0x6b, 0xed, 0x6b, 0xed, 0x72, 0xed, 0x67, 0x73, 0xe1,
0x72, 0xfa, 0x77, 0xe1, 0x77, 0x69, 0x63, 0x68, 0x69, 0x73, 0x68, 0x75, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6d, 0x61, 0x6e,
0xe1, 0x52, 0x57, 0x42d, 0x418, 0x4c, 0x77, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x77, 0x75, 0x6b, 0x69, 0x25b, 0x6d, 0x25b, 0x301,
0x25b, 0x6d, 0x6d, 0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0x2bc, 0xe1, 0x6d, 0x62, 0x61, 0x2bc, 0x64,
0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61
};

static const ushort pm_data[] = {
0x50, 0x4d, 0x57, 0x42, 0x6e, 0x6d, 0x2e, 0x70, 0x61, 0x73, 0x64, 0x69, 0x74, 0x65, 0x12a8, 0x1230, 0x12d3, 0x1275, 0x645, 0x56f,
0x565, 0x57d, 0x585, 0x580, 0x56b, 0x581, 0x20, 0x570, 0x565, 0x57f, 0x578, 0x985, 0x9aa, 0x9f0, 0x9be, 0x9b9, 0x9cd, 0x9a3, 0x985, 0x9aa,
0x9b0, 0x9be, 0x9b9, 0x9cd, 0x9a3, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf46, 0xf0b, 0x47, 0x2e, 0x4d, 0x2e, 0x441, 0x43b, 0x2e, 0x43e, 0x431,
0x2e, 0x100a, 0x1014, 0x1031, 0x43f, 0x430, 0x441, 0x43b, 0x44f, 0x20, 0x43f, 0x430, 0x43b, 0x443, 0x434, 0x43d, 0x44f, 0x179b, 0x17d2, 0x1784,
0x17b6, 0x1785, 0x70, 0x2e, 0x20, 0x6d, 0x2e, 0x4e0b, 0x5348, 0x6f, 0x64, 0x70, 0x6f, 0x6c, 0x65, 0x64, 0x6e, 0x65, 0x70, 0x2e,
0x6d, 0x2e, 0x75, 0x6d, 0x20, 0x73, 0x65, 0x69, 0x6e, 0x6e, 0x61, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x69, 0x70, 0x2e,
0x66, 0x6e, 0x61, 0x63, 0x68, 0x6d, 0x2e, 0x3bc, 0x2e, 0x3bc, 0x2e, 0x5d0, 0x5d7, 0x5d4, 0x5f4, 0x5e6, 0x905, 0x92a, 0x930, 0x93e,
0x939, 0x94d, 0x928, 0x64, 0x75, 0x2e, 0x65, 0x2e, 0x68, 0x2e, 0x5348, 0x5f8c, 0xc85, 0xcaa, 0xcb0, 0xcbe, 0xcb9, 0xccd, 0xca8, 0x442,
0x4af, 0x441, 0x442, 0x435, 0x43d, 0x20, 0x43a, 0x435, 0x439, 0x456, 0x43d, 0x433, 0x456, 0x442, 0x4af, 0x448, 0x442, 0x4e9, 0x43d, 0x20,
0x43a, 0x438, 0x439, 0x438, 0x43d, 0xc624, 0xd6c4, 0x5a, 0x2e, 0x4d, 0x57, 0x2e, 0xeab, 0xebc, 0xeb1, 0xe87, 0xe97, 0xec8, 0xebd, 0xe87,
0x70, 0x113, 0x63, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6d, 0x70, 0xf3, 0x6b, 0x77, 0x61, 0x70, 0x6f, 0x70,
0x69, 0x65, 0x74, 0x43f, 0x43e, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x54, 0x47, 0x92e, 0x2e, 0x909, 0x2e, 0x4ae, 0x425,
0x70, 0x6d, 0x63a, 0x2e, 0x648, 0x2e, 0x628, 0x639, 0x62f, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64, 0x61, 0x20, 0x74, 0x61, 0x72,
0x64, 0x65, 0xa2c, 0xa3e, 0x2e, 0xa26, 0xa41, 0x2e, 0x73, 0x6d, 0x4c, 0x4b, 0x43f, 0x43e, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435,
0x70, 0x6f, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x444, 0x4d5,
0x441, 0x442, 0x4d5, 0xdb4, 0x2e, 0xdc0, 0x2e, 0x6f, 0x64, 0x70, 0x6f, 0x6c, 0x75, 0x64, 0x6e, 0x69, 0x61, 0x70, 0x6f, 0x70,
0x2e, 0x67, 0x6e, 0x2e, 0x79, 0x61, 0x20, 0x6d, 0x75, 0x63, 0x68, 0x61, 0x6e, 0x61, 0x65, 0x6d, 0xbaa, 0xbbf, 0xbb1, 0xbcd,
0xbaa, 0xb95, 0xbb2, 0xbcd, 0x5b, 0x50, 0x4d, 0x5d, 0xe2b, 0xe25, 0xe31, 0xe07, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf55, 0xfb1,
0xf72, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x12f5, 0x1215, 0x122d, 0x20, 0x1230, 0x12d3, 0x1275, 0xd6, 0x53, 0x686, 0x6c8, 0x634, 0x62a, 0x649,
0x646, 0x20, 0x643, 0x6d0, 0x64a, 0x649, 0x646, 0x43f, 0x43f, 0x628, 0x639, 0x62f, 0x20, 0x62f, 0x648, 0x67e, 0x6c1, 0x631, 0x54, 0x4b,
0x43, 0x48, 0x1ecc, 0x300, 0x73, 0xe1, 0x6e, 0x186, 0x300, 0x73, 0xe1, 0x6e, 0x4e, 0x74, 0x61, 0x6d, 0x62, 0x61, 0x6d, 0x61,
0x65, 0x74, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67, 0x70, 0x6f, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x43f, 0x43e,
0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x45, 0x57, 0x92e, 0x2e, 0x928, 0x902, 0x2e, 0x50, 0x2e, 0x4d, 0x2e, 0x128, 0x79, 0x61, 0x77,
0x129, 0x6f, 0x6f, 0x70, 0x2e, 0x263, 0x65, 0x74, 0x72, 0x254, 0x6e, 0x61, 0x6d, 0x2e, 0xa06f, 0xa2d2, 0x65, 0x61, 0x68, 0x6b,
0x65, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x4d, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x2f, 0x4d, 0x6f, 0x67, 0x6c,
0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x70, 0x6b, 0x69, 0x6b, 0x69, 0x69, 0x257, 0x65, 0x48, 0x77, 0x61, 0x129,
0x2d, 0x69, 0x6e, 0x129, 0x54, 0x65, 0x69, 0x70, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6f, 0x74, 0x6f, 0x2d5c, 0x2d30, 0x2d37, 0x2d33,
0x2d33, 0x2d6f, 0x2d30, 0x2d5c, 0x74, 0x61, 0x64, 0x67, 0x67, 0x2b7, 0x61, 0x74, 0x6e, 0x20, 0x74, 0x6d, 0x65, 0x64, 0x64, 0x69,
0x74, 0x70, 0x61, 0x6d, 0x75, 0x6e, 0x79, 0x69, 0x6b, 0x79, 0x69, 0x75, 0x6b, 0x6f, 0x6e, 0x79, 0x69, 0x55, 0x54, 0x13d2,
0x13af, 0x13f1, 0x13a2, 0x13d7, 0x13e2, 0x43, 0x68, 0x69, 0x6c, 0x6f, 0x4d, 0x55, 0x55, 0x61, 0x6b, 0x61, 0x73, 0x75, 0x62, 0x61,
0x168, 0x47, 0x6b, 0x6f, 0x6f, 0x73, 0x6b, 0x6f, 0x6c, 0x69, 0x6e, 0x79, 0x1c3, 0x75, 0x69, 0x61, 0x73, 0x55, 0x68, 0x72,
0x20, 0x6e, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x190, 0x6e, 0x64, 0xe1, 0x6d, 0xe2, 0x45,
0x69, 0x67, 0x75, 0x6c, 0x6f, 0x69, 0x63, 0x68, 0x61, 0x6d, 0x74, 0x68, 0x69, 0x45, 0x62, 0x6f, 0x6e, 0x67, 0x69, 0x41,
0x6c, 0x75, 0x75, 0x6c, 0x61, 0x4f, 0x54, 0x1e0c, 0x65, 0x66, 0x66, 0x69, 0x72, 0x20, 0x61, 0x7a, 0x61, 0x6e, 0x79, 0x69,
0x61, 0x67, 0x68, 0x75, 0x6f, 0x92c, 0x947, 0x932, 0x93e, 0x938, 0x947, 0x44, 0x69, 0x6c, 0x6f, 0x6c, 0x6f, 0x6e, 0x6f, 0x6d,
0xeb, 0x74, 0x74, 0x65, 0x73, 0x61, 0x2e, 0x6b, 0x49, 0x20, 0x253, 0x75, 0x67, 0x61, 0x6a, 0x254, 0x70, 0x5a, 0x61, 0x61,
0x72, 0x69, 0x6b, 0x61, 0x79, 0x20, 0x62, 0x65, 0x62, 0x79, 0xe1, 0x6d, 0x75, 0x6e, 0x67, 0x259, 0x67, 0xf3, 0x67, 0x259,
0x6c, 0x65, 0x63, 0x25b, 0x25b, 0x301, 0x6e, 0x6b, 0x6f, 0x6d, 0x63, 0x68, 0x6f, 0x63, 0x68, 0x69, 0x6c, 0x2019, 0x6c, 0x6c,
0x69, 0x6c, 0x6c, 0x69, 0x6b, 0x75, 0x67, 0xfa, 0x54, 0x14a, 0x42d, 0x41a, 0x50, 0x61, 0x73, 0x68, 0x61, 0x6d, 0x69, 0x68,
0x65, 0x6b, 0x69, 0x73, 0x25b, 0x301, 0x6e, 0x64, 0x25b, 0x14b, 0x6b, 0x61, 0x20, 0x6d, 0x62, 0x254, 0x301, 0x74, 0x20, 0x6e,
0x6a, 0x69, 0x6e, 0x63, 0x77, 0xf2, 0x6e, 0x7a, 0xe9, 0x6d, 0x77, 0xf3, 0x74, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61,
0x70, 0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x75
};

static const ushort currency_symbol_data[] = {
0x42, 0x72, 0x4b, 0x73, 0x68, 0x52, 0x24, 0x4c, 0x65, 0x6b, 0xeb, 0x64, 0x65, 0x6e, 0x20ac, 0x1265, 0x122d, 0x62c, 0x2e, 0x645,
0x2e, 0x200f, 0x62f, 0x2e, 0x62c, 0x2e, 0x200f, 0x62f, 0x2e, 0x628, 0x2e, 0x200f, 0x46, 0x43, 0x46, 0x41, 0x641, 0x2e, 0x62c, 0x2e,
0x642, 0x2e, 0x200f, 0x46, 0x64, 0x6a, 0x4e, 0x66, 0x6b, 0x62f, 0x2e, 0x639, 0x2e, 0x200f, 0x20aa, 0x62f, 0x2e, 0x623, 0x2e, 0x200f,
0x62f, 0x2e, 0x643, 0x2e, 0x200f, 0x644, 0x2e, 0x644, 0x2e, 0x200f, 0x62f, 0x2e, 0x644, 0x2e, 0x200f, 0x623, 0x2e, 0x645, 0x2e, 0x200f,
0x62f, 0x2e, 0x645, 0x2e, 0x200f, 0x631, 0x2e, 0x639, 0x2e, 0x200f, 0x631, 0x2e, 0x642, 0x2e, 0x200f, 0x631, 0x2e, 0x633, 0x2e, 0x200f,
0x53, 0x62c, 0x2e, 0x633, 0x2e, 0x644, 0x2e, 0x633, 0x2e, 0x200f, 0x62f, 0x2e, 0x62a, 0x2e, 0x200f, 0x62f, 0x2e, 0x625, 0x2e, 0x200f,
0x631, 0x2e, 0x64a, 0x2e, 0x200f, 0xa3, 0x58f, 0x20b9, 0x41, 0x5a, 0x4e, 0x43c, 0x430, 0x43d, 0x2e, 0x20bd, 0x9f3, 0x4e, 0x75, 0x2e,
0x43b, 0x432, 0x2e, 0x4b, 0x440, 0x2e, 0x17db, 0xffe5, 0x48, 0x4b, 0x24, 0x4d, 0x4f, 0x50, 0x24, 0x4e, 0x54, 0x24, 0x48, 0x52,
0x4b, 0x4b, 0x4d, 0x4b, 0x10d, 0x6b, 0x72, 0x2e, 0x41, 0x66, 0x6c, 0x2e, 0x4e, 0x41, 0x66, 0x2e, 0x55, 0x53, 0x24, 0x50,
0x44, 0x47, 0x48, 0x20b5, 0x41, 0x72, 0x4d, 0x4b, 0x52, 0x4d, 0x52, 0x73, 0x20a6, 0x20b1, 0x52, 0x46, 0x57, 0x53, 0x24, 0x53,
0x52, 0x4c, 0x65, 0x45, 0x54, 0x53, 0x68, 0x54, 0x24, 0x55, 0x53, 0x68, 0x56, 0x54, 0x6b, 0x72, 0x44, 0x41, 0x43, 0x46,
0x41, 0x46, 0x42, 0x75, 0x43, 0x46, 0x46, 0x43, 0x46, 0x43, 0x46, 0x50, 0x46, 0x47, 0x47, 0x55, 0x4d, 0x4d, 0x41, 0x44,
0x43, 0x48, 0x46, 0x4c, 0x53, 0x44, 0x54, 0x47, 0x45, 0x4c, 0x20b2, 0x48, 0x55, 0x46, 0x49, 0x53, 0x4b, 0x52, 0x70, 0x43,
0x41, 0x24, 0x20b8, 0x441, 0x43e, 0x43c, 0x20a9, 0x4b, 0x50, 0x57, 0x20ba, 0x20ad, 0x4b, 0x7a, 0x434, 0x435, 0x43d, 0x4e, 0x5a, 0x24,
0x20ae, 0x43, 0x4e, 0xa5, 0x928, 0x947, 0x930, 0x942, 0x60b, 0x631, 0x6cc, 0x627, 0x644, 0x7a, 0x142, 0x52, 0x24, 0x200b, 0x4d, 0x54,
0x6e, 0x44, 0x62, 0x631, 0x53, 0x2f, 0x2e, 0x42, 0x73, 0x52, 0x4f, 0x4e, 0x4c, 0x440, 0x443, 0x431, 0x2e, 0x20b4, 0x52, 0x53,
0x44, 0x41a, 0x41c, 0xdbb, 0xdd4, 0x2e, 0x20a1, 0x51, 0x43, 0x24, 0x42, 0x2f, 0x2e, 0x42, 0x73, 0x2e, 0x52, 0x73, 0x2e, 0x54,
0x48, 0x42, 0xa5, 0x73, 0x6f, 0x2bb, 0x6d, 0x441, 0x45e, 0x43c, 0x20ab, 0x41, 0x24
};

static const ushort currency_display_name_data[] = {
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x20, 0x42, 0x69,
0x72, 0x72, 0x69, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69,
0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x4c, 0x65, 0x6b, 0x75, 0x20, 0x73, 0x68,
0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72,
0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0xeb, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x44, 0x65,
0x6e, 0x61, 0x72, 0x69, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61,
0x72, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61, 0x72,
0xeb, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x6a, 0x61, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20,
0x1265, 0x122d, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275,
0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626,
0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628,
0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x641,
0x631, 0x646, 0x643, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x623, 0x641, 0x631, 0x64a,
0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20,
0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641,
0x631, 0x646, 0x643, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x623, 0x641, 0x631, 0x64a,
0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632,
0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642,
0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632,
0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b,
0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628,
0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643,
0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b,
0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631,
0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627,
0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a,
0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643,
0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a,
0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f,
0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627,
0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a,
0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20,
0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c,
0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f,
0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a,
0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f,
0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631,
0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631,
0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648,
0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b,
0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646,
0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629,
0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b,
0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a,
0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a,
0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629,
0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642,
0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645,
0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a,
0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629,
0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631,
0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645,
0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645,
0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645,
0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f,
0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645,
0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635,
0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646,
0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x62c,
0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627,
0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20,
0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c,
0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627,
0x646, 0x64a, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633,
0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629,
0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a,
0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648,
0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x631, 0x647,
0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627,
0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645,
0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a,
0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20,
0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647,
0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c,
0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648,
0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644,
0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648,
0x62f, 0x627, 0x646, 0x3b, 0x540, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x3b, 0x540,
0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x3b, 0x3b, 0x3b, 0x540, 0x561, 0x575, 0x56f,
0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e,
0x20, 0x4d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x20,
0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e,
0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x43c, 0x430, 0x43d, 0x430, 0x442, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x45, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2,
0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6,
0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa,
0x9bf, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ad,
0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0xf51, 0xf44, 0xf74, 0xf63, 0xf0b, 0xf40, 0xfb2, 0xf58,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x61, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x69, 0x6f, 0xf9, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x431, 0x44a,
0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433, 0x430,
0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x430, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x1000, 0x103b, 0x1015, 0x103a,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x1000, 0x103b, 0x1015, 0x103a, 0x3b, 0x431, 0x435, 0x43b,
0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x179a, 0x17c0, 0x179b,
0x200b, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x4eba, 0x6c11, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4eba, 0x6c11,
0x5e01, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x6fb3, 0x95e8, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x6fb3, 0x95e8, 0x5143, 0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143,
0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x65b0, 0x81fa, 0x5e63, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x65b0, 0x81fa, 0x5e63, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61,
0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x68, 0x72, 0x76,
0x61, 0x74, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x75, 0x6e, 0x65, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69,
0x68, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61,
0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e,
0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c,
0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69,
0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f,
0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b,
0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b,
0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xfd, 0x63, 0x68, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x3b,
0x44, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65,
0x72, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x41,
0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x41,
0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x4e, 0x65, 0x64, 0x65,
0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20,
0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41,
0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b,
0x3b, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69,
0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61,
0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d,
0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61,
0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e,
0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e,
0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61,
0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x55, 0x53, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61,
0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62,
0x62, 0x65, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20,
0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x75,
0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x41, 0x75, 0x73,
0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x75,
0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x61, 0x68,
0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20,
0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x65,
0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61,
0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x50, 0x75, 0x6c, 0x61,
0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x73, 0x3b, 0x43, 0x65, 0x6e, 0x74,
0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72, 0x61, 0x6e,
0x63, 0x3b, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43,
0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20,
0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x43,
0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61,
0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64,
0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b,
0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x73, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x6b, 0x66, 0x61, 0x3b,
0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x6b, 0x66, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x45,
0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c,
0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x46,
0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e,
0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b,
0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x72, 0x69, 0x74,
0x69, 0x73, 0x68, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70,
0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e,
0x64, 0x73, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x47,
0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x61, 0x6d,
0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x73, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61,
0x6e, 0x20, 0x43, 0x65, 0x64, 0x69, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64,
0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64, 0x69, 0x73, 0x3b,
0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x47, 0x69, 0x62,
0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72,
0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65,
0x73, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x44,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x73, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x49,
0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61,
0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x44, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x73, 0x3b, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x65,
0x6e, 0x79, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68,
0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68,
0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75,
0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4c, 0x69, 0x62, 0x65,
0x72, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x61,
0x74, 0x61, 0x63, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61,
0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x41, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x4d,
0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61,
0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x69, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61,
0x77, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61,
0x6e, 0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e,
0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x52,
0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69,
0x6e, 0x67, 0x67, 0x69, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72,
0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x73, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75,
0x70, 0x65, 0x65, 0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65,
0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73,
0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d,
0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69,
0x61, 0x6e, 0x20, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e,
0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69,
0x72, 0x61, 0x73, 0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b,
0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x50, 0x61, 0x70,
0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x4b, 0x69, 0x6e, 0x61, 0x3b,
0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6b,
0x69, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69,
0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65,
0x20, 0x50, 0x65, 0x73, 0x6f, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x65,
0x73, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x65, 0x73,
0x6f, 0x73, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x52, 0x77,
0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64,
0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x54, 0x61, 0x6c,
0x61, 0x3b, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x61,
0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69,
0x73, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73,
0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69,
0x73, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e,
0x65, 0x61, 0x6e, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65,
0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72,
0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x6e,
0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61,
0x70, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61,
0x70, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e,
0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x6f, 0x6c,
0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x50, 0x6f,
0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x70, 0x6f, 0x75, 0x6e,
0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x70, 0x6f, 0x75, 0x6e,
0x64, 0x73, 0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53,
0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x64,
0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x4c,
0x69, 0x6c, 0x61, 0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x6c, 0x69, 0x6c, 0x61,
0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x65, 0x6d, 0x61, 0x6c, 0x61,
0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c,
0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c,
0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x73, 0x68,
0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x50, 0x61, 0x2bb, 0x61, 0x6e,
0x67, 0x61, 0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x54, 0x72, 0x69,
0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20,
0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x55, 0x67, 0x61,
0x6e, 0x64, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x55, 0x67, 0x61, 0x6e, 0x64,
0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x67, 0x61, 0x6e, 0x64,
0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75,
0x20, 0x56, 0x61, 0x74, 0x75, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x3b,
0x3b, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x73, 0x3b, 0x5a, 0x61, 0x6d,
0x62, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e,
0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x6b,
0x77, 0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73,
0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e,
0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53,
0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65,
0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x47, 0x75, 0x69,
0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e,
0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e,
0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e,
0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x74, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e,
0x61, 0x3b, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f,
0x6e, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x61, 0x6c,
0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69,
0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65,
0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29,
0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b,
0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f,
0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x73, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43,
0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20,
0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61,
0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64,
0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64,
0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63,
0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63,
0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f,
0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74,
0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75,
0x74, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x50,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20,
0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x73, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61, 0xef, 0x74,
0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61, 0xef, 0x74, 0x69, 0x65,
0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x73, 0x20, 0x68, 0x61, 0xef, 0x74, 0x69,
0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68,
0x65, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x3b, 0x3b,
0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x73, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x73, 0x3b,
0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x3b,
0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e,
0x3b, 0x3b, 0x3b, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x73, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61,
0x6e, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69,
0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69,
0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73, 0x20, 0x6d, 0x61, 0x75, 0x72,
0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61, 0x72, 0x6f,
0x63, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63, 0x61, 0x69,
0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x73, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63, 0x61, 0x69,
0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x73, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20,
0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70,
0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x3b, 0x3b,
0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c,
0x6c, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73,
0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x73, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65,
0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b,
0x3b, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x73, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b,
0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61,
0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x73,
0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e, 0x75,
0x61, 0x74, 0x75, 0x61, 0x6e, 0x3b, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61,
0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x73, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e,
0x73, 0x3b, 0x50, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70,
0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x70, 0x68, 0x75, 0x6e,
0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x70, 0x75, 0x69, 0x6e, 0x6e, 0x64, 0x20,
0x53, 0x68, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61,
0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8,
0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x3b, 0x3b, 0x3b, 0x10e5, 0x10d0,
0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x45, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20,
0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46,
0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20,
0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x395, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20, 0x6b,
0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x6e, 0x75, 0x74, 0x20, 0x6b, 0x6f,
0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74,
0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf,
0xaaf, 0xabe, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x3b, 0x3b,
0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20, 0x53, 0x65, 0x66, 0x61, 0x20, 0x6e, 0x61,
0x20, 0x41, 0x66, 0x69, 0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x5e9, 0x5f4, 0x5d7, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b,
0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7,
0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x92d, 0x93e, 0x930,
0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941,
0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x90f, 0x3b, 0x6d,
0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72,
0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f,
0x72, 0x69, 0x6e, 0x74, 0x3b, 0xcd, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b,
0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0xed, 0x73, 0x6c,
0x65, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68,
0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x75, 0x70, 0x69,
0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x68, 0x69, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x69, 0x3b, 0x65e5, 0x672c, 0x5186, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5186, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc1, 0xcaa, 0xcbe, 0xcaf, 0xcbf,
0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc1, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x3b, 0x3b, 0x3b, 0xcad,
0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc1, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x6c1, 0x650, 0x646, 0x62f, 0x64f, 0x633, 0x62a,
0x672, 0x646, 0x6cd, 0x20, 0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430,
0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b,
0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430,
0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437,
0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430,
0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d,
0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xb300, 0xd55c,
0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20,
0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654,
0xad6d, 0x20, 0xc6d0, 0x3b, 0x49, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x72, 0x79, 0x2019, 0x55, 0x62, 0x75, 0x72,
0x75, 0x6e, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x65, 0x69, 0x72,
0x6f, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e,
0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x77,
0x61, 0x6e, 0x7a, 0x61, 0x20, 0x79, 0x61, 0x20, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x61, 0x73, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x73, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x61, 0x69, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x173, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e,
0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441,
0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441,
0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x41, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61,
0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44,
0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69,
0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53,
0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a,
0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d,
0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x92d, 0x93e, 0x930, 0x924,
0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a,
0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x947, 0x3b, 0x442,
0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x3b, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x3b, 0x3b, 0x3b, 0x442, 0x4e9, 0x433,
0x440, 0x4e9, 0x433, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x3b,
0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x3b, 0x3b, 0x3b, 0x928, 0x947,
0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f,
0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f,
0x93e, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x3b, 0x6e, 0x6f, 0x72,
0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0xb1f, 0xb19, 0xb15, 0xb3e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a,
0x627, 0x646, 0x6cd, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646,
0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644,
0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633,
0x62a, 0x627, 0x646, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627,
0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627,
0x646, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74,
0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x73,
0x6b, 0x69, 0x65, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x63, 0x68, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x63, 0x68,
0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x67, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x67, 0x6f, 0x3b, 0x52,
0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x6c,
0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x69, 0x73,
0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x73, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20,
0x61, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e, 0x67,
0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x67,
0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x45, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76,
0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x45, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f,
0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x73,
0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x44, 0xf3, 0x6c, 0x61,
0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73,
0x3b, 0x3b, 0x44, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20,
0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x64, 0x6f,
0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x46, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x46, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x46,
0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x50,
0x61, 0x74, 0x61, 0x63, 0x61, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x3b, 0x3b, 0x50, 0x61, 0x74, 0x61,
0x63, 0x61, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x74, 0x61, 0x63,
0x61, 0x73, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20,
0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63,
0x61, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69,
0x71, 0x75, 0x65, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75,
0x72, 0x6f, 0x73, 0x3b, 0x44, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d,
0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x3b, 0x44, 0x6f, 0x62, 0x72, 0x61, 0x20,
0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69,
0x70, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x62, 0x72, 0x61, 0x73, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20,
0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24,
0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x3b, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06,
0x3b, 0x3b, 0x3b, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa0f, 0x3b, 0x631, 0x648, 0x67e, 0x626, 0x6cc,
0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65,
0x72, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f,
0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63,
0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b, 0x6c, 0x65, 0x69,
0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f,
0x76, 0x65, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e,
0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74,
0x69, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b,
0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e,
0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441,
0x438, 0x439, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441,
0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x43e,
0x433, 0x43e, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x411, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439,
0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20,
0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440,
0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431,
0x43b, 0x435, 0x439, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x440, 0x443, 0x431,
0x43b, 0x44f, 0x3b, 0x41a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b,
0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437,
0x430, 0x445, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a,
0x438, 0x445, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x41a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c,
0x3b, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a, 0x438,
0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437,
0x441, 0x43a, 0x438, 0x445, 0x20, 0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x43e, 0x433,
0x43e, 0x20, 0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x41c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435,
0x439, 0x3b, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b, 0x3b, 0x43c,
0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x43b, 0x435, 0x44f, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432,
0x441, 0x43a, 0x438, 0x445, 0x20, 0x43b, 0x435, 0x435, 0x432, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x43e, 0x433,
0x43e, 0x20, 0x43b, 0x435, 0x44f, 0x3b, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438,
0x432, 0x43d, 0x430, 0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432,
0x43d, 0x430, 0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x438, 0x435, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d,
0x44b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x3b,
0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x43e, 0x439, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b, 0x66, 0x61,
0x72, 0xe2, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x421, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f,
0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x430, 0x20, 0x434, 0x438,
0x43d, 0x430, 0x440, 0x430, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x430,
0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d,
0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72,
0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f,
0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20,
0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63,
0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c,
0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68,
0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74,
0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x45, 0x76, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x53, 0x72,
0x70, 0x73, 0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x20, 0x64,
0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x61, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61, 0x3b,
0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x68, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61, 0x3b, 0x411, 0x43e, 0x441, 0x430,
0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e,
0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431,
0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430,
0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430,
0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430,
0x447, 0x43a, 0x435, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435, 0x20, 0x43c, 0x430,
0x440, 0x43a, 0x65, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433,
0x43e, 0x432, 0x430, 0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d,
0x438, 0x445, 0x20, 0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x415, 0x432, 0x440, 0x43e, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x43e,
0x3b, 0x3b, 0x435, 0x432, 0x440, 0x430, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x430, 0x3b, 0x41b, 0x430, 0x440, 0x3b, 0x3b, 0x43b, 0x430,
0x440, 0x3b, 0x3b, 0x3b, 0x3b, 0x43b, 0x430, 0x440, 0x44b, 0x3b, 0x421, 0x43e, 0x43c, 0x3b, 0x3b, 0x441, 0x43e, 0x43c, 0x3b, 0x3b,
0x3b, 0x3b, 0x441, 0x43e, 0x43c, 0x44b, 0x3b, 0x44, 0x6f, 0x72, 0x61, 0x20, 0x72, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69,
0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20,
0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20, 0xdbb,
0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b, 0x3b, 0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20,
0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0xe1, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x65, 0x75, 0x72, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x76, 0x72, 0x6f, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x65, 0x76, 0x72, 0x69, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x76,
0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x20, 0x4a, 0x61, 0x62, 0x62, 0x75, 0x75, 0x74, 0x69, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x69, 0x72, 0x74, 0x61, 0x20, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x62, 0x69, 0x79, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f,
0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x73, 0x3b, 0x62, 0x6f, 0x6c,
0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x68, 0x69,
0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73,
0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63,
0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63,
0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63, 0x6f, 0x6c, 0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73,
0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x63, 0x6f, 0x6c, 0xf3, 0x6e, 0x20, 0x63, 0x6f,
0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x63, 0x6f, 0x6c, 0x6f, 0x6e,
0x65, 0x73, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x70, 0x65,
0x73, 0x6f, 0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x75, 0x62, 0x61,
0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x73, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73,
0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f,
0x73, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20,
0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61,
0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e,
0x73, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x71, 0x75, 0x65,
0x74, 0x7a, 0x61, 0x6c, 0x20, 0x67, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x74, 0x65, 0x63, 0x6f, 0x3b, 0x3b, 0x71,
0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x20, 0x67, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x74, 0x65, 0x63, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x67, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61,
0x6c, 0x74, 0x65, 0x63, 0x6f, 0x73, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f, 0x6e, 0x64, 0x75,
0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72,
0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x73, 0x20, 0x68, 0x6f, 0x6e, 0x64,
0x75, 0x72, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f,
0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70,
0x65, 0x73, 0x6f, 0x73, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f,
0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x63, 0xf3, 0x72,
0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x73, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e,
0x73, 0x65, 0x73, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x3b,
0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x73, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x67, 0x75,
0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x67, 0x75, 0x61,
0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x75,
0x61, 0x72, 0x61, 0x6e, 0xed, 0x65, 0x73, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x73, 0x3b, 0x6e,
0x75, 0x65, 0x76, 0x6f, 0x20, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x6e, 0x75,
0x65, 0x76, 0x6f, 0x20, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e,
0x75, 0x65, 0x76, 0x6f, 0x73, 0x20, 0x73, 0x6f, 0x6c, 0x65, 0x73, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x73,
0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f,
0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x66,
0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61,
0x79, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x73, 0x3b, 0x62, 0x6f, 0x6c,
0xed, 0x76, 0x61, 0x72, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x62, 0x6f, 0x6c,
0xed, 0x76, 0x61, 0x72, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x62,
0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x65, 0x73, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x73,
0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69,
0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61,
0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x7a, 0x61, 0x20, 0x54,
0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b,
0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e,
0x67, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x7a, 0x61, 0x20, 0x4b, 0x6f, 0x6e,
0x67, 0x6f, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x7a, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b,
0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x7a, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64,
0x61, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x73, 0x76, 0x65, 0x6e,
0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x20,
0x6b, 0x72, 0x6f, 0x6e, 0x6f, 0x72, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd,
0x3b, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xb87,
0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xbae, 0xbb2, 0xbc7, 0xbb7,
0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xba4, 0xbcd, 0x3b, 0x3b, 0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf,
0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xba4, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xbae, 0xbb2, 0xbc7, 0xbb7,
0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xba4, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbbf, 0xb99,
0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0x3b, 0x3b, 0xb9a, 0xbbf, 0xb99, 0xbcd,
0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xb9a, 0xbbf, 0xb99,
0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb87, 0xbb2,
0xb99, 0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x20,
0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa,
0xbbe, 0xbaf, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc3f, 0x3b, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f,
0xc3f, 0x3b, 0x3b, 0x3b, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc32, 0xc41, 0x3b, 0xe1a, 0xe32, 0xe17, 0xe44, 0xe17, 0xe22, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xe1a, 0xe32, 0xe17, 0xe44, 0xe17, 0xe22, 0x3b, 0xf61, 0xf74, 0xf0b, 0xf68, 0xf53, 0xf0b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0xf66, 0xf92, 0xf7c, 0xf62, 0xf0b, 0xf58, 0xf7c, 0xf0b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e, 0x67, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f,
0x6e, 0x67, 0x61, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x4c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x54, 0xfc, 0x72,
0x6b, 0x20, 0x6c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x6c, 0x69, 0x72,
0x61, 0x73, 0x131, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b, 0x3b, 0x62c, 0x6c7, 0x6ad,
0x6af, 0x648, 0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b, 0x3b, 0x3b, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8,
0x6d5, 0x646, 0x649, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d,
0x44f, 0x3b, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f, 0x3b, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x456, 0x3b, 0x433, 0x440,
0x438, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x456, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646,
0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648,
0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc,
0x6c1, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x628, 0x6be, 0x627, 0x631,
0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631,
0x648, 0x67e, 0x6d2, 0x3b, 0x4f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2bb, 0x6d,
0x3b, 0x3b, 0x4f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2bb, 0x6d, 0x3b, 0x3b,
0x3b, 0x3b, 0x4f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2bb, 0x6d, 0x3b, 0x627,
0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442,
0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441,
0x45e, 0x43c, 0x3b, 0x3b, 0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c,
0x3b, 0x110, 0x1ed3, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x111, 0x1ed3, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50,
0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b,
0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72,
0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x50,
0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79,
0x64, 0x61, 0x69, 0x6e, 0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x20, 0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x1eb9, 0x301,
0xe8, 0x64, 0x65, 0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46,
0x61, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x20, 0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x25b, 0x301, 0xe8, 0x64, 0x65, 0x20,
0x42, 0x49, 0x4b, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68,
0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75,
0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x69,
0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b,
0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65,
0x72, 0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x48, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61,
0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61,
0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67,
0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61,
0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72,
0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69,
0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d,
0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72,
0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x41a, 0x43e, 0x43d, 0x432,
0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441,
0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a,
0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b,
0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a,
0x435, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435, 0x20, 0x43c, 0x430, 0x440, 0x43a,
0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430,
0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445, 0x20,
0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x53, 0x69, 0x64, 0x69, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x1ecb, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x67,
0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256,
0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x263, 0x65, 0x74, 0x6f,
0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20,
0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42,
0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72,
0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41,
0x4f, 0x3b, 0x50, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b,
0x3b, 0x70, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x3b,
0x3b, 0x3b, 0x70, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b,
0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x3b, 0x53, 0x63,
0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63,
0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67,
0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72,
0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f,
0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x72, 0x75, 0x6f,
0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b,
0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76,
0x64, 0x6e, 0x6f, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x75, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61,
0x61, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x69,
0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55,
0x67, 0x69, 0x79, 0x79, 0x61, 0x20, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x43, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x6a, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x65, 0x6c, 0x20, 0x4b, 0x65, 0x6e,
0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x64, 0x65, 0x20,
0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c,
0x61, 0x20, 0x79, 0x61, 0x73, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x68, 0x65, 0x6c, 0x65, 0x72, 0x69, 0x20, 0x73, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x2d30, 0x2d37, 0x2d54, 0x2d49, 0x2d4e, 0x20, 0x2d4f, 0x20, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x64, 0x72, 0x69, 0x6d, 0x20, 0x6e, 0x20, 0x6c, 0x6d, 0x263, 0x72, 0x69,
0x62, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x41, 0x7a, 0x7a, 0x61, 0x79,
0x72, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x73, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79,
0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a,
0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x66, 0x61, 0x20, 0x46, 0x72, 0x61, 0x14b,
0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x13a4, 0x13c3, 0x13cd, 0x13d7, 0x3b,
0x3b, 0x13a4, 0x13c3, 0x13cd, 0x13d7, 0x3b, 0x3b, 0x3b, 0x3b, 0x13e7, 0x13c3, 0x13cd, 0x13d7, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x20,
0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0xed,
0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x79, 0x61, 0x20, 0x59, 0x75, 0x67, 0x61,
0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62, 0x75,
0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20,
0x4b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x74, 0x61, 0x62, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e,
0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61,
0x6e, 0xed, 0x20, 0x65, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f,
0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x72, 0x69, 0x6e, 0x6a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20,
0x54, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6e, 0x67, 0x6f,
0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x2019, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x2019, 0x20, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72, 0x61, 0x14b, 0x20,
0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67,
0x20, 0x6d, 0x61, 0x72, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x65, 0x72,
0x68, 0x65, 0x6d, 0x20, 0x55, 0x6d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73,
0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x930, 0x93e, 0x902, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x66, 0x61, 0x6c,
0x61, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x43, 0x46, 0x41, 0x20, 0x46, 0xe0, 0x6c, 0xe2, 0x14b, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x46, 0x72, 0x1ce, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x65, 0x66, 0x61, 0x20, 0x79, 0x61, 0x74, 0x69, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x259, 0x6c, 0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41,
0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0xe1, 0x14b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x73, 0x6f, 0x6c, 0x61, 0x69, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61,
0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x68, 0x65,
0x6c, 0x61, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x20, 0xa55c, 0xa55e, 0xa54c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x61, 0x69,
0x62, 0x68, 0x69, 0x79, 0x61, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x25b, 0x6c,
0xe2, 0x14b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x72, 0xe8, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x65, 0x6c,
0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x6a, 0x3b, 0x65, 0x75, 0x72,
0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x77, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,

};

static const ushort currency_format_data[] = {
0x25, 0x31, 0x25, 0x32, 0x25, 0x32, 0x25, 0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x25, 0x32,
0xa0, 0x2d, 0x25, 0x31, 0x25, 0x32, 0x2212, 0x25, 0x31, 0x25, 0x32, 0x2d, 0x25, 0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x2d,
0x200e, 0x25, 0x32, 0x25, 0x31, 0x25, 0x32, 0x2d, 0xa0, 0x25, 0x31
};
static const ushort endonyms_data[] = {
0x4f, 0x72, 0x6f, 0x6d, 0x6f, 0x6f, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x4b, 0x65, 0x65, 0x6e,
0x69, 0x79, 0x61, 0x61, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0xeb, 0x73, 0x68, 0x71, 0x69, 0x70, 0x53, 0x68, 0x71, 0x69,
0x70, 0xeb, 0x72, 0x69, 0x4d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x69, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0xeb, 0x12a0, 0x121b,
0x122d, 0x129b, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x645, 0x635, 0x631, 0x627, 0x644, 0x62c,
0x632, 0x627, 0x626, 0x631, 0x627, 0x644, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x62a, 0x634, 0x627, 0x62f, 0x62c, 0x632, 0x631, 0x20, 0x627,
0x644, 0x642, 0x645, 0x631, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x627, 0x627, 0x644, 0x639,
0x631, 0x627, 0x642, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x627, 0x644, 0x623, 0x631, 0x62f, 0x646, 0x627, 0x644, 0x643, 0x648,
0x64a, 0x62a, 0x644, 0x628, 0x646, 0x627, 0x646, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a,
0x627, 0x627, 0x644, 0x645, 0x63a, 0x631, 0x628, 0x639, 0x64f, 0x645, 0x627, 0x646, 0x627, 0x644, 0x623, 0x631, 0x627, 0x636, 0x64a, 0x20,
0x627, 0x644, 0x641, 0x644, 0x633, 0x637, 0x64a, 0x646, 0x64a, 0x629, 0x642, 0x637, 0x631, 0x627, 0x644, 0x645, 0x645, 0x644, 0x643, 0x629,
0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x629, 0x627, 0x644, 0x635,
0x648, 0x645, 0x627, 0x644, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x633, 0x648, 0x631, 0x64a, 0x627, 0x62a, 0x648, 0x646, 0x633,
0x627, 0x644, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x645,
0x62a, 0x62d, 0x62f, 0x629, 0x627, 0x644, 0x635, 0x62d, 0x631, 0x627, 0x621, 0x20, 0x627, 0x644, 0x63a, 0x631, 0x628, 0x64a, 0x629, 0x627,
0x644, 0x64a, 0x645, 0x646, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x570, 0x561, 0x575, 0x565,
0x580, 0x565, 0x576, 0x540, 0x561, 0x575, 0x561, 0x57d, 0x57f, 0x561, 0x576, 0x985, 0x9b8, 0x9ae, 0x9c0, 0x9af, 0x9bc, 0x9be, 0x9ad, 0x9be,
0x9f0, 0x9a4, 0x61, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63,
0x61, 0x6e, 0x410, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d, 0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61, 0x45,
0x73, 0x70, 0x61, 0x69, 0x6e, 0x69, 0x61, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6,
0x9ad, 0x9be, 0x9b0, 0x9a4, 0xf62, 0xfab, 0xf7c, 0xf44, 0xf0b, 0xf41, 0xf60, 0xf56, 0xfb2, 0xf74, 0xf42, 0x62, 0x72, 0x65, 0x7a, 0x68,
0x6f, 0x6e, 0x65, 0x67, 0x46, 0x72, 0x61, 0xf1, 0x73, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x411, 0x44a,
0x43b, 0x433, 0x430, 0x440, 0x438, 0x44f, 0x1017, 0x1019, 0x102c, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x431, 0x435, 0x43b, 0x430, 0x440,
0x443, 0x441, 0x43a, 0x430, 0x44f, 0x411, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x44c, 0x1781, 0x17d2, 0x1798, 0x17c2, 0x179a, 0x1780, 0x1798,
0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x63, 0x61, 0x74, 0x61, 0x6c, 0xe0, 0x45, 0x73, 0x70, 0x61, 0x6e, 0x79, 0x61, 0x41, 0x6e,
0x64, 0x6f, 0x72, 0x72, 0x61, 0x46, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x49, 0x74, 0xe0, 0x6c, 0x69, 0x61, 0x7b80, 0x4f53, 0x4e2d,
0x6587, 0x4e2d, 0x56fd, 0x4e2d, 0x56fd, 0x9999, 0x6e2f, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x4e2d, 0x56fd, 0x6fb3, 0x95e8, 0x7279, 0x522b, 0x884c, 0x653f,
0x533a, 0x65b0, 0x52a0, 0x5761, 0x7e41, 0x9ad4, 0x4e2d, 0x6587, 0x4e2d, 0x83ef, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c,
0x653f, 0x5340, 0x4e2d, 0x83ef, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x6fb3, 0x9580, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x53f0, 0x7063, 0x68, 0x72,
0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x48, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x42, 0x6f, 0x73, 0x6e, 0x61, 0x20,
0x69, 0x20, 0x48, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x69, 0x6e, 0x61, 0x10d, 0x65, 0x161, 0x74, 0x69, 0x6e, 0x61,
0x10c, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x72, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x6b, 0x61, 0x64, 0x61, 0x6e, 0x73, 0x6b,
0x44, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x47, 0x72, 0xf8, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x65, 0x64, 0x65, 0x72,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x41, 0x72, 0x75, 0x62, 0x61, 0x56,
0x6c, 0x61, 0x61, 0x6d, 0x73, 0x42, 0x65, 0x6c, 0x67, 0x69, 0xeb, 0x43, 0x75, 0x72, 0x61, 0xe7, 0x61, 0x6f, 0x53, 0x75,
0x72, 0x69, 0x6e, 0x61, 0x6d, 0x65, 0x43, 0x61, 0x72, 0x69, 0x62, 0x69, 0x73, 0x63, 0x68, 0x20, 0x4e, 0x65, 0x64, 0x65,
0x72, 0x6c, 0x61, 0x6e, 0x64, 0x53, 0x69, 0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x41, 0x6d, 0x65,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20,
0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61,
0x6e, 0x20, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x41, 0x6e, 0x67, 0x75, 0x69, 0x6c, 0x6c, 0x61, 0x41, 0x6e, 0x74, 0x69, 0x67,
0x75, 0x61, 0x20, 0x26, 0x20, 0x42, 0x61, 0x72, 0x62, 0x75, 0x64, 0x61, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69,
0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x42,
0x61, 0x68, 0x61, 0x6d, 0x61, 0x73, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x6f, 0x73, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x75,
0x6d, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61,
0x6e, 0x61, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x4f, 0x63, 0x65,
0x61, 0x6e, 0x20, 0x54, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x6f, 0x6e,
0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x43, 0x61, 0x6e, 0x61,
0x64, 0x61, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x68, 0x72, 0x69,
0x73, 0x74, 0x6d, 0x61, 0x73, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x63, 0x6f, 0x73, 0x20, 0x28, 0x4b,
0x65, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x29, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x6f, 0x6f, 0x6b, 0x20,
0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x45, 0x72, 0x69, 0x74, 0x72,
0x65, 0x61, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x46, 0x69,
0x6a, 0x69, 0x47, 0x75, 0x65, 0x72, 0x6e, 0x73, 0x65, 0x79, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x47, 0x68, 0x61, 0x6e,
0x61, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x47, 0x75, 0x61,
0x6d, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x53, 0x41, 0x52,
0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x4a, 0x61,
0x6d, 0x61, 0x69, 0x63, 0x61, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x4b, 0x69, 0x72, 0x69, 0x62, 0x61, 0x74, 0x69, 0x4c, 0x65,
0x73, 0x6f, 0x74, 0x68, 0x6f, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x20, 0x53, 0x41,
0x52, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x63, 0x61, 0x72, 0x4d, 0x61, 0x6c,
0x61, 0x77, 0x69, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x4d, 0x61, 0x6c, 0x74, 0x61, 0x4d, 0x61, 0x72, 0x73,
0x68, 0x61, 0x6c, 0x6c, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x75,
0x73, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x4d, 0x6f, 0x6e, 0x74, 0x73, 0x65, 0x72, 0x72, 0x61,
0x74, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x4e, 0x61, 0x75, 0x72, 0x75, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61,
0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x4e, 0x69, 0x75, 0x65, 0x4e, 0x6f, 0x72, 0x66, 0x6f,
0x6c, 0x6b, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x4d, 0x61,
0x72, 0x69, 0x61, 0x6e, 0x61, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61,
0x6e, 0x50, 0x61, 0x6c, 0x61, 0x75, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e,
0x65, 0x61, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x73, 0x50, 0x69, 0x74, 0x63, 0x61, 0x69, 0x72,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x75, 0x65, 0x72, 0x74, 0x6f, 0x20, 0x52, 0x69, 0x63, 0x6f,
0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x4b, 0x69, 0x74, 0x74, 0x73, 0x20, 0x26, 0x20, 0x4e, 0x65,
0x76, 0x69, 0x73, 0x53, 0x74, 0x2e, 0x20, 0x4c, 0x75, 0x63, 0x69, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x56, 0x69, 0x6e, 0x63,
0x65, 0x6e, 0x74, 0x20, 0x26, 0x20, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x53, 0x61, 0x6d, 0x6f,
0x61, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65,
0x6f, 0x6e, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20,
0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x53,
0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x6c,
0x61, 0x6e, 0x64, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x54, 0x6f, 0x6b, 0x65, 0x6c, 0x61, 0x75, 0x54, 0x6f,
0x6e, 0x67, 0x61, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f,
0x54, 0x75, 0x72, 0x6b, 0x73, 0x20, 0x26, 0x20, 0x43, 0x61, 0x69, 0x63, 0x6f, 0x73, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e,
0x64, 0x73, 0x54, 0x75, 0x76, 0x61, 0x6c, 0x75, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73,
0x68, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67,
0x64, 0x6f, 0x6d, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x4f, 0x75, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x49, 0x73, 0x6c,
0x61, 0x6e, 0x64, 0x73, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x56,
0x69, 0x72, 0x67, 0x69, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x56, 0x69,
0x72, 0x67, 0x69, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x5a, 0x69,
0x6d, 0x62, 0x61, 0x62, 0x77, 0x65, 0x44, 0x69, 0x65, 0x67, 0x6f, 0x20, 0x47, 0x61, 0x72, 0x63, 0x69, 0x61, 0x49, 0x73,
0x6c, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x61, 0x6e, 0x4a, 0x65, 0x72, 0x73, 0x65, 0x79, 0x53, 0x6f, 0x75, 0x74, 0x68,
0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x53, 0x69, 0x6e, 0x74, 0x20, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x65, 0x65,
0x73, 0x74, 0x69, 0x45, 0x65, 0x73, 0x74, 0x69, 0x66, 0xf8, 0x72, 0x6f, 0x79, 0x73, 0x6b, 0x74, 0x46, 0xf8, 0x72, 0x6f,
0x79, 0x61, 0x72, 0x73, 0x75, 0x6f, 0x6d, 0x69, 0x53, 0x75, 0x6f, 0x6d, 0x69, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69,
0x73, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x71,
0x75, 0x65, 0x42, 0xe9, 0x6e, 0x69, 0x6e, 0x42, 0x75, 0x72, 0x6b, 0x69, 0x6e, 0x61, 0x20, 0x46, 0x61, 0x73, 0x6f, 0x42,
0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x75, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61,
0x69, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x52, 0xe9, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x71, 0x75,
0x65, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x66, 0x72, 0x69, 0x63, 0x61, 0x69, 0x6e, 0x65, 0x54, 0x63, 0x68, 0x61,
0x64, 0x43, 0x6f, 0x6d, 0x6f, 0x72, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x2d, 0x4b, 0x69, 0x6e, 0x73, 0x68, 0x61,
0x73, 0x61, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x2d, 0x42, 0x72, 0x61, 0x7a, 0x7a, 0x61, 0x76, 0x69, 0x6c, 0x6c, 0x65, 0x43,
0xf4, 0x74, 0x65, 0x20, 0x64, 0x2019, 0x49, 0x76, 0x6f, 0x69, 0x72, 0x65, 0x44, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69,
0x47, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x20, 0xe9, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x47, 0x75,
0x79, 0x61, 0x6e, 0x65, 0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6e, 0xe9,
0x73, 0x69, 0x65, 0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x47, 0x61, 0x62, 0x6f, 0x6e, 0x47, 0x75,
0x61, 0x64, 0x65, 0x6c, 0x6f, 0x75, 0x70, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x48, 0x61, 0xef, 0x74, 0x69, 0x4c,
0x75, 0x78, 0x65, 0x6d, 0x62, 0x6f, 0x75, 0x72, 0x67, 0x4d, 0x61, 0x6c, 0x69, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x69,
0x71, 0x75, 0x65, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x65,
0x4d, 0x61, 0x79, 0x6f, 0x74, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x4d, 0x61, 0x72, 0x6f, 0x63, 0x4e, 0x6f,
0x75, 0x76, 0x65, 0x6c, 0x6c, 0x65, 0x2d, 0x43, 0x61, 0x6c, 0xe9, 0x64, 0x6f, 0x6e, 0x69, 0x65, 0x4e, 0x69, 0x67, 0x65,
0x72, 0x4c, 0x61, 0x20, 0x52, 0xe9, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x53, 0xe9, 0x6e, 0xe9, 0x67, 0x61, 0x6c, 0x53, 0x61,
0x69, 0x6e, 0x74, 0x2d, 0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x2d, 0x65, 0x74, 0x2d, 0x4d, 0x69, 0x71, 0x75, 0x65, 0x6c,
0x6f, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x53, 0x75, 0x69,
0x73, 0x73, 0x65, 0x53, 0x79, 0x72, 0x69, 0x65, 0x54, 0x6f, 0x67, 0x6f, 0x54, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x57,
0x61, 0x6c, 0x6c, 0x69, 0x73, 0x2d, 0x65, 0x74, 0x2d, 0x46, 0x75, 0x74, 0x75, 0x6e, 0x61, 0x53, 0x61, 0x69, 0x6e, 0x74,
0x2d, 0x42, 0x61, 0x72, 0x74, 0x68, 0xe9, 0x6c, 0x65, 0x6d, 0x79, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x72,
0x74, 0x69, 0x6e, 0x57, 0x65, 0x73, 0x74, 0x2d, 0x46, 0x72, 0x79, 0x73, 0x6b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0xe2,
0x6e, 0x47, 0xe0, 0x69, 0x64, 0x68, 0x6c, 0x69, 0x67, 0x41, 0x6e, 0x20, 0x52, 0xec, 0x6f, 0x67, 0x68, 0x61, 0x63, 0x68,
0x64, 0x20, 0x41, 0x6f, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x74, 0x65, 0x67, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x45, 0x73, 0x70,
0x61, 0xf1, 0x61, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x10e1, 0x10d0, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10d5, 0x10d4, 0x10da, 0x10dd,
0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0xd6, 0x73,
0x74, 0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x69, 0x73, 0x63, 0x68, 0x65, 0x73, 0x20, 0x44, 0x65, 0x75, 0x74, 0x73,
0x63, 0x68, 0xd6, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x65, 0x6e, 0x4c,
0x69, 0x65, 0x63, 0x68, 0x74, 0x65, 0x6e, 0x73, 0x74, 0x65, 0x69, 0x6e, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72,
0x67, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x48, 0x6f, 0x63, 0x68, 0x64, 0x65, 0x75, 0x74, 0x73,
0x63, 0x68, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x395, 0x3bb, 0x3bb, 0x3b7, 0x3bd, 0x3b9, 0x3ba, 0x3ac, 0x395, 0x3bb, 0x3bb,
0x3ac, 0x3b4, 0x3b1, 0x39a, 0x3cd, 0x3c0, 0x3c1, 0x3bf, 0x3c2, 0x6b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c, 0x69, 0x73, 0x75, 0x74,
0x4b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c, 0x69, 0x74, 0x20, 0x4e, 0x75, 0x6e, 0x61, 0x61, 0x74, 0xa97, 0xac1, 0xa9c, 0xab0,
0xabe, 0xaa4, 0xac0, 0xaad, 0xabe, 0xab0, 0xaa4, 0x48, 0x61, 0x75, 0x73, 0x61, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61,
0x47, 0x61, 0x6e, 0x61, 0x4e, 0x69, 0x6a, 0x61, 0x72, 0x5e2, 0x5d1, 0x5e8, 0x5d9, 0x5ea, 0x5d9, 0x5e9, 0x5e8, 0x5d0, 0x5dc, 0x939,
0x93f, 0x928, 0x94d, 0x926, 0x940, 0x92d, 0x93e, 0x930, 0x924, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x4d, 0x61, 0x67, 0x79, 0x61,
0x72, 0x6f, 0x72, 0x73, 0x7a, 0xe1, 0x67, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0xcd, 0x73, 0x6c, 0x61, 0x6e,
0x64, 0x42, 0x61, 0x68, 0x61, 0x73, 0x61, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x49, 0x6e, 0x64,
0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x47, 0x61, 0x65, 0x69, 0x6c, 0x67, 0x65, 0xc9, 0x69, 0x72, 0x65, 0x69, 0x74, 0x61,
0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x53, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x6e,
0x6f, 0x53, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x61, 0x65e5, 0x672c, 0x8a9e, 0x65e5, 0x672c, 0xc95, 0xca8, 0xccd, 0xca8, 0xca1, 0xcad,
0xcbe, 0xcb0, 0xca4, 0x6a9, 0x672, 0x634, 0x64f, 0x631, 0x6c1, 0x650, 0x646, 0x65b, 0x62f, 0x648, 0x633, 0x62a, 0x627, 0x646, 0x49b, 0x430,
0x437, 0x430, 0x49b, 0x20, 0x442, 0x456, 0x43b, 0x456, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x4b, 0x69, 0x6e,
0x79, 0x61, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x43a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x447, 0x430, 0x41a, 0x44b, 0x440, 0x433,
0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0xd55c, 0xad6d, 0xc5b4, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0xc870, 0xc120, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0xc778,
0xbbfc, 0xacf5, 0xd654, 0xad6d, 0x49, 0x6b, 0x69, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69,
0xea5, 0xeb2, 0xea7, 0x6c, 0x61, 0x74, 0x76, 0x69, 0x65, 0x161, 0x75, 0x4c, 0x61, 0x74, 0x76, 0x69, 0x6a, 0x61, 0x6c, 0x69,
0x6e, 0x67, 0xe1, 0x6c, 0x61, 0x52, 0x65, 0x70, 0x69, 0x62, 0x69, 0x6b, 0x69, 0x20, 0x64, 0x65, 0x6d, 0x6f, 0x6b, 0x72,
0x61, 0x74, 0x69, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61,
0x52, 0x65, 0x70, 0x69, 0x62, 0x69, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x41, 0x66, 0x72, 0xed, 0x6b, 0x61, 0x20, 0x79,
0x61, 0x20, 0x4b, 0xe1, 0x74, 0x69, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0x173, 0x4c,
0x69, 0x65, 0x74, 0x75, 0x76, 0x61, 0x43c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x41c, 0x430, 0x43a, 0x435,
0x434, 0x43e, 0x43d, 0x438, 0x458, 0x430, 0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61,
0x73, 0x69, 0x6b, 0x61, 0x72, 0x61, 0x42, 0x61, 0x68, 0x61, 0x73, 0x61, 0x20, 0x4d, 0x65, 0x6c, 0x61, 0x79, 0x75, 0x42,
0x72, 0x75, 0x6e, 0x65, 0x69, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0xd2e, 0xd32, 0xd2f, 0xd3e, 0xd33, 0xd02,
0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0x4d, 0x61, 0x6c, 0x74, 0x69, 0x92e, 0x930, 0x93e, 0x920, 0x940, 0x43c, 0x43e, 0x43d, 0x433,
0x43e, 0x43b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x6e,
0x6f, 0x72, 0x73, 0x6b, 0x20, 0x62, 0x6f, 0x6b, 0x6d, 0xe5, 0x6c, 0x4e, 0x6f, 0x72, 0x67, 0x65, 0x53, 0x76, 0x61, 0x6c,
0x62, 0x61, 0x72, 0x64, 0x20, 0x6f, 0x67, 0x20, 0x4a, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x79, 0x65, 0x6e, 0xb13, 0xb21, 0xb3c,
0xb3f, 0xb06, 0xb2d, 0xb3e, 0xb30, 0xb24, 0x67e, 0x69a, 0x62a, 0x648, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x641,
0x627, 0x631, 0x633, 0x6cc, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x50, 0x6f, 0x6c, 0x73, 0x6b,
0x61, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x20, 0x64, 0x6f, 0x20, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c,
0x42, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x41, 0x6e, 0x67, 0x6f, 0x6c,
0x61, 0x43, 0x61, 0x62, 0x6f, 0x20, 0x56, 0x65, 0x72, 0x64, 0x65, 0x54, 0x69, 0x6d, 0x6f, 0x72, 0x2d, 0x4c, 0x65, 0x73,
0x74, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x2d, 0x42, 0x69, 0x73, 0x73, 0x61, 0x75, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x2c,
0x20, 0x52, 0x41, 0x45, 0x20, 0x64, 0x61, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69,
0x71, 0x75, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x75,
0x50, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x61, 0x6c, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50,
0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0xa2a, 0xa70, 0xa1c, 0xa3e, 0xa2c, 0xa40, 0xa2d, 0xa3e, 0xa30, 0xa24, 0x67e, 0x646, 0x62c,
0x627, 0x628, 0x6cc, 0x67e, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x52, 0x75, 0x6e, 0x61, 0x73, 0x69, 0x6d, 0x69, 0x50, 0x65, 0x72,
0xfa, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x45, 0x63, 0x75, 0x61, 0x64, 0x6f, 0x72, 0x72, 0x75, 0x6d, 0x61, 0x6e,
0x74, 0x73, 0x63, 0x68, 0x53, 0x76, 0x69, 0x7a, 0x72, 0x61, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x103, 0x52, 0x6f, 0x6d, 0xe2,
0x6e, 0x69, 0x61, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x61, 0x73, 0x63, 0x103, 0x52, 0x65, 0x70, 0x75,
0x62, 0x6c, 0x69, 0x63, 0x61, 0x20, 0x4d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x61, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439,
0x420, 0x43e, 0x441, 0x441, 0x438, 0x44f, 0x41a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x442, 0x430, 0x43d, 0x41a, 0x438, 0x440, 0x433, 0x438,
0x437, 0x438, 0x44f, 0x41c, 0x43e, 0x43b, 0x434, 0x43e, 0x432, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x430, 0x53, 0xe4, 0x6e,
0x67, 0xf6, 0x4b, 0xf6, 0x64, 0xf6, 0x72, 0xf6, 0x73, 0xea, 0x73, 0x65, 0x20, 0x74, 0xee, 0x20, 0x42, 0xea, 0x61, 0x66,
0x72, 0xee, 0x6b, 0x61, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x421, 0x440, 0x431, 0x438, 0x458, 0x430, 0x73, 0x72, 0x70, 0x73,
0x6b, 0x69, 0x43, 0x72, 0x6e, 0x61, 0x20, 0x47, 0x6f, 0x72, 0x61, 0x53, 0x72, 0x62, 0x69, 0x6a, 0x61, 0x411, 0x43e, 0x441,
0x43d, 0x430, 0x20, 0x438, 0x20, 0x425, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x438, 0x43d, 0x430, 0x426, 0x440, 0x43d, 0x430,
0x20, 0x413, 0x43e, 0x440, 0x430, 0x41a, 0x43e, 0x441, 0x43e, 0x432, 0x43e, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0x6f, 0x438, 0x440, 0x43e,
0x43d, 0x413, 0x443, 0x44b, 0x440, 0x434, 0x437, 0x44b, 0x441, 0x442, 0x43e, 0x43d, 0x423, 0x4d5, 0x440, 0x4d5, 0x441, 0x435, 0x63, 0x68,
0x69, 0x53, 0x68, 0x6f, 0x6e, 0x61, 0xdc3, 0xdd2, 0xd82, 0xdc4, 0xdbd, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a,
0xdcf, 0xdc0, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x73, 0x6b,
0x6f, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x161, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x69, 0x6a,
0x61, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x79, 0x61, 0x4a,
0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x69, 0x79, 0x61, 0x4b, 0x69, 0x69, 0x6e, 0x69, 0x79,
0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x45, 0x73, 0x70, 0x61, 0xf1, 0x61, 0x65, 0x73,
0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x41, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x61, 0x43, 0x68, 0x69, 0x6c, 0x65, 0x43,
0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x43, 0x6f, 0x73, 0x74, 0x61, 0x20, 0x52, 0x69, 0x63, 0x61, 0x43, 0x75, 0x62,
0x61, 0x52, 0x65, 0x70, 0xfa, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x20, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e,
0x61, 0x45, 0x6c, 0x20, 0x53, 0x61, 0x6c, 0x76, 0x61, 0x64, 0x6f, 0x72, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x20, 0x45,
0x63, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x47, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x48, 0x6f,
0x6e, 0x64, 0x75, 0x72, 0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0xe9, 0x78,
0x69, 0x63, 0x6f, 0x4d, 0xe9, 0x78, 0x69, 0x63, 0x6f, 0x4e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x50, 0x61,
0x6e, 0x61, 0x6d, 0xe1, 0x50, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61,
0x73, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x55, 0x72, 0x75, 0x67, 0x75,
0x61, 0x79, 0x56, 0x65, 0x6e, 0x65, 0x7a, 0x75, 0x65, 0x6c, 0x61, 0x69, 0x73, 0x6c, 0x61, 0x73, 0x20, 0x43, 0x61, 0x6e,
0x61, 0x72, 0x69, 0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61,
0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x4c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0xe9, 0x72, 0x69, 0x63,
0x61, 0x43, 0x65, 0x75, 0x74, 0x61, 0x20, 0x79, 0x20, 0x4d, 0x65, 0x6c, 0x69, 0x6c, 0x6c, 0x61, 0x4b, 0x69, 0x73, 0x77,
0x61, 0x68, 0x69, 0x6c, 0x69, 0x4a, 0x61, 0x6d, 0x68, 0x75, 0x72, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x69, 0x64, 0x65,
0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x73, 0x69, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x76, 0x65,
0x6e, 0x73, 0x6b, 0x61, 0x53, 0x76, 0x65, 0x72, 0x69, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0xc5, 0x6c,
0x61, 0x6e, 0x64, 0xba4, 0xbae, 0xbbf, 0xbb4, 0xbcd, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0xbbe, 0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf,
0xbaf, 0xbbe, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x442,
0x430, 0x442, 0x430, 0x440, 0xc24, 0xc46, 0xc32, 0xc41, 0xc17, 0xc41, 0xc2d, 0xc3e, 0xc30, 0xc24, 0x20, 0xc26, 0xc47, 0xc36, 0xc02, 0xe44,
0xe17, 0xe22, 0xf56, 0xf7c, 0xf51, 0xf0b, 0xf66, 0xf90, 0xf51, 0xf0b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf53, 0xf42, 0xf62, 0xf92, 0xfb1, 0xf0b,
0xf42, 0xf62, 0xf0b, 0x1275, 0x130d, 0x122d, 0x129b, 0x12a4, 0x122d, 0x1275, 0x122b, 0x6c, 0x65, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74,
0x6f, 0x6e, 0x67, 0x61, 0x54, 0xfc, 0x72, 0x6b, 0xe7, 0x65, 0x54, 0xfc, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x47, 0xfc, 0x6e,
0x65, 0x79, 0x20, 0x4b, 0x131, 0x62, 0x72, 0x131, 0x73, 0x20, 0x52, 0x75, 0x6d, 0x20, 0x4b, 0x65, 0x73, 0x69, 0x6d, 0x69,
0x626, 0x6c7, 0x64a, 0x63a, 0x6c7, 0x631, 0x686, 0x6d5, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x443, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441,
0x44c, 0x43a, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x430, 0x627, 0x631, 0x62f, 0x648, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627,
0x646, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b, 0x63, 0x68, 0x61, 0x4f, 0x2bb, 0x7a, 0x62, 0x65,
0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x627, 0x648, 0x632, 0x628, 0x6cc, 0x6a9, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x40e, 0x437, 0x431,
0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x54, 0x69, 0x1ebf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x56, 0x69, 0x1ec7,
0x74, 0x20, 0x4e, 0x61, 0x6d, 0x43, 0x79, 0x6d, 0x72, 0x61, 0x65, 0x67, 0x59, 0x20, 0x44, 0x65, 0x79, 0x72, 0x6e, 0x61,
0x73, 0x20, 0x55, 0x6e, 0x65, 0x64, 0x69, 0x67, 0xc8, 0x64, 0xe8, 0x20, 0x59, 0x6f, 0x72, 0xf9, 0x62, 0xe1, 0x4f, 0x72,
0xed, 0x6c, 0x1eb9, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x4f, 0x72, 0xed, 0x6c,
0x25b, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x42, 0x25b, 0x300, 0x6e, 0x25b, 0x300, 0x69, 0x73, 0x69, 0x5a, 0x75, 0x6c, 0x75, 0x69,
0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x79, 0x6e, 0x6f, 0x72, 0x73, 0x6b,
0x4e, 0x6f, 0x72, 0x65, 0x67, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a,
0x438, 0x47, 0x61, 0x65, 0x6c, 0x67, 0x45, 0x6c, 0x6c, 0x61, 0x6e, 0x20, 0x56, 0x61, 0x6e, 0x6e, 0x69, 0x6e, 0x6b, 0x65,
0x72, 0x6e, 0x65, 0x77, 0x65, 0x6b, 0x52, 0x79, 0x77, 0x76, 0x61, 0x6e, 0x65, 0x74, 0x68, 0x20, 0x55, 0x6e, 0x79, 0x73,
0x41, 0x6b, 0x61, 0x6e, 0x47, 0x61, 0x61, 0x6e, 0x61, 0x915, 0x94b, 0x902, 0x915, 0x923, 0x940, 0x49, 0x67, 0x62, 0x6f, 0x4b,
0x69, 0x6b, 0x61, 0x6d, 0x62, 0x61, 0x66, 0x75, 0x72, 0x6c, 0x61, 0x6e, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x65, 0x65, 0x28b,
0x65, 0x67, 0x62, 0x65, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x54, 0x6f, 0x67, 0x6f,
0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x2bb, 0x14c, 0x6c, 0x65, 0x6c, 0x6f, 0x20, 0x48, 0x61, 0x77, 0x61, 0x69, 0x2bb,
0x69, 0x2bb, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x20, 0x48, 0x75, 0x69, 0x20, 0x50, 0x16b, 0x20, 0x2bb, 0x49, 0x61,
0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x53, 0x63, 0x68,
0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x74, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a,
0x46, 0x72, 0x61, 0x6e, 0x6b, 0x72, 0x69, 0x69, 0x63, 0x68, 0x4c, 0x69, 0xe4, 0x63, 0x68, 0x74, 0x65, 0x73, 0x63, 0x68,
0x74, 0xe4, 0x69, 0xa188, 0xa320, 0xa259, 0xa34f, 0xa1e9, 0x64, 0x61, 0x76, 0x76, 0x69, 0x73, 0xe1, 0x6d, 0x65, 0x67, 0x69, 0x65,
0x6c, 0x6c, 0x61, 0x4e, 0x6f, 0x72, 0x67, 0x61, 0x53, 0x75, 0x6f, 0x70, 0x6d, 0x61, 0x52, 0x75, 0x6f, 0x167, 0x167, 0x61,
0x45, 0x6b, 0x65, 0x67, 0x75, 0x73, 0x69, 0x69, 0x4b, 0x69, 0x74, 0x61, 0x69, 0x74, 0x61, 0x50, 0x75, 0x6c, 0x61, 0x61,
0x72, 0x53, 0x65, 0x6e, 0x65, 0x67, 0x61, 0x61, 0x6c, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x75, 0x6e, 0x47, 0x69, 0x6e,
0x65, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x47, 0x69, 0x6b, 0x75, 0x79, 0x75, 0x4b, 0x69, 0x73, 0x61, 0x6d,
0x70, 0x75, 0x72, 0x73, 0x65, 0x6e, 0x61, 0x69, 0x73, 0x69, 0x4e, 0x64, 0x65, 0x62, 0x65, 0x6c, 0x65, 0x4b, 0x69, 0x68,
0x6f, 0x72, 0x6f, 0x6d, 0x62, 0x6f, 0x2d5c, 0x2d30, 0x2d4e, 0x2d30, 0x2d63, 0x2d49, 0x2d56, 0x2d5c, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31,
0x74, 0x61, 0x6d, 0x61, 0x7a, 0x69, 0x67, 0x68, 0x74, 0x6c, 0x6d, 0x263, 0x72, 0x69, 0x62, 0x54, 0x61, 0x71, 0x62, 0x61,
0x79, 0x6c, 0x69, 0x74, 0x4c, 0x65, 0x7a, 0x7a, 0x61, 0x79, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x6f,
0x72, 0x65, 0x48, 0x69, 0x62, 0x65, 0x6e, 0x61, 0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x79,
0x69, 0x76, 0x75, 0x6e, 0x6a, 0x6f, 0x62, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x6b, 0x61, 0x6e, 0x4b, 0x129, 0x65, 0x6d, 0x62,
0x75, 0x13e3, 0x13b3, 0x13a9, 0x13a0, 0x13b9, 0x13f0, 0x13df, 0x6b, 0x72, 0x65, 0x6f, 0x6c, 0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69,
0x65, 0x6e, 0x4d, 0x6f, 0x72, 0x69, 0x73, 0x43, 0x68, 0x69, 0x6d, 0x61, 0x6b, 0x6f, 0x6e, 0x64, 0x65, 0x4b, 0x268, 0x6c,
0x61, 0x61, 0x6e, 0x67, 0x69, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x4c, 0x75, 0x67, 0x61, 0x6e, 0x64,
0x61, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x49, 0x63, 0x68, 0x69, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x6b, 0x61, 0x62,
0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x4b, 0x61, 0x62, 0x75, 0x20, 0x56, 0x65, 0x72, 0x64, 0x69, 0x4b,
0x129, 0x6d, 0x129, 0x72, 0x169, 0x4b, 0x61, 0x6c, 0x65, 0x6e, 0x6a, 0x69, 0x6e, 0x45, 0x6d, 0x65, 0x74, 0x61, 0x62, 0x20,
0x4b, 0x65, 0x6e, 0x79, 0x61, 0x4b, 0x68, 0x6f, 0x65, 0x6b, 0x68, 0x6f, 0x65, 0x67, 0x6f, 0x77, 0x61, 0x62, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x62, 0x4b, 0x69, 0x6d, 0x61, 0x63, 0x68, 0x61, 0x6d, 0x65, 0x4b, 0xf6, 0x6c, 0x73, 0x63,
0x68, 0x44, 0x6f, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0x4d, 0x61, 0x61, 0x54, 0x61, 0x6e, 0x73, 0x61,
0x6e, 0x69, 0x61, 0x4f, 0x6c, 0x75, 0x73, 0x6f, 0x67, 0x61, 0x4c, 0x75, 0x6c, 0x75, 0x68, 0x69, 0x61, 0x4b, 0x69, 0x70,
0x61, 0x72, 0x65, 0x54, 0x61, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x69, 0x74, 0x65, 0x73, 0x6f, 0x4b, 0x65, 0x6e,
0x69, 0x61, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x20, 0x63, 0x69, 0x69, 0x6e, 0x69, 0x4d, 0x61, 0x61, 0x6c, 0x69, 0x4b, 0x69,
0x72, 0x75, 0x77, 0x61, 0x44, 0x68, 0x6f, 0x6c, 0x75, 0x6f, 0x52, 0x75, 0x6b, 0x69, 0x67, 0x61, 0x54, 0x61, 0x6d, 0x61,
0x7a, 0x69, 0x263, 0x74, 0x4d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x62, 0x6f, 0x72, 0x6f, 0x20,
0x73, 0x65, 0x6e, 0x6e, 0x69, 0x4b, 0x69, 0x73, 0x68, 0x61, 0x6d, 0x62, 0x61, 0x61, 0x92c, 0x921, 0x93c, 0x94b, 0x54, 0x73,
0x68, 0x69, 0x6c, 0x75, 0x62, 0x61, 0x44, 0x69, 0x74, 0x75, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e,
0x67, 0x75, 0x4c, 0xeb, 0x74, 0x7a, 0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x65, 0x73, 0x63, 0x68, 0x4c, 0xeb, 0x74, 0x7a,
0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x41, 0x67, 0x68, 0x65, 0x6d, 0x4b, 0xe0, 0x6d, 0xe0, 0x6c, 0xfb, 0x14b, 0x181, 0xe0,
0x73, 0xe0, 0x61, 0x4b, 0xe0, 0x6d, 0x25b, 0x300, 0x72, 0xfb, 0x6e, 0x5a, 0x61, 0x72, 0x6d, 0x61, 0x63, 0x69, 0x69, 0x6e,
0x65, 0x4e, 0x69, 0x17e, 0x65, 0x72, 0x64, 0x75, 0xe1, 0x6c, 0xe1, 0x6a, 0x6f, 0x6f, 0x6c, 0x61, 0x53, 0x65, 0x6e, 0x65,
0x67, 0x61, 0x6c, 0x65, 0x77, 0x6f, 0x6e, 0x64, 0x6f, 0x4b, 0x61, 0x6d, 0x259, 0x72, 0xfa, 0x6e, 0x72, 0x69, 0x6b, 0x70,
0x61, 0x6b, 0x61, 0x6d, 0x25b, 0x72, 0xfa, 0x6e, 0x4d, 0x61, 0x6b, 0x75, 0x61, 0x55, 0x6d, 0x6f, 0x7a, 0x61, 0x6d, 0x62,
0x69, 0x6b, 0x69, 0x4d, 0x55, 0x4e, 0x44, 0x41, 0x14a, 0x6b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x14b, 0x4b, 0x77, 0x61, 0x73,
0x69, 0x6f, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x6e, 0x54, 0x68, 0x6f, 0x6b, 0x20, 0x4e, 0x61, 0x74, 0x68, 0x441, 0x430,
0x445, 0x430, 0x20, 0x442, 0x44b, 0x43b, 0x430, 0x49, 0x73, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x67, 0x75, 0x54, 0x61, 0x6e, 0x73,
0x61, 0x6e, 0x69, 0x79, 0x61, 0x54, 0x61, 0x73, 0x61, 0x77, 0x61, 0x71, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0xa559, 0xa524,
0xa55e, 0xa524, 0xa52b, 0xa569, 0x56, 0x61, 0x69, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61, 0x57, 0x61, 0x6c, 0x73, 0x65,
0x72, 0x53, 0x63, 0x68, 0x77, 0x69, 0x7a, 0x6e, 0x75, 0x61, 0x73, 0x75, 0x65, 0x4b, 0x65, 0x6d, 0x65, 0x6c, 0xfa, 0x6e,
0x61, 0x73, 0x74, 0x75, 0x72, 0x69, 0x61, 0x6e, 0x75, 0x4e, 0x64, 0x61, 0xa78c, 0x61, 0x4b, 0x61, 0x6d, 0x25b, 0x6c, 0xfb,
0x6e, 0x6b, 0x61, 0x6b, 0x254, 0x4b, 0x61, 0x6d, 0x25b, 0x72, 0x75, 0x6e, 0x6d, 0x65, 0x74, 0x61, 0x2bc, 0x4b, 0x61, 0x6d,
0x61, 0x6c, 0x75, 0x6e, 0x53, 0x68, 0x77, 0xf3, 0x14b, 0xf2, 0x20, 0x6e, 0x67, 0x69, 0x65, 0x6d, 0x62, 0x254, 0x254, 0x6e,
0x4b, 0xe0, 0x6d, 0x61, 0x6c, 0xfb, 0x6d, 0x4c, 0x61, 0x6b, 0x21f, 0xf3, 0x6c, 0x2bc, 0x69, 0x79, 0x61, 0x70, 0x69, 0x4d,
0xed, 0x6c, 0x61, 0x68, 0x61, 0x14b, 0x73, 0x6b, 0x61, 0x20, 0x54, 0x21f, 0x61, 0x6d, 0xe1, 0x6b, 0x21f, 0x6f, 0x10d, 0x68,
0x65, 0x64, 0x6f, 0x6c, 0x6e, 0x6f, 0x73, 0x65, 0x72, 0x62, 0x161, 0x107, 0x69, 0x6e, 0x61, 0x4e, 0x69, 0x6d, 0x73, 0x6b,
0x61, 0x68, 0x6f, 0x72, 0x6e, 0x6a, 0x6f, 0x73, 0x65, 0x72, 0x62, 0x161, 0x107, 0x69, 0x6e, 0x61, 0x4e, 0x11b, 0x6d, 0x73,
0x6b, 0x61, 0x61, 0x6e, 0x61, 0x72, 0xe2, 0x161, 0x6b, 0x69, 0x65, 0x6c, 0xe2
};

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Oromo\0"
"Afar\0"
"Afrikaans\0"
"Albanian\0"
"Amharic\0"
"Arabic\0"
"Armenian\0"
"Assamese\0"
"Aymara\0"
"Azerbaijani\0"
"Bashkir\0"
"Basque\0"
"Bengali\0"
"Dzongkha\0"
"Bihari\0"
"Bislama\0"
"Breton\0"
"Bulgarian\0"
"Burmese\0"
"Belarusian\0"
"Khmer\0"
"Catalan\0"
"Chinese\0"
"Corsican\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Dutch\0"
"English\0"
"Esperanto\0"
"Estonian\0"
"Faroese\0"
"Fijian\0"
"Finnish\0"
"French\0"
"Western Frisian\0"
"Gaelic\0"
"Galician\0"
"Georgian\0"
"German\0"
"Greek\0"
"Greenlandic\0"
"Guarani\0"
"Gujarati\0"
"Hausa\0"
"Hebrew\0"
"Hindi\0"
"Hungarian\0"
"Icelandic\0"
"Indonesian\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiak\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Kannada\0"
"Kashmiri\0"
"Kazakh\0"
"Kinyarwanda\0"
"Kirghiz\0"
"Korean\0"
"Kurdish\0"
"Rundi\0"
"Lao\0"
"Latin\0"
"Latvian\0"
"Lingala\0"
"Lithuanian\0"
"Macedonian\0"
"Malagasy\0"
"Malay\0"
"Malayalam\0"
"Maltese\0"
"Maori\0"
"Marathi\0"
"Marshallese\0"
"Mongolian\0"
"Nauru\0"
"Nepali\0"
"NorwegianBokmal\0"
"Occitan\0"
"Oriya\0"
"Pashto\0"
"Persian\0"
"Polish\0"
"Portuguese\0"
"Punjabi\0"
"Quechua\0"
"Romansh\0"
"Romanian\0"
"Russian\0"
"Samoan\0"
"Sango\0"
"Sanskrit\0"
"Serbian\0"
"Ossetic\0"
"Southern Sotho\0"
"Tswana\0"
"Shona\0"
"Sindhi\0"
"Sinhala\0"
"Swati\0"
"Slovak\0"
"Slovenian\0"
"Somali\0"
"Spanish\0"
"Sundanese\0"
"Swahili\0"
"Swedish\0"
"Sardinian\0"
"Tajik\0"
"Tamil\0"
"Tatar\0"
"Telugu\0"
"Thai\0"
"Tibetan\0"
"Tigrinya\0"
"Tongan\0"
"Tsonga\0"
"Turkish\0"
"Turkmen\0"
"Tahitian\0"
"Uighur\0"
"Ukrainian\0"
"Urdu\0"
"Uzbek\0"
"Vietnamese\0"
"Volapuk\0"
"Welsh\0"
"Wolof\0"
"Xhosa\0"
"Yiddish\0"
"Yoruba\0"
"Zhuang\0"
"Zulu\0"
"NorwegianNynorsk\0"
"Bosnian\0"
"Divehi\0"
"Manx\0"
"Cornish\0"
"Akan\0"
"Konkani\0"
"Ga\0"
"Igbo\0"
"Kamba\0"
"Syriac\0"
"Blin\0"
"Geez\0"
"Koro\0"
"Sidamo\0"
"Atsam\0"
"Tigre\0"
"Jju\0"
"Friulian\0"
"Venda\0"
"Ewe\0"
"Walamo\0"
"Hawaiian\0"
"Tyap\0"
"Nyanja\0"
"Filipino\0"
"Swiss German\0"
"Sichuan Yi\0"
"Kpelle\0"
"Low German\0"
"South Ndebele\0"
"Northern Sotho\0"
"Northern Sami\0"
"Taroko\0"
"Gusii\0"
"Taita\0"
"Fulah\0"
"Kikuyu\0"
"Samburu\0"
"Sena\0"
"North Ndebele\0"
"Rombo\0"
"Tachelhit\0"
"Kabyle\0"
"Nyankole\0"
"Bena\0"
"Vunjo\0"
"Bambara\0"
"Embu\0"
"Cherokee\0"
"Morisyen\0"
"Makonde\0"
"Langi\0"
"Ganda\0"
"Bemba\0"
"Kabuverdianu\0"
"Meru\0"
"Kalenjin\0"
"Nama\0"
"Machame\0"
"Colognian\0"
"Masai\0"
"Soga\0"
"Luyia\0"
"Asu\0"
"Teso\0"
"Saho\0"
"Koyra Chiini\0"
"Rwa\0"
"Luo\0"
"Chiga\0"
"Central Morocco Tamazight\0"
"Koyraboro Senni\0"
"Shambala\0"
"Bodo\0"
"Avaric\0"
"Chamorro\0"
"Chechen\0"
"Church\0"
"Chuvash\0"
"Cree\0"
"Haitian\0"
"Herero\0"
"Hiri Motu\0"
"Kanuri\0"
"Komi\0"
"Kongo\0"
"Kwanyama\0"
"Limburgish\0"
"LubaKatanga\0"
"Luxembourgish\0"
"Navaho\0"
"Ndonga\0"
"Ojibwa\0"
"Pali\0"
"Walloon\0"
"Aghem\0"
"Basaa\0"
"Zarma\0"
"Duala\0"
"JolaFonyi\0"
"Ewondo\0"
"Bafia\0"
"MakhuwaMeetto\0"
"Mundang\0"
"Kwasio\0"
"Nuer\0"
"Sakha\0"
"Sangu\0"
"Congo Swahili\0"
"Tasawaq\0"
"Vai\0"
"Walser\0"
"Yangben\0"
"Avestan\0"
"Asturian\0"
"Ngomba\0"
"Kako\0"
"Meta\0"
"Ngiemboon\0"
"Aragonese\0"
"Akkadian\0"
"AncientEgyptian\0"
"AncientGreek\0"
"Aramaic\0"
"Balinese\0"
"Bamun\0"
"BatakToba\0"
"Buginese\0"
"Buhid\0"
"Carian\0"
"Chakma\0"
"ClassicalMandaic\0"
"Coptic\0"
"Dogri\0"
"EasternCham\0"
"EasternKayah\0"
"Etruscan\0"
"Gothic\0"
"Hanunoo\0"
"Ingush\0"
"LargeFloweryMiao\0"
"Lepcha\0"
"Limbu\0"
"Lisu\0"
"Lu\0"
"Lycian\0"
"Lydian\0"
"Mandingo\0"
"Manipuri\0"
"Meroitic\0"
"NorthernThai\0"
"OldIrish\0"
"OldNorse\0"
"OldPersian\0"
"OldTurkish\0"
"Pahlavi\0"
"Parthian\0"
"Phoenician\0"
"PrakritLanguage\0"
"Rejang\0"
"Sabaean\0"
"Samaritan\0"
"Santali\0"
"Saurashtra\0"
"Sora\0"
"Sylheti\0"
"Tagbanwa\0"
"TaiDam\0"
"TaiNua\0"
"Ugaritic\0"
"Akoose\0"
"Lakota\0"
"Standard Moroccan Tamazight\0"
"Mapuche\0"
"Central Kurdish\0"
"LowerSorbian\0"
"UpperSorbian\0"
"Kenyang\0"
"Mohawk\0"
"Nko\0"
"Prussian\0"
"Kiche\0"
"Southern Sami\0"
"Lule Sami\0"
"Inari Sami\0"
"Skolt Sami\0"
"Warlpiri\0"
"Manichaean Middle Persian\0"
"Mende\0"
"Ancient North Arabian\0"
"Linear A\0"
"Hmong Njua\0"
"Ho\0"
"Lezghian\0"
"Bassa\0"
"Mono\0"
"Tedim Chin\0"
"Maithili\0"
;

static const quint16 language_name_index[] = {
     0, // AnyLanguage
     8, // C
    10, // Abkhazian
    20, // Oromo
    26, // Afar
    31, // Afrikaans
    41, // Albanian
    50, // Amharic
    58, // Arabic
    65, // Armenian
    74, // Assamese
    83, // Aymara
    90, // Azerbaijani
   102, // Bashkir
   110, // Basque
   117, // Bengali
   125, // Dzongkha
   134, // Bihari
   141, // Bislama
   149, // Breton
   156, // Bulgarian
   166, // Burmese
   174, // Belarusian
   185, // Khmer
   191, // Catalan
   199, // Chinese
   207, // Corsican
   216, // Croatian
   225, // Czech
   231, // Danish
   238, // Dutch
   244, // English
   252, // Esperanto
   262, // Estonian
   271, // Faroese
   279, // Fijian
   286, // Finnish
   294, // French
   301, // Western Frisian
   317, // Gaelic
   324, // Galician
   333, // Georgian
   342, // German
   349, // Greek
   355, // Greenlandic
   367, // Guarani
   375, // Gujarati
   384, // Hausa
   390, // Hebrew
   397, // Hindi
   403, // Hungarian
   413, // Icelandic
   423, // Indonesian
   434, // Interlingua
   446, // Interlingue
   458, // Inuktitut
   468, // Inupiak
   476, // Irish
   482, // Italian
   490, // Japanese
   499, // Javanese
   508, // Kannada
   516, // Kashmiri
   525, // Kazakh
   532, // Kinyarwanda
   544, // Kirghiz
   552, // Korean
   559, // Kurdish
   567, // Rundi
   573, // Lao
   577, // Latin
   583, // Latvian
   591, // Lingala
   599, // Lithuanian
   610, // Macedonian
   621, // Malagasy
   630, // Malay
   636, // Malayalam
   646, // Maltese
   654, // Maori
   660, // Marathi
   668, // Marshallese
   680, // Mongolian
   690, // Nauru
   696, // Nepali
   703, // NorwegianBokmal
   719, // Occitan
   727, // Oriya
   733, // Pashto
   740, // Persian
   748, // Polish
   755, // Portuguese
   766, // Punjabi
   774, // Quechua
   782, // Romansh
   790, // Romanian
   799, // Russian
   807, // Samoan
   814, // Sango
   820, // Sanskrit
   829, // Serbian
   837, // Ossetic
   845, // Southern Sotho
   860, // Tswana
   867, // Shona
   873, // Sindhi
   880, // Sinhala
   888, // Swati
   894, // Slovak
   901, // Slovenian
   911, // Somali
   918, // Spanish
   926, // Sundanese
   936, // Swahili
   944, // Swedish
   952, // Sardinian
   962, // Tajik
   968, // Tamil
   974, // Tatar
   980, // Telugu
   987, // Thai
   992, // Tibetan
  1000, // Tigrinya
  1009, // Tongan
  1016, // Tsonga
  1023, // Turkish
  1031, // Turkmen
  1039, // Tahitian
  1048, // Uighur
  1055, // Ukrainian
  1065, // Urdu
  1070, // Uzbek
  1076, // Vietnamese
  1087, // Volapuk
  1095, // Welsh
  1101, // Wolof
  1107, // Xhosa
  1113, // Yiddish
  1121, // Yoruba
  1128, // Zhuang
  1135, // Zulu
  1140, // NorwegianNynorsk
  1157, // Bosnian
  1165, // Divehi
  1172, // Manx
  1177, // Cornish
  1185, // Akan
  1190, // Konkani
  1198, // Ga
  1201, // Igbo
  1206, // Kamba
  1212, // Syriac
  1219, // Blin
  1224, // Geez
  1229, // Koro
  1234, // Sidamo
  1241, // Atsam
  1247, // Tigre
  1253, // Jju
  1257, // Friulian
  1266, // Venda
  1272, // Ewe
  1276, // Walamo
  1283, // Hawaiian
  1292, // Tyap
  1297, // Nyanja
  1304, // Filipino
  1313, // Swiss German
  1326, // Sichuan Yi
  1337, // Kpelle
  1344, // Low German
  1355, // South Ndebele
  1369, // Northern Sotho
  1384, // Northern Sami
  1398, // Taroko
  1405, // Gusii
  1411, // Taita
  1417, // Fulah
  1423, // Kikuyu
  1430, // Samburu
  1438, // Sena
  1443, // North Ndebele
  1457, // Rombo
  1463, // Tachelhit
  1473, // Kabyle
  1480, // Nyankole
  1489, // Bena
  1494, // Vunjo
  1500, // Bambara
  1508, // Embu
  1513, // Cherokee
  1522, // Morisyen
  1531, // Makonde
  1539, // Langi
  1545, // Ganda
  1551, // Bemba
  1557, // Kabuverdianu
  1570, // Meru
  1575, // Kalenjin
  1584, // Nama
  1589, // Machame
  1597, // Colognian
  1607, // Masai
  1613, // Soga
  1618, // Luyia
  1624, // Asu
  1628, // Teso
  1633, // Saho
  1638, // Koyra Chiini
  1651, // Rwa
  1655, // Luo
  1659, // Chiga
  1665, // Central Morocco Tamazight
  1691, // Koyraboro Senni
  1707, // Shambala
  1716, // Bodo
  1721, // Avaric
  1728, // Chamorro
  1737, // Chechen
  1745, // Church
  1752, // Chuvash
  1760, // Cree
  1765, // Haitian
  1773, // Herero
  1780, // Hiri Motu
  1790, // Kanuri
  1797, // Komi
  1802, // Kongo
  1808, // Kwanyama
  1817, // Limburgish
  1828, // LubaKatanga
  1840, // Luxembourgish
  1854, // Navaho
  1861, // Ndonga
  1868, // Ojibwa
  1875, // Pali
  1880, // Walloon
  1888, // Aghem
  1894, // Basaa
  1900, // Zarma
  1906, // Duala
  1912, // JolaFonyi
  1922, // Ewondo
  1929, // Bafia
  1935, // MakhuwaMeetto
  1949, // Mundang
  1957, // Kwasio
  1964, // Nuer
  1969, // Sakha
  1975, // Sangu
  1981, // Congo Swahili
  1995, // Tasawaq
  2003, // Vai
  2007, // Walser
  2014, // Yangben
  2022, // Avestan
  2030, // Asturian
  2039, // Ngomba
  2046, // Kako
  2051, // Meta
  2056, // Ngiemboon
  2066, // Aragonese
  2076, // Akkadian
  2085, // AncientEgyptian
  2101, // AncientGreek
  2114, // Aramaic
  2122, // Balinese
  2131, // Bamun
  2137, // BatakToba
  2147, // Buginese
  2156, // Buhid
  2162, // Carian
  2169, // Chakma
  2176, // ClassicalMandaic
  2193, // Coptic
  2200, // Dogri
  2206, // EasternCham
  2218, // EasternKayah
  2231, // Etruscan
  2240, // Gothic
  2247, // Hanunoo
  2255, // Ingush
  2262, // LargeFloweryMiao
  2279, // Lepcha
  2286, // Limbu
  2292, // Lisu
  2297, // Lu
  2300, // Lycian
  2307, // Lydian
  2314, // Mandingo
  2323, // Manipuri
  2332, // Meroitic
  2341, // NorthernThai
  2354, // OldIrish
  2363, // OldNorse
  2372, // OldPersian
  2383, // OldTurkish
  2394, // Pahlavi
  2402, // Parthian
  2411, // Phoenician
  2422, // PrakritLanguage
  2438, // Rejang
  2445, // Sabaean
  2453, // Samaritan
  2463, // Santali
  2471, // Saurashtra
  2482, // Sora
  2487, // Sylheti
  2495, // Tagbanwa
  2504, // TaiDam
  2511, // TaiNua
  2518, // Ugaritic
  2527, // Akoose
  2534, // Lakota
  2541, // Standard Moroccan Tamazight
  2569, // Mapuche
  2577, // Central Kurdish
  2593, // LowerSorbian
  2606, // UpperSorbian
  2619, // Kenyang
  2627, // Mohawk
  2634, // Nko
  2638, // Prussian
  2647, // Kiche
  2653, // Southern Sami
  2667, // Lule Sami
  2677, // Inari Sami
  2688, // Skolt Sami
  2699, // Warlpiri
  2708, // Manichaean Middle Persian
  2734, // Mende
  2740, // Ancient North Arabian
  2762, // Linear A
  2771, // Hmong Njua
  2782, // Ho
  2785, // Lezghian
  2794, // Bassa
  2800, // Mono
  2805, // Tedim Chin
  2816, // Maithili
};

static const char script_name_list[] =
"Default\0"
"Arabic\0"
"Cyrillic\0"
"Deseret\0"
"Gurmukhi\0"
"Simplified Han\0"
"Traditional Han\0"
"Latin\0"
"Mongolian\0"
"Tifinagh\0"
"Armenian\0"
"Bengali\0"
"Cherokee\0"
"Devanagari\0"
"Ethiopic\0"
"Georgian\0"
"Greek\0"
"Gujarati\0"
"Hebrew\0"
"Japanese\0"
"Khmer\0"
"Kannada\0"
"Korean\0"
"Lao\0"
"Malayalam\0"
"Myanmar\0"
"Oriya\0"
"Tamil\0"
"Telugu\0"
"Thaana\0"
"Thai\0"
"Tibetan\0"
"Sinhala\0"
"Syriac\0"
"Yi\0"
"Vai\0"
"Avestan\0"
"Balinese\0"
"Bamum\0"
"Batak\0"
"Bopomofo\0"
"Brahmi\0"
"Buginese\0"
"Buhid\0"
"CanadianAboriginal\0"
"Carian\0"
"Chakma\0"
"Cham\0"
"Coptic\0"
"Cypriot\0"
"Egyptian Hieroglyphs\0"
"Fraser\0"
"Glagolitic\0"
"Gothic\0"
"Han\0"
"Hangul\0"
"Hanunoo\0"
"Imperial Aramaic\0"
"Inscriptional Pahlavi\0"
"Inscriptional Parthian\0"
"Javanese\0"
"Kaithi\0"
"Katakana\0"
"Kayah Li\0"
"Kharoshthi\0"
"Lanna\0"
"Lepcha\0"
"Limbu\0"
"Linear B\0"
"Lycian\0"
"Lydian\0"
"Mandaean\0"
"Meitei Mayek\0"
"Meroitic\0"
"Meroitic Cursive\0"
"Nko\0"
"New Tai Lue\0"
"Ogham\0"
"Ol Chiki\0"
"Old Italic\0"
"Old Persian\0"
"Old South Arabian\0"
"Orkhon\0"
"Osmanya\0"
"Phags Pa\0"
"Phoenician\0"
"Pollard Phonetic\0"
"Rejang\0"
"Runic\0"
"Samaritan\0"
"Saurashtra\0"
"Sharada\0"
"Shavian\0"
"Sora Sompeng\0"
"Cuneiform\0"
"Sundanese\0"
"Syloti Nagri\0"
"Tagalog\0"
"Tagbanwa\0"
"Tai Le\0"
"Tai Viet\0"
"Takri\0"
"Ugaritic\0"
"Braille\0"
"Hiragana\0"
"Caucasian Albanian\0"
"Bassa Vah\0"
"Duployan\0"
"Elbasan\0"
"Grantha\0"
"Pahawh Hmong\0"
"Khojki\0"
"Linear A\0"
"Mahajani\0"
"Manichaean\0"
"Mende Kikakui\0"
"Modi\0"
"Mro\0"
"Old North Arabian\0"
"Nabataean\0"
"Palmyrene\0"
"Pau Cin Hau\0"
"Old Permic\0"
"Psalter Pahlavi\0"
"Siddham\0"
"Khudawadi\0"
"Tirhuta\0"
"Varang Kshiti\0"
;

static const quint16 script_name_index[] = {
     0, // AnyScript
     8, // Arabic
    15, // Cyrillic
    24, // Deseret
    32, // Gurmukhi
    41, // Simplified Han
    56, // Traditional Han
    72, // Latin
    78, // Mongolian
    88, // Tifinagh
    97, // Armenian
   106, // Bengali
   114, // Cherokee
   123, // Devanagari
   134, // Ethiopic
   143, // Georgian
   152, // Greek
   158, // Gujarati
   167, // Hebrew
   174, // Japanese
   183, // Khmer
   189, // Kannada
   197, // Korean
   204, // Lao
   208, // Malayalam
   218, // Myanmar
   226, // Oriya
   232, // Tamil
   238, // Telugu
   245, // Thaana
   252, // Thai
   257, // Tibetan
   265, // Sinhala
   273, // Syriac
   280, // Yi
   283, // Vai
   287, // Avestan
   295, // Balinese
   304, // Bamum
   310, // Batak
   316, // Bopomofo
   325, // Brahmi
   332, // Buginese
   341, // Buhid
   347, // CanadianAboriginal
   366, // Carian
   373, // Chakma
   380, // Cham
   385, // Coptic
   392, // Cypriot
   400, // Egyptian Hieroglyphs
   421, // Fraser
   428, // Glagolitic
   439, // Gothic
   446, // Han
   450, // Hangul
   457, // Hanunoo
   465, // Imperial Aramaic
   482, // Inscriptional Pahlavi
   504, // Inscriptional Parthian
   527, // Javanese
   536, // Kaithi
   543, // Katakana
   552, // Kayah Li
   561, // Kharoshthi
   572, // Lanna
   578, // Lepcha
   585, // Limbu
   591, // Linear B
   600, // Lycian
   607, // Lydian
   614, // Mandaean
   623, // Meitei Mayek
   636, // Meroitic
   645, // Meroitic Cursive
   662, // Nko
   666, // New Tai Lue
   678, // Ogham
   684, // Ol Chiki
   693, // Old Italic
   704, // Old Persian
   716, // Old South Arabian
   734, // Orkhon
   741, // Osmanya
   749, // Phags Pa
   758, // Phoenician
   769, // Pollard Phonetic
   786, // Rejang
   793, // Runic
   799, // Samaritan
   809, // Saurashtra
   820, // Sharada
   828, // Shavian
   836, // Sora Sompeng
   849, // Cuneiform
   859, // Sundanese
   869, // Syloti Nagri
   882, // Tagalog
   890, // Tagbanwa
   899, // Tai Le
   906, // Tai Viet
   915, // Takri
   921, // Ugaritic
   930, // Braille
   938, // Hiragana
   947, // Caucasian Albanian
   966, // Bassa Vah
   976, // Duployan
   985, // Elbasan
   993, // Grantha
  1001, // Pahawh Hmong
  1014, // Khojki
  1021, // Linear A
  1030, // Mahajani
  1039, // Manichaean
  1050, // Mende Kikakui
  1064, // Modi
  1069, // Mro
  1073, // Old North Arabian
  1091, // Nabataean
  1101, // Palmyrene
  1111, // Pau Cin Hau
  1123, // Old Permic
  1134, // Psalter Pahlavi
  1150, // Siddham
  1158, // Khudawadi
  1168, // Tirhuta
  1176, // Varang Kshiti
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Albania\0"
"Algeria\0"
"AmericanSamoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"AntiguaAndBarbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"BosniaAndHerzegowina\0"
"Botswana\0"
"BouvetIsland\0"
"Brazil\0"
"BritishIndianOceanTerritory\0"
"Brunei\0"
"Bulgaria\0"
"BurkinaFaso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"CapeVerde\0"
"CaymanIslands\0"
"CentralAfricanRepublic\0"
"Chad\0"
"Chile\0"
"China\0"
"ChristmasIsland\0"
"CocosIslands\0"
"Colombia\0"
"Comoros\0"
"CongoKinshasa\0"
"CongoBrazzaville\0"
"CookIslands\0"
"CostaRica\0"
"IvoryCoast\0"
"Croatia\0"
"Cuba\0"
"Cyprus\0"
"CzechRepublic\0"
"Denmark\0"
"Djibouti\0"
"Dominica\0"
"DominicanRepublic\0"
"EastTimor\0"
"Ecuador\0"
"Egypt\0"
"ElSalvador\0"
"EquatorialGuinea\0"
"Eritrea\0"
"Estonia\0"
"Ethiopia\0"
"FalklandIslands\0"
"FaroeIslands\0"
"Fiji\0"
"Finland\0"
"France\0"
"Guernsey\0"
"FrenchGuiana\0"
"FrenchPolynesia\0"
"FrenchSouthernTerritories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guinea\0"
"GuineaBissau\0"
"Guyana\0"
"Haiti\0"
"HeardAndMcDonaldIslands\0"
"Honduras\0"
"HongKong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Israel\0"
"Italy\0"
"Jamaica\0"
"Japan\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"NorthKorea\0"
"SouthKorea\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Laos\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"Libya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macau\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"MarshallIslands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"CuraSao\0"
"NewCaledonia\0"
"NewZealand\0"
"Nicaragua\0"
"Niger\0"
"Nigeria\0"
"Niue\0"
"NorfolkIsland\0"
"NorthernMarianaIslands\0"
"Norway\0"
"Oman\0"
"Pakistan\0"
"Palau\0"
"PalestinianTerritories\0"
"Panama\0"
"PapuaNewGuinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"PuertoRico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"Russia\0"
"Rwanda\0"
"SaintKittsAndNevis\0"
"SaintLucia\0"
"SaintVincentAndTheGrenadines\0"
"Samoa\0"
"SanMarino\0"
"SaoTomeAndPrincipe\0"
"SaudiArabia\0"
"Senegal\0"
"Seychelles\0"
"SierraLeone\0"
"Singapore\0"
"Slovakia\0"
"Slovenia\0"
"SolomonIslands\0"
"Somalia\0"
"SouthAfrica\0"
"SouthGeorgiaAndTheSouthSandwichIslands\0"
"Spain\0"
"SriLanka\0"
"SaintHelena\0"
"SaintPierreAndMiquelon\0"
"Sudan\0"
"Suriname\0"
"SvalbardAndJanMayenIslands\0"
"Swaziland\0"
"Sweden\0"
"Switzerland\0"
"Syria\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"TrinidadAndTobago\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"TurksAndCaicosIslands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"UnitedArabEmirates\0"
"UnitedKingdom\0"
"UnitedStates\0"
"UnitedStatesMinorOutlyingIslands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"VaticanCityState\0"
"Venezuela\0"
"Vietnam\0"
"BritishVirginIslands\0"
"UnitedStatesVirginIslands\0"
"WallisAndFutunaIslands\0"
"WesternSahara\0"
"Yemen\0"
"CanaryIslands\0"
"Zambia\0"
"Zimbabwe\0"
"ClippertonIsland\0"
"Montenegro\0"
"Serbia\0"
"Saint Barthelemy\0"
"Saint Martin\0"
"LatinAmericaAndTheCaribbean\0"
"AscensionIsland\0"
"AlandIslands\0"
"DiegoGarcia\0"
"CeutaAndMelilla\0"
"IsleOfMan\0"
"Jersey\0"
"TristanDaCunha\0"
"SouthSudan\0"
"Bonaire\0"
"SintMaarten\0"
"Kosovo\0"
;

static const quint16 country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Albania
    28, // Algeria
    36, // AmericanSamoa
    50, // Andorra
    58, // Angola
    65, // Anguilla
    74, // Antarctica
    85, // AntiguaAndBarbuda
   103, // Argentina
   113, // Armenia
   121, // Aruba
   127, // Australia
   137, // Austria
   145, // Azerbaijan
   156, // Bahamas
   164, // Bahrain
   172, // Bangladesh
   183, // Barbados
   192, // Belarus
   200, // Belgium
   208, // Belize
   215, // Benin
   221, // Bermuda
   229, // Bhutan
   236, // Bolivia
   244, // BosniaAndHerzegowina
   265, // Botswana
   274, // BouvetIsland
   287, // Brazil
   294, // BritishIndianOceanTerritory
   322, // Brunei
   329, // Bulgaria
   338, // BurkinaFaso
   350, // Burundi
   358, // Cambodia
   367, // Cameroon
   376, // Canada
   383, // CapeVerde
   393, // CaymanIslands
   407, // CentralAfricanRepublic
   430, // Chad
   435, // Chile
   441, // China
   447, // ChristmasIsland
   463, // CocosIslands
   476, // Colombia
   485, // Comoros
   493, // CongoKinshasa
   507, // CongoBrazzaville
   524, // CookIslands
   536, // CostaRica
   546, // IvoryCoast
   557, // Croatia
   565, // Cuba
   570, // Cyprus
   577, // CzechRepublic
   591, // Denmark
   599, // Djibouti
   608, // Dominica
   617, // DominicanRepublic
   635, // EastTimor
   645, // Ecuador
   653, // Egypt
   659, // ElSalvador
   670, // EquatorialGuinea
   687, // Eritrea
   695, // Estonia
   703, // Ethiopia
   712, // FalklandIslands
   728, // FaroeIslands
   741, // Fiji
   746, // Finland
   754, // France
   761, // Guernsey
   770, // FrenchGuiana
   783, // FrenchPolynesia
   799, // FrenchSouthernTerritories
   825, // Gabon
   831, // Gambia
   838, // Georgia
   846, // Germany
   854, // Ghana
   860, // Gibraltar
   870, // Greece
   877, // Greenland
   887, // Grenada
   895, // Guadeloupe
   906, // Guam
   911, // Guatemala
   921, // Guinea
   928, // GuineaBissau
   941, // Guyana
   948, // Haiti
   954, // HeardAndMcDonaldIslands
   978, // Honduras
   987, // HongKong
   996, // Hungary
  1004, // Iceland
  1012, // India
  1018, // Indonesia
  1028, // Iran
  1033, // Iraq
  1038, // Ireland
  1046, // Israel
  1053, // Italy
  1059, // Jamaica
  1067, // Japan
  1073, // Jordan
  1080, // Kazakhstan
  1091, // Kenya
  1097, // Kiribati
  1106, // NorthKorea
  1117, // SouthKorea
  1128, // Kuwait
  1135, // Kyrgyzstan
  1146, // Laos
  1151, // Latvia
  1158, // Lebanon
  1166, // Lesotho
  1174, // Liberia
  1182, // Libya
  1188, // Liechtenstein
  1202, // Lithuania
  1212, // Luxembourg
  1223, // Macau
  1229, // Macedonia
  1239, // Madagascar
  1250, // Malawi
  1257, // Malaysia
  1266, // Maldives
  1275, // Mali
  1280, // Malta
  1286, // MarshallIslands
  1302, // Martinique
  1313, // Mauritania
  1324, // Mauritius
  1334, // Mayotte
  1342, // Mexico
  1349, // Micronesia
  1360, // Moldova
  1368, // Monaco
  1375, // Mongolia
  1384, // Montserrat
  1395, // Morocco
  1403, // Mozambique
  1414, // Myanmar
  1422, // Namibia
  1430, // Nauru
  1436, // Nepal
  1442, // Netherlands
  1454, // CuraSao
  1462, // NewCaledonia
  1475, // NewZealand
  1486, // Nicaragua
  1496, // Niger
  1502, // Nigeria
  1510, // Niue
  1515, // NorfolkIsland
  1529, // NorthernMarianaIslands
  1552, // Norway
  1559, // Oman
  1564, // Pakistan
  1573, // Palau
  1579, // PalestinianTerritories
  1602, // Panama
  1609, // PapuaNewGuinea
  1624, // Paraguay
  1633, // Peru
  1638, // Philippines
  1650, // Pitcairn
  1659, // Poland
  1666, // Portugal
  1675, // PuertoRico
  1686, // Qatar
  1692, // Reunion
  1700, // Romania
  1708, // Russia
  1715, // Rwanda
  1722, // SaintKittsAndNevis
  1741, // SaintLucia
  1752, // SaintVincentAndTheGrenadines
  1781, // Samoa
  1787, // SanMarino
  1797, // SaoTomeAndPrincipe
  1816, // SaudiArabia
  1828, // Senegal
  1836, // Seychelles
  1847, // SierraLeone
  1859, // Singapore
  1869, // Slovakia
  1878, // Slovenia
  1887, // SolomonIslands
  1902, // Somalia
  1910, // SouthAfrica
  1922, // SouthGeorgiaAndTheSouthSandwichIslands
  1961, // Spain
  1967, // SriLanka
  1976, // SaintHelena
  1988, // SaintPierreAndMiquelon
  2011, // Sudan
  2017, // Suriname
  2026, // SvalbardAndJanMayenIslands
  2053, // Swaziland
  2063, // Sweden
  2070, // Switzerland
  2082, // Syria
  2088, // Taiwan
  2095, // Tajikistan
  2106, // Tanzania
  2115, // Thailand
  2124, // Togo
  2129, // Tokelau
  2137, // Tonga
  2143, // TrinidadAndTobago
  2161, // Tunisia
  2169, // Turkey
  2176, // Turkmenistan
  2189, // TurksAndCaicosIslands
  2211, // Tuvalu
  2218, // Uganda
  2225, // Ukraine
  2233, // UnitedArabEmirates
  2252, // UnitedKingdom
  2266, // UnitedStates
  2279, // UnitedStatesMinorOutlyingIslands
  2312, // Uruguay
  2320, // Uzbekistan
  2331, // Vanuatu
  2339, // VaticanCityState
  2356, // Venezuela
  2366, // Vietnam
  2374, // BritishVirginIslands
  2395, // UnitedStatesVirginIslands
  2421, // WallisAndFutunaIslands
  2444, // WesternSahara
  2458, // Yemen
  2464, // CanaryIslands
  2478, // Zambia
  2485, // Zimbabwe
  2494, // ClippertonIsland
  2511, // Montenegro
  2522, // Serbia
  2529, // Saint Barthelemy
  2546, // Saint Martin
  2559, // LatinAmericaAndTheCaribbean
  2587, // AscensionIsland
  2603, // AlandIslands
  2616, // DiegoGarcia
  2628, // CeutaAndMelilla
  2644, // IsleOfMan
  2654, // Jersey
  2661, // TristanDaCunha
  2676, // SouthSudan
  2687, // Bonaire
  2695, // SintMaarten
  2707, // Kosovo
};

static const unsigned char language_code_list[] =
"  \0" // AnyLanguage
"  \0" // C
"ab\0" // Abkhazian
"om\0" // Oromo
"aa\0" // Afar
"af\0" // Afrikaans
"sq\0" // Albanian
"am\0" // Amharic
"ar\0" // Arabic
"hy\0" // Armenian
"as\0" // Assamese
"ay\0" // Aymara
"az\0" // Azerbaijani
"ba\0" // Bashkir
"eu\0" // Basque
"bn\0" // Bengali
"dz\0" // Dzongkha
"bh\0" // Bihari
"bi\0" // Bislama
"br\0" // Breton
"bg\0" // Bulgarian
"my\0" // Burmese
"be\0" // Belarusian
"km\0" // Khmer
"ca\0" // Catalan
"zh\0" // Chinese
"co\0" // Corsican
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"nl\0" // Dutch
"en\0" // English
"eo\0" // Esperanto
"et\0" // Estonian
"fo\0" // Faroese
"fj\0" // Fijian
"fi\0" // Finnish
"fr\0" // French
"fy\0" // Western Frisian
"gd\0" // Gaelic
"gl\0" // Galician
"ka\0" // Georgian
"de\0" // German
"el\0" // Greek
"kl\0" // Greenlandic
"gn\0" // Guarani
"gu\0" // Gujarati
"ha\0" // Hausa
"he\0" // Hebrew
"hi\0" // Hindi
"hu\0" // Hungarian
"is\0" // Icelandic
"id\0" // Indonesian
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiak
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kn\0" // Kannada
"ks\0" // Kashmiri
"kk\0" // Kazakh
"rw\0" // Kinyarwanda
"ky\0" // Kirghiz
"ko\0" // Korean
"ku\0" // Kurdish
"rn\0" // Rundi
"lo\0" // Lao
"la\0" // Latin
"lv\0" // Latvian
"ln\0" // Lingala
"lt\0" // Lithuanian
"mk\0" // Macedonian
"mg\0" // Malagasy
"ms\0" // Malay
"ml\0" // Malayalam
"mt\0" // Maltese
"mi\0" // Maori
"mr\0" // Marathi
"mh\0" // Marshallese
"mn\0" // Mongolian
"na\0" // Nauru
"ne\0" // Nepali
"nb\0" // NorwegianBokmal
"oc\0" // Occitan
"or\0" // Oriya
"ps\0" // Pashto
"fa\0" // Persian
"pl\0" // Polish
"pt\0" // Portuguese
"pa\0" // Punjabi
"qu\0" // Quechua
"rm\0" // Romansh
"ro\0" // Romanian
"ru\0" // Russian
"sm\0" // Samoan
"sg\0" // Sango
"sa\0" // Sanskrit
"sr\0" // Serbian
"os\0" // Ossetic
"st\0" // Southern Sotho
"tn\0" // Tswana
"sn\0" // Shona
"sd\0" // Sindhi
"si\0" // Sinhala
"ss\0" // Swati
"sk\0" // Slovak
"sl\0" // Slovenian
"so\0" // Somali
"es\0" // Spanish
"su\0" // Sundanese
"sw\0" // Swahili
"sv\0" // Swedish
"sc\0" // Sardinian
"tg\0" // Tajik
"ta\0" // Tamil
"tt\0" // Tatar
"te\0" // Telugu
"th\0" // Thai
"bo\0" // Tibetan
"ti\0" // Tigrinya
"to\0" // Tongan
"ts\0" // Tsonga
"tr\0" // Turkish
"tk\0" // Turkmen
"ty\0" // Tahitian
"ug\0" // Uighur
"uk\0" // Ukrainian
"ur\0" // Urdu
"uz\0" // Uzbek
"vi\0" // Vietnamese
"vo\0" // Volapuk
"cy\0" // Welsh
"wo\0" // Wolof
"xh\0" // Xhosa
"yi\0" // Yiddish
"yo\0" // Yoruba
"za\0" // Zhuang
"zu\0" // Zulu
"nn\0" // NorwegianNynorsk
"bs\0" // Bosnian
"dv\0" // Divehi
"gv\0" // Manx
"kw\0" // Cornish
"ak\0" // Akan
"kok" // Konkani
"gaa" // Ga
"ig\0" // Igbo
"kam" // Kamba
"syr" // Syriac
"byn" // Blin
"gez" // Geez
"kfo" // Koro
"sid" // Sidamo
"cch" // Atsam
"tig" // Tigre
"kaj" // Jju
"fur" // Friulian
"ve\0" // Venda
"ee\0" // Ewe
"wal" // Walamo
"haw" // Hawaiian
"kcg" // Tyap
"ny\0" // Nyanja
"fil" // Filipino
"gsw" // Swiss German
"ii\0" // Sichuan Yi
"kpe" // Kpelle
"nds" // Low German
"nr\0" // South Ndebele
"nso" // Northern Sotho
"se\0" // Northern Sami
"trv" // Taroko
"guz" // Gusii
"dav" // Taita
"ff\0" // Fulah
"ki\0" // Kikuyu
"saq" // Samburu
"seh" // Sena
"nd\0" // North Ndebele
"rof" // Rombo
"shi" // Tachelhit
"kab" // Kabyle
"nyn" // Nyankole
"bez" // Bena
"vun" // Vunjo
"bm\0" // Bambara
"ebu" // Embu
"chr" // Cherokee
"mfe" // Morisyen
"kde" // Makonde
"lag" // Langi
"lg\0" // Ganda
"bem" // Bemba
"kea" // Kabuverdianu
"mer" // Meru
"kln" // Kalenjin
"naq" // Nama
"jmc" // Machame
"ksh" // Colognian
"mas" // Masai
"xog" // Soga
"luy" // Luyia
"asa" // Asu
"teo" // Teso
"ssy" // Saho
"khq" // Koyra Chiini
"rwk" // Rwa
"luo" // Luo
"cgg" // Chiga
"tzm" // Central Morocco Tamazight
"ses" // Koyraboro Senni
"ksb" // Shambala
"brx" // Bodo
"av\0" // Avaric
"ch\0" // Chamorro
"ce\0" // Chechen
"cu\0" // Church
"cv\0" // Chuvash
"cr\0" // Cree
"ht\0" // Haitian
"hz\0" // Herero
"ho\0" // Hiri Motu
"kr\0" // Kanuri
"kv\0" // Komi
"kg\0" // Kongo
"kj\0" // Kwanyama
"li\0" // Limburgish
"lu\0" // LubaKatanga
"lb\0" // Luxembourgish
"nv\0" // Navaho
"ng\0" // Ndonga
"oj\0" // Ojibwa
"pi\0" // Pali
"wa\0" // Walloon
"agq" // Aghem
"bas" // Basaa
"dje" // Zarma
"dua" // Duala
"dyo" // JolaFonyi
"ewo" // Ewondo
"ksf" // Bafia
"mgh" // MakhuwaMeetto
"mua" // Mundang
"nmg" // Kwasio
"nus" // Nuer
"sah" // Sakha
"sbp" // Sangu
"swc" // Congo Swahili
"twq" // Tasawaq
"vai" // Vai
"wae" // Walser
"yav" // Yangben
"ae\0" // Avestan
"ast" // Asturian
"jgo" // Ngomba
"kkj" // Kako
"mgo" // Meta
"nnh" // Ngiemboon
"an\0" // Aragonese
"akk" // Akkadian
"egy" // AncientEgyptian
"grc" // AncientGreek
"arc" // Aramaic
"ban" // Balinese
"bax" // Bamun
"bbc" // BatakToba
"bug" // Buginese
"bku" // Buhid
"xcr" // Carian
"ccp" // Chakma
"myz" // ClassicalMandaic
"cop" // Coptic
"doi" // Dogri
"cjm" // EasternCham
"eky" // EasternKayah
"ett" // Etruscan
"got" // Gothic
"hnn" // Hanunoo
"inh" // Ingush
"hmd" // LargeFloweryMiao
"lep" // Lepcha
"lif" // Limbu
"lis" // Lisu
"khb" // Lu
"xlc" // Lycian
"xld" // Lydian
"man" // Mandingo
"mni" // Manipuri
"xmr" // Meroitic
"nod" // NorthernThai
"sga" // OldIrish
"non" // OldNorse
"peo" // OldPersian
"otk" // OldTurkish
"pal" // Pahlavi
"xpr" // Parthian
"phn" // Phoenician
"pra" // PrakritLanguage
"rej" // Rejang
"xsa" // Sabaean
"smp" // Samaritan
"sat" // Santali
"saz" // Saurashtra
"srb" // Sora
"syl" // Sylheti
"tbw" // Tagbanwa
"blt" // TaiDam
"tdd" // TaiNua
"uga" // Ugaritic
"bss" // Akoose
"lkt" // Lakota
"zgh" // Standard Moroccan Tamazight
"arn" // Mapuche
"ckb" // Central Kurdish
"dsb" // LowerSorbian
"hsb" // UpperSorbian
"ken" // Kenyang
"moh" // Mohawk
"nqo" // Nko
"prg" // Prussian
"quc" // Kiche
"sma" // Southern Sami
"smj" // Lule Sami
"smn" // Inari Sami
"sms" // Skolt Sami
"wbp" // Warlpiri
"xmn" // Manichaean Middle Persian
"men" // Mende
"xna" // Ancient North Arabian
"lab" // Linear A
"hnj" // Hmong Njua
"hoc" // Ho
"lez" // Lezghian
"bsq" // Bassa
"mru" // Mono
"ctd" // Tedim Chin
"mai" // Maithili
;

static const unsigned char script_code_list[] =
"Zzzz" // AnyScript
"Arab" // Arabic
"Cyrl" // Cyrillic
"Dsrt" // Deseret
"Guru" // Gurmukhi
"Hans" // Simplified Han
"Hant" // Traditional Han
"Latn" // Latin
"Mong" // Mongolian
"Tfng" // Tifinagh
"Armn" // Armenian
"Beng" // Bengali
"Cher" // Cherokee
"Deva" // Devanagari
"Ethi" // Ethiopic
"Geor" // Georgian
"Grek" // Greek
"Gujr" // Gujarati
"Hebr" // Hebrew
"Jpan" // Japanese
"Khmr" // Khmer
"Knda" // Kannada
"Kore" // Korean
"Laoo" // Lao
"Mlym" // Malayalam
"Mymr" // Myanmar
"Orya" // Oriya
"Taml" // Tamil
"Telu" // Telugu
"Thaa" // Thaana
"Thai" // Thai
"Tibt" // Tibetan
"Sinh" // Sinhala
"Syrc" // Syriac
"Yiii" // Yi
"Vaii" // Vai
"Avst" // Avestan
"Bali" // Balinese
"Bamu" // Bamum
"Batk" // Batak
"Bopo" // Bopomofo
"Brah" // Brahmi
"Bugi" // Buginese
"Buhd" // Buhid
"Cans" // CanadianAboriginal
"Cari" // Carian
"Cakm" // Chakma
"Cham" // Cham
"Copt" // Coptic
"Cprt" // Cypriot
"Egyp" // Egyptian Hieroglyphs
"Lisu" // Fraser
"Glag" // Glagolitic
"Goth" // Gothic
"Hani" // Han
"Hang" // Hangul
"Hano" // Hanunoo
"Armi" // Imperial Aramaic
"Phli" // Inscriptional Pahlavi
"Prti" // Inscriptional Parthian
"Java" // Javanese
"Kthi" // Kaithi
"Kana" // Katakana
"Kali" // Kayah Li
"Khar" // Kharoshthi
"Lana" // Lanna
"Lepc" // Lepcha
"Limb" // Limbu
"Linb" // Linear B
"Lyci" // Lycian
"Lydi" // Lydian
"Mand" // Mandaean
"Mtei" // Meitei Mayek
"Mero" // Meroitic
"Merc" // Meroitic Cursive
"Nkoo" // Nko
"Talu" // New Tai Lue
"Ogam" // Ogham
"Olck" // Ol Chiki
"Ital" // Old Italic
"Xpeo" // Old Persian
"Sarb" // Old South Arabian
"Orkh" // Orkhon
"Osma" // Osmanya
"Phag" // Phags Pa
"Phnx" // Phoenician
"Plrd" // Pollard Phonetic
"Rjng" // Rejang
"Runr" // Runic
"Samr" // Samaritan
"Saur" // Saurashtra
"Shrd" // Sharada
"Shaw" // Shavian
"Sora" // Sora Sompeng
"Xsux" // Cuneiform
"Sund" // Sundanese
"Sylo" // Syloti Nagri
"Tglg" // Tagalog
"Tagb" // Tagbanwa
"Tale" // Tai Le
"Tavt" // Tai Viet
"Takr" // Takri
"Ugar" // Ugaritic
"Brai" // Braille
"Hira" // Hiragana
"Aghb" // Caucasian Albanian
"Bass" // Bassa Vah
"Dupl" // Duployan
"Elba" // Elbasan
"Gran" // Grantha
"Hmng" // Pahawh Hmong
"Khoj" // Khojki
"Lina" // Linear A
"Mahj" // Mahajani
"Mani" // Manichaean
"Mend" // Mende Kikakui
"Modi" // Modi
"Mroo" // Mro
"Narb" // Old North Arabian
"Nbat" // Nabataean
"Palm" // Palmyrene
"Pauc" // Pau Cin Hau
"Perm" // Old Permic
"Phlp" // Psalter Pahlavi
"Sidd" // Siddham
"Sind" // Khudawadi
"Tirh" // Tirhuta
"Wara" // Varang Kshiti
;
static const unsigned char country_code_list[] =
"ZZ\0" // AnyCountry
"AF\0" // Afghanistan
"AL\0" // Albania
"DZ\0" // Algeria
"AS\0" // AmericanSamoa
"AD\0" // Andorra
"AO\0" // Angola
"AI\0" // Anguilla
"AQ\0" // Antarctica
"AG\0" // AntiguaAndBarbuda
"AR\0" // Argentina
"AM\0" // Armenia
"AW\0" // Aruba
"AU\0" // Australia
"AT\0" // Austria
"AZ\0" // Azerbaijan
"BS\0" // Bahamas
"BH\0" // Bahrain
"BD\0" // Bangladesh
"BB\0" // Barbados
"BY\0" // Belarus
"BE\0" // Belgium
"BZ\0" // Belize
"BJ\0" // Benin
"BM\0" // Bermuda
"BT\0" // Bhutan
"BO\0" // Bolivia
"BA\0" // BosniaAndHerzegowina
"BW\0" // Botswana
"BV\0" // BouvetIsland
"BR\0" // Brazil
"IO\0" // BritishIndianOceanTerritory
"BN\0" // Brunei
"BG\0" // Bulgaria
"BF\0" // BurkinaFaso
"BI\0" // Burundi
"KH\0" // Cambodia
"CM\0" // Cameroon
"CA\0" // Canada
"CV\0" // CapeVerde
"KY\0" // CaymanIslands
"CF\0" // CentralAfricanRepublic
"TD\0" // Chad
"CL\0" // Chile
"CN\0" // China
"CX\0" // ChristmasIsland
"CC\0" // CocosIslands
"CO\0" // Colombia
"KM\0" // Comoros
"CD\0" // CongoKinshasa
"CG\0" // CongoBrazzaville
"CK\0" // CookIslands
"CR\0" // CostaRica
"CI\0" // IvoryCoast
"HR\0" // Croatia
"CU\0" // Cuba
"CY\0" // Cyprus
"CZ\0" // CzechRepublic
"DK\0" // Denmark
"DJ\0" // Djibouti
"DM\0" // Dominica
"DO\0" // DominicanRepublic
"TL\0" // EastTimor
"EC\0" // Ecuador
"EG\0" // Egypt
"SV\0" // ElSalvador
"GQ\0" // EquatorialGuinea
"ER\0" // Eritrea
"EE\0" // Estonia
"ET\0" // Ethiopia
"FK\0" // FalklandIslands
"FO\0" // FaroeIslands
"FJ\0" // Fiji
"FI\0" // Finland
"FR\0" // France
"GG\0" // Guernsey
"GF\0" // FrenchGuiana
"PF\0" // FrenchPolynesia
"TF\0" // FrenchSouthernTerritories
"GA\0" // Gabon
"GM\0" // Gambia
"GE\0" // Georgia
"DE\0" // Germany
"GH\0" // Ghana
"GI\0" // Gibraltar
"GR\0" // Greece
"GL\0" // Greenland
"GD\0" // Grenada
"GP\0" // Guadeloupe
"GU\0" // Guam
"GT\0" // Guatemala
"GN\0" // Guinea
"GW\0" // GuineaBissau
"GY\0" // Guyana
"HT\0" // Haiti
"HM\0" // HeardAndMcDonaldIslands
"HN\0" // Honduras
"HK\0" // HongKong
"HU\0" // Hungary
"IS\0" // Iceland
"IN\0" // India
"ID\0" // Indonesia
"IR\0" // Iran
"IQ\0" // Iraq
"IE\0" // Ireland
"IL\0" // Israel
"IT\0" // Italy
"JM\0" // Jamaica
"JP\0" // Japan
"JO\0" // Jordan
"KZ\0" // Kazakhstan
"KE\0" // Kenya
"KI\0" // Kiribati
"KP\0" // NorthKorea
"KR\0" // SouthKorea
"KW\0" // Kuwait
"KG\0" // Kyrgyzstan
"LA\0" // Laos
"LV\0" // Latvia
"LB\0" // Lebanon
"LS\0" // Lesotho
"LR\0" // Liberia
"LY\0" // Libya
"LI\0" // Liechtenstein
"LT\0" // Lithuania
"LU\0" // Luxembourg
"MO\0" // Macau
"MK\0" // Macedonia
"MG\0" // Madagascar
"MW\0" // Malawi
"MY\0" // Malaysia
"MV\0" // Maldives
"ML\0" // Mali
"MT\0" // Malta
"MH\0" // MarshallIslands
"MQ\0" // Martinique
"MR\0" // Mauritania
"MU\0" // Mauritius
"YT\0" // Mayotte
"MX\0" // Mexico
"FM\0" // Micronesia
"MD\0" // Moldova
"MC\0" // Monaco
"MN\0" // Mongolia
"MS\0" // Montserrat
"MA\0" // Morocco
"MZ\0" // Mozambique
"MM\0" // Myanmar
"NA\0" // Namibia
"NR\0" // Nauru
"NP\0" // Nepal
"NL\0" // Netherlands
"CW\0" // CuraSao
"NC\0" // NewCaledonia
"NZ\0" // NewZealand
"NI\0" // Nicaragua
"NE\0" // Niger
"NG\0" // Nigeria
"NU\0" // Niue
"NF\0" // NorfolkIsland
"MP\0" // NorthernMarianaIslands
"NO\0" // Norway
"OM\0" // Oman
"PK\0" // Pakistan
"PW\0" // Palau
"PS\0" // PalestinianTerritories
"PA\0" // Panama
"PG\0" // PapuaNewGuinea
"PY\0" // Paraguay
"PE\0" // Peru
"PH\0" // Philippines
"PN\0" // Pitcairn
"PL\0" // Poland
"PT\0" // Portugal
"PR\0" // PuertoRico
"QA\0" // Qatar
"RE\0" // Reunion
"RO\0" // Romania
"RU\0" // Russia
"RW\0" // Rwanda
"KN\0" // SaintKittsAndNevis
"LC\0" // SaintLucia
"VC\0" // SaintVincentAndTheGrenadines
"WS\0" // Samoa
"SM\0" // SanMarino
"ST\0" // SaoTomeAndPrincipe
"SA\0" // SaudiArabia
"SN\0" // Senegal
"SC\0" // Seychelles
"SL\0" // SierraLeone
"SG\0" // Singapore
"SK\0" // Slovakia
"SI\0" // Slovenia
"SB\0" // SolomonIslands
"SO\0" // Somalia
"ZA\0" // SouthAfrica
"GS\0" // SouthGeorgiaAndTheSouthSandwichIslands
"ES\0" // Spain
"LK\0" // SriLanka
"SH\0" // SaintHelena
"PM\0" // SaintPierreAndMiquelon
"SD\0" // Sudan
"SR\0" // Suriname
"SJ\0" // SvalbardAndJanMayenIslands
"SZ\0" // Swaziland
"SE\0" // Sweden
"CH\0" // Switzerland
"SY\0" // Syria
"TW\0" // Taiwan
"TJ\0" // Tajikistan
"TZ\0" // Tanzania
"TH\0" // Thailand
"TG\0" // Togo
"TK\0" // Tokelau
"TO\0" // Tonga
"TT\0" // TrinidadAndTobago
"TN\0" // Tunisia
"TR\0" // Turkey
"TM\0" // Turkmenistan
"TC\0" // TurksAndCaicosIslands
"TV\0" // Tuvalu
"UG\0" // Uganda
"UA\0" // Ukraine
"AE\0" // UnitedArabEmirates
"GB\0" // UnitedKingdom
"US\0" // UnitedStates
"UM\0" // UnitedStatesMinorOutlyingIslands
"UY\0" // Uruguay
"UZ\0" // Uzbekistan
"VU\0" // Vanuatu
"VA\0" // VaticanCityState
"VE\0" // Venezuela
"VN\0" // Vietnam
"VG\0" // BritishVirginIslands
"VI\0" // UnitedStatesVirginIslands
"WF\0" // WallisAndFutunaIslands
"EH\0" // WesternSahara
"YE\0" // Yemen
"IC\0" // CanaryIslands
"ZM\0" // Zambia
"ZW\0" // Zimbabwe
"CP\0" // ClippertonIsland
"ME\0" // Montenegro
"RS\0" // Serbia
"BL\0" // Saint Barthelemy
"MF\0" // Saint Martin
"419" // LatinAmericaAndTheCaribbean
"AC\0" // AscensionIsland
"AX\0" // AlandIslands
"DG\0" // DiegoGarcia
"EA\0" // CeutaAndMelilla
"IM\0" // IsleOfMan
"JE\0" // Jersey
"TA\0" // TristanDaCunha
"SS\0" // SouthSudan
"BQ\0" // Bonaire
"SX\0" // SintMaarten
"XK\0" // Kosovo
;

// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
