/*
 * Copyright (c) 2020 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef MDM_SMSHISTORY_H
#define MDM_SMSHISTORY_H

#include <QObject>
#include <QDateTime>
#include <QList>
#include <QMetaType>

namespace Sailfish {
namespace Mdm {

class SMSHistoryPrivate;
class Q_DECL_EXPORT SMSHistory : public QObject
{
    Q_OBJECT

public:
    struct Filter {
        QDateTime start;
        QDateTime end;
    };

    struct Result {
        QDateTime when;
        QString phoneNumber;
    };

    explicit SMSHistory(QObject *parent = 0);
    ~SMSHistory();

    void search(const Sailfish::Mdm::SMSHistory::Filter &filter);

Q_SIGNALS:
    void searchFinished(bool success, const QList<Sailfish::Mdm::SMSHistory::Result> &results);

private:
    SMSHistoryPrivate *d;
    Q_DISABLE_COPY(SMSHistory)
    Q_DECLARE_PRIVATE(SMSHistory)
};

}
}

Q_DECLARE_METATYPE(Sailfish::Mdm::SMSHistory::Result)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::SMSHistory::Result>)

#endif
