/*
 * Copyright (c) 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMSLOTS_H
#define SAILFISH_MDM_SIMSLOTS_H

#include <QObject>

namespace Sailfish {
namespace Mdm {
class SimSlotsPrivate;

class Q_DECL_EXPORT SimSlots : public QObject
{
    Q_OBJECT

public:
    explicit SimSlots(QObject *parent = nullptr);

    QStringList availableSlots() const;
    QStringList enabledSlots() const;
    void enableSlot(const QString &path);
    void disableSlot(const QString &path);

signals:
    void enabledSlotsChanged(QStringList paths);

private:
    SimSlotsPrivate *d_ptr;
    Q_DISABLE_COPY(SimSlots)
    Q_DECLARE_PRIVATE(SimSlots)
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_SIMSLOTS_H
