/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

namespace {

// BaseStation
const auto PathKey = QStringLiteral("path");
const auto RegisteredKey = QStringLiteral("registered");
const auto StrengthKey = QStringLiteral("signalStrength");
const auto MccKey = QStringLiteral("mcc");
const auto MncKey = QStringLiteral("mnc");
const auto LacKey = QStringLiteral("lac");
const auto CidKey = QStringLiteral("cid");
const auto TypeKey = QStringLiteral("type");
const auto PscKey = QStringLiteral("psc");
const auto CiKey = QStringLiteral("ci");
const auto PciKey = QStringLiteral("pci");
const auto TacKey = QStringLiteral("tac");
const auto RsrpKey = QStringLiteral("rsrp");
const auto RsrqKey = QStringLiteral("rsrq");
const auto RssnrKey = QStringLiteral("rssnr");
const auto CqiKey = QStringLiteral("cqi");

// SimInfo
const auto ModemPathKey = QStringLiteral("modemPath");
const auto PresentKey = QStringLiteral("present");
const auto VoiceSimKey = QStringLiteral("voiceSim");
const auto DataSimKey = QStringLiteral("dataSim");
const auto EnabledKey = QStringLiteral("enabled");
const auto PinRequiredKey = QStringLiteral("pinRequired");
const auto NetworkRegistrationStatusKey = QStringLiteral("networkRegistrationStatus");
const auto ImsiKey = QStringLiteral("imsi");
const auto CardIdentifierKey = QStringLiteral("cardIdentifier");
const auto ServiceProviderNameKey = QStringLiteral("serviceProviderName");
const auto SubscriberNumbersKey = QStringLiteral("subscriberNumbers");

enum class PinRequired {
    SimPinUnknown = -1,
    SimPinNotRequired = 0,
    SimPinRequired = 1,
    SimPukRequired = 2
};

enum class NetworkRegistrationStatus {
    UnknownRegistrationStatus = -1,
    NotRegistered = 0,
    Registered,
    SearchingForRegistration,
    RegistrationDenied,
    Roaming
};

} // anonymous namespace
