/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "mdm-networkservice.h"

#include <QSharedPointer>
#include <QVector>

namespace Aurora {
namespace Mdm {
namespace Connectivity {

class NetworkManagerPrivate;
class Q_DECL_EXPORT NetworkManager : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool scanning READ scanning WRITE setScanning NOTIFY scanningChanged)
    Q_PROPERTY(bool valid READ isValid NOTIFY validChanged)
public:
    NetworkManager(QObject *parent = 0);
    virtual ~NetworkManager();

    using ServicesVector = QVector<QSharedPointer<NetworkService>>;
    ServicesVector getAvailableServices(const QString &type);
    void requestAvailableServices(const QString &type);
    ServicesVector getSavedServices(const QString &type);
    void requestSavedServices(const QString &type);
    QString createService(QVariantMap settings);
    void requestCreateService(QVariantMap settings);

    QStringList getMissingMandatoryProps(const QVariantMap &settings) const;
    QStringList getMissingOptionalProps(const QVariantMap &settings) const;

    bool removeSavedService(const QString &path, const QString &type);
    bool removeSavedServiceByName(const QString &name, const QString &type);
    bool requestConnect(const QString &path, const QString &type);
    bool requestConnectByName(const QString &name, const QString &type);
    bool requestDisconnect(const QString &path, const QString &type);
    bool requestDisconnectByName(const QString &name, const QString &type);

    bool isValid() const;
    bool scanning();
    void setScanning(bool value);

Q_SIGNALS:
    void availableServicesReady(ServicesVector newServices);
    void savedServicesReady(ServicesVector newServices);
    void serviceCreated(const QString &newPath);
    void errorCreateService();
    void availableServicesChanged();
    void savedServicesChanged();

    void validChanged();
    void scanningChanged();

private:
    Q_DISABLE_COPY(NetworkManager)
    QScopedPointer<NetworkManagerPrivate> d_ptr;
};

} // namespace Connectivity
} // namespace Mdm
} // namespace Aurora
