/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_FILES_H
#define AURORA_MDM_FILES_H

#include <QObject>
#include <QFlags>

namespace Aurora {
namespace Mdm {

class FilesPrivate;
class Q_DECL_EXPORT Files: public QObject
{
    Q_OBJECT

public:
    enum EntryOwner { MdmOwner = 0x01, UserOwner = 0x02 };
    Q_ENUM(EntryOwner);

    enum EntryType { FileType = 0x01, DirType = 0x02 };
    Q_ENUM(EntryType);

    enum ErrorType {
        NoError = 0,
        NotEnoughSpace,
        ExecutableFile,
        InvalidPath,
        InvalidTmpPath,
        UserFilesAffected,
        OverwritingIsImpossible,
        InternalError,
    };
    Q_ENUM(ErrorType);

    struct EntryInfo {
        EntryOwner owner;
        EntryType type;
        QString name;
        bool isExecutable;
    };

    explicit Files(QObject *parent = nullptr);
    virtual ~Files();

    QStringList allowedUserDirs();
    QList<EntryInfo> entriesInDir(const QString &path, const QStringList &extensions, ErrorType &error);
    ErrorType createDir(const QString &path);
    ErrorType remove(const QString &path);
    int getReadFileDescriptor(const QString &path, ErrorType &error);
    quint64 getAvailableBytes(const QString &path, ErrorType &error);
    QString getTmpFilesDir();
    ErrorType moveToUser(const QString &tmpPath, const QString &path);

private:
    FilesPrivate *d_ptr;

    Q_DISABLE_COPY(Files)
    Q_DECLARE_PRIVATE(Files)
};
} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_FILES_H
