/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_AUTOSTART_H
#define SAILFISH_MDM_AUTOSTART_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QPair>

namespace Sailfish {
namespace Mdm {

class AutostartPrivate;

class Q_DECL_EXPORT Autostart : public QObject
{
    Q_OBJECT

public:

    enum Result {
        Success = 0,
        InternalError,
        InvalidDesktopFile,
        AlreadyAutostarted,
        InvalidUID,
    };

    enum UID {
        Current = -2,
        All = -1,
    };

    Q_ENUM(Result)
    Q_ENUM(UID)

    explicit Autostart(QObject *parent = Q_NULLPTR);
    virtual ~Autostart() Q_DECL_OVERRIDE;

    Q_DECL_DEPRECATED_X("Use enable() instead")
    Result add(const QString &desktopFilePath);

    Q_DECL_DEPRECATED_X("Use disable() instead")
    Result remove(const QString &desktopFilePath);

    Q_DECL_DEPRECATED_X("Use list() instead")
    QStringList query(Autostart::Result &result);

    Result enable(const QString &application, int uid = UID::Current);
    Result disable(const QString &application, int uid = UID::Current);
    QPair<Result, QStringList> list(int uid = UID::Current);

private:

    Q_DISABLE_COPY(Autostart)
    Q_DECLARE_PRIVATE(Autostart)

    AutostartPrivate *d_ptr;

};

}
}

#endif // SAILFISH_MDM_AUTOSTART_H
