/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import ru.auroraos.WebView.Private 1.0

MouseInput {
    id: mouseInput

    signal scrolled(var x, var y, var deltaX, var deltaY)

    anchors.fill: parent

    MouseArea {
        id: mouseArea

        x: 0
        y: 0
        anchors.fill: parent
        enabled: true
        hoverEnabled: true
        acceptedButtons: Qt.RightButton
        cursorShape: mouseInput.cursorShape 

        onPressed: {
            mouseInput.handleMouseEvent(MouseInput.Press, mouseX, mouseY, mouse.button)
        }

        onReleased: {
            mouseInput.handleMouseEvent(MouseInput.Release, mouseX, mouseY, mouse.button)
        }

        onWheel: {
            mouseInput.wheelScrolled(wheel.x, wheel.y, wheel.angleDelta.x, wheel.angleDelta.y)
            mouseInput.scrolled(wheel.x, wheel.y, wheel.angleDelta.x, wheel.angleDelta.y)
        }

        onPositionChanged: {
            mouseInput.handleMouseEvent(MouseInput.Move, mouseX, mouseY, Qt.NoButton)
        }
    }
}
