/****************************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013 Jolla Ltd.
** All rights reserved.
**
** This file is part of Sailfish Silica UI component package.
**
** You may use this file under the terms of BSD license as follows:
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are met:
**     * Redistributions of source code must retain the above copyright
**       notice, this list of conditions and the following disclaimer.
**     * Redistributions in binary form must reproduce the above copyright
**       notice, this list of conditions and the following disclaimer in the
**       documentation and/or other materials provided with the distribution.
**     * Neither the name of the Jolla Ltd nor the
**       names of its contributors may be used to endorse or promote products
**       derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
** DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
** (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
** ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import QtGraphicalEffects 1.0
import "private"
import "private/Util.js" as Util

PulleyMenuBase {
    id: pushUpMenu

    property real topMargin: _menuLabel ? 0 : Theme.paddingLarge
    property real bottomMargin: Theme.itemSizeSmall
    property real _contentEnd: contentColumn.height + topMargin
    property Item _menuLabel: {
        var firstChild = contentColumn.visible && Util.childAt(contentColumn, width/2, 1)
        if (firstChild && firstChild.hasOwnProperty("__silica_menulabel")) {
            return firstChild
        }
        return null
    }
    property real _topDragMargin: (_menuLabel ? _menuLabel.height : 0) + topMargin
    property real _originalPos: flickable.contentY - _activeHeight
    property real bottomPadding: Theme.dp(8)

    default property alias _content: contentColumn.children

    spacing: 0
    y: flickable.originY + flickable.contentHeight + _contentDeficit - bottomPadding

    _contentColumn: contentColumn
    _isPullDownMenu: false
    _inactiveHeight: 0
    _activeHeight: contentColumn.height + topMargin + bottomMargin
    _inactivePosition: Math.round(y + _inactiveHeight + spacing - flickable.height + bottomPadding)
    _finalPosition: _inactivePosition + _activeHeight
    _menuIndicatorPosition: -Theme.paddingSmall + spacing
    _highlightIndicatorPosition: Math.max(Math.min(_dragDistance, _contentEnd) - _menuItemHeight + spacing,
        _menuIndicatorPosition + (_dragDistance/(_menuItemHeight+_topDragMargin)*(Theme.paddingSmall+_topDragMargin)))
    width: (flickable.width ? Math.min(flickable.width, screen.sizeCategory > Screen.Medium ? Screen.width * 0.7 : Screen.width) : Screen.width)
           - 2 * Theme.horizontalPageMargin
    highlightItemRadius: Theme.paddingSmall

    property Component background: Rectangle {
        id: bg

        width: parent.width
        height: _activeHeight
        opacity: pushUpMenu.active ? Theme.opacityLow : 0.0
        color: pushUpMenu.backgroundColor
    }

    property Component menuIndicator // Remains for API compatibility
    onMenuIndicatorChanged: console.log("WARNING: PushUpMenu.menuIndicator is no longer supported.")

    // pulleyIndicator
    Rectangle {
        width: parent.width
        opacity: 1.0 - Math.min((mask.height / _activeHeight) * 4, 1.0)
        height: Math.max(Theme.dp(8), _dragDistance) // 8 by design
        color: pushUpMenu.highlightColor
        radius: Theme.paddingMedium
    }

    Item {
        id: mask

        width: parent.width
        height: _dragDistance

        layer.enabled: true
        layer.effect: OpacityMask {
            maskSource: Rectangle {
                width: mask.width
                height: mask.height
                radius: Theme.paddingMedium
            }
        }

        Column {
            id: contentColumn

            property int __silica_pulleymenu_content

            property real menuContentY: pushUpMenu.active ? _dragDistance + pushUpMenu.spacing : -1
            onMenuContentYChanged: {
                if (menuContentY >= 0) {
                    if (flickable.dragging && !_bounceBackRunning) {
                        _highlightMenuItem(contentColumn, menuContentY - y - _menuItemHeight)
                    } else if (quickSelect){
                        _quickSelectMenuItem(contentColumn, menuContentY - y - _menuItemHeight)
                    }
                }
            }

            y: pushUpMenu.spacing + pushUpMenu.topMargin
            width: parent.width
            visible: active
        }
    }

    Binding {
        target: flickable
        property: "bottomMargin"
        value: (active ? pushUpMenu.height : _inactiveHeight + spacing) + _contentDeficit
    }

    // Ensure that we are positioned at the bottom limit, even if the content does not fill the height
    property real _contentDeficit: Math.max(flickable.height - (flickable.contentHeight + _pdmHeight + spacing), 0)
    property real _pdmHeight: flickable.pullDownMenu ? (flickable.pullDownMenu._inactiveHeight + flickable.pullDownMenu.spacing) : 0

    function _addToFlickable(flickableItem) {
        if (flickableItem.pushUpMenu !== undefined) {
            flickableItem.pushUpMenu = pushUpMenu
        } else {
            console.log('Warning: PushUpMenu must be added to an instance of SilicaFlickable.')
        }
    }

    // for testing
    function _menuContentY() {
        return contentColumn.menuContentY
    }

    Component.onCompleted: {
        if (background) {
            background.createObject(mask, {"z": -2})
        }
        _updateFlickable()
    }
}
