/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (C) 2017 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

BackgroundItem {
    property alias text: label.text
    property string iconSource

    width: ListView.view.width
    height: Theme.iconSizeLauncher + 2 * Theme.paddingSmall

    highlightedColor: Theme.rgba(Theme.highlightColor, Theme.opacityFaint)

    contentItem {
        x: Theme.paddingMedium
        width: parent.width - 2 * Theme.paddingMedium
        radius: Theme.paddingSmall
    }

    Row {
        anchors.centerIn: parent
        width: parent.width - 2 * Theme.paddingMedium
        spacing: Theme.paddingMedium

        Item {
            width: height
            height: Theme.iconSizeLauncher

            Rectangle {
                anchors.fill: parent
                radius: Theme.paddingSmall
                rotation: 270

                gradient: Gradient {
                    GradientStop { position: 0.0; color: Theme.rgba(Theme.primaryColor, Theme.opacityFaint) }
                    GradientStop { position: 1.0; color: "transparent" }
                }
            }

            Image {
                anchors.centerIn: parent
                source: iconSource + (highlighted ? "?" + Theme.highlightColor : "")
            }
        }

        Label {
            id: label

            anchors.verticalCenter: parent.verticalCenter
            width: parent.width - parent.height - parent.spacing
            truncationMode: TruncationMode.Fade
        }
    }
}
