/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */
import QtQuick 2.6
import Sailfish.Silica 1.0

GlassItem {
    property var appBar

    signal indicatorClicked()

    color: Theme.lightPrimaryColor
    backgroundColor: Theme.backgroundGlowColor
    clip: true

    height: Theme.itemSizeMedium
    width: height
    radius: 0.22
    falloffRadius: 0.18
    z: appBar.z + 1
    anchors {
        leftMargin: -width / 2
        left: appBar.left
        verticalCenter: appBar.verticalCenter
        verticalCenterOffset: isPortrait
                              ? Theme.paddingSmall + Theme.paddingSmall / 2
                              : -Theme.paddingSmall
    }

    MouseArea {
        anchors.fill: parent
        onClicked: indicatorClicked()
    }
}
