/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_SYSTEMEVENTS_H
#define AURORA_MDM_SYSTEMEVENTS_H

#include <QObject>
#include <QVariantMap>
#include <QList>

namespace Aurora {
namespace Mdm {

class SystemEventsPrivate;
class Q_DECL_EXPORT SystemEvents : public QObject
{
    Q_OBJECT

public:
    using Event = QVariantMap;
    using Events = QList<Event>;

    explicit SystemEvents(QObject *parent = nullptr);
    ~SystemEvents();

    Events getEvents(quint64 startEventId, quint32 count, bool *hasMore = nullptr,
                     bool *success = nullptr);
    quint32 countEventLimit() const;

signals:
    void newEvent(const QVariantMap &event);

private:
    SystemEventsPrivate *d_ptr;
    Q_DISABLE_COPY(SystemEvents)
    Q_DECLARE_PRIVATE(SystemEvents)
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_SYSTEMEVENTS_H
