/**
 * SPDX-FileCopyrightText: 2017-2020 Jolla Ltd.
 * SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_LOCATIONSETTINGS_P_H
#define SAILFISH_MDM_LOCATIONSETTINGS_P_H

#include "mdm-location.h"
#include "base-mdm-proxy-interface_p.h"
#include "util_p.h"
#include <location-settings-qt5/global-settings.hpp>

#include <QDBusInterface>
#include <QEventLoop>
#include <QFileSystemWatcher>
#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QGeoSatelliteInfo>
#include <QGeoSatelliteInfoSource>
#include <QObject>
#include <QPair>
#include <QTimer>

namespace Sailfish {
namespace Mdm {

namespace {

const int ResponseTimeoutMs = 10000; // 10 seconds

using Status = Aurora::Location::Status::Enum;
using LocationMode = Aurora::Location::LocationMode::Enum;

} // anonymous namespace

class LocationInfoPrivate : public QObject
{
    Q_OBJECT

public:
    LocationInfoPrivate(LocationInfo *info);

public slots:
    void satellitesInUseUpdated(const QList<QGeoSatelliteInfo> &inUse);
    void satellitesInViewUpdated(const QList<QGeoSatelliteInfo> &inView);
    void positionUpdated(const QGeoPositionInfo &info);

private slots:
    void emitSatellitesChanged();

private:
    friend class LocationInfo;
    LocationInfo *q;
    QGeoSatelliteInfoSource *satellites { Q_NULLPTR };
    QGeoPositionInfoSource *geoclue { Q_NULLPTR };
    QGeoPositionInfo position;
    QPair<int, int> lastEmittedSatellites;
    int satellitesInUse;
    int satellitesInView;
    bool isActive;
};

class LocationSettingsPrivate : public QObject
{
    Q_OBJECT

public:
    using Mode = LocationSettings::Mode;

    LocationSettingsPrivate(Mode mode, LocationSettings *settings);

    bool gpsAvailable();
    bool gpsEnabled();
    bool locationStatus();
    LocationMode locationMode();
    void setLocationEnabled(Status status);
    void setGpsEnabled(Status status);
    void setLocationMode(int locationMode);

private:
    friend class LocationSettings;

    template<typename SignalName>
    void waitForSignal(SignalName signal)
    {
        QEventLoop loop;
        QTimer timer;
        timer.setSingleShot(true);
        connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
        connect(&m_globalSettings, signal, &loop, &QEventLoop::quit);
        timer.start(ResponseTimeoutMs);
        loop.exec();
    }

    Mode m_mode;
    Aurora::Location::GlobalSettings m_globalSettings;
    QDBusInterface m_agnssIface;
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_LOCATIONSETTINGS_P_H
