/*
 * Copyright (c) 2020 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_DBUS_SERIALISATION_IMPL_P_H
#define SAILFISH_MDM_DBUS_SERIALISATION_IMPL_P_H

#include <QDataStream>
#include <QDBusMessage>
#include <QList>
#include <QString>
#include <QVariant>

QDataStream &operator<<(QDataStream &dataStream, const QDBusMessage &message)
{
    return dataStream << message.service()
                      << message.path()
                      << message.interface()
                      << message.member()
                      << message.arguments();
}

QDataStream &operator>>(QDataStream &dataStream, QDBusMessage &message)
{
    QString service;
    QString path;
    QString interface;
    QString member;
    QList<QVariant> args;

    dataStream >> service >> path >> interface >> member >> args;
    message = QDBusMessage::createMethodCall(service, path, interface, member);
    message.setArguments(args);

    return dataStream;
}

#endif // SAILFISH_MDM_DBUS_SERIALISATION_IMPL_P_H
