#!/bin/bash

check_response() {
    if [ $? -ne 0 ]; then
        echo "$1"
        exit 1
    fi
}

if [ $# -eq 0 ]; then
    echo "Can not change developer mode service state. No user was provided."
    exit 1
fi

username=$(getent passwd "$1" | cut -f 1 -d ":")
check_response "Can't get username"

# check if user is privileged
tmp=$(groups "$username" | grep -w sailfish-system)
if [ $? -eq 0 ]; then
    echo "Privileged user. Trying to unblock developer mode service"
    sleep 5
    gdbus call -y -d ru.omp.developermode -o / -m ru.omp.developermode.SetBlocked false
    check_response "Failed to unblock developer mode service"
fi

exit 0
