
function init_obs_macros()
    local path = rpm.expand('%_project')
    -- FIXME: should be replaced with rpm.isdefined() for rpm >= 4.17.0 --
    if path == '%_project' then
        path = 'unknown'
    end
    local stage = path:match('devel', -8) or path:match('testing', -8) or path:match('release', -8) or 'live'
    local project = stage == 'live' and path or path:match('(pj:[%w%p]-):%d+.%d+.%d+') or 'unknown'

    -- FIXME: remove qa_stage_devel for live
    if stage == 'live' then
        rpm.define('qa_stage_devel 1')
    end
    rpm.define('qa_stage_' .. stage .. ' 1')
    rpm.define('qa_stage_name ' .. stage)
    rpm.define('obs_stage_' .. stage .. ' 1')
    rpm.define('obs_project_name ' .. project)
end

if rpm.expand('%obs_macro_override') ~= '1' then
    init_obs_macros()
end
