/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd.
** SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private

Private.SilicaLabelBase {
    id: root

    textFormat: _defaultLabelFormat

    layer.effect: OpacityRampEffectBase {
        direction: root.horizontalAlignment === Text.AlignRight ? OpacityRamp.RightToLeft
                                                                : OpacityRamp.LeftToRight
        slope: Math.max(
                   1 + 6 * root.width / Screen.width,
                   root.width / Math.max(1, 2 * (root.implicitWidth - width)))
        offset: 1 - 1 / slope
        // The explicit source used to search for elements in a child's tree
        // with Util.js in a ContextMenu, PullDownMenu and other.
        // TODO: can be adjusted after reworking or removing Util.js
        source: root
    }
}
