/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Applications.Internal 1.0 as AppInternal

AppInternal.LottiePlaceholder {
    id: root

    readonly property var __appBar: try { return appBar } catch(e) { return { height: 0 } }
    readonly property var __pathBar: try { return pathBar } catch(e) { return { height: 0 } }

    anchors {
        topMargin: root.isLandscape ? 0 : -(__pathBar.height + __appBar.height)
        bottomMargin: root.isLandscape ? __appBar.height / 2 : 0
    }

    lottie.source: Qt.resolvedUrl("Files.json")
}
