/**
 * SPDX-FileCopyrightText: Copyright 2022 – 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Loader {
    id: root

    property string text
    property bool busy

    parent: pageStack.currentPage

    active: enabled
    onActiveChanged: active = true // remove binding
    anchors.fill: parent
    z: 10000 // to block AppBar

    sourceComponent: Item {
        id: busyView

        enabled: root.active
        opacity: enabled ? 1.0 : 0.0
        anchors.fill: parent
        Behavior on opacity { FadeAnimator { duration: 400 } }

        onEnabledChanged: {
            if (enabled) {
                busyRectangle.visible = root.busy
            }
        }

        Rectangle {
            id: busyRectangle

            color: Theme.rgba("black",  Theme.opacityOverlay)
            anchors.fill: parent

            TouchBlocker {
                anchors.fill: parent
            }
        }

        BusyLabel {
            objectName: "BusyLabel"

            y: Theme.itemSizeMedium * 2 + Theme.itemSizeExtraLarge
            text: root.text
            running: busyView.enabled
        }
    }
}
