/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Item {
    property alias buttons: row.children
    property PopupBase _rootPopup
    property int layout: PopupMenuToolBar.LayoutJustify
    property color _backgroundColor

    onButtonsChanged: {
        for (var i = 0; i < buttons.length; i++) {
            buttons[i]._closePopup.disconnect(_rootPopup.close)
            buttons[i]._closePopup.connect(_rootPopup.close)
        }
    }

    Rectangle {
        anchors.fill: parent

        color: Qt.tint(_backgroundColor, Theme.rgba(palette.primaryColor, 0.1))
    }

    MouseArea {
        anchors.fill: parent
    }

    Row {
        id: row

        anchors.centerIn: parent

        spacing: {
            if (layout != PopupMenuToolBar.LayoutJustify) {
                return Theme.paddingLarge
            }

            var result = parent.width - Theme.paddingMedium * 2
            var visibleCount = 0
            for (var i = 0; i < children.length; i++) {
                if (!children[i].visible) {
                    continue
                }
                visibleCount++
                result = result - children[i].width
            }

            return result / (visibleCount > 1 ? visibleCount - 1 : 1)
        }
    }
}
