/*
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef USBMODEL_H
#define USBMODEL_H

#include "systemsettingsglobal.h"

#include <QAbstractListModel>

class UsbModelPrivate;

class SYSTEMSETTINGS_EXPORT UsbModel: public QAbstractListModel
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(UsbModel)

public:
    enum Roles {
        ModeRole = Qt::UserRole,
    };
    Q_ENUM(Roles)

    Q_PROPERTY(QString configMode READ configMode WRITE setConfigMode NOTIFY configModeChanged)
    Q_PROPERTY(int currentIndex READ currentIndex)

    explicit UsbModel(QObject *parent = 0);
    ~UsbModel();

    QHash<int, QByteArray> roleNames() const;
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    bool setData(const QModelIndex &, const QVariant &, int role = Qt::EditRole);

    void setConfigMode(QString mode);
    QString configMode() const;
    int currentIndex() const;

signals:
    void configModeChanged();

private:
    UsbModelPrivate *const d_ptr;

    friend class UsbModelPrivate;
};

#endif /* USBMODEL_H */
