/**
 * SPDX-FileCopyrightText: 2012 Digia Plc and/or its subsidiary(-ies)
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: LGPLv2
 */

#ifndef QABSTRACTGALLERY_H
#define QABSTRACTGALLERY_H

#include <qgalleryabstractrequest.h>

QT_BEGIN_NAMESPACE_DOCGALLERY

class QAbstractGalleryPrivate;

class Q_GALLERY_EXPORT QAbstractGallery : public QObject
{
    Q_OBJECT
public:
    QAbstractGallery(QObject *parent = Q_NULLPTR);
    ~QAbstractGallery();

    virtual bool isRequestSupported(QGalleryAbstractRequest::RequestType type) const = 0;

Q_SIGNALS:
    void dataAvailableChanged(bool value);

protected:
    virtual QGalleryAbstractResponse *createResponse(QGalleryAbstractRequest *request) = 0;

    QAbstractGallery(QAbstractGalleryPrivate &dd, QObject *parent);

    QScopedPointer<QAbstractGalleryPrivate> d_ptr;

    friend class QGalleryAbstractRequest;
};

QT_END_NAMESPACE_DOCGALLERY

#endif
