/**
 * SPDX-FileCopyrightText: 2012 Digia Plc and/or its subsidiary(-ies)
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: LGPLv2
 */

#ifndef QGALLERYTRACKEREDITABLERESULTSET_P_H
#define QGALLERYTRACKEREDITABLERESULTSET_P_H

#include "qgallerytrackerresultset_p.h"

QT_BEGIN_NAMESPACE_DOCGALLERY

class QGalleryTrackerMetaDataEdit;

class QGalleryTrackerEditableResultSetPrivate;

class QGalleryTrackerEditableResultSet : public QGalleryTrackerResultSet
{
    Q_OBJECT
public:
    QGalleryTrackerEditableResultSet(
            TrackerSparqlConnection *connection,
            QGalleryTrackerResultSetArguments *arguments,
            bool autoUpdate,
            QObject *parent = Q_NULLPTR);
    ~QGalleryTrackerEditableResultSet();

    bool setMetaData(int key, const QVariant &value);

public Q_SLOTS:
    void setConnection(TrackerSparqlConnection *connection);

private:
    Q_DECLARE_PRIVATE(QGalleryTrackerEditableResultSet)
    Q_PRIVATE_SLOT(d_func(), void _q_editFinished(QGalleryTrackerMetaDataEdit *))
};

QT_END_NAMESPACE_DOCGALLERY

#endif
