/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_NOTIFICATIONS_H
#define SAILFISH_MDM_NOTIFICATIONS_H

#include <QString>
#include <QDateTime>
#include <QVariantList>
#include <QObject>
#include <QDateTime>

#include <QDBusArgument>
#include <QDBusMetaType>

namespace Sailfish {
namespace Mdm {

// NOTE: must be identical in format and serialisation as the proxy version!
struct Q_DECL_EXPORT NotificationData {
    NotificationData() : id(0), itemCount(0) {}
    quint32 id;
    int itemCount;
    QString category;
    QString appName;
    QString appIcon;
    QString summary;
    QString body;
    QString previewSummary;
    QString previewBody;
    QDateTime timestamp;
    QVariantList remoteActions;
};

class NotificationInfoPrivate;
class Q_DECL_EXPORT NotificationInfo : public QObject
{
    Q_OBJECT

public:
    NotificationInfo(QObject *parent = Q_NULLPTR);
    ~NotificationInfo();

    Q_INVOKABLE quint32 createNotification(const Sailfish::Mdm::NotificationData &data);
    Q_INVOKABLE quint32 updateNotification(quint32 notificationId, const Sailfish::Mdm::NotificationData &data);
    Q_INVOKABLE bool closeNotification(quint32 notificationId);

    Q_INVOKABLE QList<NotificationData> notifications(const QString &owner = QString());
    Q_INVOKABLE QList<NotificationData> notificationsByCategory(const QString &category);

private:
    NotificationInfoPrivate *d_ptr;
    Q_DISABLE_COPY(NotificationInfo)
    Q_DECLARE_PRIVATE(NotificationInfo)
};

} // Mdm
} // Sailfish

QDBusArgument &operator<<(QDBusArgument &, const Sailfish::Mdm::NotificationData &) Q_DECL_EXPORT;
const QDBusArgument &operator>>(const QDBusArgument &, Sailfish::Mdm::NotificationData &) Q_DECL_EXPORT;

Q_DECLARE_METATYPE(Sailfish::Mdm::NotificationData)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::NotificationData>)

#endif // SAILFISH_MDM_NOTIFICATIONS_H
