/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_DISPLAYSETTINGS_H
#define AURORA_MDM_DISPLAYSETTINGS_H

#include <QObject>
#include <QList>

namespace Aurora {
namespace Mdm {

class DisplaySettingsPrivate;
class Q_DECL_EXPORT DisplaySettings : public QObject
{
    Q_OBJECT

public:
    enum AutolockPeriod {
        NotInUse,
        NoDelay,
        FiveteenSeconds,
        ThirtySeconds,
        OneMinute,
        TwoMinutes,
        FiveMinutes,
        TenMinutes,
    };
    Q_ENUM(AutolockPeriod)

    explicit DisplaySettings(QObject *parent = nullptr);
    ~DisplaySettings();

    bool setAutolockPeriod(AutolockPeriod);
    AutolockPeriod autolockPeriod() const;
    QList<AutolockPeriod> getSupportedAutolockPeriods() const;

signals:
    void autolockPeriodChanged();

private:
    DisplaySettingsPrivate *d_ptr;
    Q_DISABLE_COPY(DisplaySettings)
    Q_DECLARE_PRIVATE(DisplaySettings)
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_DISPLAYSETTINGS_H
